/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.event;

import com.neeve.event.Event;
import com.neeve.event.EventFactory;
import java.util.Properties;

public final class AepTransactionStageEvent
extends Event {
    private ICommitContext context;
    private TransactionStage stage;
    private boolean suspend;

    private AepTransactionStageEvent() {
        super((short)515);
    }

    public static Event create(Properties props) {
        return new AepTransactionStageEvent();
    }

    public static AepTransactionStageEvent create(ICommitContext context, TransactionStage stage) {
        if (context == null) {
            throw new IllegalArgumentException("commit context cannot be null");
        }
        return ((AepTransactionStageEvent)EventFactory.getInstance().createEvent((short)515)).init(context, stage);
    }

    private final AepTransactionStageEvent init(ICommitContext context, TransactionStage stage) {
        super.init(null, null);
        this.context = context;
        this.stage = stage;
        return this;
    }

    protected final void reset() {
        this.context = null;
        this.stage = null;
    }

    public final ICommitContext getCommitContext() {
        return this.context;
    }

    public final TransactionStage getStage() {
        return this.stage;
    }

    public final void setSuspend(boolean val) {
        if (this.stage != TransactionStage.Start) {
            throw new IllegalStateException("a transaction cannot be suspended in any other stage other than the Start stage");
        }
        this.suspend = val;
    }

    public final boolean getSuspend() {
        return this.suspend;
    }

    public String toString() {
        return "[event=TRANSACTION_STAGE, " + super.toString() + "numInboundEvents=" + this.context.getInboundEventCount() + ", stage=" + (Object)((Object)this.stage) + ", suspend=" + this.suspend + "]";
    }

    public static interface ICommitContext {
        public long getTransactionId();

        public int getInboundEventCount();

        public Event[] getInboundEvents();
    }

    public static enum TransactionStage {
        Start,
        StoreCommitComplete,
        SendCommitComplete,
        Complete;

    }
}

