/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep;

import com.eaio.uuid.UUID;
import com.neeve.aep.AepEngine;
import com.neeve.aep.AepInboundSnoTable;
import com.neeve.aep.AepInboundSnoTableES;
import com.neeve.aep.AepInboundSnoTableEntry;
import com.neeve.aep.AepInboundSnoTableEntryES;
import com.neeve.ods.IStoreObject;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyAepFlow;
import com.neeve.rog.IRogCollectionNodeElement;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.RogNode;
import com.neeve.rog.impl.RogRootNode;
import com.neeve.sma.event.MessageEvent;
import java.nio.ByteBuffer;

final class AepFlow
extends RogRootNode {
    private final int fid_osno = super.getLastFid() + 1;
    private final int fid_state = super.getLastFid() + 2;
    private final int fid_isnot = super.getLastFid() + 3;
    private final PktBodyAepFlow data;
    private AepInboundSnoTable isnot;
    private RogNode state;
    private long osno;
    private AepInboundSnoTableES isnotES;
    private AepEngine aepEngine;
    private AepEngine.HAPolicy haPolicy;
    private boolean isClustered;
    private EventQueue evq = new EventQueue();

    AepFlow(int flowid) {
        this(new UUID(), PktFactory.getInstance().createPacket(856), flowid);
    }

    AepFlow(UUID id, PktPacket packet) {
        this(id, packet, -1);
    }

    AepFlow(UUID id, PktPacket packet, int flowid) {
        super((short)2, (short)0, (short)0, id, true, flowid);
        this.setAsInternal(true);
        this.data = (PktBodyAepFlow)PktFactory.getInstance().createPacketBody(856);
        this.setMessage(1, (Object)this.data);
        this.deserializeFromPacket(packet);
    }

    final int getFlowId() {
        return this.getGraphId();
    }

    final void setAepEngine(AepEngine aepEngine) {
        this.aepEngine = aepEngine;
        this.haPolicy = aepEngine.getHAPolicy();
        this.isClustered = aepEngine.isClustered();
    }

    final AepEngine getAepEngine() {
        return this.aepEngine;
    }

    final void setApplicationState(IRogNode state) {
        if (state != this.state) {
            if (this.state != null) {
                this.removeChild(this.fid_state, this.state);
            }
            if (state != null) {
                this.addChild(this.fid_state, (RogNode)state);
            }
            this.state = (RogNode)state;
        }
    }

    final IRogNode getApplicationState() {
        return this.state;
    }

    final MessageEvent enque(MessageEvent event) {
        return this.evq.offer(event);
    }

    final void rollfwd() {
        this.evq.rollfwd();
    }

    final void rollback() {
        this.evq.rollback();
    }

    private final void setInboundSnoTable(AepInboundSnoTable isnot) {
        if (isnot != this.isnot) {
            if (this.isnot != null) {
                this.removeChild(this.fid_isnot, (RogNode)this.isnot);
            }
            if (isnot != null) {
                this.addChild(this.fid_isnot, (RogNode)isnot);
            }
            this.isnot = isnot;
        }
    }

    final AepFlow setLastSno(int sender, long sno) {
        switch (this.haPolicy) {
            case StateReplication: {
                AepInboundSnoTableEntry entry;
                if (this.isnot == null) {
                    this.setInboundSnoTable(new AepInboundSnoTable());
                }
                if ((entry = (AepInboundSnoTableEntry)this.isnot.get(sender)) == null) {
                    entry = new AepInboundSnoTableEntry();
                    this.isnot.put(sender, (IRogCollectionNodeElement)entry);
                    entry.setSender(sender);
                }
                entry.setSno(sno);
                break;
            }
            case EventSourcing: {
                AepInboundSnoTableEntryES entry;
                if (this.isnotES == null) {
                    this.isnotES = new AepInboundSnoTableES();
                }
                if ((entry = (AepInboundSnoTableEntryES)this.isnotES.get(sender)) == null) {
                    entry = new AepInboundSnoTableEntryES();
                    this.isnotES.put(sender, entry);
                    entry.setSender(sender);
                }
                entry.setSno(sno);
                break;
            }
            default: {
                throw new InternalError("addToOutboundMessageQueue called for HA policy=" + (Object)((Object)this.haPolicy));
            }
        }
        return this;
    }

    final long getLastSno(int sender) {
        switch (this.haPolicy) {
            case StateReplication: {
                AepInboundSnoTableEntry entry;
                if (this.isnot != null && (entry = (AepInboundSnoTableEntry)this.isnot.get(sender)) != null) {
                    return entry.getSno();
                }
                return 0L;
            }
            case EventSourcing: {
                AepInboundSnoTableEntryES entry;
                if (this.isnotES != null && (entry = (AepInboundSnoTableEntryES)this.isnotES.get(sender)) != null) {
                    return entry.getSno();
                }
                return 0L;
            }
        }
        throw new InternalError("addToOutboundMessageQueue called for HA policy=" + (Object)((Object)this.haPolicy));
    }

    final long incrementOutboundSno() {
        switch (this.haPolicy) {
            case StateReplication: {
                long osno = this.data.getOsno();
                this.recordFieldUpdate(this.fid_osno, osno);
                this.data.setOsno(++osno);
                return osno;
            }
            case EventSourcing: {
                return ++this.osno;
            }
        }
        throw new InternalError("incrementOutboundSno called for HA policy=" + (Object)((Object)this.haPolicy));
    }

    protected final void addChildrenToStore() {
        if (this.isnot != null || this.state != null) {
            throw new InternalError("AEP flow added to graph collection after setting inbound sno table and/or state in it");
        }
    }

    protected final void removeChildrenFromStore() {
        throw new InternalError("remove children from store invoked on AEP flow");
    }

    public final int getNumChildren() {
        int count = 0;
        if (this.isnot != null) {
            ++count;
        }
        if (this.state != null) {
            ++count;
        }
        return count;
    }

    protected int getLastFid() {
        return this.fid_isnot;
    }

    public final void addChild(IRogNode node) {
        if (node instanceof AepInboundSnoTable) {
            this.setInboundSnoTable((AepInboundSnoTable)node);
        } else {
            this.setApplicationState(node);
        }
    }

    public final void removeChild(IRogNode node) {
        if (node instanceof AepInboundSnoTable) {
            this.setInboundSnoTable(null);
        } else {
            this.setApplicationState(null);
        }
    }

    public final byte[] serializeToByteArray() {
        throw new InternalError("serializeToByteArray() called on AepFlow object");
    }

    public final ByteBuffer serializeToByteBuffer() {
        throw new InternalError("serializeToByteBuffer() called on AepFlow object");
    }

    public final PktPacket serializeToPacket() {
        PktPacket packet = PktFactory.getInstance().createPacket(257);
        this.serializeTo(packet);
        return packet;
    }

    public final String serializeToJson() {
        throw new InternalError("serializeToJson() called on AepFlow object");
    }

    public final AepFlow deserializeFromByteArray(byte[] array) {
        throw new InternalError("deserializeFromByteArray() called on AepFlow object");
    }

    public final AepFlow deserializeFromByteBuffer(ByteBuffer buffer) {
        throw new InternalError("deserializeFromByteBuffer() called on AepFlow object");
    }

    public final AepFlow deserializeFromPacket(PktPacket packet) {
        this.data.deserialize(packet.getBody().getBuffer(), 0, packet.getBody().getBuffer().getLength());
        packet.dispose();
        return this;
    }

    public final AepFlow deserializeFromJson(String json) {
        throw new InternalError("deserializeFromJson() called on AepFlow object");
    }

    public final void sync() {
        this.data.sync();
    }

    public final IStoreObject.EncodingType getContentEncodingType() {
        return IStoreObject.EncodingType.Custom;
    }

    public final PktPacket serialize() {
        return this.serializeToPacket();
    }

    public final int serializeTo(PktPacket packet) {
        this.sync();
        packet.getBody().putFrom((PktBody)this.data);
        return this.data.getBuffer().getLength();
    }

    public final IStoreObject deserialize(PktPacket packet) {
        return this.deserializeFromPacket(packet);
    }

    public final IStoreObject setFieldValue(long fid, Object val) {
        if (fid == (long)this.fid_osno) {
            this.data.setOsno((Long)val);
        } else {
            super.setFieldValue(fid, val);
        }
        return this;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(super.toString());
        builder.append("] {");
        builder.append("EvQueue=").append(this.evq.size()).append(",");
        builder.append("ISTTable=").append(this.isnot != null ? this.isnot.size() : 0);
        builder.append("}");
        return builder.toString();
    }

    private final class EventQueue {
        private MessageEvent[] q = new MessageEvent[256];
        private long tail = -1L;
        private long last = -1L;
        private long head = -1L;

        private EventQueue() {
        }

        final MessageEvent offer(MessageEvent event) {
            if (this.head - this.tail == (long)this.q.length) {
                MessageEvent[] newq = new MessageEvent[this.q.length * 2];
                for (long i = this.tail + 1L; i <= this.head; ++i) {
                    newq[(int)(i % (long)this.q.length)] = this.q[(int)(i % (long)this.q.length)];
                }
                this.q = newq;
            }
            this.q[(int)(++this.head % (long)this.q.length)] = event;
            return this.q[(int)(++this.last % (long)this.q.length)];
        }

        final void rollfwd() {
            this.tail = this.last;
        }

        final void rollback() {
            this.last = this.tail;
        }

        final int size() {
            return (int)(this.head - this.tail);
        }

        public final String toString() {
            return "(tail=" + this.tail + ", last=" + this.last + ", head=" + this.head + ")";
        }
    }
}

