/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive.commands;

import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkContainer;
import com.neeve.tools.interactive.commands.Command;

public final class Leave
extends Command {
    private final LnkContainer container;

    public Leave(LnkContainer container) {
        this.container = container;
    }

    private void processLeave(String name, boolean suppressClose) {
        ILnkPeerEndpoint pep = this.container.getLink(name);
        if (pep != null) {
            System.out.println("Leaving link ['" + name + "' close=" + !suppressClose + "]...");
            try {
                int flags = 1;
                if (suppressClose) {
                    flags |= 2;
                }
                pep.leave((short)-1, flags);
                System.out.println("Success.");
            }
            catch (Exception e) {
                System.out.println("Failure [" + e.toString() + "]");
            }
        } else {
            System.out.println("Invalid link ['" + name + "'].");
        }
    }

    public final void run(String[] args) {
        if (args.length != 2) {
            System.out.println("Syntax error: leave <name> <suppressClose>");
        } else {
            this.processLeave(args[0], Boolean.parseBoolean(args[1]));
        }
    }

    public final void help() {
        System.out.println("leave <name> <suppressClose>");
        System.out.println("  Leave a link.");
    }

    public final String[] keywords() {
        return new String[]{"leave"};
    }
}

