/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import java.nio.ByteBuffer;

public abstract class StoVariableLengthField<T>
extends StoField {
    protected T val;

    protected StoVariableLengthField(StoField.Type type, String name) {
        super(type, name);
    }

    protected StoVariableLengthField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    @Override
    protected final void doSyncToBuffer(ByteBuffer buffer, int bufferOffset) {
        this.serialize(buffer, bufferOffset, this.val);
    }

    @Override
    protected final void onBackingBufferAttach() {
        this.serialize(this.buffer, this.bodyOffset, this.val);
    }

    @Override
    protected final void onBackingBufferChange() {
        this.val = null;
    }

    @Override
    protected final void onBackingBufferDetach() {
        if (this.val == null) {
            this.val = this.deserialize(this.buffer, this.bodyOffset);
        }
    }

    @Override
    protected final int getSerializedLength() {
        if (this.buffer != null) {
            return this.serializedLength(this.buffer, this.bodyOffset);
        }
        return this.serializedLength(this.val);
    }

    @Override
    protected final String getValueString() {
        T val = this.getValue();
        return val != null ? this.toString(val) : "null";
    }

    @Override
    protected final boolean bodyContentsEquals(StoField other) {
        T thisVal = this.getValue();
        T otherVal = ((StoVariableLengthField)other).getValue();
        return thisVal == null || otherVal == null ? thisVal == otherVal : this.compare(thisVal, otherVal);
    }

    @Override
    protected final void cloneBody(StoField clonee) {
        T thisVal = this.getValue();
        ((StoVariableLengthField)clonee).setValue(thisVal == null ? null : (T)this.clone(thisVal));
    }

    protected abstract int serializedLength(ByteBuffer var1, int var2);

    protected abstract int serializedLength(T var1);

    protected abstract void serialize(ByteBuffer var1, int var2, T var3);

    protected abstract T deserialize(ByteBuffer var1, int var2);

    protected abstract boolean compare(T var1, T var2);

    protected abstract T clone(T var1);

    protected abstract String toString(T var1);

    @Override
    public final boolean isVariableLength() {
        return true;
    }

    @Override
    public final void reset() {
        this.setValue(null);
    }

    public final void setValue(T val) {
        this.val = val;
        if (this.buffer != null) {
            this.serialize(this.buffer, this.bodyOffset, val);
        }
    }

    public final T getValue() {
        if (this.val == null && this.buffer != null) {
            this.val = this.deserialize(this.buffer, this.bodyOffset);
        }
        return this.val;
    }
}

