/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class UtlLinkedHashMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient EntryImpl<K, V>[] _entries;
    private transient int _capacity;
    private transient int _mask;
    private transient EntryImpl<K, V> _poolFirst;
    private transient EntryImpl<K, V> _mapFirst;
    private transient EntryImpl<K, V> _mapLast;
    private transient int _size;
    private final FastIterator _fastIterator = new FastIterator();
    private transient Values _values;
    private transient EntrySet _entrySet;
    private transient KeySet _keySet;

    public UtlLinkedHashMap() {
        this.initialize(16);
    }

    public UtlLinkedHashMap(Map<K, V> map) {
        int capacity = map instanceof UtlLinkedHashMap ? ((UtlLinkedHashMap)map).capacity() : map.size();
        this.initialize(capacity);
        this.putAll(map);
    }

    public UtlLinkedHashMap(int capacity) {
        this.initialize(capacity);
    }

    @Override
    public int size() {
        return this._size;
    }

    public int capacity() {
        return this._capacity;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        EntryImpl entry = this._entries[UtlLinkedHashMap.keyHash(key) & this._mask];
        while (entry != null) {
            if (key.equals(entry._key)) {
                return true;
            }
            entry = entry._next;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        EntryImpl entry = this._mapFirst;
        while (entry != null) {
            if (value.equals(entry._value)) {
                return true;
            }
            entry = entry._after;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        EntryImpl entry = this._entries[UtlLinkedHashMap.keyHash(key) & this._mask];
        while (entry != null) {
            if (key.equals(entry._key)) {
                return (V)entry._value;
            }
            entry = entry._next;
        }
        return null;
    }

    public Map.Entry<K, V> getEntry(K key) {
        EntryImpl entry = this._entries[UtlLinkedHashMap.keyHash(key) & this._mask];
        while (entry != null) {
            if (key.equals(entry._key)) {
                return entry;
            }
            entry = entry._next;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        EntryImpl entry = this._entries[UtlLinkedHashMap.keyHash(key) & this._mask];
        while (entry != null) {
            if (key.equals(entry._key)) {
                Object prevValue = entry._value;
                entry._value = value;
                return (V)prevValue;
            }
            entry = entry._next;
        }
        this.addEntry(key, value);
        return null;
    }

    public FastIterator fastIterator() {
        return this._fastIterator;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.addEntry(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        EntryImpl entry = this._entries[UtlLinkedHashMap.keyHash(key) & this._mask];
        while (entry != null) {
            if (key.equals(entry._key)) {
                Object prevValue = entry._value;
                this.removeEntry(entry);
                return (V)prevValue;
            }
            entry = entry._next;
        }
        return null;
    }

    @Override
    public void clear() {
        EntryImpl entry = this._mapFirst;
        while (entry != null) {
            entry._key = null;
            entry._value = null;
            entry._before = null;
            entry._next = null;
            if (entry._previous == null) {
                this._entries[entry._index] = null;
            } else {
                entry._previous = null;
            }
            entry = entry._after;
        }
        if (this._mapLast != null) {
            ((EntryImpl)this._mapLast)._after = (EntryImpl)this._poolFirst;
            this._poolFirst = this._mapFirst;
            this._mapFirst = null;
            this._mapLast = null;
            this._size = 0;
            this.sizeChanged();
        }
    }

    public void setCapacity(int newCapacity) {
        int tableLength;
        EntryImpl entry;
        int i;
        if (newCapacity > this._capacity) {
            for (i = this._capacity; i < newCapacity; ++i) {
                entry = new EntryImpl();
                entry._after = (EntryImpl)this._poolFirst;
                this._poolFirst = entry;
            }
        } else if (newCapacity < this._capacity) {
            for (i = newCapacity; i < this._capacity && this._poolFirst != null; ++i) {
                entry = this._poolFirst;
                this._poolFirst = entry._after;
                entry._after = null;
            }
        }
        for (tableLength = 16; tableLength < newCapacity; tableLength <<= 1) {
        }
        if (this._entries.length != tableLength) {
            this._entries = new EntryImpl[tableLength];
            this._mask = tableLength - 1;
            entry = this._mapFirst;
            while (entry != null) {
                int index = UtlLinkedHashMap.keyHash(entry._key) & this._mask;
                entry._index = index;
                entry._previous = null;
                EntryImpl<K, V> next = this._entries[index];
                entry._next = (EntryImpl)next;
                if (next != null) {
                    ((EntryImpl)next)._previous = entry;
                }
                this._entries[index] = entry;
                entry = entry._after;
            }
        }
        this._capacity = newCapacity;
    }

    public Object clone() {
        try {
            UtlLinkedHashMap clone = (UtlLinkedHashMap)super.clone();
            clone.initialize(this._capacity);
            clone.putAll(this);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Map) {
            Map that = (Map)obj;
            if (this.size() == that.size()) {
                EntryImpl entry = this._mapFirst;
                while (entry != null) {
                    if (!that.entrySet().contains(entry)) {
                        return false;
                    }
                    entry = entry._after;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = 0;
        EntryImpl entry = this._mapFirst;
        while (entry != null) {
            code += entry.hashCode();
            entry = entry._after;
        }
        return code;
    }

    public String toString() {
        return this.entrySet().toString();
    }

    @Override
    public Collection<V> values() {
        return this._values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._entrySet;
    }

    @Override
    public Set<K> keySet() {
        return this._keySet;
    }

    protected void sizeChanged() {
        if (this.size() > this.capacity()) {
            this.setCapacity(this.capacity() * 2);
        }
    }

    private static <K> int keyHash(K key) {
        int hashCode = key.hashCode();
        hashCode += ~(hashCode << 9);
        hashCode ^= hashCode >>> 14;
        hashCode += hashCode << 4;
        hashCode ^= hashCode >>> 10;
        return hashCode;
    }

    private void addEntry(K key, V value) {
        EntryImpl<K, V> entry = this._poolFirst;
        if (entry != null) {
            this._poolFirst = ((EntryImpl)entry)._after;
            ((EntryImpl)entry)._after = null;
        } else {
            entry = new EntryImpl();
        }
        ((EntryImpl)entry)._key = key;
        ((EntryImpl)entry)._value = value;
        int index = UtlLinkedHashMap.keyHash(key) & this._mask;
        ((EntryImpl)entry)._index = index;
        EntryImpl<K, V> next = this._entries[index];
        ((EntryImpl)entry)._next = (EntryImpl)next;
        if (next != null) {
            ((EntryImpl)next)._previous = (EntryImpl)entry;
        }
        this._entries[index] = entry;
        if (this._mapLast != null) {
            ((EntryImpl)entry)._before = (EntryImpl)this._mapLast;
            ((EntryImpl)this._mapLast)._after = (EntryImpl)entry;
        } else {
            this._mapFirst = entry;
        }
        this._mapLast = entry;
        ++this._size;
        this.sizeChanged();
    }

    private void removeEntry(EntryImpl<K, V> entry) {
        EntryImpl previous = ((EntryImpl)entry)._previous;
        EntryImpl next = ((EntryImpl)entry)._next;
        if (previous != null) {
            previous._next = next;
            ((EntryImpl)entry)._previous = null;
        } else {
            this._entries[((EntryImpl)entry)._index] = next;
        }
        if (next != null) {
            next._previous = previous;
            ((EntryImpl)entry)._next = null;
        }
        EntryImpl before = ((EntryImpl)entry)._before;
        EntryImpl after = ((EntryImpl)entry)._after;
        if (before != null) {
            before._after = after;
            ((EntryImpl)entry)._before = null;
        } else {
            this._mapFirst = after;
        }
        if (after != null) {
            after._before = before;
        } else {
            this._mapLast = before;
        }
        ((EntryImpl)entry)._key = null;
        ((EntryImpl)entry)._value = null;
        ((EntryImpl)entry)._after = (EntryImpl)this._poolFirst;
        this._poolFirst = entry;
        --this._size;
        this.sizeChanged();
    }

    private void initialize(int capacity) {
        int tableLength;
        for (tableLength = 16; tableLength < capacity; tableLength <<= 1) {
        }
        this._entries = new EntryImpl[tableLength];
        this._mask = tableLength - 1;
        this._capacity = capacity;
        this._size = 0;
        this._values = new Values();
        this._entrySet = new EntrySet();
        this._keySet = new KeySet();
        this._poolFirst = null;
        this._mapFirst = null;
        this._mapLast = null;
        for (int i = 0; i < capacity; ++i) {
            EntryImpl entry = new EntryImpl();
            entry._after = (EntryImpl)this._poolFirst;
            this._poolFirst = entry;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int capacity = stream.readInt();
        this.initialize(capacity);
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = stream.readObject();
            Object value = stream.readObject();
            this.addEntry(key, value);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this._capacity);
        stream.writeInt(this._size);
        int count = 0;
        EntryImpl entry = this._mapFirst;
        while (entry != null) {
            stream.writeObject(entry._key);
            stream.writeObject(entry._value);
            ++count;
            entry = entry._after;
        }
        if (count != this._size) {
            throw new IOException("UtlLinkedHashMap Corrupted");
        }
    }

    private static final class EntryImpl<K, V>
    implements Map.Entry<K, V> {
        private K _key;
        private V _value;
        private int _index;
        private EntryImpl<K, V> _previous;
        private EntryImpl<K, V> _next;
        private EntryImpl<K, V> _before;
        private EntryImpl<K, V> _after;

        private EntryImpl() {
        }

        @Override
        public K getKey() {
            return this._key;
        }

        @Override
        public V getValue() {
            return this._value;
        }

        @Override
        public V setValue(V value) {
            V old = this._value;
            this._value = value;
            return old;
        }

        @Override
        public boolean equals(Object that) {
            if (that instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)that;
                return this._key.equals(entry.getKey()) && (this._value != null ? this._value.equals(entry.getValue()) : entry.getValue() == null);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this._key.hashCode() ^ (this._value != null ? this._value.hashCode() : 0);
        }

        public String toString() {
            return this._key + "=" + this._value;
        }
    }

    public final class FastIterator
    implements ListIterator<Map.Entry<K, V>> {
        EntryImpl<K, V> after;
        EntryImpl<K, V> before;
        int nextIndex;

        public FastIterator() {
            this.after = UtlLinkedHashMap.this._mapFirst;
            this.nextIndex = 0;
        }

        public FastIterator toFirst() {
            this.after = UtlLinkedHashMap.this._mapFirst;
            this.before = null;
            this.nextIndex = 0;
            return this;
        }

        public FastIterator toLast() {
            this.after = null;
            this.before = UtlLinkedHashMap.this._mapLast;
            this.nextIndex = UtlLinkedHashMap.this._size;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.after != null;
        }

        public Map.Entry<K, V> nextEntry() {
            if (this.after != null) {
                ++this.nextIndex;
                this.before = this.after;
                this.after = this.after._after;
                return this.before;
            }
            throw new NoSuchElementException();
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }

        @Override
        public boolean hasPrevious() {
            return this.before != null;
        }

        public Map.Entry<K, V> previousEntry() {
            if (this.before != null) {
                --this.nextIndex;
                this.after = this.before;
                this.before = this.before._after;
                return this.after;
            }
            throw new NoSuchElementException();
        }

        @Override
        public Map.Entry<K, V> previous() {
            return this.previousEntry();
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            if (this.before == null) {
                throw new IllegalStateException();
            }
            UtlLinkedHashMap.this.removeEntry(this.before);
        }

        @Override
        public void set(Map.Entry<K, V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Map.Entry<K, V> o) {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                EntryImpl<K, V> after;
                EntryImpl<K, V> before;
                {
                    this.after = UtlLinkedHashMap.this._mapFirst;
                }

                @Override
                public void remove() {
                    if (this.before == null) {
                        throw new IllegalStateException();
                    }
                    UtlLinkedHashMap.this.removeEntry(this.before);
                }

                @Override
                public boolean hasNext() {
                    return this.after != null;
                }

                @Override
                public K next() {
                    if (this.after != null) {
                        this.before = this.after;
                        this.after = this.after._after;
                        return this.before._key;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public int size() {
            return UtlLinkedHashMap.this._size;
        }

        @Override
        public boolean contains(Object obj) {
            return UtlLinkedHashMap.this.containsKey(obj);
        }

        @Override
        public boolean remove(Object obj) {
            return UtlLinkedHashMap.this.remove(obj) != null;
        }

        @Override
        public void clear() {
            UtlLinkedHashMap.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                EntryImpl<K, V> after;
                EntryImpl<K, V> before;
                {
                    this.after = UtlLinkedHashMap.this._mapFirst;
                }

                @Override
                public void remove() {
                    if (this.before == null) {
                        throw new IllegalStateException();
                    }
                    UtlLinkedHashMap.this.removeEntry(this.before);
                }

                @Override
                public boolean hasNext() {
                    return this.after != null;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.after != null) {
                        this.before = this.after;
                        this.after = this.after._after;
                        return this.before;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public int size() {
            return UtlLinkedHashMap.this._size;
        }

        @Override
        public boolean contains(Object obj) {
            if (obj instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)obj;
                Map.Entry mapEntry = UtlLinkedHashMap.this.getEntry(entry.getKey());
                return entry.equals(mapEntry);
            }
            return false;
        }

        @Override
        public boolean remove(Object obj) {
            Map.Entry entry;
            EntryImpl mapEntry;
            if (obj instanceof Map.Entry && (mapEntry = (EntryImpl)UtlLinkedHashMap.this.getEntry((entry = (Map.Entry)obj).getKey())) != null && entry.getValue().equals(mapEntry._value)) {
                UtlLinkedHashMap.this.removeEntry(mapEntry);
                return true;
            }
            return false;
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                EntryImpl<K, V> after;
                EntryImpl<K, V> before;
                {
                    this.after = UtlLinkedHashMap.this._mapFirst;
                }

                @Override
                public void remove() {
                    if (this.before == null) {
                        throw new IllegalStateException();
                    }
                    UtlLinkedHashMap.this.removeEntry(this.before);
                }

                @Override
                public boolean hasNext() {
                    return this.after != null;
                }

                @Override
                public V next() {
                    if (this.after != null) {
                        this.before = this.after;
                        this.after = this.after._after;
                        return this.before._value;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public int size() {
            return UtlLinkedHashMap.this._size;
        }

        @Override
        public boolean contains(Object o) {
            return UtlLinkedHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            UtlLinkedHashMap.this.clear();
        }
    }
}

