/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.test.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.fusesource.jansi.AnsiString;

public class ProcessWrapper {
    private final Process process;
    private final BufferedWriter out;
    private final OutputMonitor in;
    private final OutputMonitor err;

    private ProcessWrapper(Process process) {
        this.process = process;
        this.out = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
        this.in = new OutputMonitor(process.getInputStream(), false);
        this.err = new OutputMonitor(process.getErrorStream(), true);
    }

    public static final ProcessWrapper launch(List<String> cmd, File file) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(cmd);
        if (file != null) {
            pb.directory(file);
        }
        Process process = pb.start();
        return new ProcessWrapper(process);
    }

    public void writeLn(String line) throws IOException {
        this.in.flush();
        this.err.flush();
        if (this.in.echoOutput) {
            System.out.println(line + " <enter>");
        }
        this.out.write(line);
        this.out.newLine();
        this.out.flush();
    }

    public void close() {
        try {
            this.in.flush();
            this.err.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.process.destroy();
        try {
            this.process.waitFor();
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.err.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (IOException iOException) {}
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    public void waitForOutputQuiescence(long time) {
        while (System.currentTimeMillis() - this.in.getLastOutput() < time) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        while (System.currentTimeMillis() - this.err.getLastOutput() < time) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public final void setOutputEchoEnabled(boolean enabled) {
        this.in.setOutputEchoEnabled(enabled);
    }

    public final void markOutputPosistions() {
        this.in.markOutputPositions();
        this.err.markOutputPositions();
    }

    public final void resetOutputMarks() {
        this.in.resetOutputMark();
        this.err.resetOutputMark();
    }

    public int getErrorOutputLength() {
        return this.err.sb.length();
    }

    public int getOutputLength() {
        return this.in.sb.length();
    }

    public final boolean waitForOutputAndQuiesence(long quiescencePeriod, long timeout) {
        return this.in.waitForOutputAndQuiesence(quiescencePeriod, timeout);
    }

    public final boolean waitForOutputAndQuiesence(long quiescencePeriod, long timeout, String output) {
        long end = System.currentTimeMillis() + timeout;
        this.in.waitForOutputAndQuiesence(quiescencePeriod, timeout);
        boolean timedOut = false;
        while (!this.checkForOutput(output) && !timedOut) {
            long remaining = end - System.currentTimeMillis();
            if (remaining <= 0L) {
                timedOut = true;
            }
            if (this.err.sb.length() > this.err.mark) {
                this.err.waitForOutputAndQuiesence(1000L, 0L);
                return false;
            }
            this.in.waitForOutputAndQuiesence(quiescencePeriod, remaining);
        }
        if (this.err.sb.length() > this.err.mark) {
            this.err.waitForOutputAndQuiesence(1000L, timeout);
            return false;
        }
        return !timedOut;
    }

    public final boolean checkForOutput(String text) {
        return this.in.checkForOutput(text);
    }

    public final String getErrorOutput() {
        return this.err.getOutput();
    }

    public final String getOutput() {
        return this.in.getOutput();
    }

    private class OutputMonitor
    implements Runnable {
        private final Thread thread;
        private final BufferedInputStream is;
        private final StringBuilder sb = new StringBuilder();
        private final BufferedOutputStream out;
        private volatile long lastOutput;
        private int mark;
        private boolean echoOutput = true;

        OutputMonitor(InputStream is, boolean err) {
            this.is = new BufferedInputStream(is);
            this.thread = new Thread((Runnable)this, "Process " + (err ? "Error" : "Output") + " Monitor");
            this.out = new BufferedOutputStream(err ? System.err : System.out);
            this.thread.start();
            this.lastOutput = System.currentTimeMillis();
        }

        public void close() throws IOException {
            this.is.close();
        }

        @Override
        public void run() {
            try {
                int b = 0;
                while ((b = this.is.read()) != -1) {
                    this.lastOutput = System.currentTimeMillis();
                    this.sb.append((char)b);
                    if (!this.echoOutput) continue;
                    this.out.write(b);
                    if ('\n' != (char)b) continue;
                    this.out.flush();
                }
            }
            catch (EOFException eof) {
                return;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return;
            }
        }

        private void flush() throws IOException {
            this.out.flush();
        }

        public long getLastOutput() {
            return this.lastOutput;
        }

        public String getOutput() {
            return new AnsiString((CharSequence)this.sb).getPlain().toString();
        }

        public void markOutputPositions() {
            this.mark = this.sb.length();
        }

        public boolean waitForOutputAndQuiesence(long quiescencePeriod, long timeout) {
            long start = System.currentTimeMillis();
            while (this.mark >= this.sb.length() || System.currentTimeMillis() - ProcessWrapper.this.in.getLastOutput() < quiescencePeriod) {
                if (System.currentTimeMillis() - start > timeout) {
                    return false;
                }
                try {
                    if (this.echoOutput) {
                        this.out.flush();
                    }
                    Thread.sleep(Math.max(Math.min(500L, quiescencePeriod), 1L));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
                catch (IOException iOException) {
                }
            }
            return true;
        }

        public void resetOutputMark() {
            this.mark = 0;
        }

        public boolean checkForOutput(String text) {
            return this.sb.indexOf(text, this.mark) > 0;
        }

        private void setOutputEchoEnabled(boolean enabled) {
            this.echoOutput = enabled;
        }
    }
}

