/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.test;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import org.junit.Assume;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class ConditionalIgnoreRule
implements MethodRule {
    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        IgnoreCondition condition;
        Statement result = base;
        if (ConditionalIgnoreRule.hasConditionalIgnoreAnnotation(method) && (condition = ConditionalIgnoreRule.getIgnoreContition(target, method)).isSatisfied()) {
            result = new IgnoreStatement(condition);
        }
        return result;
    }

    private static boolean hasConditionalIgnoreAnnotation(FrameworkMethod method) {
        return method.getAnnotation(ConditionalIgnore.class) != null;
    }

    private static IgnoreCondition getIgnoreContition(Object target, FrameworkMethod method) {
        ConditionalIgnore annotation = (ConditionalIgnore)method.getAnnotation(ConditionalIgnore.class);
        return new IgnoreConditionCreator(target, annotation).create();
    }

    private static class IgnoreStatement
    extends Statement {
        private final IgnoreCondition condition;

        IgnoreStatement(IgnoreCondition condition) {
            this.condition = condition;
        }

        public void evaluate() {
            Assume.assumeTrue((String)("Ignored by " + this.condition.getClass().getSimpleName()), (boolean)false);
        }
    }

    private static class IgnoreConditionCreator {
        private final Object target;
        private final Class<? extends IgnoreCondition> conditionType;

        IgnoreConditionCreator(Object target, ConditionalIgnore annotation) {
            this.target = target;
            this.conditionType = annotation.condition();
        }

        IgnoreCondition create() {
            this.checkConditionType();
            try {
                return this.createCondition();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private IgnoreCondition createCondition() throws Exception {
            IgnoreCondition result = this.isConditionTypeStandalone() ? this.conditionType.newInstance() : this.conditionType.getDeclaredConstructor(this.target.getClass()).newInstance(this.target);
            return result;
        }

        private void checkConditionType() {
            if (!this.isConditionTypeStandalone() && !this.isConditionTypeDeclaredInTarget()) {
                String msg = "Conditional class '%s' is a member class but was not declared inside the test case using it.\nEither make this class a static class, standalone class (by declaring it in it's own file) or move it inside the test case using it";
                throw new IllegalArgumentException(String.format(msg, this.conditionType.getName()));
            }
        }

        private boolean isConditionTypeStandalone() {
            return !this.conditionType.isMemberClass() || Modifier.isStatic(this.conditionType.getModifiers());
        }

        private boolean isConditionTypeDeclaredInTarget() {
            return this.target.getClass().isAssignableFrom(this.conditionType.getDeclaringClass());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ConditionalIgnore {
        public Class<? extends IgnoreCondition> condition();
    }

    public static interface IgnoreCondition {
        public boolean isSatisfied();
    }
}

