#!/bin/bash

# Create the Rumi user
sudo adduser rumi
# ...add it to the sudo group 
sudo usermod -aG wheel rumi
# ...update the sudo group to enable nopasswd login
sudo sed -i 's/%wheel\tALL=(ALL)\tALL/# %wheel\tALL=(ALL)\tALL/g' /etc/sudoers
sudo sed -i 's/# %wheel\tALL=(ALL)\tNOPASSWD: ALL/%wheel\tALL=(ALL)\tNOPASSWD: ALL/g' /etc/sudoers
# ...create the user's key pair and authorized keys
sudo mkdir ~rumi/.ssh
sudo ssh-keygen -t rsa -N '' -f ~rumi/.ssh/id_rsa <<< y
sudo cp /root/.ssh/authorized_keys ~rumi/.ssh
sudo chown -R rumi ~rumi/.ssh
sudo chgrp -R rumi ~rumi/.ssh
sudo chmod 700 ~rumi/.ssh

# Work around for "authenticity of host ... can't be established"
sudo echo "UserKnownHostsFile /dev/null" >> ~rumi/.ssh/config
sudo echo "StrictHostKeyChecking no" >> ~rumi/.ssh/config
sudo chmod 644 ~rumi/.ssh/config

# Create the various directories
sudo mkdir ~rumi/scripts
sudo chown -R rumi ~rumi/scripts
sudo chgrp -R rumi ~rumi/scripts

# Install docker
sudo dnf -y install dnf-plugins-core
sudo dnf config-manager --add-repo https://download.docker.com/linux/rhel/docker-ce.repo
sudo dnf -y install docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin
sudo systemctl enable --now docker

# Create grafana data directory
sudo mkdir /home/rumi/grafana-data
sudo chmod 777 /home/rumi/grafana-data

# Download and run the latest Rumi Monitor
sudo docker run --restart=always -d -p 3000:3000 --network=host -v /home/rumi/grafana-data:/var/lib/grafana neeve/nvx-rumi-monitor:latest

# Disable remote login as root
sudo truncate --size=0 /root/.ssh/authorized_keys
