#!/bin/bash

# Usage function
print_usage() {
    echo "Usage: $0 --file <file_path> --target-host <target_host> --target-dir <target_directory>"
    exit 1
}

# Parse input arguments
FILE=""
TARGET_HOST=""
TARGET_DIR=""

while [[ "$1" == -* ]]; do
    case "$1" in
    --file)
        shift
        FILE=$1
        shift
    ;;
    --target-host)
        shift
        TARGET_HOST=$1
        shift
    ;;
    --target-dir)
        shift
        TARGET_DIR=$1
        shift
    ;;
    *)
        echo "Error: Unknown option: $1" >&2
        exit 1
    ;;
    esac
done

# Validate input parameters
if [[ -z "$FILE" || -z "$TARGET_HOST" || -z "$TARGET_DIR" ]]; then
    print_usage
fi

# Ensure the file exists before attempting to copy
if [[ ! -f "$FILE" ]]; then
    echo "Error: File '$FILE' does not exist."
    exit 1
fi

# Copy the file using scp with the ~/.ssh/rumi key
echo "Copying '$FILE' to '$TARGET_HOST:$TARGET_DIR'..."
scp -i ~/.ssh/rumi "$FILE" "rumi@$TARGET_HOST:$TARGET_DIR"

# Check if the copy was successful
if [[ $? -eq 0 ]]; then
    echo "File successfully copied to $TARGET_HOST:$TARGET_DIR"
else
    echo "Error: File transfer failed."
    exit 1
fi
    
