/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.event;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.neeve.event.Event;
import com.neeve.event.EventMultiplexer;
import com.neeve.event.IEventHandler;
import com.neeve.event.IEventMultiplexer;
import com.neeve.event.IEventMultiplexerStats;
import com.neeve.stats.IStats;
import com.neeve.stats.Stats;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlDisruptor;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.text.NumberFormat;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class EventMultiplexerSingleThreaded
extends EventMultiplexer {
    private static final AtomicInteger multiplexerId = new AtomicInteger();
    private final String claimStrategyStr;
    private final String waitStrategyStr;
    private final int maxFeederConcurrency;
    private final DisruptorFeeder feeder;
    private final Disruptor<CarrierEvent> disruptor;
    private final RingBuffer<CarrierEvent> ringBuffer;
    private final long cpuAffinityMask;
    private final MultiplexerStats stats;
    private Thread processorThread;
    private boolean closeDeferred;
    public static final String PROP_QUEUE_DEPTH = "queueDepth";
    public static final int PROP_QUEUE_DEPTH_DEFAULT = 1024;
    public static final String PROP_QUEUE_OFFER_STRATEGY = "queueOfferStrategy";
    public static final String PROP_QUEUE_OFFER_STRATEGY_DEFAULT = "MultiThreaded";
    public static final String PROP_QUEUE_WAIT_STRATEGY = "queueWaitStrategy";
    public static final String PROP_QUEUE_WAIT_STRATEGY_DEFAULT = null;
    public static final String PROP_QUEUE_MAX_FEEDER_CONCURRENCY = "queueFeedMaxConcurrency";
    public static final int PROP_QUEUE_MAX_FEEDER_CONCURRENCY_DEFAULT = 16;
    public static final String PROP_QUEUE_DRAINER_CPU_AFFINITY_MASK = "queueDrainerCpuAffinityMask";

    protected EventMultiplexerSingleThreaded(String name, boolean administrative, IEventHandler eventHandler, Properties props) {
        super(name, administrative, eventHandler);
        int queueDepth = UtlProps.getValue((Properties)props, (String)PROP_QUEUE_DEPTH, (int)1024);
        this.claimStrategyStr = UtlProps.getValue((Properties)props, (String)PROP_QUEUE_OFFER_STRATEGY, (String)PROP_QUEUE_OFFER_STRATEGY_DEFAULT);
        ProducerType producerType = UtlDisruptor.legacyClaimStrategyStrToProducerType((String)this.claimStrategyStr);
        WaitStrategy waitStrategy = UtlDisruptor.getWaitStrategy((String)UtlProps.getValue((Properties)props, (String)PROP_QUEUE_WAIT_STRATEGY, (String)PROP_QUEUE_WAIT_STRATEGY_DEFAULT), (!administrative ? 1 : 0) != 0);
        this.waitStrategyStr = UtlDisruptor.waitStrategyToStr((WaitStrategy)waitStrategy);
        this.disruptor = UtlDisruptor.createSingleConsumerDisruptor((EventFactory)new CarrierEventFactory(), (int)queueDepth, (ThreadFactory)new CarrierEventProcessorThreadFactory(), (ProducerType)producerType, (WaitStrategy)waitStrategy, (EventHandler)new CarrierEventProcessor());
        this.ringBuffer = this.disruptor.getRingBuffer();
        this.maxFeederConcurrency = UtlProps.getValue((Properties)props, (String)PROP_QUEUE_MAX_FEEDER_CONCURRENCY, (int)16);
        this.feeder = new DisruptorFeeder(this.maxFeederConcurrency);
        this.cpuAffinityMask = UtlThread.parseAffinityMask((String)UtlProps.getValue((Properties)props, (String)PROP_QUEUE_DRAINER_CPU_AFFINITY_MASK, (String)UtlThread.getDefaultCPUAffinityMask()));
        this.tracer.log(" Multiplexer Configuration {", Tracer.Level.CONFIG);
        this.tracer.log(" ...type=SingleThreaded.", Tracer.Level.CONFIG);
        this.tracer.log(" ...queue depth=" + queueDepth + ".", Tracer.Level.CONFIG);
        this.tracer.log(" ...claimStrategy=" + this.claimStrategyStr + ".", Tracer.Level.CONFIG);
        this.tracer.log(" ...waitStrategy=" + this.waitStrategyStr + ".", Tracer.Level.CONFIG);
        this.tracer.log(" ...cpuAffinity=" + this.cpuAffinityMask + ".", Tracer.Level.CONFIG);
        this.tracer.log(" }", Tracer.Level.CONFIG);
        this.stats = new MultiplexerStats(name, "nv.event.mux." + name + ".stats.interval");
    }

    public static final IEventMultiplexer create(String name, boolean administrative, IEventHandler eventHandler, Properties props) {
        return new EventMultiplexerSingleThreaded(name, administrative, eventHandler, props == null ? new Properties() : props);
    }

    public static final IEventMultiplexer create(String name, IEventHandler eventHandler, Properties props) {
        return EventMultiplexerSingleThreaded.create(name, false, eventHandler, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dispatch(Event event) {
        try {
            if (this.state == IEventMultiplexer.State.Open) {
                this.dispatchEvent(event);
                if (this.closeDeferred) {
                    this.disruptor.halt();
                    this.stats.close();
                    this.closeDeferred = false;
                    UtlThread.deregister((Thread)Thread.currentThread());
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Multiplexer event handler [" + this.eventHandler + "] faulted with error [" + e.toString() + "] on event {" + event + "} with the following stack trace:\n");
            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
            sb.append("Ignoring...");
            this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
        }
        finally {
            event.dispose();
        }
    }

    @Override
    protected final void doOpen() {
        this.disruptor.start();
    }

    @Override
    protected final void doMultiplex(Event event, int flags) {
        this.feeder.offer(event, (flags & 1) == 1 || Thread.currentThread() == this.processorThread);
    }

    @Override
    protected final void doClose() {
        if (Thread.currentThread() != this.processorThread) {
            this.stats.close();
            while (this.processorThread.isAlive()) {
                this.disruptor.halt();
                try {
                    this.processorThread.join(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.processorThread = null;
            UtlThread.deregister((Thread)this.processorThread);
        } else {
            this.closeDeferred = true;
        }
    }

    @Override
    public final IEventMultiplexerStats getStats() {
        return this.stats;
    }

    private final class CarrierEventProcessorThreadFactory
    implements ThreadFactory {
        private CarrierEventProcessorThreadFactory() {
        }

        @Override
        public final Thread newThread(Runnable r) {
            return EventMultiplexerSingleThreaded.this.processorThread = new CarrierEventProcessorThread("X-STEMux-" + EventMultiplexerSingleThreaded.this.name + "-" + multiplexerId.incrementAndGet(), r);
        }
    }

    private final class CarrierEventProcessorThread
    extends Thread {
        private final Runnable r;

        CarrierEventProcessorThread(String name, Runnable r) {
            this.setDaemon(true);
            this.setName(name);
            this.r = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            UtlThread.setCPUAffinityMask((long)EventMultiplexerSingleThreaded.this.cpuAffinityMask);
            try {
                this.r.run();
            }
            finally {
                EventMultiplexerSingleThreaded.this.feeder.threadQueue.remove();
                for (Queue queue : EventMultiplexerSingleThreaded.this.feeder.queues) {
                    queue.cleanup();
                }
            }
        }
    }

    private final class CarrierEventProcessor
    implements EventHandler<CarrierEvent> {
        private CarrierEventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onEvent(CarrierEvent event, long sequence, boolean endOfBatch) throws Exception {
            long preProcTs = EventMultiplexer.recordEventLegLatencies ? System.nanoTime() : 0L;
            try {
                if (event.offerTs > 0L) {
                    ((EventMultiplexerSingleThreaded)EventMultiplexerSingleThreaded.this).stats.o2p.add((double)(UtlTime.now() - event.offerTs));
                }
                event.event.setEndOfBatch(endOfBatch);
                EventMultiplexerSingleThreaded.this.dispatch(event.event);
                if (endOfBatch) {
                    EventMultiplexerSingleThreaded.this.feeder.decongest();
                }
            }
            finally {
                event.event = null;
                if (EventMultiplexer.recordEventLegLatencies) {
                    ((EventMultiplexerSingleThreaded)EventMultiplexerSingleThreaded.this).stats.proc.add((double)(System.nanoTime() - preProcTs));
                }
            }
        }
    }

    private final class CarrierEventFactory
    implements EventFactory<CarrierEvent> {
        private CarrierEventFactory() {
        }

        public final CarrierEvent newInstance() {
            return new CarrierEvent();
        }
    }

    private final class CarrierEvent {
        long offerTs;
        Event event;

        private CarrierEvent() {
        }
    }

    private final class MultiplexerStats
    extends Stats
    implements IEventMultiplexerStats {
        private final FeederQueueStats[] feederQueueStats;
        private final NumberFormat format;
        final Stats.LatencyManager o2p;
        final Stats.LatencyManager proc;

        MultiplexerStats(String name, String startProp) {
            super("nv.event.stmux", name, "nv.event.stmux.stats", startProp);
            this.o2p = new Stats.LatencyManager(" o2p");
            this.proc = new Stats.LatencyManager("proc");
            this.format = NumberFormat.getInstance();
            this.format.setMaximumFractionDigits(2);
            this.feederQueueStats = new FeederQueueStats[EventMultiplexerSingleThreaded.this.feeder.queues.length];
            for (int i = 0; i < this.feederQueueStats.length; ++i) {
                this.feederQueueStats[i] = new FeederQueueStats();
            }
            this.startPeriodicOutputIfConfigured();
        }

        private final void stamp() {
        }

        protected final void init() {
            this.stamp();
        }

        public final synchronized void get(StringBuilder sb) {
            int i;
            long disruptorCapacity = EventMultiplexerSingleThreaded.this.ringBuffer.getBufferSize();
            long disruptorRemaining = EventMultiplexerSingleThreaded.this.ringBuffer.remainingCapacity();
            long disruptorUsed = disruptorCapacity - disruptorRemaining;
            int disruptorUsagePct = (int)(disruptorUsed * 100L / disruptorCapacity);
            String disruptorCapacityStr = this.format.format(disruptorCapacity);
            String disruptorUsedStr = this.format.format(disruptorUsed);
            String disruptorUsagePctStr = this.format.format(disruptorUsagePct);
            int lastFeederDecongested = EventMultiplexerSingleThreaded.this.feeder.lastDecongested;
            for (i = 0; i < this.feederQueueStats.length; ++i) {
                Queue queue = EventMultiplexerSingleThreaded.this.feeder.queues[i];
                this.feederQueueStats[i].owner = queue.owner.get();
                this.feederQueueStats[i].size = queue.size();
                this.feederQueueStats[i].decongestCount = queue.decongestCount;
                queue.latencyManager().compute();
                this.feederQueueStats[i].latencyManager = queue.latencyManager();
            }
            this.o2p.compute();
            this.proc.compute(0.001);
            sb.append("Disruptor (").append(EventMultiplexerSingleThreaded.this.claimStrategyStr).append(", ").append(EventMultiplexerSingleThreaded.this.waitStrategyStr).append(")...\n");
            sb.append("[").append(disruptorUsedStr).append(" of ").append(disruptorCapacityStr).append("] ").append(disruptorUsagePctStr).append("%").append("\n");
            this.o2p.get(sb);
            this.proc.get(sb);
            sb.append("Schedule Queue (size=").append(EventMultiplexerSingleThreaded.this.numScheduledEvents).append(").\n");
            sb.append("Feeder Queues (max=").append(EventMultiplexerSingleThreaded.this.maxFeederConcurrency).append(", lastDecongest=").append(lastFeederDecongested).append(")\n");
            for (i = 0; i < this.feederQueueStats.length; ++i) {
                if (this.feederQueueStats[i].owner == null) continue;
                sb.append("...").append(this.feederQueueStats[i].owner.getName()).append(" has ").append(this.format.format(this.feederQueueStats[i].size)).append(" (decongestCount=").append(this.feederQueueStats[i].decongestCount).append(")").append("\n").append("...");
                this.feederQueueStats[i].latencyManager.get(sb);
            }
            this.stamp();
        }

        @Override
        public final IStats.Latencies getOfferToPollLatencies() {
            return this.o2p;
        }

        public final IStats.Latencies getProcessingLatencies() {
            return this.proc;
        }

        @Override
        public int getScheduleQueueSize() {
            return EventMultiplexerSingleThreaded.this.numScheduledEvents;
        }

        @Override
        public int getLastDecongested() {
            return EventMultiplexerSingleThreaded.this.feeder.lastDecongested;
        }

        @Override
        public int getMaxConcurrency() {
            return EventMultiplexerSingleThreaded.this.maxFeederConcurrency;
        }

        @Override
        public int getCapacity() {
            return EventMultiplexerSingleThreaded.this.ringBuffer.getBufferSize();
        }

        @Override
        public int getCapacityRemaining() {
            return (int)EventMultiplexerSingleThreaded.this.ringBuffer.remainingCapacity();
        }

        @Override
        public String getClaimStrategy() {
            return EventMultiplexerSingleThreaded.this.claimStrategyStr;
        }

        @Override
        public String getWaitStrategy() {
            return EventMultiplexerSingleThreaded.this.waitStrategyStr;
        }

        @Override
        public void getFeederQueueStats(List<IEventMultiplexerStats.IFeederQueueStats> results) {
            for (int i = 0; i < this.feederQueueStats.length; ++i) {
                if (i >= EventMultiplexerSingleThreaded.this.feeder.queues.length) continue;
                Queue queue = EventMultiplexerSingleThreaded.this.feeder.queues[i];
                Thread owner = queue.owner.get();
                if (owner == null) continue;
                results.add(queue);
            }
        }

        @Override
        public int getNumFeederQueues() {
            return EventMultiplexerSingleThreaded.this.feeder.queues.length;
        }

        private final class FeederQueueStats
        implements IEventMultiplexerStats.IFeederQueueStats {
            Thread owner;
            int size;
            int decongestCount;
            Stats.LatencyManager latencyManager;

            private FeederQueueStats() {
            }

            @Override
            public final int getSize() {
                return this.size;
            }

            @Override
            public final int getDecongestCount() {
                return this.decongestCount;
            }

            @Override
            public Thread getOwner() {
                if (this.owner != null) {
                    return this.owner;
                }
                return null;
            }

            @Override
            public IStats.Latencies getOfferToPollLatencies() {
                return null;
            }
        }
    }

    private final class DisruptorFeeder {
        private final ThreadLocal<Queue> threadQueue;
        private final Queue[] queues;
        private final AtomicInteger numOwned;
        private int lastDecongested;

        DisruptorFeeder(int maxConcurrency) {
            this.queues = new Queue[maxConcurrency];
            for (int i = 0; i < this.queues.length; ++i) {
                this.queues[i] = new Queue(EventMultiplexerSingleThreaded.this.tracer);
            }
            this.threadQueue = new ThreadLocal();
            this.numOwned = new AtomicInteger();
            this.lastDecongested = -1;
        }

        private final long getDisruptorSlot(boolean nonBlocking) {
            long sequence = -1L;
            if (nonBlocking) {
                if (EventMultiplexerSingleThreaded.this.ringBuffer.hasAvailableCapacity(1)) {
                    try {
                        sequence = EventMultiplexerSingleThreaded.this.ringBuffer.tryNext(1);
                    }
                    catch (InsufficientCapacityException insufficientCapacityException) {}
                }
            } else {
                sequence = EventMultiplexerSingleThreaded.this.ringBuffer.next();
            }
            return sequence;
        }

        private final void publish(long sequence, Event event) {
            CarrierEvent carrierEvent = (CarrierEvent)EventMultiplexerSingleThreaded.this.ringBuffer.get(sequence);
            carrierEvent.event = event;
            carrierEvent.offerTs = carrierEvent.event.offerTs;
            EventMultiplexerSingleThreaded.this.ringBuffer.publish(sequence);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void offer(Event event, boolean nonBlocking) {
            block13: {
                Queue queue = this.threadQueue.get();
                if (queue == null && (queue = this.allocateQueueSlot()) == null) {
                    throw new InternalError("Number of concurrent thread has exceeded the queue's max concurrency");
                }
                queue.ownerWaiting = true;
                try {
                    while (!queue.guard.compareAndSet(false, true)) {
                    }
                }
                finally {
                    queue.ownerWaiting = false;
                }
                event.acquire();
                try {
                    if (queue.size() > 0) {
                        long sequence;
                        queue.offer(event);
                        while ((sequence = this.getDisruptorSlot(nonBlocking)) >= 0L) {
                            this.publish(sequence, queue.poll());
                            if (queue.size() > 0) continue;
                            break block13;
                        }
                        break block13;
                    }
                    long sequence = this.getDisruptorSlot(nonBlocking);
                    if (sequence >= 0L) {
                        this.publish(sequence, event);
                    } else {
                        queue.offer(event);
                    }
                }
                finally {
                    queue.guard.set(false);
                }
            }
        }

        private final Queue allocateQueueSlot() {
            Queue queue;
            if (this.numOwned.get() < this.queues.length) {
                queue = this.fastAllocateQueueSlot();
                if (queue == null) {
                    queue = this.reclaimDeadThreadQueueSlot();
                }
            } else {
                queue = this.reclaimDeadThreadQueueSlot();
            }
            return queue;
        }

        private Queue fastAllocateQueueSlot() {
            Queue queue = null;
            Thread thread = Thread.currentThread();
            for (int i = 0; i < this.queues.length; ++i) {
                if (!this.queues[i].owner.compareAndSet(null, thread)) continue;
                this.threadQueue.set(this.queues[i]);
                queue = this.queues[i];
                this.numOwned.incrementAndGet();
                break;
            }
            return queue;
        }

        private final Queue reclaimDeadThreadQueueSlot() {
            Thread newOwner = Thread.currentThread();
            for (int i = 0; i < this.queues.length; ++i) {
                Queue queue = this.queues[i];
                Thread currentOwner = queue.owner.get();
                if (currentOwner != null) {
                    if (currentOwner.isAlive() || !queue.guard.compareAndSet(false, true)) continue;
                    int queueSize = queue.size();
                    queue.guard.set(false);
                    if (queueSize > 0 || !queue.owner.compareAndSet(currentOwner, newOwner)) continue;
                    this.threadQueue.set(queue);
                    return queue;
                }
                if (!queue.owner.compareAndSet(null, newOwner)) continue;
                this.threadQueue.set(queue);
                this.numOwned.incrementAndGet();
                return queue;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void decongest() {
            int val = this.numOwned.get();
            for (int i = 0; i < val; ++i) {
                int toDecongest = (this.lastDecongested + 1) % val;
                Queue queue = this.queues[toDecongest];
                if (queue.guard.compareAndSet(false, true)) {
                    try {
                        long sequence;
                        while (!queue.ownerWaiting && queue.size() > 0 && (sequence = this.getDisruptorSlot(true)) >= 0L) {
                            this.publish(sequence, queue.poll());
                        }
                    }
                    finally {
                        queue.guard.set(false);
                    }
                }
                ++queue.decongestCount;
                this.lastDecongested = toDecongest;
            }
        }
    }

    private static final class Queue
    extends EventMultiplexer.Queue
    implements IEventMultiplexerStats.IFeederQueueStats {
        final AtomicBoolean guard = new AtomicBoolean();
        final AtomicReference<Thread> owner = new AtomicReference();
        boolean ownerWaiting;
        int decongestCount;

        Queue(Tracer tracer) {
            super(tracer);
        }

        @Override
        public final void cleanup() {
            super.cleanup();
            this.owner.set(null);
        }

        @Override
        public Thread getOwner() {
            Thread currentOwner = this.owner.get();
            if (currentOwner != null) {
                return currentOwner;
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.size();
        }

        @Override
        public int getDecongestCount() {
            return this.decongestCount;
        }

        @Override
        public IStats.Latencies getOfferToPollLatencies() {
            return this.latencyManager();
        }
    }
}

