/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.event;

import com.neeve.config.Config;
import com.neeve.event.Event;
import com.neeve.event.EventObject;
import com.neeve.event.EventWakeup;
import com.neeve.event.IEventHandler;
import com.neeve.event.IEventMultiplexer;
import com.neeve.stats.Stats;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class EventMultiplexer
extends EventObject
implements IEventMultiplexer {
    private final java.util.Queue<Event> scheduledQueue;
    private final AtomicBoolean scheduledQueueGuard;
    private final WakeupThread wakeupThread;
    private final AtomicBoolean wakeupEventMultiplexed;
    private boolean dispatchAllEvents;
    protected final String name;
    protected final boolean administrative;
    protected final IEventHandler eventHandler;
    protected volatile int numScheduledEvents;
    protected volatile IEventMultiplexer.State state;
    public static final boolean recordEventLegLatencies = Config.getValue((String)"nv.stats.latency.event.enabled", (boolean)Config.getValue((String)"nv.event.latency.stats", (boolean)Stats.LatencyManager.recordLegLatencies));

    protected EventMultiplexer(String name, boolean administrative, IEventHandler eventHandler) {
        super(null);
        if (eventHandler == null) {
            throw new IllegalArgumentException("chained event handler cannot be null");
        }
        this.name = name;
        this.administrative = administrative;
        this.eventHandler = eventHandler;
        this.scheduledQueue = new PriorityQueue<Event>(128, new SchedulableEventComparator());
        this.scheduledQueueGuard = new AtomicBoolean();
        this.wakeupThread = new WakeupThread(name);
        this.wakeupEventMultiplexed = new AtomicBoolean();
        this.state = IEventMultiplexer.State.Init;
    }

    private final void multiplexWakeupEvent() {
        if (this.wakeupEventMultiplexed.compareAndSet(false, true)) {
            EventWakeup event = EventWakeup.create();
            try {
                this.multiplexEvent(event, 1);
            }
            finally {
                event.dispose();
            }
        }
    }

    private final void adjustWakeupAlarm(long delay) {
        this.wakeupThread.adjustWakeup(delay);
    }

    protected abstract void doOpen();

    protected abstract void doMultiplex(Event var1, int var2);

    protected abstract void doClose();

    protected final void dispatchEvent(Event event) {
        boolean dispatchAfterScheduled;
        boolean isWakeupEvent;
        block9: {
            block10: {
                block8: {
                    int remainingTime;
                    boolean offerEvent;
                    isWakeupEvent = event.getType() == 1;
                    int eventDelay = event.getDelay();
                    dispatchAfterScheduled = eventDelay >= 0;
                    boolean dispatchBeforeScheduled = eventDelay == Integer.MIN_VALUE;
                    boolean bl = offerEvent = !dispatchBeforeScheduled && !dispatchAfterScheduled;
                    if (isWakeupEvent) {
                        this.wakeupEventMultiplexed.set(false);
                    }
                    if (dispatchBeforeScheduled && (this.dispatchAllEvents || !isWakeupEvent)) {
                        this.eventHandler.onEvent(event);
                    }
                    if (this.numScheduledEvents <= 0 && !offerEvent) break block9;
                    boolean eventOffered = false;
                    while (true) {
                        Event nextEvent;
                        if (!this.scheduledQueueGuard.compareAndSet(false, true)) {
                            continue;
                        }
                        long now = System.currentTimeMillis();
                        if (offerEvent && !eventOffered) {
                            event.acquire();
                            this.scheduledQueue.offer(event.setScheduledTime(now));
                            ++this.numScheduledEvents;
                        }
                        eventOffered = true;
                        Event scheduledEvent = this.scheduledQueue.peek();
                        if (scheduledEvent == null) break block8;
                        remainingTime = scheduledEvent.getRemainingTime(now);
                        if (remainingTime > 0) break;
                        this.scheduledQueue.remove();
                        --this.numScheduledEvents;
                        if ((dispatchBeforeScheduled || isWakeupEvent) && event.isEndOfBatch() && ((nextEvent = this.scheduledQueue.peek()) == null || nextEvent.getRemainingTime(now) > 0)) {
                            scheduledEvent.setEndOfBatch(true);
                        }
                        this.scheduledQueueGuard.set(false);
                        scheduledEvent.setDispatchTime(now);
                        this.eventHandler.onEvent(scheduledEvent);
                        scheduledEvent.dispose();
                    }
                    this.scheduledQueueGuard.set(false);
                    this.adjustWakeupAlarm(remainingTime);
                    break block10;
                }
                this.scheduledQueueGuard.set(false);
            }
            if (this.numScheduledEvents == 0) {
                this.adjustWakeupAlarm(Long.MAX_VALUE);
            }
        }
        if (dispatchAfterScheduled && (this.dispatchAllEvents || !isWakeupEvent)) {
            this.eventHandler.onEvent(event);
        }
    }

    @Override
    public final void setAllEventDispatch(boolean val) {
        this.dispatchAllEvents = val;
    }

    @Override
    public final void open() {
        if (this.state != IEventMultiplexer.State.Init) {
            throw new IllegalStateException("invalid multiplexer state for open (exp=" + (Object)((Object)IEventMultiplexer.State.Init) + ", actual=" + (Object)((Object)this.state) + ")");
        }
        this.doOpen();
        this.wakeupThread.start();
        this.state = IEventMultiplexer.State.Open;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    @Deprecated
    public final void onEvent(Event event, int flags) {
        this.multiplexEvent(event, flags);
    }

    @Override
    public final void multiplexEvent(Event event, int flags) {
        if (this.state == IEventMultiplexer.State.Open) {
            if (event == null) {
                throw new IllegalArgumentException("event cannot be null");
            }
            event.offerTs = recordEventLegLatencies ? UtlTime.now() : 0L;
            this.doMultiplex(event, flags);
        } else {
            switch (this.state) {
                case Closing: 
                case Closed: {
                    event.acquire();
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid multiplexer state (exp=" + (Object)((Object)IEventMultiplexer.State.Open) + ", actual=" + (Object)((Object)this.state) + ")");
                }
            }
        }
    }

    @Override
    public final void scheduleEvent(Event event) {
        if (this.state == IEventMultiplexer.State.Open) {
            if (event == null) {
                throw new IllegalArgumentException("event cannot be null");
            }
            long now = System.currentTimeMillis();
            while (!this.scheduledQueueGuard.compareAndSet(false, true)) {
            }
            Event preOfferEvent = this.scheduledQueue.peek();
            event.acquire();
            this.scheduledQueue.offer(event.setScheduledTime(now));
            ++this.numScheduledEvents;
            Event postOfferEvent = this.scheduledQueue.peek();
            int remainingTime = postOfferEvent.getRemainingTime(now);
            this.scheduledQueueGuard.set(false);
            if (remainingTime <= 0) {
                this.multiplexWakeupEvent();
            } else if (preOfferEvent != postOfferEvent) {
                this.adjustWakeupAlarm(remainingTime);
            }
        } else {
            switch (this.state) {
                case Closing: 
                case Closed: {
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid multiplexer state (exp=" + (Object)((Object)IEventMultiplexer.State.Open) + ", actual=" + (Object)((Object)this.state) + ")");
                }
            }
        }
    }

    @Override
    public final void unscheduleEvent(Event event) {
        if (this.state == IEventMultiplexer.State.Open) {
            if (event == null) {
                throw new IllegalArgumentException("event cannot be null");
            }
            while (!this.scheduledQueueGuard.compareAndSet(false, true)) {
            }
            if (this.scheduledQueue.remove(event)) {
                event.dispose();
                --this.numScheduledEvents;
            }
            this.scheduledQueueGuard.set(false);
        } else {
            switch (this.state) {
                case Closing: 
                case Closed: {
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid multiplexer state (exp=" + (Object)((Object)IEventMultiplexer.State.Open) + ", actual=" + (Object)((Object)this.state) + ")");
                }
            }
        }
    }

    @Override
    public final int scheduledEventCount() {
        return this.numScheduledEvents;
    }

    @Override
    public final void onEvent(Event event) {
        this.onEvent(event, 0);
    }

    @Override
    public final void close() {
        try {
            if (this.state == IEventMultiplexer.State.Open) {
                this.state = IEventMultiplexer.State.Closing;
                this.wakeupThread.shutdown();
                this.doClose();
            }
        }
        finally {
            this.state = IEventMultiplexer.State.Closed;
        }
    }

    protected static class Queue {
        private volatile Event[] q;
        private long tail = -1L;
        private long head = -1L;
        private Stats.LatencyManager lm = new Stats.LatencyManager("o2p");
        protected Tracer tracer;

        public Queue(Tracer tracer) {
            this(256, tracer);
        }

        public Queue(int initialCapacity, Tracer tracer) {
            this.q = new Event[initialCapacity];
            this.tracer = tracer;
        }

        public final void offer(Event event) {
            if (this.head - this.tail == (long)this.q.length) {
                Event[] newq = new Event[this.q.length * 2];
                if (this.tracer.debug) {
                    this.tracer.log("MuxQ[" + this.hashCode() + "] Resizing (" + this.q.length + "->" + newq.length + ")...", Tracer.Level.DEBUG);
                }
                for (long i = this.tail + 1L; i <= this.head; ++i) {
                    newq[(int)(i % (long)newq.length)] = this.q[(int)(i % (long)this.q.length)];
                }
                this.q = newq;
            }
            this.q[(int)(++this.head % (long)this.q.length)] = event;
            if (this.tracer.debug) {
                this.tracer.log("MuxQ[" + this.hashCode() + "] --> " + this.head + " (" + event.hashCode() + "{" + event.owners() + "})", Tracer.Level.DEBUG);
            }
        }

        public final Event peek() {
            return this.tail == this.head ? null : this.q[(int)((this.tail + 1L) % (long)this.q.length)];
        }

        public final Event poll() {
            Event event;
            Event event2 = event = this.tail == this.head ? null : this.q[(int)(++this.tail % (long)this.q.length)];
            if (recordEventLegLatencies) {
                event.pollTs = UtlTime.now();
                this.lm.add((double)(event.pollTs - event.offerTs));
            }
            if (this.tracer.debug) {
                this.tracer.log("MuxQ[" + this.hashCode() + "] <-- " + (event == null ? 0L : this.tail) + " (" + (event == null ? 0 : event.hashCode()) + "{" + event.owners() + "})", Tracer.Level.DEBUG);
            }
            return event;
        }

        public final int size() {
            return (int)(this.head - this.tail);
        }

        public final Stats.LatencyManager latencyManager() {
            return this.lm;
        }

        public final String toString() {
            return "[MuxQ[" + this.hashCode() + "] count=" + this.size() + " cap=" + this.q.length + " tail=" + this.tail + " head=" + this.head + "]";
        }

        public void cleanup() {
            this.q = null;
            this.lm = null;
            this.tracer = null;
        }
    }

    private final class WakeupThread
    extends Thread {
        private boolean done = false;
        private long interval = Long.MAX_VALUE;
        private boolean adjusted = false;
        private final Object wakeup = new Object();

        WakeupThread(String name) {
            this.setDaemon(true);
            this.setName("X-EventMultiplexer-Wakeup-" + name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void adjustWakeup(long interval) {
            Object object = this.wakeup;
            synchronized (object) {
                this.interval = interval;
                this.adjusted = true;
                this.wakeup.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void shutdown() {
            Object object = this.wakeup;
            synchronized (object) {
                this.done = true;
                this.interrupt();
            }
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            UtlThread.setDefaultCPUAffinityMask();
            while (!this.done) {
                try {
                    Object object = this.wakeup;
                    synchronized (object) {
                        this.adjusted = false;
                        this.wakeup.wait(this.interval);
                        if (this.adjusted) {
                            continue;
                        }
                    }
                    try {
                        EventMultiplexer.this.multiplexWakeupEvent();
                    }
                    catch (Throwable e) {
                        EventMultiplexer.this.tracer.log("Error multiplexing wake up event:\n" + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.SEVERE);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private final class SchedulableEventComparator
    implements Comparator<Event> {
        private SchedulableEventComparator() {
        }

        @Override
        public final int compare(Event e1, Event e2) {
            int r2;
            long now = System.currentTimeMillis();
            int r1 = e1.getRemainingTime(now);
            if (r1 < (r2 = e2.getRemainingTime(now))) {
                return -1;
            }
            if (r1 > r2) {
                return 1;
            }
            return e1.getInstanceNumber() < e2.getInstanceNumber() ? -1 : 1;
        }
    }
}

