/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.deploy;

import com.neeve.deploy.Host;
import com.neeve.deploy.Model;
import com.neeve.discovery.DiscoveryCacheEvents;
import com.neeve.discovery.DiscoveryCacheFactory;
import com.neeve.discovery.EDiscoveryException;
import com.neeve.discovery.IDiscoveryCache;
import com.neeve.discovery.IDiscoveryCacheEventHandler;
import com.neeve.discovery.IDiscoveryEntity;
import com.neeve.emx.IEmxAction;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class HostCollection {
    private final Model model;
    private final HashMap<InetAddress, Host> hosts;
    private final IDiscoveryCacheEventHandler discoveryCacheEventHandler;
    private final Tracer tracer;
    private final String tracePrefix;
    private volatile EventHandler eventHandler;
    final IDiscoveryCache discoveryCache;

    HostCollection(Model model, String discoveryDescriptor, Tracer tracer) {
        this.model = model;
        this.hosts = new HashMap();
        this.discoveryCacheEventHandler = new DiscoveryCacheEventHandler();
        this.tracer = tracer;
        this.tracePrefix = "[HostCollection] ";
        try {
            this.discoveryCache = DiscoveryCacheFactory.getInstance().createCache(discoveryDescriptor == null ? DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR : discoveryDescriptor);
        }
        catch (EDiscoveryException e) {
            throw new RuntimeException("Unable to open server discovery cache '" + UtlAddressDescriptor.parse((String)discoveryDescriptor, null).toPasswordSanitizedFullString() + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int onServerUp(IDiscoveryEntity entity) {
        block8: {
            try {
                InetAddress address = InetAddress.getByName(entity.getHost());
                Host host = this.hosts.get(address);
                if (host != null) break block8;
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Found host '" + address.getHostName() + "' [" + address.getHostAddress() + "].", Tracer.Level.DEBUG);
                }
                HashMap<InetAddress, Host> hashMap = this.hosts;
                synchronized (hashMap) {
                    host = new Host(this, address, this.tracer);
                    this.hosts.put(address, host);
                }
                try {
                    this.model.scheduleAction((IEmxAction)new IEmxAction<Host, Object>(){

                        public final Object execute(IEmxDispatcher dispatcher, Host host) throws Exception {
                            EventHandler eventHandler = HostCollection.this.eventHandler;
                            if (eventHandler != null) {
                                eventHandler.onHostUp(host);
                            }
                            host.open();
                            return null;
                        }
                    }, host);
                    return 1;
                }
                catch (Exception e) {
                    this.tracer.log(this.tracePrefix + "Failed to schedule processing of new host [" + e.toString() + ". Host will not appear in view...", Tracer.Level.WARNING);
                }
            }
            catch (UnknownHostException e) {
                this.tracer.log(this.tracePrefix + "Failed to get the IP address of entity host '" + entity.getHost() + "' [" + e.toString() + "]. Host will not appear in view...", Tracer.Level.WARNING);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void open() {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Opening...", Tracer.Level.DEBUG);
        }
        Object object = this.discoveryCache.getCacheLock();
        synchronized (object) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Finding hosts...", Tracer.Level.DEBUG);
            }
            int count = 0;
            Set entities = this.discoveryCache.matches("Server");
            Iterator iterator = entities.iterator();
            while (iterator.hasNext()) {
                count += this.onServerUp((IDiscoveryEntity)iterator.next());
            }
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Found " + count + " hosts.", Tracer.Level.DEBUG);
            }
            this.discoveryCache.addEventHandler(this.discoveryCacheEventHandler);
        }
    }

    final Model getModel() {
        return this.model;
    }

    public final void setEventHandler(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public final EventHandler getEventHandler() {
        return this.eventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<Host> getHosts() {
        HashSet<Host> ret = new HashSet<Host>();
        HashMap<InetAddress, Host> hashMap = this.hosts;
        synchronized (hashMap) {
            for (Host host : this.hosts.values()) {
                ret.add(host);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() {
        this.discoveryCache.removeEventHandler(this.discoveryCacheEventHandler);
        HashMap<InetAddress, Host> hashMap = this.hosts;
        synchronized (hashMap) {
            for (Host host : this.hosts.values()) {
                host.close();
            }
        }
        if (!DiscoveryCacheFactory.getInstance().isDefaultCache(this.discoveryCache)) {
            this.discoveryCache.close();
        }
    }

    public static interface EventHandler {
        public void onHostUp(Host var1);
    }

    private final class DiscoveryCacheEventHandler
    implements IDiscoveryCacheEventHandler {
        private DiscoveryCacheEventHandler() {
        }

        public final void onEvent(IDiscoveryCache cache, int type, Object data) {
            switch (type) {
                case 0: {
                    DiscoveryCacheEvents.DiscoveryCacheAddEventData eventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)data;
                    if (!eventData.newEntity.getType().equals("Server")) break;
                    if (((HostCollection)HostCollection.this).tracer.debug) {
                        HostCollection.this.tracer.log(HostCollection.this.tracePrefix + "Server '" + eventData.newEntity + "' is up. Parsing for new hosts...", Tracer.Level.DEBUG);
                    }
                    int count = HostCollection.this.onServerUp(eventData.newEntity);
                    if (!((HostCollection)HostCollection.this).tracer.debug) break;
                    HostCollection.this.tracer.log(HostCollection.this.tracePrefix + "Found " + count + " new hosts.", Tracer.Level.DEBUG);
                }
            }
        }
    }
}

