/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.ucx;

import com.neeve.emx.EEmxException;
import com.neeve.emx.EEmxInvalidStateException;
import com.neeve.emx.EEmxNwLnkInetAddrFormatException;
import com.neeve.emx.EEmxNwLnkOpFailedException;
import com.neeve.emx.EmxNwLnkInetAddr;
import com.neeve.emx.EmxNwLnkOpWaitCond;
import com.neeve.emx.IEmxNwConnectReadyEvent;
import com.neeve.emx.IEmxNwLnkClientEndpoint;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.emx.ucx.EmxUcx;
import com.neeve.emx.ucx.EmxUcxNwLnkPeerEndpoint;
import com.neeve.emx.ucx.EmxUcxObject;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;

public final class EmxUcxNwLnkClientEndpoint
extends EmxUcxObject
implements IEmxNwLnkClientEndpoint {
    private final String remoteIfAddr;
    private final short remotePort;
    private final long ep;
    private boolean connected;
    private boolean closed;

    private EmxUcxNwLnkClientEndpoint(UtlAddressDescriptor descriptor) throws EEmxException {
        EmxNwLnkInetAddr inetAddr;
        try {
            inetAddr = EmxNwLnkInetAddr.parse(descriptor.address);
        }
        catch (IllegalArgumentException e) {
            throw new EEmxNwLnkInetAddrFormatException(descriptor.address);
        }
        this.remoteIfAddr = inetAddr.host;
        this.remotePort = (short)inetAddr.port;
        this.ep = EmxUcx.createEndpoint();
    }

    public static IEmxNwLnkClientEndpoint create(UtlAddressDescriptor descriptor) throws EEmxException {
        return new EmxUcxNwLnkClientEndpoint(descriptor);
    }

    private final IEmxNwLnkPeerEndpoint connectInternal() throws EEmxNwLnkOpFailedException {
        if (this.tracer.fine) {
            this.tracer.log("Connecting UCX network link client endpoint to " + this.remoteIfAddr + ":" + this.remotePort + "...", Tracer.Level.FINE);
        }
        try {
            EmxUcx.connect(this.ep, null, (short)0, this.remoteIfAddr, this.remotePort);
            this.connected = true;
            if (this.tracer.fine) {
                this.tracer.log("Connect successfully completed.", Tracer.Level.FINE);
            }
            return new EmxUcxNwLnkPeerEndpoint(this.ep, false);
        }
        catch (Exception e) {
            if (this.tracer.fine) {
                this.tracer.log("Connect failed [" + e.toString() + "]", Tracer.Level.FINE);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new EEmxNwLnkOpFailedException(e);
        }
    }

    private final void closeInternal() {
        EmxUcx.destroyEndpoint(this.ep);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void configureBlocking(boolean blocking) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (this.closed) throw new EEmxInvalidStateException("configureBlocking", "closed");
        if (this.connected) throw new EEmxInvalidStateException("configureBlocking", "connected");
        if (blocking) return;
        throw new UnsupportedOperationException("non-blocking IO is not supported");
    }

    @Override
    public final boolean isBlocking() throws EEmxInvalidStateException {
        if (!this.closed) {
            return true;
        }
        throw new EEmxInvalidStateException("isBlocking", "closed");
    }

    @Override
    public final IEmxNwLnkPeerEndpoint connect(EmxNwLnkOpWaitCond waitCond) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            if (waitCond != null) {
                throw new UnsupportedOperationException("non-blocking IO is not supported");
            }
            if (!this.connected) {
                return this.connectInternal();
            }
            throw new EEmxInvalidStateException("connect", "connected");
        }
        throw new EEmxInvalidStateException("connect", "closed");
    }

    @Override
    public final IEmxNwLnkPeerEndpoint connect() throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        return this.connect(null);
    }

    @Override
    public final IEmxNwConnectReadyEvent getConnectReadyEvent() {
        return null;
    }

    @Override
    public final void close() throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            if (!this.connected) {
                if (this.tracer.fine) {
                    this.tracer.log("Closing UCX network link client endpoint...", Tracer.Level.FINE);
                }
                try {
                    this.closeInternal();
                }
                catch (Exception e) {
                    this.tracer.log("Failure in closing UCX network link client endpoint [" + e.toString() + "].", Tracer.Level.WARNING);
                }
                finally {
                    this.closed = true;
                }
            } else {
                throw new EEmxInvalidStateException("close", "connected");
            }
        }
    }
}

