/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cloud.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.neeve.trace.Tracer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpClient {
    private final OkHttpClient client = new OkHttpClient.Builder().readTimeout(300L, TimeUnit.SECONDS).build();
    protected static final String HTTP_HEADER_CONTENT_TYPE_KEY = "Content-Type";
    protected static final String HTTP_HEADER_ACCEPT_KEY = "Accept";
    protected static final String HTTP_HEADER_URLENCODED_CONTENT_VALUE = "application/x-www-form-urlencoded";
    protected static final String HTTP_HEADER_JSON_CONTENT_VALUE = "application/json";
    protected static final String HTTP_HEADER_AUTHORIZATION_KEY = "Authorization";
    protected static final String HTTP_HEADER_AUTH_TOKEN_KEY = "X-Auth-Token";
    protected static final MediaType MEDIATYPE_URLENCODED = MediaType.parse((String)("application/x-www-form-urlencoded; charset=" + StandardCharsets.UTF_8.name()));
    protected static final MediaType MEDIATYPE_JSON = MediaType.parse((String)("application/json; charset=" + StandardCharsets.UTF_8.name()));
    protected final ObjectMapper mapper = new ObjectMapper();

    protected HttpClient() {
        this.mapper.configure(MapperFeature.USE_ANNOTATIONS, true).configure(MapperFeature.AUTO_DETECT_GETTERS, false).configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false).configure(MapperFeature.AUTO_DETECT_FIELDS, false).configure(MapperFeature.AUTO_DETECT_SETTERS, false).configure(MapperFeature.AUTO_DETECT_CREATORS, false).configure(MapperFeature.USE_GETTERS_AS_SETTERS, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }

    private Request buildRequest(String url, Map<String, String> headers, RequestBody body, HttpMethod method) {
        Request.Builder requestBuilder = new Request.Builder().url(url);
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        switch (method) {
            case GET: {
                return requestBuilder.get().build();
            }
            case POST: {
                return requestBuilder.post(body).build();
            }
            case PUT: {
                return requestBuilder.put(body == null ? RequestBody.create((byte[])new byte[0], null) : body).build();
            }
            case DELETE: {
                return requestBuilder.delete().build();
            }
        }
        throw new IllegalArgumentException("Unsupported HTTP method: " + (Object)((Object)method));
    }

    private Response executeRequest(Request request, Tracer tracer) throws IOException {
        if (tracer.debug) {
            tracer.log("--> " + request.toString(), Tracer.Level.DEBUG);
        }
        Response response = this.client.newCall(request).execute();
        if (tracer.debug) {
            tracer.log("<-- " + response.toString(), Tracer.Level.DEBUG);
        }
        return response;
    }

    protected final Response get(String url, Map<String, String> headers, Tracer tracer) throws IOException {
        Request request = this.buildRequest(url, headers, null, HttpMethod.GET);
        return this.executeRequest(request, tracer);
    }

    protected final Response put(String url, Map<String, String> headers, Tracer tracer) throws IOException {
        Request request = this.buildRequest(url, headers, null, HttpMethod.PUT);
        return this.executeRequest(request, tracer);
    }

    protected final Response post(String url, Map<String, String> headers, RequestBody body, Tracer tracer) throws IOException {
        Request request = this.buildRequest(url, headers, body, HttpMethod.POST);
        return this.executeRequest(request, tracer);
    }

    protected final Response delete(String url, Map<String, String> headers, Tracer tracer) throws IOException {
        Request request = this.buildRequest(url, headers, null, HttpMethod.DELETE);
        return this.executeRequest(request, tracer);
    }

    protected static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

