/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmCollection;
import com.neeve.adm.AdmDeprecation;
import com.neeve.adm.AdmDirective;
import com.neeve.adm.AdmDocumentation;
import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmEntityArray;
import com.neeve.adm.AdmEnumeration;
import com.neeve.adm.AdmEnumerationArray;
import com.neeve.adm.AdmFactory;
import com.neeve.adm.AdmField;
import com.neeve.adm.AdmFieldLookup;
import com.neeve.adm.AdmGenerator;
import com.neeve.adm.AdmGeneratorRegistry;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmModelImport;
import com.neeve.adm.AdmObject;
import com.neeve.adm.AdmPooledString;
import com.neeve.adm.AdmPrimitive;
import com.neeve.adm.AdmPrimitiveArray;
import com.neeve.adm.AdmSemanticType;
import com.neeve.adm.AdmType;
import com.neeve.adm.EAdmCyclicModelImportException;
import com.neeve.adm.EAdmException;
import com.neeve.build.codegen.CgCodeSource;
import com.neeve.build.codegen.CgExtendedDOMBuilder;
import com.neeve.build.codegen.CgResourceChangeTracker;
import com.neeve.build.codegen.CgSourceCodeErrorAggregator;
import com.neeve.build.codegen.ECgException;
import com.neeve.config.Config;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlText;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class AdmXMLParser
extends AdmObject {
    private static final ThreadLocal<Stack<AdmModel>> importParseStack = new ThreadLocal();
    private static final HashMap<URL, WeakReference<AdmModel>> importCache = new HashMap();
    private static final boolean IMPORT_CACHING_ENABLED = Config.getValue((String)"nv.adm.enableimportcaching", (boolean)false);
    private static final boolean SUPPRESS_DUPLICATE_CHECKING = Config.getValue((String)"nv.adm.suppressduplicatechecks", (boolean)false);
    private final URL modelUrl;
    private final File modelsDir;
    private final Document doc;
    private final NodeList directivesElements;
    private final NodeList importElements;
    private final NodeList factoryElements;
    private final NodeList enumElements;
    private final NodeList typeElements;
    private final NodeList fieldElements;
    private final NodeList messageElements;
    private final NodeList entityElements;
    private final NodeList collectionElements;
    private final CgResourceChangeTracker parseContext;
    private final CgSourceCodeErrorAggregator errorAggregator;
    private final boolean contextClassLoaderResolutionFirst = Config.getValue((String)"nv.adm.contextclassloaderfirst", (boolean)false);
    private final HashSet<String> fieldCycleCheck = new HashSet();
    private final Stack<FieldResolutionFrame> fieldTypeStack = new Stack();

    private AdmXMLParser(URL modelURL, File modelsDir, CgResourceChangeTracker parseContext) throws Exception {
        if (modelURL == null) {
            throw new IllegalArgumentException("Model must not be null");
        }
        this.modelUrl = modelURL;
        this.modelsDir = modelsDir;
        this.parseContext = parseContext;
        try {
            this.doc = CgExtendedDOMBuilder.readXML((URL)modelURL, (String)"/x-adml.xsd", (CgResourceChangeTracker)this.parseContext);
        }
        catch (ECgException ex) {
            if (ex.getCodeSource() != null) {
                throw new EAdmException(ex.getMessage(), (Throwable)ex, ex.getCodeSource());
            }
            if (ex.getAggregatedErrors() != null) {
                throw new EAdmException(ex.getMessage(), (Throwable)ex, ex.getAggregatedErrors());
            }
            throw new RuntimeException(ex.getMessage(), ex);
        }
        this.importElements = this.doc.getElementsByTagName("import");
        this.factoryElements = this.doc.getElementsByTagName("factory");
        this.enumElements = this.doc.getElementsByTagName("enum");
        this.messageElements = this.doc.getElementsByTagName("message");
        this.entityElements = this.doc.getElementsByTagName("entity");
        this.collectionElements = this.doc.getElementsByTagName("collection");
        this.directivesElements = this.doc.getElementsByTagName("directives");
        NodeList typesElement = this.doc.getElementsByTagName("types");
        this.typeElements = typesElement != null && typesElement.getLength() > 0 ? ((Element)typesElement.item(0)).getElementsByTagName("type") : new NodeList(){

            @Override
            public Node item(int index) {
                throw new IndexOutOfBoundsException("" + index);
            }

            @Override
            public int getLength() {
                return 0;
            }
        };
        NodeList fieldsElement = this.doc.getElementsByTagName("fields");
        this.fieldElements = fieldsElement != null && fieldsElement.getLength() > 0 ? ((Element)fieldsElement.item(0)).getElementsByTagName("field") : new NodeList(){

            @Override
            public Node item(int index) {
                throw new IndexOutOfBoundsException("" + index);
            }

            @Override
            public int getLength() {
                return 0;
            }
        };
        this.errorAggregator = new CgSourceCodeErrorAggregator(modelURL);
    }

    private final boolean isArrayType(String typeName) {
        return typeName.endsWith("[]");
    }

    private final String getArrayTypeName(String typeName) {
        return typeName.lastIndexOf("[]") == 0 ? null : typeName.substring(0, typeName.lastIndexOf("[]"));
    }

    private final AdmType getType(AdmModel model, String typeName) throws EAdmException {
        AdmType type = model.lookupType(typeName = this.substituteThisNamespace(typeName, model.getNamespace()), true);
        if (type == null && model.isOf(typeName)) {
            int i;
            String name = model.nameFromFullName(typeName);
            for (i = 0; type == null && i < this.enumElements.getLength(); ++i) {
                Element enumElement = (Element)this.enumElements.item(i);
                String enumName = enumElement.getAttributes().getNamedItem("name").getNodeValue();
                if (name.compareToIgnoreCase(enumName) != 0) continue;
                type = this.createEnumeration(model, name, enumElement);
            }
            for (i = 0; type == null && i < this.messageElements.getLength(); ++i) {
                Element messageElement = (Element)this.messageElements.item(i);
                String messageName = messageElement.getAttributes().getNamedItem("name").getNodeValue();
                if (name.compareToIgnoreCase(messageName) != 0) continue;
                type = this.createMessage(model, name, messageElement);
            }
            for (i = 0; type == null && i < this.entityElements.getLength(); ++i) {
                Element entityElement = (Element)this.entityElements.item(i);
                String entityName = entityElement.getAttributes().getNamedItem("name").getNodeValue();
                if (name.compareToIgnoreCase(entityName) != 0) continue;
                type = this.createEntity(model, name, entityElement);
            }
            for (i = 0; type == null && i < this.collectionElements.getLength(); ++i) {
                Element collectionElement = (Element)this.collectionElements.item(i);
                String collectionName = collectionElement.getAttributes().getNamedItem("name").getNodeValue();
                if (name.compareToIgnoreCase(collectionName) != 0) continue;
                type = this.createCollection(model, name, collectionElement);
            }
            for (i = 0; type == null && i < this.typeElements.getLength(); ++i) {
                Element typeElement = (Element)this.typeElements.item(i);
                String semanticTypeName = typeElement.getAttributes().getNamedItem("name").getNodeValue();
                if (name.compareToIgnoreCase(semanticTypeName) != 0) continue;
                type = this.createSemanticType(model, name, typeElement).getBaseType();
            }
            if (type == null) {
                type = model.lookupType(typeName, false);
            }
        }
        return type;
    }

    private final AdmType getFieldType(AdmModel model, String typeName) throws EAdmException {
        if (this.isArrayType(typeName)) {
            String arrayTypeName = this.getArrayTypeName(typeName);
            if (arrayTypeName != null) {
                AdmType arrayType = this.getType(model, arrayTypeName);
                if (arrayType instanceof AdmPrimitive) {
                    return AdmPrimitiveArray.toPrimitiveArrayType(((AdmPrimitive)arrayType).getType());
                }
                if (arrayType instanceof AdmEntity) {
                    return new AdmEntityArray(model, (AdmEntity)arrayType);
                }
                if (arrayType instanceof AdmEnumeration) {
                    return new AdmEnumerationArray(model, (AdmEnumeration)arrayType);
                }
            }
            return null;
        }
        return this.getType(model, typeName);
    }

    private final AdmSemanticType getFieldSemanticType(AdmModel model, String typeName) throws EAdmException {
        if (this.isArrayType(typeName)) {
            String arrayTypeName = this.getArrayTypeName(typeName);
            return model.getSemanticType(arrayTypeName);
        }
        return model.getSemanticType(typeName);
    }

    private final URL resolveImportModel(String parentNamespace, String referencedModelFilename) throws IOException {
        block21: {
            URL url;
            block20: {
                block19: {
                    String path;
                    ClassLoader[] classLoaders = new ClassLoader[]{((Object)((Object)this)).getClass().getClassLoader(), Thread.currentThread().getContextClassLoader()};
                    String[] pathPrefixes = new String[]{"/", ""};
                    if (this.contextClassLoaderResolutionFirst) {
                        classLoaders = new ClassLoader[]{classLoaders[1], classLoaders[0]};
                        pathPrefixes = new String[]{"", "/"};
                    }
                    url = null;
                    for (int i = 0; i < 2; ++i) {
                        path = referencedModelFilename.startsWith("/") ? referencedModelFilename : pathPrefixes[i] + referencedModelFilename;
                        url = classLoaders[i].getResource(path);
                        if (url == null) continue;
                        if (this.tracer.debug) {
                            this.tracer.log("Resolved import model absolute class path resource: '" + url + "'", Tracer.Level.DEBUG);
                        }
                        return url;
                    }
                    try {
                        URI parentUri = new URI("/" + parentNamespace.replace('.', '/') + "/");
                        path = parentUri.resolve(referencedModelFilename).toString();
                        url = ((Object)((Object)this)).getClass().getResource(path);
                        if (url != null) {
                            if (this.tracer.debug) {
                                this.tracer.log("Resolved import model relative class path resource: '" + url + "'", Tracer.Level.DEBUG);
                            }
                            return url;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        if (this.tracer.debug) {
                            this.tracer.log("Couldn't resolve import model '" + referencedModelFilename + "' as a relative class path resource", Tracer.Level.DEBUG);
                        }
                    }
                    catch (URISyntaxException e) {
                        if (!this.tracer.debug) break block19;
                        this.tracer.log("Couldn't resolve import model '" + referencedModelFilename + "' as a relative class path resource", Tracer.Level.DEBUG);
                    }
                }
                File file = new File(referencedModelFilename);
                if (file.isAbsolute() && file.exists()) {
                    return file.toURI().toURL();
                }
                if (this.modelsDir != null && (file = new File(this.modelsDir + File.separator + referencedModelFilename)).exists()) {
                    return file.toURI().toURL();
                }
                if (referencedModelFilename.indexOf(":") > 0) {
                    try {
                        url = new URL(referencedModelFilename);
                        InputStream is = url.openStream();
                        is.close();
                        if (this.tracer.debug) {
                            this.tracer.log("Resolved import model as absolute url: '" + url + "'", Tracer.Level.DEBUG);
                        }
                        return url;
                    }
                    catch (Exception e) {
                        if (!this.tracer.debug) break block20;
                        this.tracer.log("Couldn't resolve import model '" + referencedModelFilename + "' as an absolute url", Tracer.Level.DEBUG);
                    }
                }
            }
            URI modelParentURI = null;
            try {
                modelParentURI = this.modelUrl.toURI();
                String modelParentURIPath = modelParentURI.getPath();
                if (modelParentURIPath != null) {
                    modelParentURI = modelParentURIPath.endsWith("/") ? modelParentURI.resolve("..") : modelParentURI.resolve(".");
                    String parentUriString = modelParentURI.toString();
                    url = parentUriString.endsWith("/") ? URI.create(parentUriString + referencedModelFilename).toURL() : URI.create(parentUriString + "/" + referencedModelFilename).toURL();
                    InputStream is = url.openStream();
                    is.close();
                    if (this.tracer.debug) {
                        this.tracer.log("Resolved import model as relative url: '" + url + "'", Tracer.Level.DEBUG);
                    }
                    return url;
                }
            }
            catch (Throwable thrown) {
                if (!this.tracer.debug) break block21;
                this.tracer.log("Couldn't resolve import model '" + referencedModelFilename + "' relative to import url '" + this.modelUrl + "'.", Tracer.Level.DEBUG);
            }
        }
        throw new FileNotFoundException("Could not find imported model '" + referencedModelFilename + "' on classpath, filesystem, or as a url resource as either an absolute or relative path.");
    }

    private final Map<String, AdmDirective> parseDirectives() throws Exception {
        HashMap<String, AdmDirective> directives = new HashMap<String, AdmDirective>();
        for (int i = 0; i < this.directivesElements.getLength(); ++i) {
            Element directivesElement = (Element)this.directivesElements.item(i);
            NodeList children = directivesElement.getChildNodes();
            for (int d = 0; d < children.getLength(); ++d) {
                Node directive = children.item(d);
                if (!(directive instanceof Element)) continue;
                String name = directive.getNodeName();
                if (directive.getChildNodes().getLength() != 1) continue;
                String value = directive.getChildNodes().item(0).getNodeValue();
                directives.put(name, new AdmDirective(name, value, false, CgExtendedDOMBuilder.getCodeSource((Node)directive)));
            }
        }
        return directives;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void parseImports(AdmModel model, CgResourceChangeTracker.ModelSourceFile modelSourceFile) throws Exception {
        Stack<AdmModel> importStack = importParseStack.get();
        if (importStack == null) {
            importStack = new Stack();
            importParseStack.set(importStack);
            importStack.push(model);
        } else {
            for (AdmModel parentModel : importStack) {
                if (!parentModel.getFullName().equals(model.getFullName())) continue;
                StringBuilder builder = new StringBuilder();
                for (AdmModel p : importStack) {
                    if (builder.length() > 0) {
                        builder.append("->");
                    }
                    builder.append(p.getFullName());
                }
                builder.append("->");
                builder.append(model.getFullName());
                throw new EAdmCyclicModelImportException("Model import cycle detected: " + builder, model.getCodeSource());
            }
            importStack.push(model);
        }
        try {
            int errorCount = 0;
            for (int i = 0; i < this.importElements.getLength(); ++i) {
                Element importElement = (Element)this.importElements.item(i);
                String importModel = null;
                try {
                    AdmModel imported;
                    importModel = importElement.getAttributes().getNamedItem("model").getNodeValue();
                    URL importURL = this.resolveImportModel(model.getNamespace(), importModel);
                    if (modelSourceFile != null) {
                        modelSourceFile.importFile(importURL);
                    }
                    WeakReference<AdmModel> importedRef = IMPORT_CACHING_ENABLED ? importCache.get(importURL) : null;
                    AdmModel admModel = imported = importedRef != null ? (AdmModel)((Object)importedRef.get()) : null;
                    if (imported == null) {
                        try {
                            imported = AdmXMLParser.parse(importURL, this.modelsDir, null, this.parseContext);
                        }
                        catch (EAdmCyclicModelImportException e) {
                            throw new EAdmException(e.getMessage(), (Throwable)((Object)e), CgExtendedDOMBuilder.getCodeSource((Node)importElement));
                        }
                        if (IMPORT_CACHING_ENABLED) {
                            importCache.put(importURL, new WeakReference<AdmModel>(imported));
                            if (this.tracer.debug) {
                                this.tracer.log("Cached model: " + importURL + "", Tracer.Level.DEBUG);
                            }
                        }
                    } else if (this.tracer.debug && IMPORT_CACHING_ENABLED) {
                        this.tracer.log("Found model '" + importURL + "' in cache", Tracer.Level.DEBUG);
                    }
                    model.addImport(new AdmModelImport(model, imported, CgExtendedDOMBuilder.getCodeSource((Node)importElement)));
                    continue;
                }
                catch (EAdmException e) {
                    throw e;
                }
                catch (Exception e) {
                    ++errorCount;
                    this.errorAggregator.add("Error parsing model import '" + importModel + "': " + e.getMessage(), CgSourceCodeErrorAggregator.Severity.ERROR, CgExtendedDOMBuilder.getCodeSource((Node)importElement), (Throwable)e);
                }
            }
            if (errorCount > 0) {
                throw new EAdmException("Failed to parse " + errorCount + " model import" + (errorCount > 1 ? "s." : "."), model.getCodeSource());
            }
        }
        finally {
            importStack.pop();
            if (importStack.isEmpty()) {
                importParseStack.remove();
            }
        }
    }

    private final void parseFactories(AdmModel model) throws Exception {
        Node defaultFactoryIdAttr = this.doc.getElementsByTagName("model").item(0).getAttributes().getNamedItem("defaultFactoryId");
        boolean hasDefaultFactoryId = defaultFactoryIdAttr != null;
        int defaultFactoryId = defaultFactoryIdAttr != null ? Integer.valueOf(defaultFactoryIdAttr.getNodeValue()) : -1;
        for (int i = 0; i < this.factoryElements.getLength(); ++i) {
            Element factoryElement = (Element)this.factoryElements.item(i);
            String name = factoryElement.getAttributes().getNamedItem("name").getNodeValue();
            int id = Integer.valueOf(factoryElement.getAttributes().getNamedItem("id").getNodeValue());
            AdmFactory factory = new AdmFactory(model, model.getNamespace(), name, id);
            factory.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)factoryElement));
            factory.setDocumentation(this.parseElementDocumentation(factoryElement, "Factory"));
            factory.setDeprecation(this.parseElementDeprecation(factoryElement));
            model.validateFactoryNameIsNotDuplicate(factory);
            model.addFactory(name, factory);
            if (!hasDefaultFactoryId || factory.getId() != defaultFactoryId) continue;
            model.setDefaultFactory(factory);
        }
        if (hasDefaultFactoryId && model.getDefaultFactory() == null) {
            AdmFactory factory = new AdmFactory(model, model.getNamespace(), UtlText.toCamelCase((String)model.getName(), (boolean)true) + "Factory", defaultFactoryId);
            model.validateFactoryNameIsNotDuplicate(factory);
            model.addFactory(factory.getName(), factory);
            model.setDefaultFactory(factory);
        }
    }

    private final AdmFactory lookupFactory(AdmModel model, String elementName, Node factoryTypeNode) throws EAdmException {
        Node factoryIdAttr = factoryTypeNode.getAttributes().getNamedItem("factoryid");
        if (factoryIdAttr == null) {
            if (model.getDefaultFactory() == null) {
                throw new EAdmException("No factory id specified for " + elementName + " and no defaultFactoryId specified on model.", CgExtendedDOMBuilder.getCodeSource((Node)factoryTypeNode));
            }
            return model.getDefaultFactory();
        }
        AdmFactory rc = model.getFactoryLocalById(Integer.valueOf(factoryIdAttr.getNodeValue()));
        if (rc == null) {
            throw new EAdmException("unknown factory '" + factoryIdAttr.getNodeValue() + "' for " + elementName, CgExtendedDOMBuilder.getCodeSource((Node)factoryTypeNode));
        }
        return rc;
    }

    private final AdmEnumeration createEnumeration(AdmModel model, String name, Element enumElement) throws EAdmException {
        Node typeAttr = enumElement.getAttributes().getNamedItem("type");
        String typeStr = typeAttr == null ? "int" : typeAttr.getNodeValue();
        AdmEnumeration.CodeType type = null;
        type = typeStr.equals("int") ? AdmEnumeration.CodeType.INTEGER : (typeStr.equals("char") ? AdmEnumeration.CodeType.CHARACTER : AdmEnumeration.CodeType.STRING);
        AdmEnumeration enumeration = new AdmEnumeration(model, model.getNamespace(), name, type);
        enumeration.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)enumElement));
        enumeration.setDocumentation(this.parseElementDocumentation(enumElement, "Enum"));
        enumeration.setDeprecation(this.parseElementDeprecation(enumElement));
        NodeList consts = enumElement.getElementsByTagName("const");
        block5: for (int j = 0; j < consts.getLength(); ++j) {
            Element constElement = (Element)consts.item(j);
            String constName = constElement.getAttributes().getNamedItem("name").getNodeValue();
            String constValue = constElement.getAttributes().getNamedItem("value").getNodeValue();
            AdmDocumentation doc = this.parseElementDocumentation(constElement, "Enum Constant");
            AdmDeprecation deprecation = this.parseElementDeprecation(constElement);
            CgCodeSource constCodeSource = CgExtendedDOMBuilder.getCodeSource((Node)constElement);
            switch (type) {
                case INTEGER: {
                    enumeration.addConst(constName, Integer.valueOf(constValue));
                    enumeration.getConst(constName).setDocumentation(doc);
                    enumeration.getConst(constName).setDeprecation(deprecation);
                    enumeration.getConst(constName).setCodeSource(constCodeSource);
                    continue block5;
                }
                case CHARACTER: {
                    if (constValue.length() > 1) {
                        this.errorAggregator.add("invalid const value '" + constValue + "' for character type enum", CgSourceCodeErrorAggregator.Severity.ERROR, enumeration.getCodeSource(), null);
                    }
                    enumeration.addConst(constName, Character.valueOf(constValue.charAt(0)));
                    enumeration.getConst(constName).setDocumentation(doc);
                    enumeration.getConst(constName).setDeprecation(deprecation);
                    enumeration.getConst(constName).setCodeSource(constCodeSource);
                    continue block5;
                }
                case STRING: {
                    enumeration.addConst(constName, constValue);
                    enumeration.getConst(constName).setDocumentation(doc);
                    enumeration.getConst(constName).setDeprecation(deprecation);
                    enumeration.getConst(constName).setCodeSource(constCodeSource);
                }
            }
        }
        if (model.getEnumeration(name) == null) {
            model.validateTypeNameIsNotDuplicate(enumeration);
            model.addEnumeration(name, enumeration);
        }
        return enumeration;
    }

    private final void parseEnumerations(AdmModel model) throws Exception {
        for (int i = 0; i < this.enumElements.getLength(); ++i) {
            Element enumElement = (Element)this.enumElements.item(i);
            String name = enumElement.getAttributes().getNamedItem("name").getNodeValue();
            this.createEnumeration(model, name, enumElement);
        }
    }

    private final AdmSemanticType createSemanticType(AdmModel model, String name, Element typeElement) throws EAdmException {
        AdmSemanticType type;
        boolean pooledDisabledByAttribute;
        String baseTypeName = typeElement.getAttributes().getNamedItem("base").getNodeValue();
        AdmType baseType = this.getType(model, baseTypeName);
        Node pooledAttribute = typeElement.hasAttribute("poolable") ? typeElement.getAttributes().getNamedItem("poolable") : null;
        boolean pooledByAttribute = pooledAttribute != null && Boolean.valueOf(pooledAttribute.getNodeValue()) != false;
        boolean poolable = pooledByAttribute || model.getBooleanDirective("generateAllStringsPoolable");
        boolean bl = pooledDisabledByAttribute = pooledAttribute != null && Boolean.valueOf(pooledAttribute.getNodeValue()) == false;
        if (pooledByAttribute || poolable && !pooledDisabledByAttribute) {
            if (baseType instanceof AdmPrimitive && ((AdmPrimitive)baseType).getType() == AdmPrimitive.Type.String) {
                String typeName = UtlText.toCamelCase((String)name, (boolean)true);
                AdmType existing = model.getPooledString(typeName);
                if (existing == null) {
                    existing = model.getType(typeName);
                    if (existing != null && !this.isValidTypeNameClash(existing, typeName)) {
                        this.errorAggregator.add("pooled string type name of '" + (Object)((Object)baseType) + "' for type '" + name + "' defined in " + typeElement + " conflicts with an existing type " + ((Object)((Object)existing)).getClass().getSimpleName(), CgSourceCodeErrorAggregator.Severity.ERROR, CgExtendedDOMBuilder.getCodeSource((Node)typeElement), null);
                    }
                    AdmPooledString createStringType = new AdmPooledString(model, model.getNamespace(), typeName);
                    model.addPooledString(createStringType);
                    baseType = createStringType;
                }
            } else if (pooledByAttribute) {
                this.errorAggregator.add("pooled attribute is not supported for type '" + baseTypeName + "' for type '" + name + "' defined in " + typeElement + ". 'pooled' attribute is currently only supported for String types", CgSourceCodeErrorAggregator.Severity.ERROR, CgExtendedDOMBuilder.getCodeSource((Node)typeElement), null);
            }
        }
        if ((type = model.getSemanticType(name)) != null) {
            return type;
        }
        type = new AdmSemanticType(model, name, baseType);
        type.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)typeElement));
        type.setDocumentation(this.parseElementDocumentation(typeElement, "Type"));
        type.setDeprecation(this.parseElementDeprecation(typeElement));
        type.setPoolable(poolable);
        Node lengthAttr = typeElement.getAttributes().getNamedItem("length");
        if (lengthAttr != null) {
            int length = Integer.valueOf(lengthAttr.getNodeValue());
            type.setLength(length);
            if (baseType instanceof AdmPooledString && baseType.getModel() == model) {
                AdmPooledString pooledString = (AdmPooledString)baseType;
                pooledString.setLength(Math.max(pooledString.getLength(), length));
            }
        }
        model.addSemanticType(type);
        if (baseType instanceof AdmPooledString) {
            AdmPooledString pooledString = (AdmPooledString)baseType;
            if (type.getLength() > 0) {
                pooledString.setLength(type.getLength());
            }
            pooledString.setDeprecation(type.getDeprecation());
            pooledString.setDocumentation(type.getDocumentation());
        }
        return type;
    }

    private final AdmMessage createMessage(AdmModel model, String name, Element messageElement) throws EAdmException {
        AdmType parentType;
        AdmFactory factory = this.lookupFactory(model, "message '" + name + "'", messageElement);
        Node parentAttr = messageElement.getAttributes().getNamedItem("extends");
        String parent = parentAttr == null ? null : parentAttr.getNodeValue();
        AdmType admType = parentType = parent == null ? null : this.getType(model, parent);
        if (parent == null || parentType != null) {
            AdmEntity.FieldOrderingPolicy fieldOrderingPolicy;
            int id = Integer.valueOf(messageElement.getAttributes().getNamedItem("id").getNodeValue());
            Node transactionalAttr = messageElement.getAttributes().getNamedItem("transactional");
            boolean transactional = transactionalAttr == null ? false : Boolean.valueOf(transactionalAttr.getNodeValue());
            Node fieldOrderingPolicyAttr = messageElement.getAttributes().getNamedItem("order");
            try {
                fieldOrderingPolicy = AdmEntity.FieldOrderingPolicy.valueOf(fieldOrderingPolicyAttr.getNodeValue());
            }
            catch (Exception e) {
                throw new EAdmException("unknown entity field order '" + fieldOrderingPolicyAttr.getNodeValue() + "'", CgExtendedDOMBuilder.getCodeSource((Node)messageElement));
            }
            AdmMessage message = new AdmMessage(model, model.getNamespace(), name, parentType, factory, id, transactional, fieldOrderingPolicy);
            message.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)messageElement));
            message.setDocumentation(this.parseElementDocumentation(messageElement, "Message"));
            message.setDeprecation(this.parseElementDeprecation(messageElement));
            this.parseEntityFields(model, message, messageElement.getElementsByTagName("*"));
            model.validateTypeNameIsNotDuplicate(message);
            try {
                model.addMessage(name, message);
            }
            catch (EAdmException adme) {
                throw adme;
            }
            catch (Exception e) {
                this.errorAggregator.add(e.getMessage(), CgSourceCodeErrorAggregator.Severity.ERROR, CgExtendedDOMBuilder.getCodeSource((Node)messageElement), (Throwable)e);
            }
            factory.addType(message);
            return message;
        }
        throw new EAdmException("unknown parent type '" + parent + "' for message '" + name + "'", CgExtendedDOMBuilder.getCodeSource((Node)messageElement));
    }

    private final AdmDocumentation parseElementDocumentation(Element element, String modelType) throws EAdmException {
        NodeList documentation;
        Node briefDoc = element.getAttributes().getNamedItem("doc");
        String brief = null;
        if (briefDoc != null) {
            brief = briefDoc.getNodeValue();
        }
        if ((documentation = element.getElementsByTagName("documentation")).getLength() > 0 && documentation.item(0).getParentNode() == element) {
            AdmDocumentation doc = new AdmDocumentation(modelType);
            doc.setBrief(brief);
            Element docElement = (Element)documentation.item(0);
            doc.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)docElement));
            if (docElement.hasAttribute("brief")) {
                doc.setBrief(docElement.getAttribute("brief"));
            }
            if (docElement.getChildNodes().getLength() > 0) {
                Text text = (Text)docElement.getChildNodes().item(0);
                doc.setFull(text.getWholeText());
            }
            return doc;
        }
        if (brief != null) {
            AdmDocumentation doc = new AdmDocumentation(modelType);
            doc.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)element));
            doc.setBrief(briefDoc.getTextContent());
            return doc;
        }
        return null;
    }

    private final AdmDeprecation parseElementDeprecation(Element element) throws EAdmException {
        NodeList deprecationNodes;
        Node deprecatedAttr = element.getAttributes().getNamedItem("deprecated");
        boolean deprecated = false;
        if (deprecatedAttr != null) {
            deprecated = Boolean.valueOf(deprecatedAttr.getNodeValue());
        }
        if ((deprecationNodes = element.getElementsByTagName("deprecation")).getLength() > 0 && deprecationNodes.item(0).getParentNode() == element) {
            AdmDeprecation deprecation = new AdmDeprecation();
            Element deprecationNode = (Element)deprecationNodes.item(0);
            deprecation.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)deprecationNode));
            if (deprecationNode.hasAttribute("since")) {
                deprecation.setSince(deprecationNode.getAttribute("since"));
            }
            if (deprecationNode.getChildNodes().getLength() > 0) {
                Text text = (Text)deprecationNode.getChildNodes().item(0);
                deprecation.setReason(text.getWholeText());
            }
            return deprecation;
        }
        if (deprecated) {
            AdmDeprecation deprecation = new AdmDeprecation();
            deprecation.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)element));
            return deprecation;
        }
        return null;
    }

    private final void parseMessages(AdmModel model) throws Exception {
        for (int i = 0; i < this.messageElements.getLength(); ++i) {
            Element messageElement = (Element)this.messageElements.item(i);
            String name = messageElement.getAttributes().getNamedItem("name").getNodeValue();
            this.createMessage(model, name, messageElement);
        }
    }

    private final AdmEntity createEntity(AdmModel model, String name, Element entityElement) throws EAdmException {
        boolean transactional;
        AdmFactory factory = this.lookupFactory(model, "entity '" + name + "'", entityElement);
        Node parentAttr = entityElement.getAttributes().getNamedItem("extends");
        String parent = parentAttr == null ? null : parentAttr.getNodeValue();
        AdmType parentType = parent == null ? null : this.getType(model, parent);
        Node isRootAttr = entityElement.getAttributes().getNamedItem("isRoot");
        boolean isRoot = isRootAttr == null ? false : Boolean.valueOf(isRootAttr.getNodeValue());
        Node asFieldAttr = entityElement.getAttributes().getNamedItem("asField");
        boolean asField = asFieldAttr == null ? false : Boolean.valueOf(asFieldAttr.getNodeValue());
        Node asEmbeddedAttr = entityElement.getAttributes().getNamedItem("asEmbedded");
        boolean asEmbedded = asEmbeddedAttr == null ? false : Boolean.valueOf(asEmbeddedAttr.getNodeValue());
        Node transactionalAttr = entityElement.getAttributes().getNamedItem("transactional");
        boolean bl = transactional = transactionalAttr == null ? true : Boolean.valueOf(transactionalAttr.getNodeValue());
        if (parent == null || parentType != null) {
            AdmEntity.FieldOrderingPolicy fieldOrderingPolicy;
            Node fieldOrderingPolicyAttr = entityElement.getAttributes().getNamedItem("order");
            try {
                fieldOrderingPolicy = AdmEntity.FieldOrderingPolicy.valueOf(fieldOrderingPolicyAttr.getNodeValue());
            }
            catch (Exception e) {
                throw new EAdmException("unknown entity field order '" + fieldOrderingPolicyAttr.getNodeValue() + "'", CgExtendedDOMBuilder.getCodeSource((Node)entityElement));
            }
            int id = Integer.valueOf(entityElement.getAttributes().getNamedItem("id").getNodeValue());
            AdmEntity entity = new AdmEntity(model, model.getNamespace(), name, parentType, factory, id, transactional, fieldOrderingPolicy);
            entity.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)entityElement));
            entity.setDocumentation(this.parseElementDocumentation(entityElement, "Entity"));
            entity.setDeprecation(this.parseElementDeprecation(entityElement));
            if (isRoot) {
                entity.setAsRoot();
            }
            if (asField || asEmbedded) {
                entity.setAsEmbedded();
            }
            this.parseEntityFields(model, entity, entityElement.getElementsByTagName("*"));
            AdmEntity foundEntity = model.getEntity(name);
            if (foundEntity == null) {
                model.validateTypeNameIsNotDuplicate(entity);
                try {
                    model.addEntity(name, entity);
                }
                catch (EAdmException adme) {
                    throw adme;
                }
                catch (Exception e) {
                    this.errorAggregator.add(e.getMessage(), CgSourceCodeErrorAggregator.Severity.ERROR, entity.getCodeSource(), (Throwable)e);
                }
                factory.addType(entity);
            } else if (!SUPPRESS_DUPLICATE_CHECKING && !foundEntity.getCodeSource().equals((Object)entity.getCodeSource())) {
                model.validateTypeNameIsNotDuplicate(entity);
            }
            return entity;
        }
        throw new EAdmException("Unknown parent type '" + parent + "' for entity '" + name + "'", CgExtendedDOMBuilder.getCodeSource((Node)entityElement));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void parseEntityFields(AdmModel model, AdmEntity entity, NodeList fieldElements) throws EAdmException {
        Element fieldElement;
        int j;
        String name = (entity instanceof AdmMessage ? "message" : "entity") + " '" + entity.getName() + "'";
        HashMap<String, AdmEntity> inlines = new HashMap<String, AdmEntity>();
        for (j = 0; j < fieldElements.getLength(); ++j) {
            fieldElement = (Element)fieldElements.item(j);
            CgCodeSource fieldElementCodeSource = CgExtendedDOMBuilder.getCodeSource((Node)fieldElement);
            if (!fieldElement.getNodeName().equals("inline")) continue;
            String inlineName = fieldElement.getAttributes().getNamedItem("ref").getNodeValue();
            AdmEntity inline = null;
            this.pushFieldResolution(name, "<inline>", inlineName);
            try {
                AdmType type = this.getFieldType(model, inlineName);
                if (type == null) {
                    throw new EAdmException("Unknown inline type '" + inlineName + "' for " + name, fieldElementCodeSource);
                }
                if (type instanceof AdmEntity) {
                    inline = (AdmEntity)type;
                    if (inline instanceof AdmMessage) {
                        if (!(entity instanceof AdmMessage)) {
                            throw new EAdmException("'" + entity.getName() + "' can't inline message '" + inline.getName() + "', only a message can inline another message.", fieldElementCodeSource);
                        }
                    } else if (!inline.isEmbedded()) {
                        this.errorAggregator.add("'" + entity.getName() + "' can't inline type '" + inline.getName() + "', only embedded entities can be inlined.", CgSourceCodeErrorAggregator.Severity.ERROR, fieldElementCodeSource, null);
                    }
                } else {
                    this.errorAggregator.add("'" + entity.getName() + "' can't inline '" + inlineName + "', only embedded entities can be inlined.", CgSourceCodeErrorAggregator.Severity.ERROR, fieldElementCodeSource, null);
                }
            }
            finally {
                this.popFieldResolution();
            }
            entity.inline(inline);
            for (AdmField field : inline.fields().values()) {
                if (inlines.containsKey(field.getName())) {
                    AdmField existing = entity.getField(field.getName());
                    if (this.tracer.debug) {
                        this.tracer.log("Merging inlined field " + existing + " for " + (Object)((Object)entity) + " from '" + (Object)((Object)inline) + "'", Tracer.Level.DEBUG);
                    }
                    inlines.put(field.getName(), inline);
                    if (this.tracer.debug) {
                        this.tracer.log("Merged inlined field: " + existing, Tracer.Level.DEBUG);
                    }
                    this.mergeInlinedField(model, existing, field, entity, ((AdmEntity)((Object)inlines.get(field.getName()))).getFullName(), inline.getFullName());
                    continue;
                }
                if (this.tracer.debug) {
                    this.tracer.log("Adding inlined field " + field + " for " + (Object)((Object)entity) + " from '" + inline.getFullName() + "'", Tracer.Level.DEBUG);
                }
                AdmField fieldCopy = field.copy();
                fieldCopy.setCodeSource(fieldElementCodeSource);
                entity.addField(fieldCopy);
                inlines.put(field.getName(), inline);
            }
        }
        for (j = 0; j < fieldElements.getLength(); ++j) {
            AdmField field;
            fieldElement = (Element)fieldElements.item(j);
            if (fieldElement.getNodeName().equals("inline")) continue;
            if (fieldElement.getNodeName().equals("field")) {
                field = this.createField(model, name, fieldElement, false, false, (short)j);
            } else {
                if (!fieldElement.getNodeName().equals("fieldRef")) continue;
                field = this.getFieldRef(model, name, fieldElement, (short)j);
            }
            if (inlines.containsKey(field.getName())) {
                AdmField existing = entity.getField(field.getName());
                if (this.tracer.debug) {
                    this.tracer.log("Overiding inlined field " + existing + " for " + (Object)((Object)entity), Tracer.Level.DEBUG);
                }
                this.overrideInlinedField(model, existing, field, fieldElement, entity);
                if (this.tracer.debug) {
                    this.tracer.log("Overided inlined field: " + existing, Tracer.Level.DEBUG);
                }
                inlines.remove(field.getName());
                continue;
            }
            entity.addField(field);
        }
    }

    private final void mergeInlinedField(AdmModel model, AdmField existing, AdmField override, AdmEntity entity, String existingSource, String overrideSource) throws EAdmException {
        CgCodeSource overrideCodeSource = override.getCodeSource();
        if (existing.getId() != override.getId()) {
            this.errorAggregator.add("Conflicting inline field id's for field '" + existing.getName() + " in '" + entity.getName() + " ': id from '" + existingSource + "' is '" + existing.getId() + "' but id from '" + overrideSource + "' is '" + override.getId() + "'", CgSourceCodeErrorAggregator.Severity.ERROR, overrideCodeSource, null);
        }
        if (!existing.getQualifiedSemanticTypeName(model).equals(override.getQualifiedSemanticTypeName(model))) {
            this.errorAggregator.add("Conflicting inline field types for field '" + existing.getName() + " in '" + entity.getName() + " ': type from '" + existingSource + "' is '" + existing.getQualifiedSemanticTypeName(model) + "' but type from '" + overrideSource + "' is '" + override.getQualifiedSemanticTypeName(model) + "'", CgSourceCodeErrorAggregator.Severity.ERROR, overrideCodeSource, null);
        }
        if (!existing.getJsonName().equals(override.getJsonName())) {
            this.errorAggregator.add("Conflicting inline field jsonNames for field '" + existing.getName() + " in '" + entity.getName() + " ': jsonName from '" + existingSource + "' is '" + existing.getJsonName() + "' but jsonName from '" + overrideSource + "' is '" + override.getJsonName() + "'", CgSourceCodeErrorAggregator.Severity.ERROR, overrideCodeSource, null);
        }
        if (existing.getLength() != override.getLength()) {
            this.errorAggregator.add("Conflicting inline field lengths for field '" + existing.getName() + " in '" + entity.getName() + " ': length from '" + existingSource + "' is '" + existing.getLength() + "' but length from '" + overrideSource + "' is '" + override.getLength() + "'", CgSourceCodeErrorAggregator.Severity.ERROR, overrideCodeSource, null);
        }
        if (override.getDocumentation() != null) {
            existing.setDocumentation(override.getDocumentation());
        }
        if (override.isDeprecated()) {
            existing.setDeprecation(override.getDeprecation());
        }
        existing.setRequired(existing.isRequired() || override.isRequired());
        existing.setCodeSource(overrideCodeSource);
    }

    private final void overrideInlinedField(AdmModel model, AdmField inlined, AdmField override, Node fieldNode, AdmEntity entity) throws EAdmException {
        if (inlined.getId() != override.getId()) {
            this.errorAggregator.add("Conflicting field id's for field '" + inlined.getName() + " in '" + entity.getName() + " ': id from inline is " + inlined.getId() + " but id specified on field is " + override.getId(), CgSourceCodeErrorAggregator.Severity.ERROR, override.getCodeSource(), null);
        }
        if (!inlined.getQualifiedSemanticTypeName(model).equals(override.getQualifiedSemanticTypeName(model))) {
            this.errorAggregator.add("Conflicting inline field types for field '" + inlined.getName() + " in '" + entity.getName() + " ': type from inline is " + inlined.getQualifiedSemanticTypeName(model) + " but type specified on field is '" + override.getQualifiedSemanticTypeName(model) + "'", CgSourceCodeErrorAggregator.Severity.ERROR, override.getCodeSource(), null);
        }
        if (!inlined.getJsonName().equals(override.getJsonName())) {
            this.errorAggregator.add("Conflicting inline field jsonNames for field '" + inlined.getName() + " in '" + entity.getName() + " ': jsonName from inline is " + inlined.getJsonName() + " but jsonName specified on field is " + override.getJsonName(), CgSourceCodeErrorAggregator.Severity.ERROR, override.getCodeSource(), null);
        }
        if (inlined.getLength() != override.getLength()) {
            this.errorAggregator.add("Conflicting inline field length for field '" + inlined.getName() + " in '" + entity.getName() + " ': length from inline is  " + inlined.getLength() + " but length specified on field is " + override.getLength(), CgSourceCodeErrorAggregator.Severity.ERROR, override.getCodeSource(), null);
        }
        if (override.getDocumentation() != null) {
            inlined.setDocumentation(inlined.getDocumentation());
        }
        if (override.getDeprecation() != null || fieldNode.getAttributes().getNamedItem("deprecated") != null) {
            inlined.setDeprecation(override.getDeprecation());
        }
        if (fieldNode.getAttributes().getNamedItem("required") != null) {
            inlined.setRequired(override.isRequired());
        }
        if (override.isKey()) {
            inlined.setAsKey();
        }
        if (override.isReflected()) {
            inlined.setAsReflected();
        }
        if (override.isPinned()) {
            inlined.setAsPinned();
        }
        inlined.setCodeSource(override.getCodeSource());
    }

    private final void parseEntities(AdmModel model) throws Exception {
        for (int i = 0; i < this.entityElements.getLength(); ++i) {
            Element entityElement = (Element)this.entityElements.item(i);
            String name = entityElement.getAttributes().getNamedItem("name").getNodeValue();
            this.createEntity(model, name, entityElement);
        }
    }

    private final AdmCollection createCollection(AdmModel model, String name, Element collectionElement) throws EAdmException {
        AdmCollection.Type isType;
        AdmFactory factory = this.lookupFactory(model, "collection '" + name + "'", collectionElement);
        String is = collectionElement.getAttributes().getNamedItem("is").getNodeValue();
        try {
            isType = AdmCollection.Type.valueOf(is);
        }
        catch (Exception e) {
            throw new EAdmException("unknown collection type '" + is + "'", CgExtendedDOMBuilder.getCodeSource((Node)collectionElement));
        }
        String contains = collectionElement.getAttributes().getNamedItem("contains").getNodeValue();
        AdmType containsType = this.getType(model, contains);
        if (containsType == null) {
            throw new EAdmException("unknown type '" + contains + "' in collection '" + name + "'", CgExtendedDOMBuilder.getCodeSource((Node)collectionElement));
        }
        if (!(containsType instanceof AdmEntity)) {
            throw new EAdmException("invalid type '" + containsType.getJavaTypeName() + "' contained in collection '" + name + "' (a collection can contain only entity (and message) types)", CgExtendedDOMBuilder.getCodeSource((Node)collectionElement));
        }
        int id = Integer.valueOf(collectionElement.getAttributes().getNamedItem("id").getNodeValue());
        Node transactionalAttr = collectionElement.getAttributes().getNamedItem("transactional");
        boolean transactional = transactionalAttr == null ? true : Boolean.valueOf(transactionalAttr.getNodeValue());
        AdmCollection collection = new AdmCollection(model, model.getNamespace(), name, isType, (AdmEntity)containsType, factory, id, transactional, CgExtendedDOMBuilder.getCodeSource((Node)collectionElement));
        if (collection.getKeyType() != null && collection.getKeyField() == null) {
            String keyFieldName = AdmGenerator.getImplicitKeyFieldNameFor(collection.getKeyType());
            this.errorAggregator.add("No field of type '" + collection.getKeyType().getName() + "' that is marked isKey=\"true\" found in '" + containsType.getJavaTypeName() + "'. A key field '" + keyFieldName + "' has been added implicitly, but to avoid compatibility problems as the model evolves it is strongly recommended  that the key field be defined explicitly. NOTE: Changing the key field in '" + containsType.getJavaTypeName() + "' used asKey can cause existing state to become unrecoverable. To remain compatible with a previous implicitly generated key field id, add the same field name/id as returned by the previously generated source's " + AdmGenerator.fieldGetterMethodName(keyFieldName) + "FieldId() method.", CgSourceCodeErrorAggregator.Severity.WARNING, CgExtendedDOMBuilder.getCodeSource((Node)collectionElement), null);
        }
        collection.setDocumentation(this.parseElementDocumentation(collectionElement, "Collection"));
        collection.setDeprecation(this.parseElementDeprecation(collectionElement));
        if (model.getCollection(name) == null) {
            model.validateTypeNameIsNotDuplicate(collection);
            try {
                model.addCollection(name, collection);
            }
            catch (EAdmException adme) {
                throw adme;
            }
            catch (Exception e) {
                this.errorAggregator.add(e.getMessage(), CgSourceCodeErrorAggregator.Severity.ERROR, collection.getCodeSource(), (Throwable)e);
            }
            factory.addType(collection);
        }
        return collection;
    }

    private final void parseCollections(AdmModel model) throws Exception {
        for (int i = 0; i < this.collectionElements.getLength(); ++i) {
            Element collectionElement = (Element)this.collectionElements.item(i);
            String name = collectionElement.getAttributes().getNamedItem("name").getNodeValue();
            this.createCollection(model, name, collectionElement);
        }
    }

    private final void parseSemanticTypes(AdmModel model) throws EAdmException {
        String name;
        Element typeElement;
        int i;
        HashSet<String> typeNames = new HashSet<String>();
        for (i = 0; i < this.typeElements.getLength(); ++i) {
            typeElement = (Element)this.typeElements.item(i);
            name = typeElement.getAttributes().getNamedItem("name").getNodeValue();
            if (!SUPPRESS_DUPLICATE_CHECKING && typeNames.contains(name)) {
                this.errorAggregator.add("Duplicate type name '" + name + "' defined in <types>", CgSourceCodeErrorAggregator.Severity.ERROR, CgExtendedDOMBuilder.getCodeSource((Node)typeElement), null);
            }
            typeNames.add(name);
        }
        for (i = 0; i < this.typeElements.getLength(); ++i) {
            typeElement = (Element)this.typeElements.item(i);
            name = typeElement.getAttributes().getNamedItem("name").getNodeValue();
            this.createSemanticType(model, name, typeElement);
        }
    }

    private final void parseFields(AdmModel model) throws EAdmException {
        String fieldName;
        Element fieldElement;
        int i;
        HashSet<String> fieldNames = new HashSet<String>();
        for (i = 0; i < this.fieldElements.getLength(); ++i) {
            fieldElement = (Element)this.fieldElements.item(i);
            fieldName = fieldElement.getAttributes().getNamedItem("name").getNodeValue();
            if (!SUPPRESS_DUPLICATE_CHECKING && fieldNames.contains(fieldName)) {
                this.errorAggregator.add("Duplicate field name '" + fieldName + "' defined in fields", CgSourceCodeErrorAggregator.Severity.ERROR, CgExtendedDOMBuilder.getCodeSource((Node)fieldElement), null);
            }
            fieldNames.add(fieldName);
        }
        for (i = 0; i < this.fieldElements.getLength(); ++i) {
            fieldElement = (Element)this.fieldElements.item(i);
            fieldName = fieldElement.getAttributes().getNamedItem("name").getNodeValue();
            AdmField field = this.createField(model, "<fields>", fieldElement, false, true, (short)-1);
            field.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)fieldElement));
            try {
                if (model.lookupField(fieldName, true) != null) continue;
                model.addField(field);
                continue;
            }
            catch (EAdmException ex) {
                throw new EAdmException("Field lookup error: " + ex.getMessage(), (Throwable)((Object)ex), CgExtendedDOMBuilder.getCodeSource((Node)fieldElement));
            }
        }
    }

    private final AdmField createField(AdmModel model, String parentElement, Element fieldElement, boolean fieldIdRequired, boolean noFidIfNotSet, short fieldPosition) throws EAdmException {
        String fieldName = fieldElement.getAttributes().getNamedItem("name").getNodeValue();
        String fieldTypeName = fieldElement.getAttributes().getNamedItem("type").getNodeValue();
        Node pooledAttribute = fieldElement.hasAttribute("poolable") ? fieldElement.getAttributes().getNamedItem("poolable") : null;
        this.pushFieldResolution(parentElement, fieldName, fieldTypeName);
        try {
            AdmPrimitive type;
            boolean pooledDisabledByAttribute;
            AdmType fieldType = null;
            boolean pooledByAttribute = pooledAttribute != null && Boolean.valueOf(pooledAttribute.getNodeValue()) != false;
            boolean pooledByDirective = model.getBooleanDirective("generateAllStringsPoolable");
            boolean bl = pooledDisabledByAttribute = pooledAttribute != null && Boolean.valueOf(pooledAttribute.getNodeValue()) == false;
            if ((pooledByAttribute || pooledByDirective && !pooledDisabledByAttribute) && (type = AdmPrimitive.toPrimitiveType(fieldTypeName)) != null) {
                if (type.getType() == AdmPrimitive.Type.String) {
                    AdmType existing;
                    fieldTypeName = UtlText.toCamelCase((String)fieldName, (boolean)true);
                    switch (model.getPooledStringFieldTypeNameSuffixPolicy()) {
                        case Always: {
                            fieldTypeName = fieldTypeName + model.getPooledStringSuffix();
                            break;
                        }
                        case OnConflict: {
                            try {
                                existing = this.getFieldType(model, fieldTypeName);
                                if (existing == null || existing instanceof AdmPooledString || this.isValidTypeNameClash(existing, fieldTypeName)) break;
                                fieldTypeName = fieldTypeName + model.getPooledStringSuffix();
                            }
                            catch (EAdmException eadm) {
                                if (!eadm.getMessage().startsWith("Cycle")) break;
                                fieldTypeName = fieldTypeName + model.getPooledStringSuffix();
                            }
                            break;
                        }
                    }
                    fieldType = model.getPooledString(fieldTypeName);
                    if (fieldType == null) {
                        try {
                            existing = model.lookupType(fieldTypeName, false);
                        }
                        catch (EAdmException ex) {
                            throw new EAdmException("Type lookup error: " + ex.getMessage(), (Throwable)((Object)ex), CgExtendedDOMBuilder.getCodeSource((Node)fieldElement));
                        }
                        if (existing != null && existing.getModel() == model && !this.isValidTypeNameClash(existing, fieldTypeName)) {
                            throw new EAdmException("pooled string type name of '" + fieldTypeName + "' for field '" + fieldName + "' defined in " + parentElement + " conflicts with an already defined type '" + existing.getFullName() + "'", CgExtendedDOMBuilder.getCodeSource((Node)fieldElement));
                        }
                        AdmPooledString stringType = new AdmPooledString(model, model.getNamespace(), fieldTypeName);
                        stringType.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)fieldElement));
                        model.addPooledString(stringType);
                        fieldType = stringType;
                    }
                } else if (pooledByAttribute) {
                    throw new EAdmException("pooled attribute is not supported for primitive type '" + fieldTypeName + "' for field '" + fieldName + "' defined in " + parentElement + ". 'pooled' attribute is currently only supported for String types", CgExtendedDOMBuilder.getCodeSource((Node)fieldElement));
                }
            }
            if (fieldType == null) {
                try {
                    fieldType = this.getFieldType(model, fieldTypeName);
                }
                catch (EAdmException ex) {
                    if (ex.getMessage().startsWith("Ambiguous type resolution ")) {
                        throw new EAdmException("Type resolution error: " + ex.getMessage(), (Throwable)((Object)ex), CgExtendedDOMBuilder.getCodeSource((Node)fieldElement));
                    }
                    throw ex;
                }
            }
            if (fieldType != null) {
                Node isRequiredAttr;
                Node isPinnedAttr;
                boolean isPinned;
                Node isReflectedAttr;
                boolean isReflected;
                Node isKeyAttr;
                boolean isKey;
                Node lengthAttr;
                Node idAttr = fieldElement.getAttributes().getNamedItem("id");
                if (fieldIdRequired && idAttr == null) {
                    throw new EAdmException("id attribute is required '" + fieldTypeName + "' for field '" + fieldName + "' defined in " + parentElement + "", CgExtendedDOMBuilder.getCodeSource((Node)fieldElement));
                }
                short maxFieldId = AdmGeneratorRegistry.getInstance().getGenerator(model.getStringDirective("encodingType")).getMaxFieldId();
                AdmField field = new AdmField(model, fieldName, idAttr != null ? Short.valueOf(idAttr.getNodeValue()) : (short)(maxFieldId - 15 - 15 - fieldPosition), fieldType);
                field.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)fieldElement));
                if (fieldType instanceof AdmMessage) {
                    throw new EAdmException("Invalid field type '" + fieldType.getFullName() + "'.Message type cannot be used as field type.", field.getCodeSource());
                }
                if (idAttr == null && noFidIfNotSet) {
                    field.setId((short)-1);
                }
                field.setDocumentation(this.parseElementDocumentation(fieldElement, "Field"));
                field.setDeprecation(this.parseElementDeprecation(fieldElement));
                field.setSemanticType(this.getFieldSemanticType(model, fieldTypeName));
                Node jsonNameAttr = fieldElement.getAttributes().getNamedItem("jsonName");
                if (jsonNameAttr != null) {
                    field.setJsonName(jsonNameAttr.getNodeValue());
                }
                if ((lengthAttr = fieldElement.getAttributes().getNamedItem("length")) != null) {
                    int length = Integer.valueOf(lengthAttr.getNodeValue());
                    field.setLength(length);
                    if (fieldType instanceof AdmPooledString && fieldType.getModel() == model) {
                        AdmPooledString pooledString = (AdmPooledString)fieldType;
                        pooledString.setLength(Math.max(pooledString.getLength(), length));
                    }
                }
                boolean bl2 = isKey = (isKeyAttr = fieldElement.getAttributes().getNamedItem("isKey")) == null ? false : Boolean.valueOf(isKeyAttr.getNodeValue());
                if (isKey) {
                    field.setAsKey();
                }
                boolean bl3 = isReflected = (isReflectedAttr = fieldElement.getAttributes().getNamedItem("isReflected")) == null ? false : Boolean.valueOf(isReflectedAttr.getNodeValue());
                if (isReflected) {
                    field.setAsReflected();
                }
                boolean bl4 = isPinned = (isPinnedAttr = fieldElement.getAttributes().getNamedItem("pinned")) == null ? false : Boolean.valueOf(isPinnedAttr.getNodeValue());
                if (isPinned) {
                    field.setAsPinned();
                }
                boolean required = (isRequiredAttr = fieldElement.getAttributes().getNamedItem("required")) == null ? false : Boolean.valueOf(isRequiredAttr.getNodeValue());
                field.setRequired(required);
                AdmField admField = field;
                return admField;
            }
            throw new EAdmException("unknown type '" + fieldTypeName + "' for field '" + fieldName + "' defined in " + parentElement + "", CgExtendedDOMBuilder.getCodeSource((Node)fieldElement));
        }
        finally {
            this.popFieldResolution();
        }
    }

    private final void pushFieldResolution(String enclosingType, String fieldName, String fieldType) throws EAdmException {
        FieldResolutionFrame frf = new FieldResolutionFrame(enclosingType, fieldName, fieldType);
        this.fieldTypeStack.push(frf);
        if (!this.fieldCycleCheck.add(enclosingType)) {
            EAdmException cycle = new EAdmException("Cycle detected: " + this.fieldTypeStack.toString().replace(", ", " -> "));
            this.fieldTypeStack.pop();
            throw cycle;
        }
    }

    private void popFieldResolution() throws EAdmException {
        FieldResolutionFrame frf = this.fieldTypeStack.pop();
        this.fieldCycleCheck.remove(frf.enclosingType);
    }

    private final AdmField getFieldRef(AdmModel model, String parentElement, Element fieldRefElement, int fieldPosition) throws EAdmException {
        Node isRequiredAttr;
        Node isPinnedAttr;
        boolean isPinned;
        Node isReflectedAttr;
        boolean isReflected;
        boolean isKey;
        AdmDocumentation doc;
        AdmFieldLookup refLookup;
        String fieldRefName = fieldRefElement.getAttributes().getNamedItem("ref").getNodeValue();
        try {
            refLookup = model.lookupField(fieldRefName, true);
        }
        catch (EAdmException ex) {
            throw new EAdmException("Field lookup error: " + ex.getMessage(), (Throwable)((Object)ex), CgExtendedDOMBuilder.getCodeSource((Node)fieldRefElement));
        }
        if (refLookup == null) {
            for (int i = 0; i < this.fieldElements.getLength(); ++i) {
                String name;
                Element fieldElement = (Element)this.fieldElements.item(i);
                Node nameAttr = fieldElement.getAttributes().getNamedItem("name");
                String string = name = nameAttr == null ? null : nameAttr.getNodeValue();
                if (!fieldRefName.equals(name)) continue;
                AdmField ref = this.createField(model, parentElement, fieldElement, false, true, (short)i);
                model.addField(ref);
                refLookup = new AdmFieldLookup(ref);
                break;
            }
        }
        if (refLookup == null) {
            try {
                refLookup = model.lookupField(fieldRefName, false);
            }
            catch (EAdmException ex) {
                throw new EAdmException("Field lookup error: " + ex.getMessage(), (Throwable)((Object)ex), CgExtendedDOMBuilder.getCodeSource((Node)fieldRefElement));
            }
        }
        if (refLookup == null) {
            throw new EAdmException("Referenced '" + fieldRefName + "' in '" + parentElement + " not found in <fields> or import", CgExtendedDOMBuilder.getCodeSource((Node)fieldRefElement));
        }
        Node nameAttr = fieldRefElement.getAttributes().getNamedItem("name");
        String name = nameAttr == null ? refLookup.getField().getName() : nameAttr.getNodeValue();
        Node idAttr = fieldRefElement.getAttributes().getNamedItem("id");
        short id = idAttr == null ? refLookup.getField().getId() : Short.valueOf(idAttr.getNodeValue()).shortValue();
        short maxFieldId = AdmGeneratorRegistry.getInstance().getGenerator(model.getStringDirective("encodingType")).getMaxFieldId();
        if (id == -1) {
            id = (short)(maxFieldId - 15 - 15 - fieldPosition);
        }
        AdmField field = refLookup.deriveField(model, name, id);
        field.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)fieldRefElement));
        Node jsonNameAttr = fieldRefElement.getAttributes().getNamedItem("jsonName");
        field.setJsonName(jsonNameAttr == null ? refLookup.getField().getJsonName() : jsonNameAttr.getNodeValue());
        if (refLookup.getField().getLength() > 0) {
            field.setLength(refLookup.getField().getLength());
        }
        field.setDocumentation((doc = this.parseElementDocumentation(fieldRefElement, "Field")) == null ? refLookup.getField().getDocumentation() : doc);
        AdmDeprecation deprecation = this.parseElementDeprecation(fieldRefElement);
        field.setDeprecation(deprecation == null ? refLookup.getField().getDeprecation() : deprecation);
        field.setSemanticType(refLookup.getField().getSemanticType());
        Node isKeyAttr = fieldRefElement.getAttributes().getNamedItem("isKey");
        boolean bl = isKey = isKeyAttr == null ? false : Boolean.valueOf(isKeyAttr.getNodeValue());
        if (isKey) {
            field.setAsKey();
        }
        boolean bl2 = isReflected = (isReflectedAttr = fieldRefElement.getAttributes().getNamedItem("isReflected")) == null ? false : Boolean.valueOf(isReflectedAttr.getNodeValue());
        if (isReflected) {
            field.setAsReflected();
        }
        boolean bl3 = isPinned = (isPinnedAttr = fieldRefElement.getAttributes().getNamedItem("pinned")) == null ? false : Boolean.valueOf(isPinnedAttr.getNodeValue());
        if (isPinned) {
            field.setAsPinned();
        }
        boolean required = (isRequiredAttr = fieldRefElement.getAttributes().getNamedItem("required")) == null ? refLookup.getField().isRequired() : Boolean.valueOf(isRequiredAttr.getNodeValue()).booleanValue();
        field.setRequired(required);
        return field;
    }

    private final boolean isValidTypeNameClash(AdmType existing, String typeName) {
        if (existing instanceof AdmPrimitive) {
            switch (((AdmPrimitive)existing).getType()) {
                case UUID: {
                    return true;
                }
                case Currency: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private final String substituteThisNamespace(String name, String namespace) {
        if (name.startsWith("this.")) {
            return namespace + name.substring(4);
        }
        return name;
    }

    public static final AdmModel parse(File modelFile, File modelsDir, String namespace, Map<String, String> directives, CgResourceChangeTracker parseContext) throws EAdmException {
        if (modelFile == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        try {
            return AdmXMLParser.parse(modelFile.toURI().toURL(), modelsDir, namespace, directives, parseContext);
        }
        catch (MalformedURLException e) {
            throw new EAdmException("Error parsing model: " + e.getMessage(), e);
        }
    }

    public static final AdmModel parse(URL modelURL, File modelsDir, String namespace, Map<String, String> directives, CgResourceChangeTracker parseContext) throws EAdmException {
        if (modelURL == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        AdmXMLParser parser = null;
        try {
            String name;
            parser = new AdmXMLParser(modelURL, modelsDir, parseContext);
            Node nsAttr = parser.doc.getElementsByTagName("model").item(0).getAttributes().getNamedItem("namespace");
            Node nameAttr = parser.doc.getElementsByTagName("model").item(0).getAttributes().getNamedItem("name");
            if (nameAttr != null) {
                name = UtlText.toCamelCase((String)nameAttr.getNodeValue(), (boolean)true);
            } else {
                String path = modelURL.getPath();
                int lastSlash = (path = path.replace('\\', '/')).lastIndexOf(47);
                if (lastSlash != -1) {
                    path = path.substring(lastSlash + 1);
                }
                String string = name = path.indexOf(".") == -1 ? path : path.substring(0, path.indexOf("."));
            }
            AdmModel model = new AdmModel(namespace != null ? namespace : (nsAttr != null ? nsAttr.getNodeValue() : null), name, parser.doc, modelURL, parser.errorAggregator);
            model.setCodeSource(new CgCodeSource(modelURL, 1, 1));
            model.setDocumentation(parser.parseElementDocumentation((Element)parser.doc.getElementsByTagName("model").item(0), "Model"));
            Map<String, AdmDirective> modelDirectives = parser.parseDirectives();
            if (directives != null) {
                for (Map.Entry<String, String> directive : directives.entrySet()) {
                    modelDirectives.put(directive.getKey(), new AdmDirective(directive.getKey(), directive.getValue(), true, null));
                }
            }
            model.setDirectives(modelDirectives);
            CgResourceChangeTracker.ModelSourceFile sourceFile = null;
            if (parseContext != null) {
                sourceFile = parseContext.getSourceFile(modelURL);
            }
            parser.parseImports(model, sourceFile);
            parser.parseFactories(model);
            parser.parseEnumerations(model);
            parser.parseFields(model);
            parser.parseSemanticTypes(model);
            parser.parseMessages(model);
            parser.parseEntities(model);
            parser.parseCollections(model);
            if (parser.errorAggregator.getNumErrors() > 0) {
                throw new EAdmException("Error parsing model", parser.errorAggregator);
            }
            return model;
        }
        catch (EAdmException e) {
            if (e.getAggregatedErrors() == null && parser != null && parser.errorAggregator.getNumErrors() > 0) {
                parser.errorAggregator.add(e.getMessage(), CgSourceCodeErrorAggregator.Severity.ERROR, e.getCodeSource(), (Throwable)((Object)e));
                throw new EAdmException("Errors parsing model", parser.errorAggregator);
            }
            throw e;
        }
        catch (Exception e) {
            if (parser != null && parser.errorAggregator.getNumErrors() > 0) {
                throw new EAdmException("Errors parsing model", parser.errorAggregator);
            }
            throw new EAdmException("Errors parsing model: " + e.getMessage() + " " + modelURL, e);
        }
    }

    public static final AdmModel parse(URL modelURL, File modelsDir, String namespace, CgResourceChangeTracker parseContext) throws EAdmException {
        return AdmXMLParser.parse(modelURL, modelsDir, namespace, null, parseContext);
    }

    public static final AdmModel parse(File modelFile, File modelsDir, String namespace) throws EAdmException {
        return AdmXMLParser.parse(modelFile, modelsDir, namespace, null, null);
    }

    public static final AdmModel parse(URL modelURL, File modelsDir, String namespace) throws EAdmException {
        return AdmXMLParser.parse(modelURL, modelsDir, namespace, null, null);
    }

    public static final AdmModel parse(File modelFile, String namespace) throws EAdmException {
        return AdmXMLParser.parse(modelFile, null, namespace);
    }

    public static final AdmModel parse(URL modelURL, String namespace) throws EAdmException {
        return AdmXMLParser.parse(modelURL, null, namespace);
    }

    public static final AdmModel parse(File modelFile) throws EAdmException {
        return AdmXMLParser.parse(modelFile, null);
    }

    public static final AdmModel parse(URL modelURL) throws EAdmException {
        return AdmXMLParser.parse(modelURL, null);
    }

    private static class FieldResolutionFrame {
        String enclosingType;
        String fieldName;
        String fieldType;

        FieldResolutionFrame(String enclosingType, String fieldName, String fieldType) {
            this.enclosingType = enclosingType;
            this.fieldName = fieldName;
            this.fieldType = fieldType;
        }

        public String toString() {
            return this.enclosingType + "." + this.fieldName + " (field of type '" + this.fieldType + "')";
        }
    }
}

