/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LocalGatewayRouteTableVpcAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LocalGatewayRouteTableVpcAssociation> {
    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_VPC_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayRouteTableVpcAssociationId").getter(LocalGatewayRouteTableVpcAssociation.getter(LocalGatewayRouteTableVpcAssociation::localGatewayRouteTableVpcAssociationId)).setter(LocalGatewayRouteTableVpcAssociation.setter(Builder::localGatewayRouteTableVpcAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableVpcAssociationId").unmarshallLocationName("localGatewayRouteTableVpcAssociationId").build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayRouteTableId").getter(LocalGatewayRouteTableVpcAssociation.getter(LocalGatewayRouteTableVpcAssociation::localGatewayRouteTableId)).setter(LocalGatewayRouteTableVpcAssociation.setter(Builder::localGatewayRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableId").unmarshallLocationName("localGatewayRouteTableId").build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayRouteTableArn").getter(LocalGatewayRouteTableVpcAssociation.getter(LocalGatewayRouteTableVpcAssociation::localGatewayRouteTableArn)).setter(LocalGatewayRouteTableVpcAssociation.setter(Builder::localGatewayRouteTableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableArn").unmarshallLocationName("localGatewayRouteTableArn").build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayId").getter(LocalGatewayRouteTableVpcAssociation.getter(LocalGatewayRouteTableVpcAssociation::localGatewayId)).setter(LocalGatewayRouteTableVpcAssociation.setter(Builder::localGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId").unmarshallLocationName("localGatewayId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(LocalGatewayRouteTableVpcAssociation.getter(LocalGatewayRouteTableVpcAssociation::vpcId)).setter(LocalGatewayRouteTableVpcAssociation.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(LocalGatewayRouteTableVpcAssociation.getter(LocalGatewayRouteTableVpcAssociation::ownerId)).setter(LocalGatewayRouteTableVpcAssociation.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(LocalGatewayRouteTableVpcAssociation.getter(LocalGatewayRouteTableVpcAssociation::state)).setter(LocalGatewayRouteTableVpcAssociation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(LocalGatewayRouteTableVpcAssociation.getter(LocalGatewayRouteTableVpcAssociation::tags)).setter(LocalGatewayRouteTableVpcAssociation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_GATEWAY_ROUTE_TABLE_VPC_ASSOCIATION_ID_FIELD, LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD, LOCAL_GATEWAY_ROUTE_TABLE_ARN_FIELD, LOCAL_GATEWAY_ID_FIELD, VPC_ID_FIELD, OWNER_ID_FIELD, STATE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String localGatewayRouteTableVpcAssociationId;
    private final String localGatewayRouteTableId;
    private final String localGatewayRouteTableArn;
    private final String localGatewayId;
    private final String vpcId;
    private final String ownerId;
    private final String state;
    private final List<Tag> tags;

    private LocalGatewayRouteTableVpcAssociation(BuilderImpl builder) {
        this.localGatewayRouteTableVpcAssociationId = builder.localGatewayRouteTableVpcAssociationId;
        this.localGatewayRouteTableId = builder.localGatewayRouteTableId;
        this.localGatewayRouteTableArn = builder.localGatewayRouteTableArn;
        this.localGatewayId = builder.localGatewayId;
        this.vpcId = builder.vpcId;
        this.ownerId = builder.ownerId;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    public final String localGatewayRouteTableVpcAssociationId() {
        return this.localGatewayRouteTableVpcAssociationId;
    }

    public final String localGatewayRouteTableId() {
        return this.localGatewayRouteTableId;
    }

    public final String localGatewayRouteTableArn() {
        return this.localGatewayRouteTableArn;
    }

    public final String localGatewayId() {
        return this.localGatewayId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String state() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayRouteTableVpcAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayRouteTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalGatewayRouteTableVpcAssociation)) {
            return false;
        }
        LocalGatewayRouteTableVpcAssociation other = (LocalGatewayRouteTableVpcAssociation)obj;
        return Objects.equals(this.localGatewayRouteTableVpcAssociationId(), other.localGatewayRouteTableVpcAssociationId()) && Objects.equals(this.localGatewayRouteTableId(), other.localGatewayRouteTableId()) && Objects.equals(this.localGatewayRouteTableArn(), other.localGatewayRouteTableArn()) && Objects.equals(this.localGatewayId(), other.localGatewayId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.state(), other.state()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"LocalGatewayRouteTableVpcAssociation").add("LocalGatewayRouteTableVpcAssociationId", (Object)this.localGatewayRouteTableVpcAssociationId()).add("LocalGatewayRouteTableId", (Object)this.localGatewayRouteTableId()).add("LocalGatewayRouteTableArn", (Object)this.localGatewayRouteTableArn()).add("LocalGatewayId", (Object)this.localGatewayId()).add("VpcId", (Object)this.vpcId()).add("OwnerId", (Object)this.ownerId()).add("State", (Object)this.state()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalGatewayRouteTableVpcAssociationId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayRouteTableVpcAssociationId()));
            }
            case "LocalGatewayRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayRouteTableId()));
            }
            case "LocalGatewayRouteTableArn": {
                return Optional.ofNullable(clazz.cast(this.localGatewayRouteTableArn()));
            }
            case "LocalGatewayId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocalGatewayRouteTableVpcAssociation, T> g) {
        return obj -> g.apply((LocalGatewayRouteTableVpcAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String localGatewayRouteTableVpcAssociationId;
        private String localGatewayRouteTableId;
        private String localGatewayRouteTableArn;
        private String localGatewayId;
        private String vpcId;
        private String ownerId;
        private String state;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LocalGatewayRouteTableVpcAssociation model) {
            this.localGatewayRouteTableVpcAssociationId(model.localGatewayRouteTableVpcAssociationId);
            this.localGatewayRouteTableId(model.localGatewayRouteTableId);
            this.localGatewayRouteTableArn(model.localGatewayRouteTableArn);
            this.localGatewayId(model.localGatewayId);
            this.vpcId(model.vpcId);
            this.ownerId(model.ownerId);
            this.state(model.state);
            this.tags(model.tags);
        }

        public final String getLocalGatewayRouteTableVpcAssociationId() {
            return this.localGatewayRouteTableVpcAssociationId;
        }

        public final void setLocalGatewayRouteTableVpcAssociationId(String localGatewayRouteTableVpcAssociationId) {
            this.localGatewayRouteTableVpcAssociationId = localGatewayRouteTableVpcAssociationId;
        }

        @Override
        public final Builder localGatewayRouteTableVpcAssociationId(String localGatewayRouteTableVpcAssociationId) {
            this.localGatewayRouteTableVpcAssociationId = localGatewayRouteTableVpcAssociationId;
            return this;
        }

        public final String getLocalGatewayRouteTableId() {
            return this.localGatewayRouteTableId;
        }

        public final void setLocalGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
        }

        @Override
        public final Builder localGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
            return this;
        }

        public final String getLocalGatewayRouteTableArn() {
            return this.localGatewayRouteTableArn;
        }

        public final void setLocalGatewayRouteTableArn(String localGatewayRouteTableArn) {
            this.localGatewayRouteTableArn = localGatewayRouteTableArn;
        }

        @Override
        public final Builder localGatewayRouteTableArn(String localGatewayRouteTableArn) {
            this.localGatewayRouteTableArn = localGatewayRouteTableArn;
            return this;
        }

        public final String getLocalGatewayId() {
            return this.localGatewayId;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        @Override
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LocalGatewayRouteTableVpcAssociation build() {
            return new LocalGatewayRouteTableVpcAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LocalGatewayRouteTableVpcAssociation> {
        public Builder localGatewayRouteTableVpcAssociationId(String var1);

        public Builder localGatewayRouteTableId(String var1);

        public Builder localGatewayRouteTableArn(String var1);

        public Builder localGatewayId(String var1);

        public Builder vpcId(String var1);

        public Builder ownerId(String var1);

        public Builder state(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

