/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller;

import com.neeve.controller.Command;
import com.neeve.controller.Controller;
import com.neeve.controller.Launch;
import com.neeve.controller.ProgressMonitorHelper;
import com.neeve.controller.Script;
import com.neeve.controller.System;
import com.neeve.controller.XVM;
import com.neeve.util.UtlThrowable;
import java.util.ListIterator;

final class Shutdown
extends Command {
    private XVM _xvm;

    Shutdown(Controller controller, ProgressMonitorHelper progressMonitorHelper, System system, Script script, int lineNum, String line) {
        super(controller, progressMonitorHelper, system, script, lineNum, line);
    }

    private final void syntaxError(int lineNum) {
        this.error("Line " + lineNum + ": Syntax error: shutdown");
    }

    @Override
    final String name() {
        return "shutdown";
    }

    @Override
    final boolean parse(Command.Args tokenizer) {
        if (tokenizer.hasMoreTokens()) {
            if (!tokenizer.nextToken().equalsIgnoreCase("the")) {
                this.syntaxError(this.lineNum());
            }
            if (!tokenizer.hasMoreTokens()) {
                this.syntaxError(this.lineNum());
            }
            String token = tokenizer.nextToken();
            this._xvm = this.system().getXVM(token);
            if (this._xvm == null) {
                this.error("Line " + this.lineNum() + ": XVM '" + token + "' is not configured in the '" + this.system().getHome().getName() + "' system");
            }
            if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("xvm")) {
                this.syntaxError(this.lineNum());
            }
        }
        return true;
    }

    @Override
    final void execute() {
        if (!this.mock()) {
            if (this._xvm != null) {
                this.info("......stopping XVM '" + this._xvm.name() + "'...");
                try {
                    this.remoteCommand(this._xvm.name(), null, "kill", false, 0);
                    for (int i = 0; i < 5; ++i) {
                        try {
                            this.remoteCommand(this._xvm.name(), null, null, false, 0);
                        }
                        catch (Exception e) {
                            this.info("......XVM stopped successfully [" + e.getMessage() + "].");
                            return;
                        }
                        this.info("......waiting for XVM to stop...");
                        this.sleep(1000L);
                    }
                    this.warning("......WARNING: Failed to stop the '" + this._xvm.name() + "' XVM [?]");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.warning("......WARNING: Failed to stop the '" + this._xvm.name() + "' XVM [" + e.toString() + "] ... see troubleshooting log.");
                    this.troubleshootingInfo(UtlThrowable.prepareStackTrace((Throwable)e));
                }
            } else {
                ListIterator<Command> iterator = this.script().commands().listIterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
                while (iterator.hasPrevious()) {
                    Command command = iterator.previous();
                    if (!(command instanceof Launch)) continue;
                    command.cleanup();
                }
            }
        }
    }

    @Override
    final void cleanup() {
    }
}

