/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.compiler;

import com.akiban.sql.compiler.TypeCompiler;
import com.akiban.sql.types.DataTypeDescriptor;
import com.akiban.sql.types.TypeId;

public class LOBTypeCompiler
extends TypeCompiler {
    protected LOBTypeCompiler(TypeId typeId) {
        super(typeId);
    }

    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        return otherType.isBlobTypeId();
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return this.convertible(otherType, false);
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 19: {
                return "java.sql.Blob";
            }
        }
        assert (false) : "unexpected formatId in getCorrespondingPrimitiveTypeName() - " + formatId;
        return null;
    }

    @Override
    public String getPrimitiveMethodName() {
        return "getBlob";
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return dts.getMaximumWidth();
    }
}

