/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.memory;

import com.neeve.config.Config;
import com.neeve.stats.StatsLogger;
import com.neeve.util.UtlLinkedHashMap;
import com.neeve.util.UtlThread;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.text.NumberFormat;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class MemoryStats
implements StatsLogger.Callback {
    private static final boolean recordStats = Config.getValue((String)"nv.stats.memory.enable", (boolean)Config.getValue((String)"nv.memory.stats.enable", (boolean)true));
    private static final boolean recordEntityTypeStats = Config.getValue((String)"nv.stats.memory.type.enable", (boolean)Config.getValue((String)"nv.memory.stats.type.enable", (boolean)false));
    private final MemoryMXBean memoryBean;
    private final NumberFormat format;
    private final StatsLogger logger;
    private final NativeMemoryStats nativeMemoryStats = new NativeMemoryStats();
    private final IOBufferStats ioBufferStats = new IOBufferStats();
    private final EntityTypeStats embeddedEntityStats = new EntityTypeStats();
    private final UtlLinkedHashMap<Class<?>, EntityTypeStats> embeddedEntityTypeStats = new UtlLinkedHashMap();
    private final EntityTypeStats entityStats = new EntityTypeStats();
    private final UtlLinkedHashMap<Class<?>, EntityTypeStats> entityTypeStats = new UtlLinkedHashMap();
    private final EntityTypeStats messageStats = new EntityTypeStats();
    private final UtlLinkedHashMap<Class<?>, EntityTypeStats> messageTypeStats = new UtlLinkedHashMap();
    private final EntityTypeStats collectionStats = new EntityTypeStats();
    private final UtlLinkedHashMap<Class<?>, EntityTypeStats> collectionTypeStats = new UtlLinkedHashMap();
    private long startTime;
    private long deltaStartTime;
    private static final MemoryStats instance = new MemoryStats();

    private MemoryStats() {
        String name = "nv.memory.stats";
        this.memoryBean = ManagementFactory.getMemoryMXBean();
        this.format = NumberFormat.getInstance();
        this.format.setMaximumFractionDigits(2);
        this.logger = new StatsLogger("nv.memory.stats", "nv.memory.stats", (StatsLogger.Callback)this);
        int interval = Config.getValue((String)"nv.memory.stats.interval", (int)0);
        if (interval > 0) {
            this.logger.startPeriodicOutput(interval);
        }
    }

    public static final MemoryStats getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stampCurrent() {
        UtlLinkedHashMap.FastIterator iterator;
        UtlLinkedHashMap<Class<?>, EntityTypeStats> utlLinkedHashMap;
        this.deltaStartTime = System.currentTimeMillis();
        this.nativeMemoryStats.stampCurrent();
        this.ioBufferStats.stampCurrent();
        this.embeddedEntityStats.stampCurrent();
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.embeddedEntityTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.embeddedEntityTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    ((EntityTypeStats)iterator.nextEntry().getValue()).stampCurrent();
                }
            }
        }
        this.entityStats.stampCurrent();
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.entityTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.entityTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    ((EntityTypeStats)iterator.nextEntry().getValue()).stampCurrent();
                }
            }
        }
        this.messageStats.stampCurrent();
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.messageTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.messageTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    ((EntityTypeStats)iterator.nextEntry().getValue()).stampCurrent();
                }
            }
        }
        this.collectionStats.stampCurrent();
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.collectionTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.collectionTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    ((EntityTypeStats)iterator.nextEntry().getValue()).stampCurrent();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void currentToLast() {
        UtlLinkedHashMap.FastIterator iterator;
        UtlLinkedHashMap<Class<?>, EntityTypeStats> utlLinkedHashMap;
        this.deltaStartTime = System.currentTimeMillis();
        this.nativeMemoryStats.currentToLast();
        this.ioBufferStats.currentToLast();
        this.embeddedEntityStats.currentToLast();
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.embeddedEntityTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.embeddedEntityTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    ((EntityTypeStats)iterator.nextEntry().getValue()).currentToLast();
                }
            }
        }
        this.entityStats.currentToLast();
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.entityTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.entityTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    ((EntityTypeStats)iterator.nextEntry().getValue()).currentToLast();
                }
            }
        }
        this.messageStats.currentToLast();
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.messageTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.messageTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    ((EntityTypeStats)iterator.nextEntry().getValue()).currentToLast();
                }
            }
        }
        this.collectionStats.currentToLast();
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.collectionTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.collectionTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    ((EntityTypeStats)iterator.nextEntry().getValue()).currentToLast();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EntityTypeStats getEmbeddedEntityTypeStats(Class<?> entity) {
        UtlLinkedHashMap<Class<?>, EntityTypeStats> utlLinkedHashMap = this.embeddedEntityTypeStats;
        synchronized (utlLinkedHashMap) {
            EntityTypeStats stats = (EntityTypeStats)this.embeddedEntityTypeStats.get(entity);
            if (stats == null) {
                stats = new EntityTypeStats();
                this.embeddedEntityTypeStats.put(entity, (Object)stats);
            }
            return stats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EntityTypeStats getEntityTypeStats(Class<?> entity) {
        UtlLinkedHashMap<Class<?>, EntityTypeStats> utlLinkedHashMap = this.entityTypeStats;
        synchronized (utlLinkedHashMap) {
            EntityTypeStats stats = (EntityTypeStats)this.entityTypeStats.get(entity);
            if (stats == null) {
                stats = new EntityTypeStats();
                this.entityTypeStats.put(entity, (Object)stats);
            }
            return stats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EntityTypeStats getMessageTypeStats(Class<?> message) {
        UtlLinkedHashMap<Class<?>, EntityTypeStats> utlLinkedHashMap = this.messageTypeStats;
        synchronized (utlLinkedHashMap) {
            EntityTypeStats stats = (EntityTypeStats)this.messageTypeStats.get(message);
            if (stats == null) {
                stats = new EntityTypeStats();
                this.messageTypeStats.put(message, (Object)stats);
            }
            return stats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EntityTypeStats getCollectionTypeStats(Class<?> collection) {
        UtlLinkedHashMap<Class<?>, EntityTypeStats> utlLinkedHashMap = this.collectionTypeStats;
        synchronized (utlLinkedHashMap) {
            EntityTypeStats stats = (EntityTypeStats)this.collectionTypeStats.get(collection);
            if (stats == null) {
                stats = new EntityTypeStats();
                this.collectionTypeStats.put(collection, (Object)stats);
            }
            return stats;
        }
    }

    public final void init() {
        UtlThread.setDefaultCPUAffinityMask();
        this.startTime = System.currentTimeMillis();
        this.stampCurrent();
        this.currentToLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void get(StringBuilder sb) {
        Map.Entry entry;
        UtlLinkedHashMap.FastIterator iterator;
        UtlLinkedHashMap<Class<?>, EntityTypeStats> utlLinkedHashMap;
        long currentTime = System.currentTimeMillis();
        long deltaTime = currentTime - this.deltaStartTime;
        long deltaTotalTime = currentTime - this.startTime;
        this.stampCurrent();
        String nativeMemoryUsedLiveStr = this.format.format(this.nativeMemoryStats.allocBytesCurrent - this.nativeMemoryStats.freeBytesCurrent + this.nativeMemoryStats.reallocBytesCurrent + (this.ioBufferStats.bufferAllocBytesCurrent + this.ioBufferStats.bufferPoolAllocBytesCurrent - this.ioBufferStats.bufferPoolDisposeBytesCurrent - this.ioBufferStats.bufferGCDisposeBytesCurrent));
        String nativeMemoryUsedPooledStr = this.format.format(this.ioBufferStats.bufferPoolDisposeBytesCurrent - this.ioBufferStats.bufferPoolAllocBytesCurrent - this.ioBufferStats.bufferPoolLeakBytesCurrent);
        String iobufCountUsedLiveStr = this.format.format(this.ioBufferStats.bufferAllocCountCurrent + this.ioBufferStats.bufferPoolAllocCountCurrent - this.ioBufferStats.bufferPoolDisposeCountCurrent - this.ioBufferStats.bufferGCDisposeCountCurrent);
        String iobufCountUsedPooledStr = this.format.format(this.ioBufferStats.bufferPoolDisposeCountCurrent - this.ioBufferStats.bufferPoolAllocCountCurrent - this.ioBufferStats.bufferPoolLeakCountCurrent);
        String iobufBytesUsedLiveStr = this.format.format(this.ioBufferStats.bufferAllocBytesCurrent + this.ioBufferStats.bufferPoolAllocBytesCurrent - this.ioBufferStats.bufferPoolDisposeBytesCurrent - this.ioBufferStats.bufferGCDisposeBytesCurrent);
        String iobufBytesUsedPooledStr = this.format.format(this.ioBufferStats.bufferPoolDisposeBytesCurrent - this.ioBufferStats.bufferPoolAllocBytesCurrent - this.ioBufferStats.bufferPoolLeakBytesCurrent);
        MemoryUsage heapUsage = this.memoryBean.getHeapMemoryUsage();
        sb.append("Heap {");
        sb.append(this.format.format(heapUsage.getInit())).append(", ").append(this.format.format(heapUsage.getUsed())).append(", ").append(this.format.format(heapUsage.getCommitted())).append(", ").append(this.format.format(heapUsage.getMax()));
        sb.append("}").append("\n");
        sb.append("OffHeap {");
        sb.append(nativeMemoryUsedLiveStr).append(", ").append(nativeMemoryUsedPooledStr).append("[").append(this.format.format(this.nativeMemoryStats.allocBytesCurrent)).append(", ").append(this.format.format(this.nativeMemoryStats.freeBytesCurrent)).append(", ").append(this.format.format(this.nativeMemoryStats.reallocBytesCurrent)).append(", ").append(this.format.format(this.ioBufferStats.bufferAllocBytesCurrent)).append(", ").append(this.format.format(this.ioBufferStats.bufferPoolAllocBytesCurrent)).append(", ").append(this.format.format(this.ioBufferStats.bufferPoolDisposeBytesCurrent)).append(", ").append(this.format.format(this.ioBufferStats.bufferGCDisposeBytesCurrent)).append("]");
        sb.append("}").append("\n");
        sb.append("IOBuf {");
        sb.append(iobufCountUsedLiveStr).append(", ").append(iobufCountUsedPooledStr).append("[").append(iobufBytesUsedLiveStr).append(", ").append(iobufBytesUsedPooledStr).append("]");
        sb.append("}").append("\n");
        this.messageStats.get("Message Entities", sb, deltaTime, deltaTotalTime);
        sb.append("\n");
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.messageTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.messageTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    entry = iterator.nextEntry();
                    sb.append("...");
                    ((EntityTypeStats)entry.getValue()).get(((Class)entry.getKey()).getName(), sb, deltaTime, deltaTotalTime);
                    sb.append("\n");
                }
            }
        }
        this.embeddedEntityStats.get("Embedded Entities", sb, deltaTime, deltaTotalTime);
        sb.append("\n");
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.embeddedEntityTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.embeddedEntityTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    entry = iterator.nextEntry();
                    sb.append("...");
                    ((EntityTypeStats)entry.getValue()).get(((Class)entry.getKey()).getName(), sb, deltaTime, deltaTotalTime);
                    sb.append("\n");
                }
            }
        }
        this.entityStats.get("State Entities", sb, deltaTime, deltaTotalTime);
        sb.append("\n");
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.entityTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.entityTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    entry = iterator.nextEntry();
                    sb.append("...");
                    ((EntityTypeStats)entry.getValue()).get(((Class)entry.getKey()).getName(), sb, deltaTime, deltaTotalTime);
                    sb.append("\n");
                }
            }
        }
        this.collectionStats.get("State Collections", sb, deltaTime, deltaTotalTime);
        sb.append("\n");
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.collectionTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.collectionTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    entry = iterator.nextEntry();
                    sb.append("...");
                    ((EntityTypeStats)entry.getValue()).get(((Class)entry.getKey()).getName(), sb, deltaTime, deltaTotalTime);
                    sb.append("\n");
                }
            }
        }
        this.currentToLast();
    }

    public final void before() {
    }

    public final void after() {
    }

    public final void onNativeMemoryAllocated(long bytes) {
        if (!recordStats) {
            return;
        }
        this.nativeMemoryStats.allocCount.incrementAndGet();
        this.nativeMemoryStats.allocBytes.addAndGet(bytes);
    }

    public final void onNativeMemoryReallocated(long bytes) {
        if (!recordStats) {
            return;
        }
        this.nativeMemoryStats.reallocCount.incrementAndGet();
        this.nativeMemoryStats.reallocBytes.addAndGet(bytes);
    }

    public final void onNativeMemoryFreed(long bytes) {
        if (!recordStats) {
            return;
        }
        this.nativeMemoryStats.freeCount.incrementAndGet();
        this.nativeMemoryStats.freeBytes.addAndGet(bytes);
    }

    public final void onIOBufferAllocated(boolean fromPool, int bytes) {
        if (!recordStats) {
            return;
        }
        if (fromPool) {
            this.ioBufferStats.bufferPoolAllocCount.incrementAndGet();
            this.ioBufferStats.bufferPoolAllocBytes.addAndGet(bytes);
        } else {
            this.ioBufferStats.bufferAllocCount.incrementAndGet();
            this.ioBufferStats.bufferAllocBytes.addAndGet(bytes);
        }
    }

    public final void onIOBufferReallocated(int bytes) {
        if (!recordStats) {
            return;
        }
        this.ioBufferStats.bufferReallocCount.incrementAndGet();
        this.ioBufferStats.bufferReallocBytes.addAndGet(bytes);
    }

    public final void onIOBufferForked(int bytes) {
        if (!recordStats) {
            return;
        }
        this.ioBufferStats.bufferForkCount.incrementAndGet();
        this.ioBufferStats.bufferForkBytes.addAndGet(bytes);
    }

    public final void onIOBufferDisposed(boolean toPool, int bytes) {
        if (!recordStats) {
            return;
        }
        if (toPool) {
            this.ioBufferStats.bufferPoolDisposeCount.incrementAndGet();
            this.ioBufferStats.bufferPoolDisposeBytes.addAndGet(bytes);
        } else {
            this.ioBufferStats.bufferGCDisposeCount.incrementAndGet();
            this.ioBufferStats.bufferGCDisposeBytes.addAndGet(bytes);
        }
    }

    public final void onIOBufferLeaked(int bytes) {
        if (!recordStats) {
            return;
        }
        this.ioBufferStats.bufferPoolLeakCount.incrementAndGet();
        this.ioBufferStats.bufferPoolLeakBytes.addAndGet(bytes);
    }

    public final void onEntityAllocated(Class<?> entity, EntityType entityType, boolean fromPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (fromPool) {
                        this.embeddedEntityStats.poolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEmbeddedEntityTypeStats(entity).poolAllocCount.incrementAndGet();
                        break;
                    }
                    this.embeddedEntityStats.createAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).createAllocCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    if (fromPool) {
                        this.entityStats.poolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEntityTypeStats(entity).poolAllocCount.incrementAndGet();
                        break;
                    }
                    this.entityStats.createAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).createAllocCount.incrementAndGet();
                    break;
                }
                case Message: {
                    if (fromPool) {
                        this.messageStats.poolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getMessageTypeStats(entity).poolAllocCount.incrementAndGet();
                        break;
                    }
                    this.messageStats.createAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).createAllocCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    if (fromPool) {
                        this.collectionStats.poolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getCollectionTypeStats(entity).poolAllocCount.incrementAndGet();
                        break;
                    }
                    this.collectionStats.createAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).createAllocCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntityDisposed(Class<?> entity, EntityType entityType, boolean toPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (toPool) {
                        this.embeddedEntityStats.poolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEmbeddedEntityTypeStats(entity).poolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.embeddedEntityStats.gcDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).gcDisposeCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    if (toPool) {
                        this.entityStats.poolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEntityTypeStats(entity).poolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.entityStats.gcDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).gcDisposeCount.incrementAndGet();
                    break;
                }
                case Message: {
                    if (toPool) {
                        this.messageStats.poolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getMessageTypeStats(entity).poolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.messageStats.gcDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).gcDisposeCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    if (toPool) {
                        this.collectionStats.poolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getCollectionTypeStats(entity).poolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.collectionStats.gcDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).gcDisposeCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntityLeaked(Class<?> entity, EntityType entityType) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    this.embeddedEntityStats.poolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).poolLeakCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    this.entityStats.poolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).poolLeakCount.incrementAndGet();
                    break;
                }
                case Message: {
                    this.messageStats.poolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).poolLeakCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    this.collectionStats.poolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).poolLeakCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntityPojoAllocated(Class<?> entity, EntityType entityType, boolean fromPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (fromPool) {
                        this.embeddedEntityStats.pojoPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEmbeddedEntityTypeStats(entity).pojoPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.embeddedEntityStats.pojoCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).pojoCreateAllocCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    if (fromPool) {
                        this.entityStats.pojoPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEntityTypeStats(entity).pojoPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.entityStats.pojoCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).pojoCreateAllocCount.incrementAndGet();
                    break;
                }
                case Message: {
                    if (fromPool) {
                        this.messageStats.pojoPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getMessageTypeStats(entity).pojoPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.messageStats.pojoCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).pojoCreateAllocCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    if (fromPool) {
                        this.collectionStats.pojoPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getCollectionTypeStats(entity).pojoPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.collectionStats.pojoCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).pojoCreateAllocCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntityPojoDisposed(Class<?> entity, EntityType entityType, boolean toPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (toPool) {
                        this.embeddedEntityStats.pojoPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEmbeddedEntityTypeStats(entity).pojoPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.embeddedEntityStats.pojoGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).pojoGCDisposeCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    if (toPool) {
                        this.entityStats.pojoPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEntityTypeStats(entity).pojoPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.entityStats.pojoGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).pojoGCDisposeCount.incrementAndGet();
                    break;
                }
                case Message: {
                    if (toPool) {
                        this.messageStats.pojoPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getMessageTypeStats(entity).pojoPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.messageStats.pojoGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).pojoGCDisposeCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    if (toPool) {
                        this.collectionStats.pojoPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getCollectionTypeStats(entity).pojoPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.collectionStats.pojoGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).pojoGCDisposeCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntityPojoLeaked(Class<?> entity, EntityType entityType) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    this.embeddedEntityStats.pojoPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).pojoPoolLeakCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    this.entityStats.pojoPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).pojoPoolLeakCount.incrementAndGet();
                    break;
                }
                case Message: {
                    this.messageStats.pojoPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).pojoPoolLeakCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    this.collectionStats.pojoPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).pojoPoolLeakCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntitySerializerAllocated(Class<?> entity, EntityType entityType, boolean fromPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (fromPool) {
                        this.embeddedEntityStats.serializerPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEmbeddedEntityTypeStats(entity).serializerPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.embeddedEntityStats.serializerCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).serializerCreateAllocCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    if (fromPool) {
                        this.entityStats.serializerPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEntityTypeStats(entity).serializerPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.entityStats.serializerCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).serializerCreateAllocCount.incrementAndGet();
                    break;
                }
                case Message: {
                    if (fromPool) {
                        this.messageStats.serializerPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getMessageTypeStats(entity).serializerPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.messageStats.serializerCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).serializerCreateAllocCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    if (fromPool) {
                        this.collectionStats.serializerPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getCollectionTypeStats(entity).serializerPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.collectionStats.serializerCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).serializerCreateAllocCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntitySerializerDisposed(Class<?> entity, EntityType entityType, boolean toPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (toPool) {
                        this.embeddedEntityStats.serializerPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEmbeddedEntityTypeStats(entity).serializerPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.embeddedEntityStats.serializerGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).serializerGCDisposeCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    if (toPool) {
                        this.entityStats.serializerPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEntityTypeStats(entity).serializerPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.entityStats.serializerGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).serializerGCDisposeCount.incrementAndGet();
                    break;
                }
                case Message: {
                    if (toPool) {
                        this.messageStats.serializerPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getMessageTypeStats(entity).serializerPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.messageStats.serializerGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).serializerGCDisposeCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    if (toPool) {
                        this.collectionStats.serializerPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getCollectionTypeStats(entity).serializerPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.collectionStats.serializerGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).serializerGCDisposeCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntitySerializerLeaked(Class<?> entity, EntityType entityType) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    this.embeddedEntityStats.serializerPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).serializerPoolLeakCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    this.entityStats.serializerPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).serializerPoolLeakCount.incrementAndGet();
                    break;
                }
                case Message: {
                    this.messageStats.serializerPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).serializerPoolLeakCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    this.collectionStats.serializerPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).serializerPoolLeakCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntityDeserializerAllocated(Class<?> entity, EntityType entityType, boolean fromPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (fromPool) {
                        this.embeddedEntityStats.deserializerPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEmbeddedEntityTypeStats(entity).deserializerPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.embeddedEntityStats.deserializerCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).deserializerCreateAllocCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    if (fromPool) {
                        this.entityStats.deserializerPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEntityTypeStats(entity).deserializerPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.entityStats.deserializerCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).deserializerCreateAllocCount.incrementAndGet();
                    break;
                }
                case Message: {
                    if (fromPool) {
                        this.messageStats.deserializerPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getMessageTypeStats(entity).deserializerPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.messageStats.deserializerCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).deserializerCreateAllocCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    if (fromPool) {
                        this.collectionStats.deserializerPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getCollectionTypeStats(entity).deserializerPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.collectionStats.deserializerCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).deserializerCreateAllocCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntityDeserializerDisposed(Class<?> entity, EntityType entityType, boolean toPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (toPool) {
                        this.embeddedEntityStats.deserializerPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEmbeddedEntityTypeStats(entity).deserializerPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.embeddedEntityStats.deserializerGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).deserializerGCDisposeCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    if (toPool) {
                        this.entityStats.deserializerPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEntityTypeStats(entity).deserializerPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.entityStats.deserializerGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).deserializerGCDisposeCount.incrementAndGet();
                    break;
                }
                case Message: {
                    if (toPool) {
                        this.messageStats.deserializerPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getMessageTypeStats(entity).deserializerPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.messageStats.deserializerGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).deserializerGCDisposeCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    if (toPool) {
                        this.collectionStats.deserializerPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getCollectionTypeStats(entity).deserializerPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.collectionStats.deserializerGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).deserializerGCDisposeCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntityDeserializerLeaked(Class<?> entity, EntityType entityType) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    this.embeddedEntityStats.deserializerPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).deserializerPoolLeakCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    this.entityStats.deserializerPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).deserializerPoolLeakCount.incrementAndGet();
                    break;
                }
                case Message: {
                    this.messageStats.deserializerPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).deserializerPoolLeakCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    this.collectionStats.deserializerPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).deserializerPoolLeakCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntityMetadataAllocated(Class<?> entity, EntityType entityType, int bytes) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    this.embeddedEntityStats.metadataAllocCount.incrementAndGet();
                    this.embeddedEntityStats.metadataAllocBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getEmbeddedEntityTypeStats(entity);
                    typeStats.metadataAllocCount.incrementAndGet();
                    typeStats.metadataAllocBytes.addAndGet(bytes);
                    break;
                }
                case Entity: {
                    this.entityStats.metadataAllocCount.incrementAndGet();
                    this.entityStats.metadataAllocBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getEntityTypeStats(entity);
                    typeStats.metadataAllocCount.incrementAndGet();
                    typeStats.metadataAllocBytes.addAndGet(bytes);
                    break;
                }
                case Message: {
                    this.messageStats.metadataAllocCount.incrementAndGet();
                    this.messageStats.metadataAllocBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getMessageTypeStats(entity);
                    typeStats.metadataAllocCount.incrementAndGet();
                    typeStats.metadataAllocBytes.addAndGet(bytes);
                    break;
                }
                case Collection: {
                    this.collectionStats.metadataAllocCount.incrementAndGet();
                    this.collectionStats.metadataAllocBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getCollectionTypeStats(entity);
                    typeStats.metadataAllocCount.incrementAndGet();
                    typeStats.metadataAllocBytes.addAndGet(bytes);
                    break;
                }
            }
        }
    }

    public final void onEntityMetadataDisposed(Class<?> entity, EntityType entityType, int bytes, boolean toPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (toPool) {
                        this.embeddedEntityStats.metadataPoolDisposeCount.incrementAndGet();
                        this.embeddedEntityStats.metadataPoolDisposeBytes.addAndGet(bytes);
                        if (!recordEntityTypeStats) break;
                        EntityTypeStats typeStats = this.getEmbeddedEntityTypeStats(entity);
                        typeStats.metadataPoolDisposeCount.incrementAndGet();
                        typeStats.metadataPoolDisposeBytes.addAndGet(bytes);
                        break;
                    }
                    this.embeddedEntityStats.metadataGCDisposeCount.incrementAndGet();
                    this.embeddedEntityStats.metadataGCDisposeBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getEmbeddedEntityTypeStats(entity);
                    typeStats.metadataGCDisposeCount.incrementAndGet();
                    typeStats.metadataGCDisposeBytes.addAndGet(bytes);
                    break;
                }
                case Entity: {
                    if (toPool) {
                        this.entityStats.metadataPoolDisposeCount.incrementAndGet();
                        this.entityStats.metadataPoolDisposeBytes.addAndGet(bytes);
                        if (!recordEntityTypeStats) break;
                        EntityTypeStats typeStats = this.getEntityTypeStats(entity);
                        typeStats.metadataPoolDisposeCount.incrementAndGet();
                        typeStats.metadataPoolDisposeBytes.addAndGet(bytes);
                        break;
                    }
                    this.entityStats.metadataGCDisposeCount.incrementAndGet();
                    this.entityStats.metadataGCDisposeBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getEntityTypeStats(entity);
                    typeStats.metadataGCDisposeCount.incrementAndGet();
                    typeStats.metadataGCDisposeBytes.addAndGet(bytes);
                    break;
                }
                case Message: {
                    if (toPool) {
                        this.messageStats.metadataPoolDisposeCount.incrementAndGet();
                        this.messageStats.metadataPoolDisposeBytes.addAndGet(bytes);
                        if (!recordEntityTypeStats) break;
                        EntityTypeStats typeStats = this.getMessageTypeStats(entity);
                        typeStats.metadataPoolDisposeCount.incrementAndGet();
                        typeStats.metadataPoolDisposeBytes.addAndGet(bytes);
                        break;
                    }
                    this.messageStats.metadataGCDisposeCount.incrementAndGet();
                    this.messageStats.metadataGCDisposeBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getMessageTypeStats(entity);
                    typeStats.metadataGCDisposeCount.incrementAndGet();
                    typeStats.metadataGCDisposeBytes.addAndGet(bytes);
                    break;
                }
                case Collection: {
                    if (toPool) {
                        this.collectionStats.metadataPoolDisposeCount.incrementAndGet();
                        this.collectionStats.metadataPoolDisposeBytes.addAndGet(bytes);
                        if (!recordEntityTypeStats) break;
                        EntityTypeStats typeStats = this.getCollectionTypeStats(entity);
                        typeStats.metadataPoolDisposeCount.incrementAndGet();
                        typeStats.metadataPoolDisposeBytes.addAndGet(bytes);
                        break;
                    }
                    this.collectionStats.metadataGCDisposeCount.incrementAndGet();
                    this.collectionStats.metadataGCDisposeBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getCollectionTypeStats(entity);
                    typeStats.metadataGCDisposeCount.incrementAndGet();
                    typeStats.metadataGCDisposeBytes.addAndGet(bytes);
                    break;
                }
            }
        }
    }

    public final void onEntityDataAllocated(Class<?> entity, EntityType entityType, int bytes) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    this.embeddedEntityStats.dataAllocCount.incrementAndGet();
                    this.embeddedEntityStats.dataAllocBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getEmbeddedEntityTypeStats(entity);
                    typeStats.dataAllocCount.incrementAndGet();
                    typeStats.dataAllocBytes.addAndGet(bytes);
                    break;
                }
                case Entity: {
                    this.entityStats.dataAllocCount.incrementAndGet();
                    this.entityStats.dataAllocBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getEntityTypeStats(entity);
                    typeStats.dataAllocCount.incrementAndGet();
                    typeStats.dataAllocBytes.addAndGet(bytes);
                    break;
                }
                case Message: {
                    this.messageStats.dataAllocCount.incrementAndGet();
                    this.messageStats.dataAllocBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getMessageTypeStats(entity);
                    typeStats.dataAllocCount.incrementAndGet();
                    typeStats.dataAllocBytes.addAndGet(bytes);
                    break;
                }
                case Collection: {
                    this.collectionStats.dataAllocCount.incrementAndGet();
                    this.collectionStats.dataAllocBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getCollectionTypeStats(entity);
                    typeStats.dataAllocCount.incrementAndGet();
                    typeStats.dataAllocBytes.addAndGet(bytes);
                    break;
                }
            }
        }
    }

    public final void onEntityDataDisposed(Class<?> entity, EntityType entityType, int bytes, boolean toPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (toPool) {
                        this.embeddedEntityStats.dataPoolDisposeCount.incrementAndGet();
                        this.embeddedEntityStats.dataPoolDisposeBytes.addAndGet(bytes);
                        if (!recordEntityTypeStats) break;
                        EntityTypeStats typeStats = this.getEmbeddedEntityTypeStats(entity);
                        typeStats.dataPoolDisposeCount.incrementAndGet();
                        typeStats.dataPoolDisposeBytes.addAndGet(bytes);
                        break;
                    }
                    this.embeddedEntityStats.dataGCDisposeCount.incrementAndGet();
                    this.embeddedEntityStats.dataGCDisposeBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getEmbeddedEntityTypeStats(entity);
                    typeStats.dataGCDisposeCount.incrementAndGet();
                    typeStats.dataGCDisposeBytes.addAndGet(bytes);
                    break;
                }
                case Entity: {
                    if (toPool) {
                        this.entityStats.dataPoolDisposeCount.incrementAndGet();
                        this.entityStats.dataPoolDisposeBytes.addAndGet(bytes);
                        if (!recordEntityTypeStats) break;
                        EntityTypeStats typeStats = this.getEntityTypeStats(entity);
                        typeStats.dataPoolDisposeCount.incrementAndGet();
                        typeStats.dataPoolDisposeBytes.addAndGet(bytes);
                        break;
                    }
                    this.entityStats.dataGCDisposeCount.incrementAndGet();
                    this.entityStats.dataGCDisposeBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getEntityTypeStats(entity);
                    typeStats.dataGCDisposeCount.incrementAndGet();
                    typeStats.dataGCDisposeBytes.addAndGet(bytes);
                    break;
                }
                case Message: {
                    if (toPool) {
                        this.messageStats.dataPoolDisposeCount.incrementAndGet();
                        this.messageStats.dataPoolDisposeBytes.addAndGet(bytes);
                        if (!recordEntityTypeStats) break;
                        EntityTypeStats typeStats = this.getMessageTypeStats(entity);
                        typeStats.dataPoolDisposeCount.incrementAndGet();
                        typeStats.dataPoolDisposeBytes.addAndGet(bytes);
                        break;
                    }
                    this.messageStats.dataGCDisposeCount.incrementAndGet();
                    this.messageStats.dataGCDisposeBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getMessageTypeStats(entity);
                    typeStats.dataGCDisposeCount.incrementAndGet();
                    typeStats.dataGCDisposeBytes.addAndGet(bytes);
                    break;
                }
                case Collection: {
                    if (toPool) {
                        this.collectionStats.dataPoolDisposeCount.incrementAndGet();
                        this.collectionStats.dataPoolDisposeBytes.addAndGet(bytes);
                        if (!recordEntityTypeStats) break;
                        EntityTypeStats typeStats = this.getCollectionTypeStats(entity);
                        typeStats.dataPoolDisposeCount.incrementAndGet();
                        typeStats.dataPoolDisposeBytes.addAndGet(bytes);
                        break;
                    }
                    this.collectionStats.dataGCDisposeCount.incrementAndGet();
                    this.collectionStats.dataGCDisposeBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getCollectionTypeStats(entity);
                    typeStats.dataGCDisposeCount.incrementAndGet();
                    typeStats.dataGCDisposeBytes.addAndGet(bytes);
                    break;
                }
            }
        }
    }

    public final MemoryUsage getHeapMemoryUsage() {
        return this.memoryBean.getHeapMemoryUsage();
    }

    public final long getOffHeapMemoryUsedLive() {
        return this.nativeMemoryStats.getBytesUsedLive() + this.ioBufferStats.getBufferBytesUsedLive();
    }

    public final long getOffHeapMemoryUsedPooled() {
        return this.ioBufferStats.getBufferBytesUsedPooled();
    }

    public final NativeMemoryStats getNativeStatsCounters() {
        return this.nativeMemoryStats;
    }

    public final IOBufferStats getIOBufferStatsCounters() {
        return this.ioBufferStats;
    }

    public final EntityTypeStats getEmbeddedEntityStatsCounters() {
        return this.embeddedEntityStats;
    }

    public final Map<Class<?>, EntityTypeStats> getEmbeddedEntityTypeStatsCounters() {
        return this.embeddedEntityTypeStats;
    }

    public final EntityTypeStats getEntityStatsCounters() {
        return this.entityStats;
    }

    public final Map<Class<?>, EntityTypeStats> getEntityTypeStatsCounters() {
        return this.entityTypeStats;
    }

    public final EntityTypeStats getMessageStatsCounters() {
        return this.messageStats;
    }

    public final Map<Class<?>, EntityTypeStats> getMessageTypeStatsCounters() {
        return this.messageTypeStats;
    }

    public final EntityTypeStats getCollectionStatsCounters() {
        return this.collectionStats;
    }

    public final Map<Class<?>, EntityTypeStats> getCollectionTypeStatsCounters() {
        return this.collectionTypeStats;
    }

    public static enum EntityType {
        EmbeddedEntity,
        Entity,
        Message,
        Collection;

    }

    public final class EntityTypeStats {
        private final AtomicLong createAllocCount = new AtomicLong();
        private final AtomicLong poolAllocCount = new AtomicLong();
        private final AtomicLong gcDisposeCount = new AtomicLong();
        private final AtomicLong poolDisposeCount = new AtomicLong();
        private final AtomicLong poolLeakCount = new AtomicLong();
        private final AtomicLong pojoCreateAllocCount = new AtomicLong();
        private final AtomicLong pojoPoolAllocCount = new AtomicLong();
        private final AtomicLong pojoGCDisposeCount = new AtomicLong();
        private final AtomicLong pojoPoolDisposeCount = new AtomicLong();
        private final AtomicLong pojoPoolLeakCount = new AtomicLong();
        private final AtomicLong serializerCreateAllocCount = new AtomicLong();
        private final AtomicLong serializerPoolAllocCount = new AtomicLong();
        private final AtomicLong serializerGCDisposeCount = new AtomicLong();
        private final AtomicLong serializerPoolDisposeCount = new AtomicLong();
        private final AtomicLong serializerPoolLeakCount = new AtomicLong();
        private final AtomicLong deserializerCreateAllocCount = new AtomicLong();
        private final AtomicLong deserializerPoolAllocCount = new AtomicLong();
        private final AtomicLong deserializerGCDisposeCount = new AtomicLong();
        private final AtomicLong deserializerPoolDisposeCount = new AtomicLong();
        private final AtomicLong deserializerPoolLeakCount = new AtomicLong();
        private final AtomicLong metadataAllocCount = new AtomicLong();
        private final AtomicLong metadataAllocBytes = new AtomicLong();
        private final AtomicLong metadataGCDisposeCount = new AtomicLong();
        private final AtomicLong metadataGCDisposeBytes = new AtomicLong();
        private final AtomicLong metadataPoolDisposeCount = new AtomicLong();
        private final AtomicLong metadataPoolDisposeBytes = new AtomicLong();
        private final AtomicLong dataAllocCount = new AtomicLong();
        private final AtomicLong dataAllocBytes = new AtomicLong();
        private final AtomicLong dataGCDisposeCount = new AtomicLong();
        private final AtomicLong dataGCDisposeBytes = new AtomicLong();
        private final AtomicLong dataPoolDisposeCount = new AtomicLong();
        private final AtomicLong dataPoolDisposeBytes = new AtomicLong();
        private long createAllocCountLast;
        private long poolAllocCountLast;
        private long gcDisposeCountLast;
        private long poolDisposeCountLast;
        private long poolLeakCountLast;
        private long pojoCreateAllocCountLast;
        private long pojoPoolAllocCountLast;
        private long pojoGCDisposeCountLast;
        private long pojoPoolDisposeCountLast;
        private long pojoPoolLeakCountLast;
        private long serializerCreateAllocCountLast;
        private long serializerPoolAllocCountLast;
        private long serializerGCDisposeCountLast;
        private long serializerPoolDisposeCountLast;
        private long serializerPoolLeakCountLast;
        private long deserializerCreateAllocCountLast;
        private long deserializerPoolAllocCountLast;
        private long deserializerGCDisposeCountLast;
        private long deserializerPoolDisposeCountLast;
        private long deserializerPoolLeakCountLast;
        private long metadataAllocCountLast;
        private long metadataAllocBytesLast;
        private long metadataGCDisposeCountLast;
        private long metadataGCDisposeBytesLast;
        private long metadataPoolDisposeCountLast;
        private long metadataPoolDisposeBytesLast;
        private long dataAllocCountLast;
        private long dataAllocBytesLast;
        private long dataGCDisposeCountLast;
        private long dataGCDisposeBytesLast;
        private long dataPoolDisposeCountLast;
        private long dataPoolDisposeBytesLast;
        private long createAllocCountCurrent;
        private long poolAllocCountCurrent;
        private long gcDisposeCountCurrent;
        private long poolDisposeCountCurrent;
        private long poolLeakCountCurrent;
        private long pojoCreateAllocCountCurrent;
        private long pojoPoolAllocCountCurrent;
        private long pojoGCDisposeCountCurrent;
        private long pojoPoolDisposeCountCurrent;
        private long pojoPoolLeakCountCurrent;
        private long serializerCreateAllocCountCurrent;
        private long serializerPoolAllocCountCurrent;
        private long serializerGCDisposeCountCurrent;
        private long serializerPoolDisposeCountCurrent;
        private long serializerPoolLeakCountCurrent;
        private long deserializerCreateAllocCountCurrent;
        private long deserializerPoolAllocCountCurrent;
        private long deserializerGCDisposeCountCurrent;
        private long deserializerPoolDisposeCountCurrent;
        private long deserializerPoolLeakCountCurrent;
        private long metadataAllocCountCurrent;
        private long metadataAllocBytesCurrent;
        private long metadataGCDisposeCountCurrent;
        private long metadataGCDisposeBytesCurrent;
        private long metadataPoolDisposeCountCurrent;
        private long metadataPoolDisposeBytesCurrent;
        private long dataAllocCountCurrent;
        private long dataAllocBytesCurrent;
        private long dataGCDisposeCountCurrent;
        private long dataGCDisposeBytesCurrent;
        private long dataPoolDisposeCountCurrent;
        private long dataPoolDisposeBytesCurrent;

        final void stampCurrent() {
            this.createAllocCountCurrent = this.createAllocCount.get();
            this.poolAllocCountCurrent = this.poolAllocCount.get();
            this.gcDisposeCountCurrent = this.gcDisposeCount.get();
            this.poolDisposeCountCurrent = this.poolDisposeCount.get();
            this.poolLeakCountCurrent = this.poolLeakCount.get();
            this.pojoCreateAllocCountCurrent = this.pojoCreateAllocCount.get();
            this.pojoPoolAllocCountCurrent = this.pojoPoolAllocCount.get();
            this.pojoGCDisposeCountCurrent = this.pojoGCDisposeCount.get();
            this.pojoPoolDisposeCountCurrent = this.pojoPoolDisposeCount.get();
            this.pojoPoolLeakCountCurrent = this.pojoPoolLeakCount.get();
            this.serializerCreateAllocCountCurrent = this.serializerCreateAllocCount.get();
            this.serializerPoolAllocCountCurrent = this.serializerPoolAllocCount.get();
            this.serializerGCDisposeCountCurrent = this.serializerGCDisposeCount.get();
            this.serializerPoolDisposeCountCurrent = this.serializerPoolDisposeCount.get();
            this.serializerPoolLeakCountCurrent = this.serializerPoolLeakCount.get();
            this.deserializerCreateAllocCountCurrent = this.deserializerCreateAllocCount.get();
            this.deserializerPoolAllocCountCurrent = this.deserializerPoolAllocCount.get();
            this.deserializerGCDisposeCountCurrent = this.deserializerGCDisposeCount.get();
            this.deserializerPoolDisposeCountCurrent = this.deserializerPoolDisposeCount.get();
            this.deserializerPoolLeakCountCurrent = this.deserializerPoolLeakCount.get();
            this.metadataAllocCountCurrent = this.metadataAllocCount.get();
            this.metadataAllocBytesCurrent = this.metadataAllocBytes.get();
            this.metadataGCDisposeCountCurrent = this.metadataGCDisposeCount.get();
            this.metadataGCDisposeBytesCurrent = this.metadataGCDisposeBytes.get();
            this.metadataPoolDisposeCountCurrent = this.metadataPoolDisposeCount.get();
            this.metadataPoolDisposeBytesCurrent = this.metadataPoolDisposeBytes.get();
            this.dataAllocCountCurrent = this.dataAllocCount.get();
            this.dataAllocBytesCurrent = this.dataAllocBytes.get();
            this.dataGCDisposeCountCurrent = this.dataGCDisposeCount.get();
            this.dataGCDisposeBytesCurrent = this.dataGCDisposeBytes.get();
            this.dataPoolDisposeCountCurrent = this.dataPoolDisposeCount.get();
            this.dataPoolDisposeBytesCurrent = this.dataPoolDisposeBytes.get();
        }

        final void currentToLast() {
            this.createAllocCountLast = this.createAllocCountCurrent;
            this.poolAllocCountLast = this.poolAllocCountCurrent;
            this.gcDisposeCountLast = this.gcDisposeCountCurrent;
            this.poolDisposeCountLast = this.poolDisposeCountCurrent;
            this.poolLeakCountLast = this.poolLeakCountCurrent;
            this.pojoCreateAllocCountLast = this.pojoCreateAllocCountCurrent;
            this.pojoPoolAllocCountLast = this.pojoPoolAllocCountCurrent;
            this.pojoGCDisposeCountLast = this.pojoGCDisposeCountCurrent;
            this.pojoPoolDisposeCountLast = this.pojoPoolDisposeCountCurrent;
            this.pojoPoolLeakCountLast = this.pojoPoolLeakCountCurrent;
            this.serializerCreateAllocCountLast = this.serializerCreateAllocCountCurrent;
            this.serializerPoolAllocCountLast = this.serializerPoolAllocCountCurrent;
            this.serializerGCDisposeCountLast = this.serializerGCDisposeCountCurrent;
            this.serializerPoolDisposeCountLast = this.serializerPoolDisposeCountCurrent;
            this.serializerPoolLeakCountLast = this.serializerPoolLeakCountCurrent;
            this.deserializerCreateAllocCountLast = this.deserializerCreateAllocCountCurrent;
            this.deserializerPoolAllocCountLast = this.deserializerPoolAllocCountCurrent;
            this.deserializerGCDisposeCountLast = this.deserializerGCDisposeCountCurrent;
            this.deserializerPoolDisposeCountLast = this.deserializerPoolDisposeCountCurrent;
            this.deserializerPoolLeakCountLast = this.deserializerPoolLeakCountCurrent;
            this.metadataAllocCountLast = this.metadataAllocCountCurrent;
            this.metadataAllocBytesLast = this.metadataAllocBytesCurrent;
            this.metadataGCDisposeCountLast = this.metadataGCDisposeCountCurrent;
            this.metadataGCDisposeBytesLast = this.metadataGCDisposeBytesCurrent;
            this.metadataPoolDisposeCountLast = this.metadataPoolDisposeCountCurrent;
            this.metadataPoolDisposeBytesLast = this.metadataPoolDisposeBytesCurrent;
            this.dataAllocCountLast = this.dataAllocCountCurrent;
            this.dataAllocBytesLast = this.dataAllocBytesCurrent;
            this.dataGCDisposeCountLast = this.dataGCDisposeCountCurrent;
            this.dataGCDisposeBytesLast = this.dataGCDisposeBytesCurrent;
            this.dataPoolDisposeCountLast = this.dataPoolDisposeCountCurrent;
            this.dataPoolDisposeBytesLast = this.dataPoolDisposeBytesCurrent;
        }

        final void get(String prefix, StringBuilder sb, long deltaTime, long deltaTotalTime) {
            String countLiveStr = MemoryStats.this.format.format(this.createAllocCountCurrent + this.poolAllocCountCurrent - this.gcDisposeCountCurrent - this.poolDisposeCountCurrent);
            String countPooledStr = MemoryStats.this.format.format(this.poolDisposeCountCurrent - this.poolAllocCountCurrent - this.poolLeakCountCurrent);
            String pojoCountLiveStr = MemoryStats.this.format.format(this.pojoCreateAllocCountCurrent + this.pojoPoolAllocCountCurrent - this.pojoGCDisposeCountCurrent - this.pojoPoolDisposeCountCurrent);
            String pojoCountPooledStr = MemoryStats.this.format.format(this.pojoPoolDisposeCountCurrent - this.pojoPoolAllocCountCurrent - this.pojoPoolLeakCountCurrent);
            String serializerCountLiveStr = MemoryStats.this.format.format(this.serializerCreateAllocCountCurrent + this.serializerPoolAllocCountCurrent - this.serializerGCDisposeCountCurrent - this.serializerPoolDisposeCountCurrent);
            String serializerCountPooledStr = MemoryStats.this.format.format(this.serializerPoolDisposeCountCurrent - this.serializerPoolAllocCountCurrent - this.serializerPoolLeakCountCurrent);
            String deserializerCountLiveStr = MemoryStats.this.format.format(this.deserializerCreateAllocCountCurrent + this.deserializerPoolAllocCountCurrent - this.deserializerGCDisposeCountCurrent - this.deserializerPoolDisposeCountCurrent);
            String deserializerCountPooledStr = MemoryStats.this.format.format(this.deserializerPoolDisposeCountCurrent - this.deserializerPoolAllocCountCurrent - this.deserializerPoolLeakCountCurrent);
            String metadataBytesLiveStr = MemoryStats.this.format.format(this.metadataAllocBytesCurrent - this.metadataPoolDisposeBytesCurrent - this.metadataGCDisposeBytesCurrent);
            String dataBytesLiveStr = MemoryStats.this.format.format(this.dataAllocBytesCurrent - this.dataPoolDisposeBytesCurrent - this.dataGCDisposeBytesCurrent);
            sb.append(prefix).append(" {");
            sb.append(countLiveStr).append(", ").append(countPooledStr);
            sb.append(" Po {");
            sb.append(pojoCountLiveStr).append(", ").append(pojoCountPooledStr);
            sb.append("}");
            sb.append(" Se {");
            sb.append(serializerCountLiveStr).append(", ").append(serializerCountPooledStr);
            sb.append("}");
            sb.append(" De {");
            sb.append(deserializerCountLiveStr).append(", ").append(deserializerCountPooledStr);
            sb.append("}");
            sb.append(" Me {");
            sb.append(metadataBytesLiveStr);
            sb.append("}");
            sb.append(" Da {");
            sb.append(dataBytesLiveStr);
            sb.append("}");
            sb.append("}");
        }

        public final long getLiveCount() {
            return this.createAllocCount.get() + this.poolAllocCount.get() - this.gcDisposeCount.get() - this.poolDisposeCount.get();
        }

        public final long getPooledCount() {
            return this.poolDisposeCount.get() - this.poolAllocCount.get() - this.poolLeakCount.get();
        }

        public final long getCreateAllocCount() {
            return this.createAllocCount.get();
        }

        public final long getPoolAllocCount() {
            return this.poolAllocCount.get();
        }

        public final long getGCDisposeCount() {
            return this.gcDisposeCount.get();
        }

        public final long getPoolDisposeCount() {
            return this.poolDisposeCount.get();
        }

        public final long getPoolLeakCount() {
            return this.poolLeakCount.get();
        }

        public final long getPojoLiveCount() {
            return this.pojoCreateAllocCount.get() + this.pojoPoolAllocCount.get() - this.pojoGCDisposeCount.get() - this.pojoPoolDisposeCount.get();
        }

        public final long getPojoPooledCount() {
            return this.pojoPoolDisposeCount.get() - this.pojoPoolAllocCount.get() - this.pojoPoolLeakCount.get();
        }

        public final long getPojoCreateAllocCount() {
            return this.pojoCreateAllocCount.get();
        }

        public final long getPojoPoolAllocCount() {
            return this.pojoPoolAllocCount.get();
        }

        public final long getPojoGCDisposeCount() {
            return this.pojoGCDisposeCount.get();
        }

        public final long getPojoPoolDisposeCount() {
            return this.pojoPoolDisposeCount.get();
        }

        public final long getPojoPoolLeakCount() {
            return this.pojoPoolLeakCount.get();
        }

        public final long getSerializerLiveCount() {
            return this.serializerCreateAllocCount.get() + this.serializerPoolAllocCount.get() - this.serializerGCDisposeCount.get() - this.serializerPoolDisposeCount.get();
        }

        public final long getSerializerPooledCount() {
            return this.serializerPoolDisposeCount.get() - this.serializerPoolAllocCount.get() - this.serializerPoolLeakCount.get();
        }

        public final long getSerializerCreateAllocCount() {
            return this.serializerCreateAllocCount.get();
        }

        public final long getSerializerPoolAllocCount() {
            return this.serializerPoolAllocCount.get();
        }

        public final long getSerializerGCDisposeCount() {
            return this.serializerGCDisposeCount.get();
        }

        public final long getSerializerPoolDisposeCount() {
            return this.serializerPoolDisposeCount.get();
        }

        public final long getSerializerPoolLeakCount() {
            return this.serializerPoolLeakCount.get();
        }

        public final long getDeserializerLiveCount() {
            return this.deserializerCreateAllocCount.get() + this.deserializerPoolAllocCount.get() - this.deserializerGCDisposeCount.get() - this.deserializerPoolDisposeCount.get();
        }

        public final long getDeserializerPooledCount() {
            return this.deserializerPoolDisposeCount.get() - this.deserializerPoolAllocCount.get() - this.deserializerPoolLeakCount.get();
        }

        public final long getDeserializerCreateAllocCount() {
            return this.deserializerCreateAllocCount.get();
        }

        public final long getDeserializerPoolAllocCount() {
            return this.deserializerPoolAllocCount.get();
        }

        public final long getDeserializerGCDisposeCount() {
            return this.deserializerGCDisposeCount.get();
        }

        public final long getDeserializerPoolDisposeCount() {
            return this.deserializerPoolDisposeCount.get();
        }

        public final long getDeserializerPoolLeakCount() {
            return this.deserializerPoolLeakCount.get();
        }

        public final long getMetadataLiveCount() {
            return this.metadataAllocCount.get() - this.metadataPoolDisposeCount.get() - this.metadataGCDisposeCount.get();
        }

        public final long getMetadataLiveBytes() {
            return this.metadataAllocBytes.get() - this.metadataPoolDisposeBytes.get() - this.metadataGCDisposeBytes.get();
        }

        public final long getMetadataAllocCount() {
            return this.metadataAllocCount.get();
        }

        public final long getMetadataAllocBytes() {
            return this.metadataAllocBytes.get();
        }

        public final long getMetadataGCDisposeCount() {
            return this.metadataGCDisposeCount.get();
        }

        public final long getMetadataGCDisposeBytes() {
            return this.metadataGCDisposeBytes.get();
        }

        public final long getMetadataPoolDisposeCount() {
            return this.metadataPoolDisposeCount.get();
        }

        public final long getMetadataPoolDisposeBytes() {
            return this.metadataPoolDisposeBytes.get();
        }

        public final long getDataLiveCount() {
            return this.dataAllocCount.get() - this.dataPoolDisposeCount.get() - this.dataGCDisposeCount.get();
        }

        public final long getDataLiveBytes() {
            return this.dataAllocBytes.get() - this.dataPoolDisposeBytes.get() - this.dataGCDisposeBytes.get();
        }

        public final long getDataAllocCount() {
            return this.dataAllocCount.get();
        }

        public final long getDataAllocBytes() {
            return this.dataAllocBytes.get();
        }

        public final long getDataGCDisposeCount() {
            return this.dataGCDisposeCount.get();
        }

        public final long getDataGCDisposeBytes() {
            return this.dataGCDisposeBytes.get();
        }

        public final long getDataPoolDisposeCount() {
            return this.dataPoolDisposeCount.get();
        }

        public final long getDataPoolDisposeBytes() {
            return this.dataPoolDisposeBytes.get();
        }
    }

    public final class IOBufferStats {
        private final AtomicLong bufferAllocCount = new AtomicLong();
        private final AtomicLong bufferAllocBytes = new AtomicLong();
        private final AtomicLong bufferPoolAllocCount = new AtomicLong();
        private final AtomicLong bufferPoolAllocBytes = new AtomicLong();
        private final AtomicLong bufferReallocCount = new AtomicLong();
        private final AtomicLong bufferReallocBytes = new AtomicLong();
        private final AtomicLong bufferForkCount = new AtomicLong();
        private final AtomicLong bufferForkBytes = new AtomicLong();
        private final AtomicLong bufferGCDisposeCount = new AtomicLong();
        private final AtomicLong bufferGCDisposeBytes = new AtomicLong();
        private final AtomicLong bufferPoolDisposeCount = new AtomicLong();
        private final AtomicLong bufferPoolDisposeBytes = new AtomicLong();
        private final AtomicLong bufferPoolLeakCount = new AtomicLong();
        private final AtomicLong bufferPoolLeakBytes = new AtomicLong();
        private long bufferAllocCountLast;
        private long bufferAllocBytesLast;
        private long bufferPoolAllocCountLast;
        private long bufferPoolAllocBytesLast;
        private long bufferReallocCountLast;
        private long bufferReallocBytesLast;
        private long bufferForkCountLast;
        private long bufferForkBytesLast;
        private long bufferGCDisposeCountLast;
        private long bufferGCDisposeBytesLast;
        private long bufferPoolDisposeCountLast;
        private long bufferPoolDisposeBytesLast;
        private long bufferPoolLeakCountLast;
        private long bufferPoolLeakBytesLast;
        private long bufferAllocCountCurrent;
        private long bufferAllocBytesCurrent;
        private long bufferPoolAllocCountCurrent;
        private long bufferPoolAllocBytesCurrent;
        private long bufferReallocCountCurrent;
        private long bufferReallocBytesCurrent;
        private long bufferForkCountCurrent;
        private long bufferForkBytesCurrent;
        private long bufferGCDisposeCountCurrent;
        private long bufferGCDisposeBytesCurrent;
        private long bufferPoolDisposeCountCurrent;
        private long bufferPoolDisposeBytesCurrent;
        private long bufferPoolLeakCountCurrent;
        private long bufferPoolLeakBytesCurrent;

        final void stampCurrent() {
            this.bufferAllocCountCurrent = this.bufferAllocCount.get();
            this.bufferAllocBytesCurrent = this.bufferAllocBytes.get();
            this.bufferPoolAllocCountCurrent = this.bufferPoolAllocCount.get();
            this.bufferPoolAllocBytesCurrent = this.bufferPoolAllocBytes.get();
            this.bufferReallocCountCurrent = this.bufferReallocCount.get();
            this.bufferReallocBytesCurrent = this.bufferReallocBytes.get();
            this.bufferForkCountCurrent = this.bufferForkCount.get();
            this.bufferForkBytesCurrent = this.bufferForkBytes.get();
            this.bufferGCDisposeCountCurrent = this.bufferGCDisposeCount.get();
            this.bufferGCDisposeBytesCurrent = this.bufferGCDisposeBytes.get();
            this.bufferPoolDisposeCountCurrent = this.bufferPoolDisposeCount.get();
            this.bufferPoolDisposeBytesCurrent = this.bufferPoolDisposeBytes.get();
            this.bufferPoolLeakCountCurrent = this.bufferPoolLeakCount.get();
            this.bufferPoolLeakBytesCurrent = this.bufferPoolLeakBytes.get();
        }

        final void currentToLast() {
            this.bufferAllocCountLast = this.bufferAllocCountCurrent;
            this.bufferAllocBytesLast = this.bufferAllocBytesCurrent;
            this.bufferPoolAllocCountLast = this.bufferPoolAllocCountCurrent;
            this.bufferPoolAllocBytesLast = this.bufferPoolAllocBytesCurrent;
            this.bufferReallocCountLast = this.bufferReallocCountCurrent;
            this.bufferReallocBytesLast = this.bufferReallocBytesCurrent;
            this.bufferForkCountLast = this.bufferForkCountCurrent;
            this.bufferForkBytesLast = this.bufferForkBytesCurrent;
            this.bufferGCDisposeCountLast = this.bufferGCDisposeCountCurrent;
            this.bufferGCDisposeBytesLast = this.bufferGCDisposeBytesCurrent;
            this.bufferPoolDisposeCountLast = this.bufferPoolDisposeCountCurrent;
            this.bufferPoolDisposeBytesLast = this.bufferPoolDisposeBytesCurrent;
            this.bufferPoolLeakCountLast = this.bufferPoolLeakCountCurrent;
            this.bufferPoolLeakBytesLast = this.bufferPoolLeakBytesCurrent;
        }

        final void get(String prefix, StringBuilder sb, long deltaTime, long deltaTotalTime) {
        }

        public final long getBufferCountUsedLive() {
            return this.getBufferAllocCount() + this.getBufferPoolAllocCount() - this.getBufferPoolDisposeCount() - this.getBufferGCDisposeCount();
        }

        public final long getBufferBytesUsedLive() {
            return this.getBufferAllocBytes() + this.getBufferPoolAllocBytes() - this.getBufferPoolDisposeBytes() - this.getBufferGCDisposeBytes();
        }

        public final long getBufferCountUsedPooled() {
            return this.getBufferPoolDisposeCount() - this.getBufferPoolAllocCount() - this.getBufferPoolLeakCount();
        }

        public final long getBufferBytesUsedPooled() {
            return this.getBufferPoolDisposeBytes() - this.getBufferPoolAllocBytes() - this.getBufferPoolLeakBytes();
        }

        public final long getBufferAllocCount() {
            return this.bufferAllocCount.get();
        }

        public final long getBufferAllocBytes() {
            return this.bufferAllocBytes.get();
        }

        public final long getBufferPoolAllocCount() {
            return this.bufferPoolAllocCount.get();
        }

        public final long getBufferPoolAllocBytes() {
            return this.bufferPoolAllocBytes.get();
        }

        public final long getBufferReallocCount() {
            return this.bufferReallocCount.get();
        }

        public final long getBufferReallocBytes() {
            return this.bufferReallocBytes.get();
        }

        public final long getBufferForkCount() {
            return this.bufferForkCount.get();
        }

        public final long getBufferForkBytes() {
            return this.bufferForkBytes.get();
        }

        public final long getBufferGCDisposeCount() {
            return this.bufferGCDisposeCount.get();
        }

        public final long getBufferGCDisposeBytes() {
            return this.bufferGCDisposeBytes.get();
        }

        public final long getBufferPoolDisposeCount() {
            return this.bufferPoolDisposeCount.get();
        }

        public final long getBufferPoolDisposeBytes() {
            return this.bufferPoolDisposeBytes.get();
        }

        public final long getBufferPoolLeakCount() {
            return this.bufferPoolLeakCount.get();
        }

        public final long getBufferPoolLeakBytes() {
            return this.bufferPoolLeakBytes.get();
        }
    }

    public final class NativeMemoryStats {
        private final AtomicLong allocCount = new AtomicLong();
        private final AtomicLong allocBytes = new AtomicLong();
        private final AtomicLong reallocCount = new AtomicLong();
        private final AtomicLong reallocBytes = new AtomicLong();
        private final AtomicLong freeCount = new AtomicLong();
        private final AtomicLong freeBytes = new AtomicLong();
        private long allocCountLast;
        private long allocBytesLast;
        private long reallocCountLast;
        private long reallocBytesLast;
        private long freeCountLast;
        private long freeBytesLast;
        private long allocCountCurrent;
        private long allocBytesCurrent;
        private long reallocCountCurrent;
        private long reallocBytesCurrent;
        private long freeCountCurrent;
        private long freeBytesCurrent;

        final void stampCurrent() {
            this.allocCountCurrent = this.allocCount.get();
            this.allocBytesCurrent = this.allocBytes.get();
            this.reallocCountCurrent = this.reallocCount.get();
            this.reallocBytesCurrent = this.reallocBytes.get();
            this.freeCountCurrent = this.freeCount.get();
            this.freeBytesCurrent = this.freeBytes.get();
        }

        final void currentToLast() {
            this.allocCountLast = this.allocCountCurrent;
            this.allocBytesLast = this.allocBytesCurrent;
            this.reallocCountLast = this.reallocCountCurrent;
            this.reallocBytesLast = this.reallocBytesCurrent;
            this.freeCountLast = this.freeCountCurrent;
            this.freeBytesLast = this.freeBytesCurrent;
        }

        final void get(String prefix, StringBuilder sb, long deltaTime, long deltaTotalTime) {
        }

        public final long getBytesUsedLive() {
            return this.getAllocBytes() - this.getFreeBytes() + this.getReallocBytes();
        }

        public final long getAllocCount() {
            return this.allocCount.get();
        }

        public final long getAllocBytes() {
            return this.allocBytes.get();
        }

        public final long getReallocCount() {
            return this.reallocCount.get();
        }

        public final long getReallocBytes() {
            return this.reallocBytes.get();
        }

        public final long getFreeCount() {
            return this.freeCount.get();
        }

        public final long getFreeBytes() {
            return this.freeBytes.get();
        }
    }
}

