/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XCollection;
import com.neeve.lang.XIntCollection;
import com.neeve.lang.XIntCollectionBase;
import com.neeve.lang.XIntIterator;
import com.neeve.lang.XIntList;
import com.neeve.lang.XIntListIterator;
import java.util.NoSuchElementException;

public class XIntLinkedList
extends XIntCollectionBase
implements XIntList {
    private transient IntNode _head = this.newNode();
    private transient IntNode _tail = this.newNode();
    private transient int _size;

    public XIntLinkedList() {
        this(4);
    }

    public XIntLinkedList(int capacity) {
        this._head._next = this._tail;
        this._tail._previous = this._head;
        IntNode previous = this._tail;
        int i = 0;
        while (i++ < capacity) {
            IntNode newNode = this.newNode();
            newNode._previous = previous;
            previous._next = newNode;
            previous = newNode;
        }
    }

    public XIntLinkedList(XIntCollection values) {
        this(values.size());
        this.addAll(values);
    }

    public static XIntLinkedList newInstance() {
        return new XIntLinkedList();
    }

    @Override
    public final boolean add(int value) {
        this.addLast(value);
        return true;
    }

    @Override
    public final int get(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return this.nodeAt(index)._value;
    }

    @Override
    public final int set(int index, int value) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        IntNode node = this.nodeAt(index);
        int previousValue = node._value;
        node._value = value;
        return previousValue;
    }

    @Override
    public final void add(int index, int value) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        this.addBefore(this.nodeAt(index), value);
    }

    @Override
    public final boolean addAll(int index, XIntCollection values) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        IntNode indexNode = this.nodeAt(index);
        XIntIterator i = values.iterator();
        while (i.hasNext()) {
            this.addBefore(indexNode, i.next());
        }
        return values.size() != 0;
    }

    @Override
    public final int removeIndex(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        IntNode node = this.nodeAt(index);
        int previousValue = node._value;
        this.delete(node);
        return previousValue;
    }

    @Override
    public final int indexOf(int value) {
        int index = 0;
        IntNode n = this._head;
        IntNode end = this._tail;
        while ((n = n._next) != end) {
            if (value == n._value) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(int value) {
        int index = this.size() - 1;
        IntNode n = this._tail;
        IntNode end = this._head;
        while ((n = n._previous) != end) {
            if (value == n._value) {
                return index;
            }
            --index;
        }
        return -1;
    }

    @Override
    public XIntIterator iterator() {
        return this.listIterator();
    }

    @Override
    public XIntListIterator listIterator() {
        return XIntLinkedListIterator.valueOf(this, this._head._next, 0, this._size);
    }

    @Override
    public XIntListIterator listIterator(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return XIntLinkedListIterator.valueOf(this, this.nodeAt(index), index, this._size);
    }

    @Override
    public final XIntList subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
        }
        return SubList.valueOf(this, this.nodeAt(fromIndex)._previous, this.nodeAt(toIndex), toIndex - fromIndex);
    }

    public final int getFirst() {
        IntNode node = this._head._next;
        if (node == this._tail) {
            throw new NoSuchElementException();
        }
        return node._value;
    }

    public final int getLast() {
        IntNode node = this._tail._previous;
        if (node == this._head) {
            throw new NoSuchElementException();
        }
        return node._value;
    }

    public final void addFirst(int value) {
        this.addBefore(this._head._next, value);
    }

    public void addLast(int value) {
        if (this._tail._next == null) {
            this.increaseCapacity();
        }
        this._tail._value = value;
        this._tail = this._tail._next;
        ++this._size;
    }

    public final int removeFirst() {
        IntNode first = this._head._next;
        if (first == this._tail) {
            throw new NoSuchElementException();
        }
        int previousValue = first._value;
        this.delete(first);
        return previousValue;
    }

    public final int removeLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        --this._size;
        IntNode last = this._tail._previous;
        int previousValue = last._value;
        this._tail = last;
        last._value = -1;
        return previousValue;
    }

    public final void addBefore(IntNode next, int value) {
        IntNode newNode;
        IntNode tailNext;
        if (this._tail._next == null) {
            this.increaseCapacity();
        }
        if ((tailNext = (this._tail._next = (newNode = this._tail._next)._next)) != null) {
            tailNext._previous = this._tail;
        }
        IntNode previous = next._previous;
        previous._next = newNode;
        next._previous = newNode;
        newNode._next = next;
        newNode._previous = previous;
        newNode._value = value;
        ++this._size;
    }

    private final IntNode nodeAt(int index) {
        IntNode node = this._head;
        int i = index;
        while (i-- >= 0) {
            node = node._next;
        }
        return node;
    }

    @Override
    public final IntNode head() {
        return this._head;
    }

    @Override
    public final IntNode tail() {
        return this._tail;
    }

    @Override
    public final int valueOf(XCollection.Record record) {
        return ((IntNode)record)._value;
    }

    @Override
    public final void delete(XCollection.Record record) {
        IntNode node = (IntNode)record;
        --this._size;
        node._value = -1;
        node._previous._next = node._next;
        node._next._previous = node._previous;
        IntNode next = this._tail._next;
        node._previous = this._tail;
        node._next = next;
        this._tail._next = node;
        if (next != null) {
            next._previous = node;
        }
    }

    @Override
    public final boolean contains(int value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final void clear() {
        this._size = 0;
        this._tail = this._head._next;
    }

    @Override
    public XIntList unmodifiable() {
        return (XIntList)super.unmodifiable();
    }

    protected IntNode newNode() {
        return new IntNode();
    }

    private void increaseCapacity() {
        IntNode newNode0 = this.newNode();
        this._tail._next = newNode0;
        newNode0._previous = this._tail;
        IntNode newNode1 = this.newNode();
        newNode0._next = newNode1;
        newNode1._previous = newNode0;
        IntNode newNode2 = this.newNode();
        newNode1._next = newNode2;
        newNode2._previous = newNode1;
        IntNode newNode3 = this.newNode();
        newNode2._next = newNode3;
        newNode3._previous = newNode2;
    }

    public void reset() {
        this.clear();
    }

    private static final class XIntLinkedListIterator
    implements XIntListIterator {
        private XIntLinkedList _list;
        private IntNode _nextNode;
        private IntNode _currentNode;
        private int _length;
        private int _nextIndex;

        private XIntLinkedListIterator() {
        }

        public static XIntLinkedListIterator valueOf(XIntLinkedList list, IntNode nextNode, int nextIndex, int size) {
            XIntLinkedListIterator itr = new XIntLinkedListIterator();
            itr._list = list;
            itr._nextNode = nextNode;
            itr._nextIndex = nextIndex;
            itr._length = size;
            return itr;
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._length;
        }

        @Override
        public int next() {
            if (this._nextIndex == this._length) {
                throw new NoSuchElementException();
            }
            ++this._nextIndex;
            this._currentNode = this._nextNode;
            this._nextNode = this._nextNode._next;
            return this._currentNode._value;
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        @Override
        public int previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            --this._nextIndex;
            this._currentNode = this._nextNode = this._nextNode._previous;
            return this._currentNode._value;
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public void add(int o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            this._list.addBefore(this._nextNode, o);
            this._currentNode = null;
            ++this._length;
            ++this._nextIndex;
        }

        @Override
        public void set(int o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            this._currentNode._value = o;
        }

        @Override
        public void remove() {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            if (this._nextNode == this._currentNode) {
                this._nextNode = this._nextNode._next;
            } else {
                --this._nextIndex;
            }
            this._list.delete(this._currentNode);
            this._currentNode = null;
            --this._length;
        }

        @Override
        public final XIntLinkedListIterator toFirst() {
            this._nextNode = this._list._head._next;
            this._nextIndex = 0;
            this._length = this._list._size;
            return this;
        }
    }

    private static final class SubList
    extends XIntCollectionBase
    implements XIntList {
        private XIntLinkedList _list;
        private IntNode _head;
        private IntNode _tail;
        private int _size;

        private SubList() {
        }

        public static SubList valueOf(XIntLinkedList list, IntNode head, IntNode tail, int size) {
            SubList subList = new SubList();
            subList._list = list;
            subList._head = head;
            subList._tail = tail;
            subList._size = size;
            return subList;
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public XCollection.Record head() {
            return this._head;
        }

        @Override
        public XCollection.Record tail() {
            return this._tail;
        }

        @Override
        public int valueOf(XCollection.Record record) {
            return this._list.valueOf(record);
        }

        @Override
        public void delete(XCollection.Record record) {
            this._list.delete(record);
            if (record == this._head) {
                this._head = this._head.getNext();
            } else if (record == this._tail) {
                this._tail = this._tail.getPrevious();
            }
            --this._size;
        }

        @Override
        public boolean addAll(XIntCollection values) {
            return this.addAll(this._size, values);
        }

        @Override
        public boolean addAll(int index, XIntCollection values) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            IntNode indexNode = this.nodeAt(index);
            XIntIterator i = values.iterator();
            while (i.hasNext()) {
                this._list.addBefore(indexNode, i.next());
            }
            if (values.size() > 0) {
                if (index == 0) {
                    this._head = this._head.getPrevious();
                } else if (index == this._size) {
                    this._tail = indexNode.getPrevious();
                }
            }
            this._size += values.size();
            return values.size() != 0;
        }

        @Override
        public int get(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this.nodeAt(index)._value;
        }

        @Override
        public int set(int index, int value) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            IntNode node = this.nodeAt(index);
            int previousValue = node._value;
            node._value = value;
            return previousValue;
        }

        @Override
        public boolean add(int element) {
            this.add(this._size, element);
            return true;
        }

        @Override
        public void add(int index, int element) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            this._list.addBefore(this.nodeAt(index), element);
            if (index == 0) {
                this._head = this._head.getPrevious();
            } else if (index == this._size) {
                this._tail = this._tail.getNext();
            }
            ++this._size;
        }

        @Override
        public int removeIndex(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            IntNode node = this.nodeAt(index);
            int previousValue = node._value;
            this._list.delete(node);
            if (index == 0) {
                this._head = this._head.getNext();
            } else if (index == this._size) {
                this._tail = this._tail.getPrevious();
            }
            --this._size;
            return previousValue;
        }

        @Override
        public int indexOf(int value) {
            int index = 0;
            IntNode n = this._head;
            IntNode end = this._tail;
            while ((n = n._next) != end) {
                if (value == n._value) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(int value) {
            int index = this.size() - 1;
            IntNode n = this._tail;
            IntNode end = this._head;
            while ((n = n._previous) != end) {
                if (value == n._value) {
                    return index;
                }
                --index;
            }
            return -1;
        }

        @Override
        public XIntListIterator listIterator() {
            return this.listIterator(0);
        }

        @Override
        public XIntListIterator listIterator(int index) {
            if (index >= 0 && index <= this._size) {
                return XIntLinkedListIterator.valueOf(this._list, this.nodeAt(index), index, this._size);
            }
            throw new IndexOutOfBoundsException("index: " + index + " for list of size: " + this._size);
        }

        @Override
        public XIntList subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
            }
            SubList subList = SubList.valueOf(this._list, this.nodeAt(fromIndex)._previous, this.nodeAt(toIndex), toIndex - fromIndex);
            return subList;
        }

        private final IntNode nodeAt(int index) {
            if (index <= this._size >> 1) {
                IntNode node = this._head;
                int i = index;
                while (i-- >= 0) {
                    node = node._next;
                }
                return node;
            }
            IntNode node = this._tail;
            int i = this._size - index;
            while (i-- > 0) {
                node = node._previous;
            }
            return node;
        }

        @Override
        public void clear() {
            while (this._size > 0) {
                this.removeIndex(0);
            }
        }
    }

    public static class IntNode
    implements XCollection.Record {
        private IntNode _next;
        private IntNode _previous;
        private int _value;

        protected IntNode() {
        }

        public final int getValue() {
            return this._value;
        }

        @Override
        public final IntNode getNext() {
            return this._next;
        }

        @Override
        public final IntNode getPrevious() {
            return this._previous;
        }
    }
}

