/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.build.codegen;

import com.neeve.build.codegen.CodegenObject;
import com.neeve.ci.ProductInfo;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlText;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.Adler32;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class CgResourceChangeTracker
extends CodegenObject {
    private final ProductInfo productInfo;
    ModelSourceFile rootSourceFile;
    private final HashMap<URL, ModelSourceFile> sourceFiles = new HashMap();
    private final TreeMap<String, String> additionalInfo = new TreeMap();
    private final File dir;
    private String version = null;
    private String additionalInfoDigest = null;
    private boolean metadataLoaded = false;

    private CgResourceChangeTracker(File dir, ProductInfo productInfo) {
        if (dir == null) {
            throw new IllegalArgumentException("'dir' cannot be null");
        }
        this.productInfo = productInfo;
        this.dir = dir;
    }

    public static CgResourceChangeTracker fromPreviousCodeGeneration(File dir, URL rootUrl, Map<String, String> additionalParseInfo, ProductInfo productInfo) {
        CgResourceChangeTracker retVal = new CgResourceChangeTracker(dir, productInfo);
        if (additionalParseInfo != null) {
            retVal.additionalInfo.putAll(additionalParseInfo);
        }
        retVal.load(rootUrl);
        return retVal;
    }

    public static CgResourceChangeTracker forNewCodeGeneration(File dir, URL rootSourceFileUrl, Map<String, String> additionalParseInfo, ProductInfo productInfo) {
        ModelSourceFile root;
        CgResourceChangeTracker retVal;
        CgResourceChangeTracker cgResourceChangeTracker = retVal = new CgResourceChangeTracker(dir, productInfo);
        ((Object)((Object)cgResourceChangeTracker)).getClass();
        retVal.rootSourceFile = root = cgResourceChangeTracker.new ModelSourceFile(retVal, rootSourceFileUrl);
        retVal.sourceFiles.put(root.getUrl(), root);
        if (additionalParseInfo != null) {
            retVal.additionalInfo.putAll(additionalParseInfo);
        }
        return retVal;
    }

    public static final URL urlFromString(String url) {
        if (url == null) {
            throw new IllegalArgumentException("'url' cannot be null");
        }
        try {
            URL retVal = new URL(url);
            return retVal;
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("Error forming URL instance from string " + url, ex);
        }
    }

    public ModelSourceFile getSourceFile(URL url) {
        ModelSourceFile retVal = this.sourceFiles.get(url);
        if (retVal == null) {
            throw new IllegalStateException("URL " + url + " is not found in this parse context. It must first be registered as root or one of imports.");
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (this.metadataLoaded) {
            throw new IllegalStateException("This context was loaded from previous build. Only newly built context may be saved");
        }
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element rootElement = document.createElement("adm-generated-metadata");
            rootElement.setAttribute("root-url", this.rootSourceFile.getUrl().toString());
            rootElement.setAttribute("version", this.getCurrentVersion());
            Element additionalInfoElement = document.createElement("additional-info");
            for (Map.Entry<String, String> entry : this.additionalInfo.entrySet()) {
                Element addInfoEntryElement = document.createElement("entry");
                addInfoEntryElement.setAttribute("key", entry.getKey());
                addInfoEntryElement.setAttribute("value", entry.getValue());
                additionalInfoElement.appendChild(addInfoEntryElement);
            }
            rootElement.appendChild(additionalInfoElement);
            Element sourceFilesElement = document.createElement("source-files");
            Element sourceFilesImportsElement = document.createElement("source-files-imports");
            for (ModelSourceFile sourceFile : this.sourceFiles.values()) {
                this.sourceFileToDOMElements(sourceFile, sourceFilesElement, sourceFilesImportsElement);
            }
            rootElement.appendChild(sourceFilesElement);
            rootElement.appendChild(sourceFilesImportsElement);
            document.appendChild(rootElement);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            try (FileOutputStream os = new FileOutputStream(this.getMetadataFile(this.rootSourceFile.getUrl()));){
                StreamResult result = new StreamResult(os);
                transformer.transform(source, result);
            }
        }
        catch (Exception ex) {
            this.tracer.log("Error saving metadata file " + ex.getMessage(), Tracer.Level.WARNING);
        }
    }

    public boolean isChanged() {
        boolean retVal;
        boolean bl = retVal = !this.metadataLoaded;
        if (!retVal) {
            boolean versionChanged = !this.getCurrentVersion().equals(this.version);
            boolean filesChanged = false;
            for (ModelSourceFile srcFile : this.sourceFiles.values()) {
                if (!srcFile.isChanged(false)) continue;
                filesChanged = true;
                break;
            }
            retVal = !this.metadataLoaded || versionChanged || filesChanged;
        }
        return retVal;
    }

    private void load(URL rootUrl) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            DefaultHandler handler = new DefaultHandler(){
                private ParseState state = ParseState.DEFAULT;
                ModelSourceFile currentSourceFile = null;
                String rootUrlStr = null;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    switch (this.state) {
                        case DEFAULT: {
                            if (localName.equals("adm-generated-metadata")) {
                                this.rootUrlStr = attributes.getValue("root-url");
                                if (this.rootUrlStr == null) {
                                    throw new IllegalStateException("Missing 'root-url' for metadata file");
                                }
                                CgResourceChangeTracker.this.version = attributes.getValue("version");
                                if (CgResourceChangeTracker.this.version == null) {
                                    throw new IllegalStateException("Missing 'version' for metadata file");
                                }
                                this.state = ParseState.ROOT;
                                break;
                            }
                            throw new IllegalStateException("Incorrect start element encountered in state " + (Object)((Object)this.state) + " : " + localName);
                        }
                        case ROOT: {
                            if (localName.equals("additional-info")) {
                                this.state = ParseState.ADDITIONAL_INFO;
                                break;
                            }
                            if (localName.equals("source-files")) {
                                this.state = ParseState.SOURCE_FILES;
                                break;
                            }
                            throw new IllegalStateException("Incorrect start element encountered in state " + (Object)((Object)this.state) + " : " + localName);
                        }
                        case ADDITIONAL_INFO: {
                            if (localName.equals("entry")) {
                                String key = attributes.getValue("key");
                                if (key == null) {
                                    throw new IllegalStateException("...additional-info/entry[@key] cannot be null");
                                }
                                String value = attributes.getValue("value");
                                if (value == null) {
                                    throw new IllegalStateException("...additional-info/entry[@value] cannot be null");
                                }
                                CgResourceChangeTracker.this.additionalInfo.put(key, value);
                                break;
                            }
                            throw new IllegalStateException("Incorrect start element encountered in state " + (Object)((Object)this.state) + " : " + localName);
                        }
                        case SOURCE_FILES: {
                            if (localName.equals("source-file")) {
                                String url = attributes.getValue("url");
                                String modification = attributes.getValue("modification");
                                if (modification == null) {
                                    throw new IllegalStateException("Missing 'modification' for source file");
                                }
                                this.currentSourceFile = new ModelSourceFile(CgResourceChangeTracker.this, CgResourceChangeTracker.urlFromString(url), modification);
                                break;
                            }
                            throw new IllegalStateException("Incorrect start element encountered in state " + (Object)((Object)this.state) + " : " + localName);
                        }
                        case SOURCE_FILES_END: {
                            if (localName.equals("source-files-imports")) {
                                this.state = ParseState.SOURCE_FILES_IMPORTS;
                                break;
                            }
                            throw new IllegalStateException("Incorrect start element encountered in state " + (Object)((Object)this.state) + " : " + localName);
                        }
                        case SOURCE_FILES_IMPORTS: {
                            if (localName.equals("source-file")) {
                                String url = attributes.getValue("url");
                                this.currentSourceFile = (ModelSourceFile)CgResourceChangeTracker.this.sourceFiles.get(CgResourceChangeTracker.urlFromString(url));
                                if (this.currentSourceFile == null) {
                                    throw new IllegalStateException("Defining imports for a missing source file " + url);
                                }
                                this.state = ParseState.IMPORTS_FOR_FILE;
                                break;
                            }
                            throw new IllegalStateException("Incorrect start element encountered in state " + (Object)((Object)this.state) + " : " + localName);
                        }
                        case IMPORTS_FOR_FILE: {
                            if (localName.equals("imported-source-file")) {
                                String url = attributes.getValue("url");
                                ModelSourceFile importedFile = (ModelSourceFile)CgResourceChangeTracker.this.sourceFiles.get(CgResourceChangeTracker.urlFromString(url));
                                this.currentSourceFile.imports.put(importedFile.getUrl(), importedFile);
                                break;
                            }
                            throw new IllegalStateException("Incorrect start element encountered in state " + (Object)((Object)this.state) + " : " + localName);
                        }
                        default: {
                            throw new IllegalStateException("Incorrect value of 'state': " + (Object)((Object)this.state) + " for start element " + localName);
                        }
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) {
                    switch (this.state) {
                        case DEFAULT: {
                            throw new IllegalStateException("Incorrect end element encountered in state " + (Object)((Object)this.state) + " : " + localName);
                        }
                        case ADDITIONAL_INFO: {
                            if (localName.equals("additional-info")) {
                                this.state = ParseState.ROOT;
                                break;
                            }
                            if (localName.equals("entry")) break;
                            throw new IllegalStateException("Incorrect end element encountered in state " + (Object)((Object)this.state) + " : " + localName);
                        }
                        case SOURCE_FILES: {
                            if (localName.equals("source-file")) {
                                CgResourceChangeTracker.this.sourceFiles.put(this.currentSourceFile.getUrl(), this.currentSourceFile);
                                this.currentSourceFile = null;
                                break;
                            }
                            if (localName.equals("source-files")) {
                                this.state = ParseState.SOURCE_FILES_END;
                                break;
                            }
                            throw new IllegalStateException("Incorrect end element encountered in state " + (Object)((Object)this.state) + " : " + localName);
                        }
                        case SOURCE_FILES_IMPORTS: {
                            if (localName.equals("source-files-imports")) {
                                this.state = ParseState.SOURCE_FILES_IMPORTS_END;
                                break;
                            }
                            throw new IllegalStateException("Incorrect end element encountered in state " + (Object)((Object)this.state) + " : " + localName);
                        }
                        case IMPORTS_FOR_FILE: {
                            if (localName.equals("source-file")) {
                                this.currentSourceFile = null;
                                this.state = ParseState.SOURCE_FILES_IMPORTS;
                                break;
                            }
                            if (localName.equals("imported-source-file")) break;
                            throw new IllegalStateException("Incorrect end element encountered in state " + (Object)((Object)this.state) + " : " + localName);
                        }
                        case SOURCE_FILES_IMPORTS_END: {
                            if (localName.equals("adm-generated-metadata")) {
                                CgResourceChangeTracker.this.rootSourceFile = (ModelSourceFile)CgResourceChangeTracker.this.sourceFiles.get(CgResourceChangeTracker.urlFromString(this.rootUrlStr));
                                this.state = ParseState.ROOT_END;
                                break;
                            }
                            throw new IllegalStateException("Incorrect end element encountered in state " + (Object)((Object)this.state) + " : " + localName);
                        }
                        default: {
                            throw new IllegalStateException("Incorrect value of 'state': " + (Object)((Object)this.state) + " for end element " + localName);
                        }
                    }
                }

                @Override
                public final void error(SAXParseException e) throws SAXParseException {
                    throw e;
                }

                @Override
                public final void fatalError(SAXParseException e) throws SAXParseException {
                    throw e;
                }

                @Override
                public final void warning(SAXParseException e) throws SAXParseException {
                    throw e;
                }
            };
            parser.parse(this.getMetadataFile(rootUrl), handler);
            this.metadataLoaded = true;
        }
        catch (Exception ex) {
            this.tracer.log("Error loading metadata file " + ex.getMessage(), Tracer.Level.DEBUG);
        }
    }

    private void sourceFileToDOMElements(ModelSourceFile sourceFile, Element sourceFilesElement, Element sourceFilesImportsElement) throws DOMException, IOException {
        Document document = sourceFilesElement.getOwnerDocument();
        Element sourceFileElement = document.createElement("source-file");
        sourceFileElement.setAttribute("url", sourceFile.getUrl().toString());
        sourceFileElement.setAttribute("modification", sourceFile.getCalculatedModification());
        sourceFilesElement.appendChild(sourceFileElement);
        if (!sourceFile.imports.isEmpty()) {
            Element sourceFileImportsElement = document.createElement("source-file");
            sourceFileImportsElement.setAttribute("url", sourceFile.getUrl().toString());
            for (ModelSourceFile importFile : sourceFile.imports.values()) {
                Element sourceFileImportElement = document.createElement("imported-source-file");
                sourceFileImportElement.setAttribute("url", importFile.getUrl().toString());
                sourceFileImportsElement.appendChild(sourceFileImportElement);
            }
            sourceFilesImportsElement.appendChild(sourceFileImportsElement);
        }
    }

    private ModelSourceFile sourceFile(URL url) {
        if (this.metadataLoaded) {
            throw new IllegalStateException("Method sourceFile cannot be called on parse context from previous code generation run");
        }
        ModelSourceFile retVal = this.sourceFiles.get(url);
        if (retVal == null) {
            retVal = new ModelSourceFile(this, url);
            this.sourceFiles.put(url, retVal);
        }
        return retVal;
    }

    private final File getMetadataFile(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("'url' cannot be null");
        }
        String[] segments = url.toString().split("/");
        String fileName = String.format(".%s_%s.metadata", segments[segments.length - 1], this.getAdditionalInfoDigest());
        File metadataDir = new File(this.dir, ".adm-metadata");
        if (!metadataDir.exists()) {
            metadataDir.mkdirs();
        }
        return new File(metadataDir, fileName);
    }

    private final String getCurrentVersion() {
        String retVal = "unknown";
        if (this.productInfo != null) {
            retVal = this.productInfo.getComponentVersionString();
        }
        return retVal;
    }

    private final String getAdditionalInfoDigest() {
        if (this.additionalInfoDigest == null) {
            StringBuilder sb = new StringBuilder("");
            for (Map.Entry<String, String> entry : this.additionalInfo.entrySet()) {
                sb.append(entry.getKey());
                sb.append("|");
                sb.append(entry.getValue());
                sb.append("#");
            }
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                byte[] checksum = digest.digest(sb.toString().getBytes());
                this.additionalInfoDigest = UtlText.bytesToHexString(checksum);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("MD5 digest algorithm not found");
            }
        }
        return this.additionalInfoDigest;
    }

    public class ModelSourceFile {
        private final URL url;
        private final HashMap<URL, ModelSourceFile> imports = new HashMap();
        private byte[] data;
        private String modification;
        private String calculatedModification;
        private final CgResourceChangeTracker context;

        private ModelSourceFile(CgResourceChangeTracker context, URL url) {
            if (context == null) {
                throw new IllegalArgumentException("Parent 'context' cannot be null");
            }
            this.context = context;
            if (url == null) {
                throw new IllegalArgumentException("'url' cannot be null");
            }
            this.url = url;
        }

        private ModelSourceFile(CgResourceChangeTracker context, URL url, String modification) {
            if (context == null) {
                throw new IllegalArgumentException("Parent 'context' cannot be null");
            }
            this.context = context;
            if (url == null) {
                throw new IllegalArgumentException("'url' cannot be null");
            }
            this.url = url;
            if (modification == null) {
                throw new IllegalArgumentException("'modification' cannot be null");
            }
            this.modification = modification;
        }

        public String getCalculatedModification() throws IOException {
            if (this.calculatedModification == null) {
                URLConnection conn = this.url.openConnection();
                long modifiedTime = conn.getLastModified();
                if (modifiedTime != 0L) {
                    this.calculatedModification = String.valueOf(modifiedTime);
                } else {
                    Adler32 crc = new Adler32();
                    crc.update(this.getData());
                    this.calculatedModification = String.valueOf(crc.getValue());
                }
            }
            return this.calculatedModification;
        }

        public final InputStream getInputStream() throws IOException {
            ByteArrayInputStream retVal = new ByteArrayInputStream(this.getData());
            return retVal;
        }

        public boolean isChanged(boolean recursiveCheck) {
            boolean retVal = true;
            try {
                boolean bl = retVal = this.modification == null || !this.modification.equals(this.getCalculatedModification());
                if (!retVal && recursiveCheck) {
                    ModelSourceFile importFile;
                    Iterator<ModelSourceFile> iterator = this.imports.values().iterator();
                    while (iterator.hasNext() && !(retVal = (importFile = iterator.next()).isChanged(recursiveCheck))) {
                    }
                }
            }
            catch (Exception ex) {
                CgResourceChangeTracker.this.tracer.log("Error calculating source change for file " + this.url + " " + ex.getMessage(), Tracer.Level.WARNING);
            }
            return retVal;
        }

        private byte[] readFully(InputStream is) throws IOException {
            int length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((length = is.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
            byte[] retVal = out.toByteArray();
            return retVal;
        }

        private byte[] getData() throws IOException {
            if (this.data == null) {
                try (InputStream is = this.url.openStream();){
                    this.data = this.readFully(is);
                }
            }
            return this.data;
        }

        public URL getUrl() {
            return this.url;
        }

        public ModelSourceFile importFile(URL url) {
            if (this.context.metadataLoaded) {
                throw new IllegalStateException("Method importFile cannot be called on parse context from previous code generation run");
            }
            ModelSourceFile importedFile = this.context.sourceFile(url);
            if (!this.imports.containsKey(url)) {
                this.imports.put(url, importedFile);
            }
            return importedFile;
        }
    }

    private static enum ParseState {
        DEFAULT,
        ROOT,
        ADDITIONAL_INFO,
        SOURCE_FILES,
        SOURCE_FILES_END,
        SOURCE_FILES_IMPORTS,
        IMPORTS_FOR_FILE,
        SOURCE_FILES_IMPORTS_END,
        ROOT_END;

    }
}

