/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf.test.unit;

import com.neeve.pkt.PktBuffer;
import com.neeve.test.UnitTest;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufFloatField;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.test.unit.XbufStringFieldTest;
import java.nio.ByteOrder;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class XbufFloatFieldTest
extends UnitTest {
    private Random random = new Random(System.currentTimeMillis());

    private final XbufFloatField testSetClearSyncDesync(XbufFloatField field1) {
        float value = this.random.nextFloat();
        field1.setValue(value);
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((double)value, (double)field1.getValue(), (double)0.0);
        Assert.assertEquals((long)(field1.headerLength() + 4), (long)field1.length());
        value = 0.0f;
        field1.setValue(0.0f);
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((double)value, (double)field1.getValue(), (double)0.0);
        Assert.assertEquals((long)(field1.headerLength() + 4), (long)field1.length());
        field1.setValue(this.random.nextFloat());
        Assert.assertTrue((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.hasValue());
        value = 0.0f;
        Assert.assertEquals((double)0.0f, (double)field1.getValue(), (double)0.0);
        PktBuffer buffer1 = PktBuffer.create(null, (int)256, (boolean)false);
        buffer1.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        Assert.assertEquals((long)(field1.headerLength() + 4), (long)field1.sync(buffer1, 10));
        XbufFloatField field2 = XbufFloatField.create(field1.id(), field1.name(), field1.pinned());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + 4), (long)field2.desync(buffer1, 10));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((double)value, (double)field2.getValue(), (double)0.0);
        Assert.assertEquals((long)(field2.headerLength() + 4), (long)field2.length());
        value = this.random.nextFloat();
        field1.setValue(value);
        Assert.assertEquals((long)(field1.headerLength() + 4), (long)field1.sync(buffer1, 23));
        field2 = XbufFloatField.create(field1.id(), field1.name(), field1.pinned());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + 4), (long)field2.desync(buffer1, 23));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((double)value, (double)field2.getValue(), (double)0.0);
        Assert.assertEquals((long)(field2.headerLength() + 4), (long)field2.length());
        return field2;
    }

    @Test
    public final void testInitialState() {
        short id = (short)this.random.nextInt(Short.MAX_VALUE);
        String name = XbufStringFieldTest.randomString();
        XbufFloatField field1 = XbufFloatField.create(id, name, false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.FLOAT), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertEquals((Object)name, (Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertFalse((boolean)field1.variableLength());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertEquals((double)0.0, (double)field1.getValue(), (double)0.0);
        Assert.assertEquals((long)(field1.headerLength() + 4), (long)field1.length());
        field1 = XbufFloatField.create(id, null, true);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.FLOAT), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertNull((Object)field1.name());
        Assert.assertTrue((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertFalse((boolean)field1.variableLength());
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((double)0.0, (double)field1.getValue(), (double)0.0);
        Assert.assertEquals((long)(field1.headerLength() + 4), (long)field1.length());
    }

    @Test
    public final void testInitSetClearSyncDesync_Unpinned_Heap() {
        XbufFloatField field1 = XbufFloatField.create((short)this.random.nextInt(Short.MAX_VALUE), null, false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testInitSetClearSyncDesync_Unpinned_Native() {
        XbufFloatField field1 = XbufFloatField.create((short)this.random.nextInt(Short.MAX_VALUE), null, false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }
}

