/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.google.protobuf.CodedOutputStream;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;

public final class XbufVariableCharField
extends XbufField {
    private final Value value = new Value();

    private XbufVariableCharField(short id, String name) {
        super(XbufField.Type.VARCHAR, id, name, false, false);
    }

    public static XbufVariableCharField create(short id, String name) {
        return new XbufVariableCharField(id, name);
    }

    final int serializedLength(char val) {
        return CodedOutputStream.computeRawVarint32Size((int)val);
    }

    final int serialize(PktBuffer buffer, int offset, char val) {
        return XbufVariableCharField.syncVarint32((int)val, buffer, offset);
    }

    final char deserialize(PktBuffer buffer, int offset) {
        return (char)XbufVariableCharField.desyncVarint32(buffer, offset, this.varintDesyncLength);
    }

    final String toString(char val) {
        return String.valueOf(val);
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        return this.serialize(buffer, offset, this.getValue());
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        this.value.val = this.deserialize(buffer, offset);
        this.container.setValue(this, this.value);
        return this.varintDesyncLength.value;
    }

    @Override
    protected final int contentLength() {
        return this.serializedLength(this.getValue());
    }

    @Override
    protected final String contentAsString() {
        return this.toString(this.getValue());
    }

    @Override
    protected final boolean contentClear() {
        this.value.val = '\u0000';
        return this.container.clearValue(this);
    }

    public final void setValue(char val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        this.value.val = val;
        this.container.setValue(this, this.value);
    }

    public final void setValueFrom(XbufVariableCharField field) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        throw new UnsupportedOperationException();
    }

    public final char getValue() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (this.container.framed[this.index]) {
            return this.deserialize(this.buffer, this.contentOffset);
        }
        Value value = (Value)this.container.fieldValues[this.index];
        return value != null ? value.val : (char)'\u0000';
    }

    static final int serializeField(PktBuffer buffer, int offset, short id, char v) {
        int headerLength = XbufVariableCharField.syncHeader(buffer, offset, id, XbufField.Type.VARCHAR, CodedOutputStream.computeRawVarint32Size((int)v));
        int valLength = XbufVariableCharField.syncVarint32((int)v, buffer, offset + headerLength);
        return headerLength + valLength;
    }

    public static int serializedFieldLength(short id, char v) {
        int len = CodedOutputStream.computeRawVarint32Size((int)v);
        return len + XbufVariableCharField.headerLength(id, XbufField.Type.VARCHAR, len);
    }

    static final char deserializeValue(PktBuffer buffer, int offset, XbufField.VarintDesyncLength varintDesyncLength) {
        return (char)XbufVariableCharField.desyncVarint32(buffer, offset, varintDesyncLength);
    }

    static final char deserializeField(PktBuffer buffer, int offset, short id, XbufField.VarintDesyncLength varintDesyncLength) {
        int tag = XbufVariableCharField.desyncVarint32(buffer, offset, varintDesyncLength);
        int tagLength = varintDesyncLength.value;
        if (id != XbufVariableCharField.fieldId(tag)) {
            throw new IllegalArgumentException("attempt to desync a field using a different field on the wire!");
        }
        char value = XbufVariableCharField.deserializeValue(buffer, offset + tagLength, varintDesyncLength);
        varintDesyncLength.value += tagLength;
        return value;
    }

    private final class Value {
        char val;

        private Value() {
        }
    }
}

