/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.PktBuffer;
import com.neeve.raw.RawType;
import com.neeve.raw.RawUUID;
import com.neeve.raw.impl.RawUUIDImpl;
import com.neeve.xbuf.XbufField;
import java.util.UUID;

public final class XbufUUIDField
extends XbufField {
    private static final long[] CLEAR = new long[]{-1L, -1L};
    private final RawUUIDImpl value = RawUUIDImpl.create((boolean)true);
    static final int SERIALIZED_LENGTH = 16;

    private XbufUUIDField(short id, String name, boolean pinned) {
        super(XbufField.Type.UUID, id, name, pinned);
    }

    private final void serialize(PktBuffer buffer, int offset, RawUUID val) {
        if (val == null || !val.isInitialized()) {
            buffer.putLong(offset, CLEAR[0]);
            buffer.putLong(offset + 8, CLEAR[1]);
        } else {
            buffer.putLong(offset, val.getLeastSignificantBits());
            buffer.putLong(offset + 8, val.getMostSignificantBits());
        }
    }

    private final RawUUIDImpl deserialize(PktBuffer buffer, int offset, RawUUIDImpl val) {
        long lsb = buffer.getLong(offset);
        long msb = buffer.getLong(offset + 8);
        if (lsb == CLEAR[0] && msb == CLEAR[1]) {
            val.reset();
        } else {
            val.initialize(msb, lsb);
        }
        return val;
    }

    public static final RawUUID toRaw(UUID val) {
        if (val == null) {
            return null;
        }
        return RawUUIDImpl.create((UUID)val);
    }

    public static final UUID fromRaw(RawUUID val) {
        if (val == null) {
            return null;
        }
        return (UUID)val.getValue();
    }

    public static final XbufUUIDField create(short id, String name, boolean pinned) {
        return new XbufUUIDField(id, name, pinned);
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        RawUUIDImpl val = (RawUUIDImpl)this.container.fieldValues[this.index];
        this.serialize(buffer, offset, (RawUUID)val);
        return 16;
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        if (length != 16) {
            throw new InternalError("request to deserialize uuid with length != 16 (length=" + length + ")");
        }
        this.container.setValue(this, this.deserialize(buffer, offset, this.value));
        return 16;
    }

    @Override
    protected void contentFramed() {
        this.value.reset();
    }

    @Override
    protected final int contentLength() {
        return 16;
    }

    @Override
    protected final String contentAsString() {
        UUID val = this.getValue();
        return val != null ? val.toString() : "null";
    }

    @Override
    protected final boolean contentClear() {
        this.value.reset();
        if (this.pinned) {
            this.serialize(this.buffer, this.offset, (RawUUID)this.value);
            return true;
        }
        return this.container.clearValue(this);
    }

    public final void setValue(UUID val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        this.value.initialize(val);
        if (this.pinned) {
            this.serialize(this.buffer, this.contentOffset, (RawUUID)this.value);
        } else {
            this.container.setValue(this, this.value);
        }
    }

    public final void setValueFrom(RawUUID val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (this.value != val) {
            if (val == null) {
                this.value.reset();
            } else {
                val.copyInto((RawType)this.value);
            }
        }
        if (this.pinned) {
            this.serialize(this.buffer, this.contentOffset, (RawUUID)this.value);
        } else {
            this.container.setValue(this, this.value);
        }
    }

    public final void setValueFrom(XbufUUIDField field) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        if (field.container.framed[field.index]) {
            if (this.pinned) {
                this.buffer.putFrom(this.contentOffset, (IOElasticBuffer)field.buffer, field.contentOffset, 16);
            } else {
                this.container.setValue(this, this.deserialize(field.buffer, field.contentOffset, this.value));
            }
        } else {
            RawUUIDImpl v = (RawUUIDImpl)field.container.fieldValues[field.index];
            if (v != null) {
                v.copyInto(this.value);
            } else {
                this.value.clear();
            }
            if (this.pinned) {
                this.serialize(this.buffer, this.contentOffset, (RawUUID)this.value);
            } else {
                this.container.setValue(this, this.value);
            }
        }
    }

    public final UUID getValue() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        RawUUIDImpl val = null;
        if (this.pinned || this.container.framed[this.index]) {
            val = this.value;
            this.deserialize(this.buffer, this.contentOffset, val);
        } else {
            val = (RawUUIDImpl)this.container.fieldValues[this.index];
        }
        if (val == null || !val.isInitialized()) {
            return null;
        }
        return val.getValue();
    }

    public final void getValueTo(RawUUID val) {
        if (val == null) {
            throw new IllegalArgumentException("val is null");
        }
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (this.pinned || this.container.framed[this.index]) {
            this.deserialize(this.buffer, this.contentOffset, (RawUUIDImpl)val);
        } else {
            RawUUIDImpl v = (RawUUIDImpl)this.container.fieldValues[this.index];
            if (v != null) {
                v.copyInto(val);
            } else {
                val.clear();
            }
        }
    }

    public final RawUUIDImpl getRawValue() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if ((this.pinned || this.container.framed[this.index]) && !this.value.isInitialized()) {
            this.deserialize(this.buffer, this.contentOffset, this.value);
        }
        return (RawUUIDImpl)this.container.fieldValues[this.index];
    }
}

