/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.IXbufDesyncer;
import com.neeve.xbuf.XbufDesyncPolicy;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufSchema;
import java.nio.ByteOrder;
import java.util.Arrays;

public class XbufFieldContainer
implements Cloneable {
    private final PktBuffer buffer;
    private XbufSchema schema;
    private IXbufDesyncer desyncer;
    private XbufField[] fieldsToSync;
    private int lastFieldToSyncIndex;
    private int lastFieldToSyncIndexAllocated;
    private int[] fieldSyncIndex;
    private boolean wasDesyncd;
    private XbufDesyncPolicy defaultDesyncPolicy;
    private XbufDesyncPolicy desyncPolicy;
    private PktBuffer cleanPinnedBuffer;
    private int lateSyncBoundary;
    private int lateSyncBoundaryMark;
    private int serializedLength;
    private XbufField.VarintDesyncLength varintDesyncLength;
    Object[] fieldValues;
    boolean[] hasValues;
    boolean[] readOnly;
    boolean[] framed;

    private XbufFieldContainer(PktBuffer buffer) {
        this.buffer = buffer;
        if (this.buffer == null) {
            throw new IllegalArgumentException("initial backing buffer cannot be null");
        }
        this.buffer.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.lateSyncBoundary = Integer.MAX_VALUE;
        this.serializedLength = 0;
        this.wasDesyncd = false;
        this.defaultDesyncPolicy = this.desyncPolicy = XbufDesyncPolicy.Copy;
        this.varintDesyncLength = new XbufField.VarintDesyncLength();
    }

    public static XbufFieldContainer create(PktBuffer buffer) {
        return new XbufFieldContainer(buffer);
    }

    private final void initLateSyncBoundary(XbufField[] fields) {
        this.lateSyncBoundaryMark = 0;
        for (int i = 0; i < fields.length; ++i) {
            XbufField field = fields[i];
            if (field.shouldPin()) {
                this.lateSyncBoundaryMark += field.pin(this.lateSyncBoundaryMark, !this.wasDesyncd);
                continue;
            }
            this.lateSyncBoundary = i;
            break;
        }
    }

    private final void initCleanPinnedBuffer(XbufField[] fields) {
        if (this.lateSyncBoundaryMark > 0) {
            int pos = 0;
            this.cleanPinnedBuffer = PktBuffer.create((IOElasticBuffer.Sizer)null, (int)this.lateSyncBoundaryMark, (boolean)this.buffer.isNative());
            for (int i = 0; i < fields.length && i != this.lateSyncBoundary; ++i) {
                fields[i].syncHeader(this.cleanPinnedBuffer, pos, fields[i].contentLength());
                pos += fields[i].length();
            }
        }
    }

    final void setValue(XbufField field, Object val, boolean markDirty) {
        if (field.pinned) {
            throw new InternalError("setValue() invoked by a pinned field");
        }
        this.fieldValues[field.index] = val;
        this.hasValues[field.index] = true;
        if (markDirty) {
            this.serializedLength = -1;
        }
        if (this.fieldSyncIndex[field.index] == -1) {
            this.fieldSyncIndex[field.index] = ++this.lastFieldToSyncIndexAllocated;
        }
        this.fieldsToSync[this.fieldSyncIndex[field.index]] = field;
        this.lastFieldToSyncIndex = Math.max(this.fieldSyncIndex[field.index], this.lastFieldToSyncIndex);
    }

    final void setValue(XbufField field, Object val) {
        this.setValue(field, val, true);
    }

    final void markDirty(XbufField field, Object val) {
        if (this.fieldValues[field.index] != val) {
            this.setValue(field, val, true);
        } else {
            this.serializedLength = -1;
        }
    }

    final boolean clearValue(XbufField field) {
        if (field.pinned) {
            throw new InternalError("clearValue() invoked by a pinned field");
        }
        this.serializedLength = -1;
        if (this.fieldSyncIndex[field.index] >= 0) {
            this.fieldsToSync[this.fieldSyncIndex[field.index]] = null;
            while (this.lastFieldToSyncIndex >= 0 && this.fieldsToSync[this.lastFieldToSyncIndex] == null) {
                --this.lastFieldToSyncIndex;
            }
        }
        boolean ret = this.hasValues[field.index];
        this.fieldValues[field.index] = null;
        this.hasValues[field.index] = false;
        return ret;
    }

    public final Object[] getFieldValues() {
        if (this.schema == null) {
            throw new IllegalStateException("no schema set");
        }
        return this.fieldValues;
    }

    public final boolean[] getHasValues() {
        if (this.schema == null) {
            throw new IllegalStateException("no schema set");
        }
        return this.hasValues;
    }

    public final XbufFieldContainer setDesyncer(IXbufDesyncer desyncer) {
        this.desyncer = desyncer;
        return this;
    }

    public final XbufFieldContainer setSchema(XbufSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException("schema cannot be null");
        }
        if (this.schema != null) {
            throw new IllegalStateException("schema already set");
        }
        this.schema = schema;
        XbufField[] fields = schema.fields();
        int i = 0;
        for (XbufField field : fields) {
            field.init(this, i++);
        }
        this.fieldValues = new Object[fields.length];
        this.hasValues = new boolean[fields.length];
        this.readOnly = new boolean[fields.length];
        this.framed = new boolean[fields.length];
        this.fieldsToSync = new XbufField[fields.length];
        this.lastFieldToSyncIndexAllocated = -1;
        this.lastFieldToSyncIndex = -1;
        this.fieldSyncIndex = new int[fields.length];
        Arrays.fill(this.fieldSyncIndex, 0, this.fieldSyncIndex.length, -1);
        this.initLateSyncBoundary(fields);
        this.initCleanPinnedBuffer(fields);
        if (this.wasDesyncd) {
            this.desync(this.desyncPolicy);
        } else {
            this.serializedLength = this.lateSyncBoundaryMark;
            this.buffer.setLength(this.serializedLength);
        }
        return this;
    }

    public final XbufSchema getSchema() {
        return this.schema;
    }

    public final XbufFieldContainer desync(XbufDesyncPolicy policy) {
        this.wasDesyncd = true;
        this.desyncPolicy = policy;
        if (this.schema != null) {
            int bufferLength = this.buffer.getLength();
            if (policy == XbufDesyncPolicy.FrameContainer) {
                this.lateSyncBoundaryMark = this.serializedLength = bufferLength;
            } else {
                int len;
                boolean frameOnly = policy == XbufDesyncPolicy.FrameFields;
                int pos = this.serializedLength = this.lateSyncBoundaryMark;
                int remaining = bufferLength - this.lateSyncBoundaryMark;
                if (this.desyncer != null) {
                    len = this.desyncer.desync(this.buffer, pos, frameOnly);
                    this.serializedLength += len;
                    pos += len;
                    remaining -= len;
                }
                long[] fieldInterestBitmask = this.schema.getFieldInterest();
                while (remaining > 0) {
                    XbufField field = this.schema.field(XbufField.fieldId(this.buffer, pos, this.varintDesyncLength));
                    if (field != null && (fieldInterestBitmask == null || (fieldInterestBitmask[field.posInSchema >> 6] & 1L << (field.posInSchema & 0x3F)) != 0L)) {
                        len = field.desync(this.buffer, pos, frameOnly);
                        this.serializedLength += len;
                    } else {
                        len = XbufField.skip(this.buffer, pos, this.varintDesyncLength);
                        this.serializedLength += len;
                    }
                    pos += len;
                    remaining -= len;
                }
            }
        } else {
            this.serializedLength = this.buffer.getLength();
        }
        return this;
    }

    public final XbufFieldContainer desync() {
        return this.desync(this.defaultDesyncPolicy);
    }

    public final PktBuffer getBackingBuffer() {
        return this.buffer;
    }

    public final boolean getWasDesyncd() {
        return this.wasDesyncd;
    }

    public final XbufFieldContainer setDesyncPolicy(XbufDesyncPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("desync policy cannot be null");
        }
        this.defaultDesyncPolicy = this.desyncPolicy = policy;
        return this;
    }

    public final XbufDesyncPolicy getDesyncPolicy() {
        return this.desyncPolicy;
    }

    public final int getLateSyncBoundaryFieldNumber() {
        if (this.schema == null) {
            throw new IllegalStateException("no schema set");
        }
        return this.lateSyncBoundary;
    }

    public final XbufField getLateSyncBoundaryField() {
        if (this.schema == null) {
            throw new IllegalStateException("no schema set");
        }
        return this.schema.fields().length > 0 && this.lateSyncBoundary != Integer.MAX_VALUE ? this.schema.fields()[this.lateSyncBoundary] : null;
    }

    public final int getLateSyncBoundaryMark() {
        if (this.schema == null) {
            throw new IllegalStateException("no schema set");
        }
        return this.lateSyncBoundaryMark;
    }

    public final boolean isVariableLength() {
        if (this.schema == null) {
            throw new IllegalStateException("schema not set");
        }
        return this.lateSyncBoundary != Integer.MAX_VALUE;
    }

    public final boolean isDirty() {
        return this.serializedLength == -1;
    }

    public final int getSerializedLength() {
        if (this.serializedLength >= 0) {
            return this.serializedLength;
        }
        int len = 0;
        if (this.schema != null) {
            if (this.lateSyncBoundary == Integer.MAX_VALUE) {
                return this.lateSyncBoundaryMark;
            }
            len = this.lateSyncBoundaryMark;
            for (int i = 0; i <= this.lastFieldToSyncIndex; ++i) {
                XbufField field = this.fieldsToSync[i];
                if (field == null || !this.hasValues[field.index]) continue;
                len += field.length();
            }
        }
        return len;
    }

    public final int syncPrepare() {
        this.buffer.setLength(this.lateSyncBoundaryMark);
        return this.lateSyncBoundaryMark;
    }

    public final void syncDone() {
        this.serializedLength = this.buffer.getLength();
    }

    public final void sync() {
        if (this.schema != null && this.serializedLength == -1) {
            int pos = this.syncPrepare();
            for (int i = 0; i <= this.lastFieldToSyncIndex; ++i) {
                XbufField field = this.fieldsToSync[i];
                if (field == null || !this.hasValues[field.index]) continue;
                pos += field.sync(this.buffer, pos);
            }
            this.syncDone();
        }
    }

    public final void reset() {
        if (this.fieldValues != null) {
            Arrays.fill(this.fieldValues, null);
        }
        if (this.hasValues != null) {
            Arrays.fill(this.hasValues, false);
        }
        if (this.readOnly != null) {
            Arrays.fill(this.readOnly, false);
        }
        if (this.framed != null) {
            Arrays.fill(this.framed, false);
        }
        this.buffer.setLength(0);
        if (this.cleanPinnedBuffer != null) {
            this.buffer.putFrom(0, (IOElasticBuffer)this.cleanPinnedBuffer, 0, this.cleanPinnedBuffer.getLength());
        }
        this.lateSyncBoundaryMark = this.buffer.getLength();
        this.lastFieldToSyncIndex = -1;
        this.wasDesyncd = false;
        this.serializedLength = -1;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; this.schema != null && i < this.schema.fields().length; ++i) {
            String name = this.schema.fields()[i].name();
            sb.append("(").append(name == null ? "null" : name).append("=").append(this.schema.fields()[i].contentAsString()).append(")");
        }
        sb.append("]");
        return sb.toString();
    }
}

