/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmArray;
import com.neeve.adm.AdmCollection;
import com.neeve.adm.AdmEncodingType;
import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmEntityArray;
import com.neeve.adm.AdmEnumeration;
import com.neeve.adm.AdmEnumerationArray;
import com.neeve.adm.AdmFactoryType;
import com.neeve.adm.AdmField;
import com.neeve.adm.AdmGenerator;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmPrimitive;
import com.neeve.adm.AdmPrimitiveArray;
import com.neeve.adm.AdmScopedType;
import com.neeve.adm.AdmSourceCodeBuilder;
import com.neeve.adm.AdmType;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

final class AdmProtobufGenerator
extends AdmGenerator {
    AdmProtobufGenerator() {
    }

    private final String protobufName(AdmScopedType type) {
        return type.getModel().getProtobufOuterClassName() + "." + type.getName();
    }

    private final String protobufName(AdmScopedType usedInType, AdmScopedType type) {
        if (type.getNamespace().equalsIgnoreCase(usedInType.getNamespace())) {
            return type.getModel().getProtobufOuterClassName() + "." + type.getName();
        }
        return type.getNamespace() + "." + type.getModel().getProtobufOuterClassName() + "." + type.getName();
    }

    @Override
    protected final void appendFieldImport(AdmEntity container, AdmField field, boolean forInterface, TreeSet<String> imports) {
        super.appendFieldImport(container, field, forInterface, imports);
        AdmType fieldType = field.getType();
        if (fieldType instanceof AdmPrimitive) {
            AdmPrimitive.Type primitiveType = ((AdmPrimitive)fieldType).getType();
            switch (primitiveType) {
                case UUID: {
                    imports.add("com.neeve.adm.types.protobuf.AdmTypeHelper");
                    break;
                }
            }
            if (primitiveType.hasRawValue()) {
                imports.add(primitiveType.getRawValueType());
                imports.add(primitiveType.getRawValueTypeImpl());
            }
            return;
        }
        if (fieldType instanceof AdmPrimitiveArray) {
            switch (((AdmPrimitiveArray)fieldType).getType()) {
                case UUID: {
                    imports.add("com.neeve.adm.types.protobuf.AdmTypeHelper");
                    break;
                }
            }
            return;
        }
    }

    private final void writeClassDeclaration(AdmCollection collection, AdmSourceCodeBuilder codeBuilder) {
        if (collection.isDeprecated()) {
            codeBuilder.last().appendln("@Deprecated");
        }
        AdmGenerator.writeAdmGeneratedAnnotations(this.getClass(), AdmEncodingType.Protobuf, collection.getModel(), codeBuilder);
        AdmGenerator.writeFactoryTypeInfoAnnotation(collection, codeBuilder);
        codeBuilder.last().append("final public class " + collection.getName() + " extends ");
        switch (collection.getType()) {
            case List: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogList}<");
                break;
            }
            case Queue: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogQueue}<");
                break;
            }
            case ByteMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXByteMap}<");
                break;
            }
            case CharMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXCharMap}<");
                break;
            }
            case ShortMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXShortMap}<");
                break;
            }
            case IntMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXIntMap}<");
                break;
            }
            case LongMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXLongMap}<");
                break;
            }
            case FloatMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXFloatMap}<");
                break;
            }
            case DoubleMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXDoubleMap}<");
                break;
            }
            case StringMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogStringMap}<");
                break;
            }
            default: {
                throw new IllegalStateException("unknown collection type '" + (Object)((Object)collection.getType()) + "'");
            }
        }
        codeBuilder.last().append(collection.getContains().getTemplatedJavaTypeName() + "> implements " + AdmProtobufGenerator.interfaceTemplatedTypeName(collection));
        codeBuilder.last().append(", %{com.neeve.rog.IRogJsonizable}");
        codeBuilder.last().appendln(" {");
    }

    private final void writeClassDeclaration(AdmEntity entity, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        AdmProtobufGenerator.writeJavadocTypeComment("", entity, codeBuilder);
        AdmGenerator.writeAdmGeneratedAnnotations(this.getClass(), AdmEncodingType.Protobuf, entity.getModel(), codeBuilder);
        AdmGenerator.writeFactoryTypeInfoAnnotation(entity, codeBuilder);
        AdmGenerator.writeJsonPropertyOrderAnnotation(entity, fields, codeBuilder);
        codeBuilder.last().append(entity.isFinal() ? "final " : "").append("public class " + entity.getName());
        if (!entity.isEmbedded()) {
            if (entity.isRoot()) {
                codeBuilder.last().append(" extends %{com.neeve.rog.impl.RogRootNode}");
            } else if (entity.containsChildren()) {
                codeBuilder.last().append(" extends %{com.neeve.rog.impl.RogContainerNode}");
            } else {
                codeBuilder.last().append(" extends %{com.neeve.rog.impl.RogNode}");
            }
            codeBuilder.last().append(" implements " + AdmProtobufGenerator.interfaceTemplatedTypeName(entity));
            codeBuilder.last().append(", %{com.neeve.rog.IRogJsonizable}");
            if (this.isMessageReflectorImpl(entity, fields)) {
                codeBuilder.last().append(", %{com.neeve.sma.MessageReflector}");
            }
        } else if (entity.getGenerateEmbeddedEntityInterfaces()) {
            codeBuilder.last().append(" implements ");
            codeBuilder.last().append(AdmProtobufGenerator.interfaceTemplatedTypeName(entity));
        } else {
            codeBuilder.last().append(" implements %{com.neeve.rog.IRogValidatable}");
        }
        codeBuilder.last().appendln(" {");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("   /**");
        codeBuilder.last().appendln("    * A preallocated empty array used to avoid garbage when returning empty arrays of this type.");
        codeBuilder.last().appendln("    */");
        codeBuilder.last().appendln("   final public static " + entity.getTemplatedJavaTypeName() + "[] EMPTY_ARRAY = new " + entity.getTemplatedJavaTypeName() + "[0];");
    }

    private final void writeInitializer(List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Initializer -----");
        codeBuilder.last().appendln("    {");
        this.writeFieldBitmaskInitializer(fields, codeBuilder);
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    // ----- Initializer -----");
    }

    private final void writeProtobufFields(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    private " + this.protobufName(type) + " _protoMessage;");
        codeBuilder.last().appendln("    private " + this.protobufName(type) + ".Builder _protoBuilder;");
    }

    private final void writeConstructors(AdmCollection collection, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Constructors -----");
        codeBuilder.last().appendln("    " + collection.getTemplatedJavaTypeName() + "(final %{com.eaio.uuid.UUID} id) {");
        codeBuilder.last().appendln("        super(" + collection.getFactory().getName() + ".OFID,");
        codeBuilder.last().appendln("              " + collection.getFactory().getName() + ".VFID,");
        codeBuilder.last().appendln("              " + collection.getFactory().getName() + ".ID_" + collection.getName() + ",");
        codeBuilder.last().appendln("              id,");
        codeBuilder.last().appendln("              " + collection.isTransactional() + ");");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    public static " + collection.getTemplatedJavaTypeName() + " create() {return " + collection.getFactory().getName() + ".create" + collection.getName() + "();}");
        codeBuilder.last().appendln("    // -----Constructors -----");
    }

    private final void writeConstructors(AdmEntity entity, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Constructors -----");
        if (entity.isEmbedded()) {
            codeBuilder.last().appendln("    public " + entity.getName() + "() {");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    " + entity.getName() + "(" + this.protobufName(entity) + " protoMessage) {");
            codeBuilder.last().appendln("        if (protoMessage != null) {");
            codeBuilder.last().appendln("            message(protoMessage);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create() {return new " + entity.getName() + "();}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromProtoMessage(final " + this.protobufName(entity) + " protoMessage) {return new " + entity.getName() + "(protoMessage);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedProtoMessage(final %{java.nio.ByteBuffer} serializedProtoMessage) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            final %{com.google.protobuf.CodedInputStream} cis = %{com.google.protobuf.CodedInputStream}.newInstance(%{com.neeve.util.UtlBuffer}.inputStream(serializedProtoMessage));");
            codeBuilder.last().appendln("            cis.setSizeLimit(serializedProtoMessage.remaining());");
            codeBuilder.last().appendln("            return new " + entity.getName() + "(" + this.protobufName(entity) + ".parseFrom(cis));");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedProtoMessage(final byte[] serializedProtoMessage) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            return new " + entity.getName() + "(" + this.protobufName(entity) + ".parseFrom(serializedProtoMessage));");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedProtoMessage(final %{com.neeve.pkt.PktPacket} serializedProtoMessage) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            final %{com.neeve.pkt.PktBuffer} buffer = serializedProtoMessage.getBody().getBuffer();");
            codeBuilder.last().appendln("            final %{com.google.protobuf.CodedInputStream} cis = %{com.google.protobuf.CodedInputStream}.newInstance(buffer.inputStream(0));");
            codeBuilder.last().appendln("            cis.setSizeLimit(buffer.getLength());");
            codeBuilder.last().appendln("            return new " + entity.getName() + "(" + this.protobufName(entity) + ".parseFrom(cis));");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFrom(final byte[] serializedProtoMessage) {return createFromSerializedProtoMessage(serializedProtoMessage);}");
        } else if (entity.isRoot()) {
            codeBuilder.last().appendln("    " + entity.getName() + "() {");
            codeBuilder.last().appendln("        this(-1, null, null);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    " + entity.getName() + "(final int grid, final %{com.eaio.uuid.UUID} id, final " + this.protobufName(entity) + " protoMessage) {");
            codeBuilder.last().appendln("        super(" + entity.getFactory().getName() + ".OFID,");
            codeBuilder.last().appendln("              " + entity.getFactory().getName() + ".VFID,");
            codeBuilder.last().appendln("              " + entity.getFactory().getName() + ".ID_" + entity.getName() + ",");
            codeBuilder.last().appendln("              id,");
            codeBuilder.last().appendln("              " + entity.isTransactional() + ",");
            codeBuilder.last().appendln("              grid);");
            codeBuilder.last().appendln("        if (protoMessage != null) {");
            codeBuilder.last().appendln("            message(protoMessage);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            setMessage(%{com.neeve.sma.MessageView}.ENCODING_TYPE_PROTOBUF, null);");
            codeBuilder.last().appendln("        }");
            if (this.isMessageReflectorImpl(entity, fields)) {
                codeBuilder.last().appendln("");
                codeBuilder.last().appendln("        if (USE_FIELD_REFLECTORS) {");
                codeBuilder.last().appendln("            setMessageReflector(this);");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create(final int grid) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "(grid);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create(final int grid, final %{com.eaio.uuid.UUID} id) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "(grid, id);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromProtoMessage(final int grid, final " + this.protobufName(entity) + " protoMessage) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromProtoMessage(grid, protoMessage);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedProtoMessage(final int grid, final %{java.nio.ByteBuffer} serializedProtoMessage) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromSerializedProtoMessage(grid, serializedProtoMessage);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedProtoMessage(final int grid, final byte[] serializedProtoMessage) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromSerializedProtoMessage(grid, serializedProtoMessage);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedProtoMessage(final int grid, final %{com.neeve.pkt.PktPacket} serializedProtoMessage) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromSerializedProtoMessage(grid, serializedProtoMessage);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFrom(final int grid, final byte[] serializedProtoMessage) {return createFromSerializedProtoMessage(grid, serializedProtoMessage);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromRawJson(final int grid, final String json) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromRawJson(grid, json);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromJson(final int grid, final String json) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromJson(grid, json);}");
        } else {
            codeBuilder.last().appendln("    " + entity.getName() + "() {");
            codeBuilder.last().appendln("        this(null, null);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    " + entity.getName() + "(final %{com.eaio.uuid.UUID} id, final " + this.protobufName(entity) + " protoMessage) {");
            codeBuilder.last().appendln("        super(" + entity.getFactory().getName() + ".OFID,");
            codeBuilder.last().appendln("              " + entity.getFactory().getName() + ".VFID,");
            codeBuilder.last().appendln("              " + entity.getFactory().getName() + ".ID_" + entity.getName() + ",");
            codeBuilder.last().appendln("              id,");
            codeBuilder.last().appendln("              " + entity.isTransactional() + ");");
            codeBuilder.last().appendln("        if (protoMessage != null) {");
            codeBuilder.last().appendln("            message(protoMessage);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            setMessage(%{com.neeve.sma.MessageView}.ENCODING_TYPE_PROTOBUF, null);");
            codeBuilder.last().appendln("        }");
            if (this.isMessageReflectorImpl(entity, fields)) {
                codeBuilder.last().appendln("");
                codeBuilder.last().appendln("        if (USE_FIELD_REFLECTORS) {");
                codeBuilder.last().appendln("            setMessageReflector(this);");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create() {return " + entity.getFactory().getName() + ".create" + entity.getName() + "();}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create(final %{com.eaio.uuid.UUID} id) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "(id);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromProtoMessage(final " + this.protobufName(entity) + " protoMessage) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromProtoMessage(protoMessage);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedProtoMessage(final %{java.nio.ByteBuffer} serializedProtoMessage) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromSerializedProtoMessage(serializedProtoMessage);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedProtoMessage(final byte[] serializedProtoMessage) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromSerializedProtoMessage(serializedProtoMessage);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedProtoMessage(final %{com.neeve.pkt.PktPacket} serializedProtoMessage) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromSerializedProtoMessage(serializedProtoMessage);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFrom(final byte[] serializedProtoMessage) {return createFromSerializedProtoMessage(serializedProtoMessage);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromRawJson(final String json) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromRawJson(json);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromJson(final String json) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromJson(json);}");
        }
        codeBuilder.last().appendln("    // -----Constructors -----");
    }

    private final void writeXRogTypeGetterMethod(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonProperty}(\"xRogType\")");
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonInclude}(value=JsonInclude.Include.ALWAYS)");
        codeBuilder.last().appendln("    final private short " + AdmProtobufGenerator.fieldGetterMethodName("xRogType") + "() {");
        codeBuilder.last().appendln("        return getType();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeClearCachedFieldValuesMethod(List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final private void clearCachedFieldValues() {");
        for (AdmField field : fields) {
            AdmType fieldType = field.getType();
            if (fieldType instanceof AdmEntity && ((AdmEntity)fieldType).isEmbedded()) {
                codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldValueVarName(field) + " = null;");
                continue;
            }
            if (!(fieldType instanceof AdmArray)) continue;
            codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldValueVarName(field) + " = null;");
        }
        codeBuilder.last().appendln("    }");
    }

    final void writeClearContentMethod(List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public void clearContent() {");
        for (AdmField field : fields) {
            AdmType fieldType = field.getType();
            if (fieldType instanceof AdmCollection || fieldType instanceof AdmEntity && !((AdmEntity)fieldType).isEmbedded()) continue;
            if (fieldType instanceof AdmEntity) {
                codeBuilder.last().appendln("        if (" + AdmProtobufGenerator.fieldGetterMethodName(field) + "() != null) {");
                codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldGetterMethodName(field) + "().clearContent();");
                codeBuilder.last().appendln("        }");
            } else if (fieldType instanceof AdmEntityArray) {
                codeBuilder.last().appendln("        if (" + AdmProtobufGenerator.fieldGetterMethodName(field) + "() != null) {");
                codeBuilder.last().appendln("            for (" + ((AdmEntityArray)fieldType).getType().getTemplatedJavaTypeName() + " v : " + AdmProtobufGenerator.fieldGetterMethodName(field) + "()) {");
                codeBuilder.last().appendln("                if (v != null) {");
                codeBuilder.last().appendln("                    v.clearContent();");
                codeBuilder.last().appendln("                }");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeProtobufBuilderRetrieverMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        if (type instanceof AdmMessage && ((AdmMessage)type).fields().isEmpty()) {
            return;
        }
        boolean isEmbeddedEntity = type instanceof AdmEntity && ((AdmEntity)type).isEmbedded();
        codeBuilder.last().appendln("    final private " + this.protobufName(type) + ".Builder builder() {");
        codeBuilder.last().appendln("        if (_protoBuilder != null) {");
        codeBuilder.last().appendln("            if (_protoMessage != null) {");
        codeBuilder.last().appendln("                _protoMessage = null;");
        if (!(type instanceof AdmMessage) && !isEmbeddedEntity) {
            codeBuilder.last().appendln("                setMessage(%{com.neeve.sma.MessageView}.ENCODING_TYPE_PROTOBUF, null);");
        }
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return _protoBuilder;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else if (_protoMessage != null) {");
        codeBuilder.last().appendln("            _protoBuilder = " + this.protobufName(type) + ".newBuilder();");
        codeBuilder.last().appendln("            _protoBuilder.mergeFrom(_protoMessage);");
        if (!isEmbeddedEntity) {
            codeBuilder.last().appendln("            _protoBuilder." + AdmProtobufGenerator.fieldSetterMethodName("xRogType") + "(getType());");
        }
        codeBuilder.last().appendln("            _protoMessage = null;");
        if (!(type instanceof AdmMessage) && !isEmbeddedEntity) {
            codeBuilder.last().appendln("            setMessage(%{com.neeve.sma.MessageView}.ENCODING_TYPE_PROTOBUF, null);");
        }
        codeBuilder.last().appendln("            return _protoBuilder;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            _protoBuilder = " + this.protobufName(type) + ".newBuilder();");
        if (!isEmbeddedEntity) {
            codeBuilder.last().appendln("            _protoBuilder." + AdmProtobufGenerator.fieldSetterMethodName("xRogType") + "(getType());");
        }
        codeBuilder.last().appendln("            return _protoBuilder;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeProtobufMessageRetrieverMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        boolean isEmbeddedEntity = type instanceof AdmEntity && ((AdmEntity)type).isEmbedded();
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * This method is for internal platform use only, and is <b>NOT</b>");
        codeBuilder.last().appendln("     * safe for use by application code.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public " + this.protobufName(type) + " message() {");
        codeBuilder.last().appendln("        if (_protoMessage != null) {");
        codeBuilder.last().appendln("            return _protoMessage;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else if (_protoBuilder != null) {");
        codeBuilder.last().appendln("            _protoMessage = _protoBuilder.build();");
        codeBuilder.last().appendln("            // _protoBuilder = null;");
        codeBuilder.last().appendln("            return _protoMessage;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            _protoBuilder = " + this.protobufName(type) + ".newBuilder();");
        if (!isEmbeddedEntity) {
            codeBuilder.last().appendln("            _protoBuilder." + AdmProtobufGenerator.fieldSetterMethodName("xRogType") + "(getType());");
        }
        codeBuilder.last().appendln("            _protoMessage = _protoBuilder.build();");
        codeBuilder.last().appendln("            _protoBuilder = null;");
        codeBuilder.last().appendln("            return _protoMessage;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeProtobufMessageOrBuilderRetrieverMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        boolean isEmbeddedEntity = type instanceof AdmEntity && ((AdmEntity)type).isEmbedded();
        codeBuilder.last().appendln("    final private " + this.protobufName(type) + "OrBuilder messageOrBuilder() {");
        codeBuilder.last().appendln("        if (_protoBuilder != null) {");
        codeBuilder.last().appendln("            return _protoBuilder;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else if (_protoMessage != null) {");
        codeBuilder.last().appendln("            return _protoMessage;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            _protoBuilder = " + this.protobufName(type) + ".newBuilder();");
        if (!isEmbeddedEntity) {
            codeBuilder.last().appendln("            _protoBuilder." + AdmProtobufGenerator.fieldSetterMethodName("xRogType") + "(getType());");
        }
        codeBuilder.last().appendln("            return _protoBuilder;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeProtobufMessageSetterMethod(AdmScopedType type, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final private void message(" + this.protobufName(type) + " val) {");
        codeBuilder.last().appendln("        _protoMessage  = val;");
        codeBuilder.last().appendln("        _protoBuilder = null;");
        for (AdmField field : fields) {
            AdmType fieldType = field.getType();
            if (fieldType instanceof AdmEntity && ((AdmEntity)fieldType).isEmbedded()) {
                codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldGetterMethodName(field) + "();");
                continue;
            }
            if (!(fieldType instanceof AdmEntityArray)) continue;
            codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldGetterMethodName(field) + "();");
        }
        if (type instanceof AdmCollection || !((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("        setMessage(%{com.neeve.sma.MessageView}.ENCODING_TYPE_PROTOBUF, val);");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeProtobufIsDirtyCheckerMethod(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public boolean isDirty() {");
        codeBuilder.last().appendln("        return (_protoBuilder != null || _protoMessage == null);");
        codeBuilder.last().appendln("    }");
    }

    private final void writeProtobufManagementMethods(AdmScopedType type, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Message/builder retrieval methods -----");
        this.writeProtobufBuilderRetrieverMethod(type, codeBuilder);
        this.writeProtobufMessageRetrieverMethod(type, codeBuilder);
        if (type instanceof AdmEntity) {
            AdmEntity entity = (AdmEntity)type;
            boolean embeddedFields = false;
            for (AdmField field : ((AdmEntity)type).fields().values()) {
                if (!field.isEmbedded()) continue;
                embeddedFields = true;
                break;
            }
            if (embeddedFields || !entity.containedInSet().isEmpty()) {
                this.writeProtobufMessageOrBuilderRetrieverMethod(type, codeBuilder);
            }
        }
        this.writeProtobufMessageSetterMethod(type, fields, codeBuilder);
        this.writeProtobufIsDirtyCheckerMethod(codeBuilder);
        codeBuilder.last().appendln("    // ----- Message/builder retrieval methods -----");
    }

    private final void writeEmbeddedEntityIsBufferBacked(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public boolean isBufferBacked() {");
        codeBuilder.last().appendln("        return false;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntityGetSerializeToNativeLength(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    final public int getSerializeToNativeLength() {");
        codeBuilder.last().appendln("        return serializeToByteArray().length;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntitySerializeToNativeMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public int serializeToNative(final long address, final int addressOffset) {");
        codeBuilder.last().appendln("        final byte[] bytes = serializeToByteArray();");
        codeBuilder.last().appendln("        final %{com.neeve.io.IOBuffer} buf = %{com.neeve.io.IOBuffer}.create(bytes.length, true);");
        codeBuilder.last().appendln("        buf.getBufferUnsafe().put(bytes, 0, bytes.length);");
        codeBuilder.last().appendln("        %{com.neeve.util.UtlBuffer}.copyToNative(buf.getBufferUnsafe(), 0, address, addressOffset, bytes.length);");
        codeBuilder.last().appendln("        buf.dispose();");
        codeBuilder.last().appendln("        return bytes.length;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntityDeserializeFromNativeMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromNative(final long address, final int addressOffset, final int length) {");
        codeBuilder.last().appendln("        final %{com.neeve.io.IOBuffer} buf = %{com.neeve.io.IOBuffer}.create(length, true);");
        codeBuilder.last().appendln("        %{com.neeve.util.UtlBuffer}.copyFromNative(address, addressOffset, buf.getBufferUnsafe(), 0, length);");
        codeBuilder.last().appendln("        deserializeFromByteBuffer(buf.takeBuffer());");
        codeBuilder.last().appendln("        buf.releaseBuffer().dispose();");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntityPoolingMethods(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Pooling related methods -----");
        codeBuilder.last().appendln("    final public boolean isReferenceCounted() {");
        codeBuilder.last().appendln("        return false;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public " + entity.getTemplatedJavaTypeName() + " acquire() {");
        codeBuilder.last().appendln("        // NO-OP");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public int getOwnerCount() {");
        codeBuilder.last().appendln("        return Integer.MAX_VALUE;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public void dispose() {");
        codeBuilder.last().appendln("        // NO-OP");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    // ----- Pooling related methods -----");
    }

    private final void writeSerializeToProtobufMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + this.protobufName(type) + " serializeToProtobuf() {");
        if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("        throw new UnsupportedOperationException();");
        } else {
            codeBuilder.last().appendln("        sync();");
            codeBuilder.last().appendln("        final " + this.protobufName(type) + " message = (" + this.protobufName(type) + ")getMessage(); ");
            if (!(type instanceof AdmMessage)) {
                codeBuilder.last().appendln("        builder();");
            }
            codeBuilder.last().appendln("        return message;");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToRawJsonMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public String serializeToRawJson() {");
        codeBuilder.last().appendln("        final java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            " + type.getFactory().getName() + ".mapper.writeValue(baos, this);");
        codeBuilder.last().appendln("            return new String(baos.toByteArray(), \"utf-8\");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
        codeBuilder.last().appendln("                throw (RuntimeException)e;");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                throw new RuntimeException(e);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToJsonMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public String serializeToJson() {");
        if (!(type instanceof AdmCollection)) {
            codeBuilder.last().appendln("        syncFieldBitmask();");
        }
        codeBuilder.last().appendln("        return serializeToRawJson();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromProtobufMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromProtobuf(final com.google.protobuf.Message message) {");
        if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("        throw new UnsupportedOperationException();");
        } else {
            codeBuilder.last().appendln("        clearCachedFieldValues();");
            codeBuilder.last().appendln("        message((" + this.protobufName(type) + ")message);");
            codeBuilder.last().appendln("        return this;");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromRawJsonMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromRawJson(final String json) {");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            clearContent();");
        codeBuilder.last().appendln("            " + type.getFactory().getName() + ".mapper.reader().withValueToUpdate(this).readValue(json);");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            throw new RuntimeException(e);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromJsonMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromJson(final String json) {");
        codeBuilder.last().appendln("        deserializeFromRawJson(json);");
        if (!(type instanceof AdmCollection)) {
            codeBuilder.last().appendln("        desyncFieldBitmask();");
        }
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeImplementedIRogNodeMethods(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- IRogNode methods -----");
        this.writeSerializeToProtobufMethod(type, codeBuilder);
        this.writeSerializeToRawJsonMethod(type, codeBuilder);
        this.writeSerializeToJsonMethod(type, codeBuilder);
        this.writeDeserializeFromProtobufMethod(type, codeBuilder);
        this.writeDeserializeFromRawJsonMethod(type, codeBuilder);
        this.writeDeserializeFromJsonMethod(type, codeBuilder);
        codeBuilder.last().appendln("    // ----- IRogNode methods -----");
    }

    private final void writeOverridenRogNodeMethods(AdmScopedType type, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- RogNode methods -----");
        this.writeReadOnlyGetterSetterMethods(type, fields, codeBuilder);
        codeBuilder.last().appendln("    // ----- RogNode methods -----");
    }

    private final void writeUserPrimitiveFieldMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmPrimitive fieldType = (AdmPrimitive)field.getType();
        AdmPrimitive.Type primitiveType = fieldType.getType();
        String javaPrimitive = fieldType.getTemplatedPrimitiveTypeName();
        boolean hasInterface = (!entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces()) && !field.getName().startsWith("xRog");
        String finalModifier = AdmProtobufGenerator.fieldAccessorFinalModifier(entity);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(final " + javaPrimitive + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        final " + javaPrimitive + " old = " + AdmProtobufGenerator.fieldGetterMethodName(field) + "();");
            if (!fieldType.isWrappedPrimitive()) {
                codeBuilder.last().appendln("        if ((val == null && val != old) || (val != null && !val.equals(old))) {");
            } else {
                codeBuilder.last().appendln("        if (val != old) {");
            }
            codeBuilder.last().appendln("            recordFieldUpdate(" + AdmProtobufGenerator.fieldIdxFieldVarName(field) + ", old, val);");
            codeBuilder.last().appendln("        }");
        }
        switch (primitiveType) {
            case Byte: 
            case Short: 
            case Char: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: {
                codeBuilder.last().appendln("        builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(val);");
                break;
            }
            case String: {
                codeBuilder.last().appendln("        if (val != null) {");
                codeBuilder.last().appendln("           builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(val);");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("           builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
                codeBuilder.last().appendln("        }");
                break;
            }
            case UUID: {
                codeBuilder.last().appendln("        if (val == null) {");
                codeBuilder.last().appendln("           builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("            builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.types.protobuf.AdmTypeHelper}.toAdmUUID(val));");
                codeBuilder.last().appendln("        }");
                break;
            }
            case Date: {
                codeBuilder.last().appendln("        if (val != null) {");
                codeBuilder.last().appendln("           builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(val.getTime());");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("           builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
                codeBuilder.last().appendln("        }");
                break;
            }
            case Currency: {
                codeBuilder.last().appendln("        if (val != null) {");
                codeBuilder.last().appendln("           builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(val.getCurrencyCode());");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("           builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
                codeBuilder.last().appendln("        }");
            }
        }
        codeBuilder.last().appendln("    }");
        switch (primitiveType) {
            case Byte: 
            case Short: 
            case Char: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: {
                codeBuilder.newCodeSegment();
                codeBuilder.last().appendln();
                this.writeDeprecationComment("    ", field, codeBuilder);
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterMethodName(field) + "AsObject(" + primitiveType.getJavaTypeName() + " val) {");
                codeBuilder.last().appendln("        if (val == null) {");
                codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(val);");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("    }");
                break;
            }
        }
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        switch (primitiveType) {
            case Byte: 
            case Short: 
            case Char: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: {
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                break;
            }
            case UUID: 
            case String: 
            case Date: 
            case Currency: {
                this.writeJsonGetterAnnotations(field, codeBuilder);
                break;
            }
        }
        codeBuilder.last().appendln("    " + finalModifier + "public " + javaPrimitive + " " + AdmProtobufGenerator.fieldGetterMethodName(field) + "() {");
        switch (primitiveType) {
            case Byte: {
                codeBuilder.last().appendln("        return messageOrBuilder()." + AdmProtobufGenerator.fieldCheckerMethodName(field) + "() ? (" + javaPrimitive + ")messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "() : (byte)0;");
                break;
            }
            case Short: {
                codeBuilder.last().appendln("        return messageOrBuilder()." + AdmProtobufGenerator.fieldCheckerMethodName(field) + "() ? (" + javaPrimitive + ")messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "() : (short)0;");
                break;
            }
            case Char: {
                codeBuilder.last().appendln("        return messageOrBuilder()." + AdmProtobufGenerator.fieldCheckerMethodName(field) + "() ? (" + javaPrimitive + ")messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "() : (char)0;");
                break;
            }
            case Integer: {
                codeBuilder.last().appendln("        return messageOrBuilder()." + AdmProtobufGenerator.fieldCheckerMethodName(field) + "() ? messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "() : 0;");
                break;
            }
            case Long: {
                codeBuilder.last().appendln("        return messageOrBuilder()." + AdmProtobufGenerator.fieldCheckerMethodName(field) + "() ? messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "() : 0L;");
                break;
            }
            case Float: {
                codeBuilder.last().appendln("        return messageOrBuilder()." + AdmProtobufGenerator.fieldCheckerMethodName(field) + "() ? messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "() : (float)0;");
                break;
            }
            case Double: {
                codeBuilder.last().appendln("        return messageOrBuilder()." + AdmProtobufGenerator.fieldCheckerMethodName(field) + "() ? messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "() : (double)0;");
                break;
            }
            case Boolean: {
                codeBuilder.last().appendln("        return messageOrBuilder()." + AdmProtobufGenerator.fieldCheckerMethodName(field) + "() ? messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "() : false;");
                break;
            }
            case String: {
                codeBuilder.last().appendln("        return messageOrBuilder()." + AdmProtobufGenerator.fieldCheckerMethodName(field) + "() ? messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "() : null;");
                break;
            }
            case UUID: {
                codeBuilder.last().appendln("        if (!messageOrBuilder()." + AdmProtobufGenerator.fieldCheckerMethodName(field) + "()) {");
                codeBuilder.last().appendln("            return null;");
                codeBuilder.last().appendln("        } ");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("            return %{com.neeve.adm.types.protobuf.AdmTypeHelper}.toUUID(messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "());");
                codeBuilder.last().appendln("        }");
                break;
            }
            case Date: {
                codeBuilder.last().appendln("        return messageOrBuilder()." + AdmProtobufGenerator.fieldCheckerMethodName(field) + "() ? new java.util.Date(messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "()) : null;");
                break;
            }
            case Currency: {
                codeBuilder.last().appendln("        return messageOrBuilder()." + AdmProtobufGenerator.fieldCheckerMethodName(field) + "() ? Currency.getInstance(messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "()) : null;");
            }
        }
        codeBuilder.last().appendln("    }");
        switch (primitiveType) {
            case Byte: 
            case Short: 
            case Char: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: {
                codeBuilder.newCodeSegment();
                this.writeDeprecationComment("    ", field, codeBuilder);
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                this.writeJsonGetterAnnotations(field, codeBuilder);
                codeBuilder.last().appendln("    " + finalModifier + "public " + primitiveType.getJavaTypeName() + " " + AdmProtobufGenerator.fieldGetterMethodName(field) + "AsObject() {");
                codeBuilder.last().appendln("        if (!" + AdmProtobufGenerator.fieldCheckerMethodName(field) + "()) return null;");
                codeBuilder.last().appendln("        return " + AdmProtobufGenerator.fieldGetterMethodName(field) + "();");
                codeBuilder.last().appendln("    }");
                break;
            }
        }
        if (primitiveType == AdmPrimitive.Type.Date) {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterAsTimestampMethodName(field) + "(final long val) {");
            this.writeReadOnlyValidator(entity, codeBuilder);
            if (!entity.isEmbedded() && entity.isTransactional()) {
                codeBuilder.last().appendln("        final long old = " + AdmProtobufGenerator.fieldGetterAsTimestampMethodName(field) + "();");
                codeBuilder.last().appendln("        if (val != old) {");
                codeBuilder.last().appendln("            recordFieldUpdate(" + AdmProtobufGenerator.fieldIdxFieldVarName(field) + ", old >= 0l ? new Date(old) : null, val >= 0l ? new Date(val) : null);");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("        if (val >= 0l) {");
            codeBuilder.last().appendln("            builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(val);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public long " + AdmProtobufGenerator.fieldGetterAsTimestampMethodName(field) + "() {");
            codeBuilder.last().appendln("        return messageOrBuilder()." + AdmProtobufGenerator.fieldCheckerMethodName(field) + "() ? messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "() : -1l;");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public Long " + AdmProtobufGenerator.fieldGetterMethodName(field) + "AsTimestampObject() {");
            codeBuilder.last().appendln("        if (!" + AdmProtobufGenerator.fieldCheckerMethodName(field) + "()) return null;");
            codeBuilder.last().appendln("        return " + AdmProtobufGenerator.fieldGetterMethodName(field) + "AsTimestamp();");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterAsInstantMethodName(field) + "(final %{java.time.Instant} val) {");
            if (!entity.isEmbedded() && entity.isTransactional()) {
                this.writeReadOnlyValidator(entity, codeBuilder);
                codeBuilder.last().appendln("        final %{java.time.Instant} existing = " + AdmProtobufGenerator.fieldGetterAsInstantMethodName(field) + "();");
                codeBuilder.last().appendln("        if (val != existing) {");
                codeBuilder.last().appendln("            recordFieldUpdate(" + AdmProtobufGenerator.fieldIdxFieldVarName(field) + ", " + AdmProtobufGenerator.fieldGetterMethodName(field) + "(), val != null ? new Date(val.toEpochMilli()) : null);");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("           " + AdmProtobufGenerator.fieldSetterAsTimestampMethodName(field) + "(val.toEpochMilli());");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("           " + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public %{java.time.Instant} " + AdmProtobufGenerator.fieldGetterAsInstantMethodName(field) + "() {");
            codeBuilder.last().appendln("        if (!" + AdmProtobufGenerator.fieldCheckerMethodName(field) + "()) return null;");
            codeBuilder.last().appendln("        return %{java.time.Instant}.ofEpochMilli(" + AdmProtobufGenerator.fieldGetterAsTimestampMethodName(field) + "());");
            codeBuilder.last().appendln("    }");
        }
        if (primitiveType == AdmPrimitive.Type.String) {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldLenderMethodName(field) + "(final %{com.neeve.lang.XString} val) {");
            codeBuilder.last().appendln("        if (val == null || !val.isInitialized() || val.isNull()) {" + AdmProtobufGenerator.fieldSetterMethodName(field) + "((String)null); return;}");
            codeBuilder.last().appendln("        if (!val.isImmutable()) {throw new IllegalArgumentException(\"value is mutable\");}");
            codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(val.getValue());");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterFromMethodName(field) + "(final long val) {");
            codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(String.valueOf(val));");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            if (entity.getGenerateDeprecatedAccessors()) {
                codeBuilder.last().appendln();
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @Deprecated");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterMethodName(field) + "AsLong(final long val) {");
                codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldSetterFromMethodName(field) + "(val);");
                codeBuilder.last().appendln("    }");
            }
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public <T extends %{com.neeve.lang.XString}> T " + AdmProtobufGenerator.fieldGetterToMethodName(field) + "(final %{com.neeve.lang.XString}.Factory<T> factory) {");
            codeBuilder.last().appendln("        final " + field.getType().getTemplatedJavaTypeName() + " val = " + AdmProtobufGenerator.fieldGetterMethodName(field) + "();");
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("            return factory.create(val, false);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            return null;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            if (entity.getGenerateDeprecatedAccessors()) {
                codeBuilder.newCodeSegment();
                codeBuilder.last().appendln();
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @Deprecated");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    " + finalModifier + "public <T extends %{com.neeve.lang.XString}> T " + AdmProtobufGenerator.fieldCopyFactoryMethodName(field) + "(final %{com.neeve.lang.XString}.Factory<T> factory) {");
                codeBuilder.last().appendln("        return " + AdmProtobufGenerator.fieldGetterToMethodName(field) + "(factory);");
                codeBuilder.last().appendln("    }");
                codeBuilder.newCodeSegment();
                codeBuilder.last().appendln();
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @Deprecated");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    public void " + AdmProtobufGenerator.fieldSetterMethodName(field) + "Value(final String val){");
                codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(val);");
                codeBuilder.last().appendln("    }");
                codeBuilder.newCodeSegment();
                codeBuilder.last().appendln();
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @Deprecated");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    " + finalModifier + "public String " + AdmProtobufGenerator.fieldGetterMethodName(field) + "Value() {");
                codeBuilder.last().appendln("        return " + AdmProtobufGenerator.fieldGetterMethodName(field) + "();");
                codeBuilder.last().appendln("    }");
            }
        }
        if (primitiveType.hasRawValue()) {
            String rawType = "%{" + primitiveType.getRawValueType() + "}";
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterFromMethodName(field) + "(final " + rawType + " val) {");
            codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(val != null ? val.getValue() : null);");
            codeBuilder.last().appendln("    }");
            if (entity.getGenerateDeprecatedAccessors()) {
                codeBuilder.newCodeSegment();
                codeBuilder.last().appendln();
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @Deprecated");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterMethodName(field) + "AsRaw(final " + rawType + " val) {");
                codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldSetterFromMethodName(field) + "(val);");
                codeBuilder.last().appendln("    }");
            }
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldGetterToMethodName(field) + "(final " + rawType + " val) {");
            codeBuilder.last().appendln("        val.setValue(" + AdmProtobufGenerator.fieldGetterMethodName(field) + "());");
            codeBuilder.last().appendln("    }");
            if (entity.getGenerateDeprecatedAccessors()) {
                codeBuilder.newCodeSegment();
                codeBuilder.last().appendln();
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @Deprecated");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    " + finalModifier + "public " + rawType + " " + AdmProtobufGenerator.fieldGetterMethodName(field) + "AsRaw() {");
                codeBuilder.last().appendln("        return " + AdmProtobufGenerator.fieldGetterUnsafeMethodName(field) + "();");
                codeBuilder.last().appendln("    }");
            }
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public " + rawType + " " + AdmProtobufGenerator.fieldGetterUnsafeMethodName(field) + "() {");
            codeBuilder.last().appendln("        return %{" + primitiveType.getRawValueTypeImpl() + "}.create(" + AdmProtobufGenerator.fieldGetterMethodName(field) + "());");
            codeBuilder.last().appendln("    }");
        }
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("        builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public boolean " + AdmProtobufGenerator.fieldCheckerMethodName(field) + "() {");
        codeBuilder.last().appendln("        return messageOrBuilder()." + AdmProtobufGenerator.fieldCheckerMethodName(field) + "();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserPrimitiveArrayFieldMethods(AdmEntity entity, AdmField field, AdmEncodingType protoXbufGenCompatibility, boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        AdmPrimitiveArray fieldType = (AdmPrimitiveArray)field.getType();
        String iteratorType = fieldType.getType().getTemplatedXIteratorType();
        String zgIteratorType = fieldType.getType().getTemplatedZGXIteratorType();
        String arrayIteratorType = fieldType.getType().getTemplatedXArrayIteratorType();
        boolean hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        String javaPrimitive = null;
        String protoPrimitive = null;
        String toProto = null;
        String fromProto = null;
        switch (fieldType.getType()) {
            case Byte: {
                javaPrimitive = "byte";
                protoPrimitive = "Integer";
                break;
            }
            case Short: {
                javaPrimitive = "short";
                protoPrimitive = "Integer";
                break;
            }
            case Char: {
                javaPrimitive = "char";
                protoPrimitive = "Integer";
                break;
            }
            case Integer: {
                javaPrimitive = "int";
                protoPrimitive = "Integer";
                break;
            }
            case Long: {
                javaPrimitive = "long";
                protoPrimitive = "Long";
                break;
            }
            case Float: {
                javaPrimitive = "float";
                protoPrimitive = "Float";
                break;
            }
            case Double: {
                javaPrimitive = "double";
                protoPrimitive = "Double";
                break;
            }
            case Boolean: {
                javaPrimitive = "boolean";
                protoPrimitive = "Boolean";
                break;
            }
            case String: {
                javaPrimitive = "String";
                protoPrimitive = "String";
                break;
            }
            case Date: {
                javaPrimitive = "Date";
                protoPrimitive = "long";
                toProto = "v.getTime()";
                fromProto = "new Date(val)";
                break;
            }
            case Currency: {
                javaPrimitive = "Currency";
                protoPrimitive = "String";
                toProto = "v.getCurrencyCode()";
                fromProto = "Currency.getInstance(val)";
                break;
            }
            case UUID: {
                javaPrimitive = "%{com.eaio.uuid.UUID}";
                protoPrimitive = "AdmUUID";
                toProto = "%{com.neeve.adm.types.protobuf.AdmTypeHelper}.toAdmUUID(v)";
                fromProto = "%{com.neeve.adm.types.protobuf.AdmTypeHelper}.toUUID(val)";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported primitive array type '" + (Object)((Object)fieldType.getType()) + "'");
            }
        }
        if (field.isDeprecated()) {
            codeBuilder.last().appendln("    @Deprecated");
        }
        codeBuilder.last().appendln("    private " + javaPrimitive + "[] " + AdmProtobufGenerator.fieldValueVarName(field) + ";");
        String finalModifier = AdmProtobufGenerator.fieldAccessorFinalModifier(entity);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(final " + javaPrimitive + "[] val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (!fieldType.isWrappedPrimitive() && entity.getNullPrimitiveArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("        if (val != null && val.length > 0) {");
            codeBuilder.last().appendln("            for(int i = 0; i < val.length; i++) {");
            codeBuilder.last().appendln("                if (val[i] == null) {");
            codeBuilder.last().appendln("                    throw new NullPointerException(\"Can't add a null value to an array field.\");");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        }
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        if (val != " + AdmProtobufGenerator.fieldGetterMethodName(field) + "()) {");
            codeBuilder.last().appendln("            recordFieldUpdate(" + AdmProtobufGenerator.fieldFidVarName(field) + ", " + AdmProtobufGenerator.fieldGetterMethodName(field) + "());");
            codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldValueVarName(field) + " = val;");
            codeBuilder.last().appendln("            builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("            if (val != null) {");
            if (protoXbufGenCompatibility == AdmEncodingType.Xbuf && fieldType.getType() == AdmPrimitive.Type.Byte) {
                codeBuilder.last().appendln("                builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(com.google.protobuf.ByteString.copyFrom(val));");
            } else {
                codeBuilder.last().appendln("                for (" + javaPrimitive + " v : val) {");
                if (!(fieldType.isWrappedPrimitive() || entity.getNullPrimitiveArrayElementPolicy() != AdmEntity.NullArrayElementPolicy.Ignore && entity.getNullPrimitiveArrayElementPolicy() != AdmEntity.NullArrayElementPolicy.IgnoreUnlessSupported)) {
                    codeBuilder.last().appendln("                    if (v == null) continue;");
                }
                if (toProto != null) {
                    codeBuilder.last().appendln("                    builder()." + AdmProtobufGenerator.fieldAddMethodName(field) + "(" + toProto + ");");
                } else {
                    codeBuilder.last().appendln("                    builder()." + AdmProtobufGenerator.fieldAddMethodName(field) + "(new " + protoPrimitive + "(v));");
                }
                codeBuilder.last().appendln("                }");
            }
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        } else {
            codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldValueVarName(field) + " = val;");
            codeBuilder.last().appendln("        builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("        if (val != null) {");
            if (protoXbufGenCompatibility == AdmEncodingType.Xbuf && fieldType.getType() == AdmPrimitive.Type.Byte) {
                codeBuilder.last().appendln("            builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(com.google.protobuf.ByteString.copyFrom(val));");
            } else {
                codeBuilder.last().appendln("            for (" + javaPrimitive + " v : val) {");
                if (!(fieldType.isWrappedPrimitive() || entity.getNullPrimitiveArrayElementPolicy() != AdmEntity.NullArrayElementPolicy.Ignore && entity.getNullPrimitiveArrayElementPolicy() != AdmEntity.NullArrayElementPolicy.IgnoreUnlessSupported)) {
                    codeBuilder.last().appendln("                    if (v == null) continue;");
                }
                if (toProto != null) {
                    codeBuilder.last().appendln("               builder()." + AdmProtobufGenerator.fieldAddMethodName(field) + "(" + toProto + ");");
                } else {
                    codeBuilder.last().appendln("                builder()." + AdmProtobufGenerator.fieldAddMethodName(field) + "(new " + protoPrimitive + "(v));");
                }
                codeBuilder.last().appendln("            }");
            }
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterFromMethodName(field) + "(final " + iteratorType + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        codeBuilder.last().appendln("        if (val == null) {");
        codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(null);");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        if (!fieldType.isWrappedPrimitive() && entity.getNullPrimitiveArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("        if (val.toFirst().hasNext()) {");
            codeBuilder.last().appendln("            while (val.hasNext()) {");
            codeBuilder.last().appendln("                if (val.next() == null) {");
            codeBuilder.last().appendln("                    throw new NullPointerException(\"Can't add a null value to an array field.\");");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            val.toFirst();");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("        val.toFirst();");
        codeBuilder.last().appendln("        if (!val.hasNext()) {");
        switch (fieldType.getType()) {
            case Byte: {
                codeBuilder.last().appendln("         " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_BYTE_ARRAY);");
                break;
            }
            case Char: {
                codeBuilder.last().appendln("         " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_CHAR_ARRAY);");
                break;
            }
            case Short: {
                codeBuilder.last().appendln("         " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_SHORT_ARRAY);");
                break;
            }
            case Integer: {
                codeBuilder.last().appendln("         " + AdmProtobufGenerator.fieldSetterMethodName(field) + "( %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_INT_ARRAY);");
                break;
            }
            case Long: {
                codeBuilder.last().appendln("         " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_LONG_ARRAY);");
                break;
            }
            case Float: {
                codeBuilder.last().appendln("         " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_FLOAT_ARRAY);");
                break;
            }
            case Double: {
                codeBuilder.last().appendln("         " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_DOUBLE_ARRAY);");
                break;
            }
            case Boolean: {
                codeBuilder.last().appendln("         " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_BOOLEAN_ARRAY);");
                break;
            }
            case UUID: {
                codeBuilder.last().appendln("         " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_UUID_ARRAY);");
                break;
            }
            case Date: {
                codeBuilder.last().appendln("         " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_DATE_ARRAY);");
                break;
            }
            case String: {
                codeBuilder.last().appendln("         " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_STRING_ARRAY);");
                break;
            }
            case Currency: {
                codeBuilder.last().appendln("         " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_CURRENCY_ARRAY);");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported primitive array type '" + (Object)((Object)fieldType.getType()) + "'");
            }
        }
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        " + javaPrimitive + "[] vArray;");
        codeBuilder.last().appendln("        if (val instanceof %{" + fieldType.getType().getXArrayIteratorTypeRaw() + "}) {");
        codeBuilder.last().appendln("            final " + arrayIteratorType + " a = (" + fieldType.getType().getXArrayIteratorType() + ") val;");
        codeBuilder.last().appendln("            vArray = a.array();");
        codeBuilder.last().appendln("            if (vArray.length != a.length()) {");
        codeBuilder.last().appendln("                vArray = new " + javaPrimitive + "[a.length()];");
        codeBuilder.last().appendln("                java.lang.System.arraycopy(a.array(), a.offset(), vArray, 0, a.length());");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(vArray);");
        codeBuilder.last().appendln("            val.toFirst();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmProtobufGenerator.fieldFidVarName(field) + ", " + AdmProtobufGenerator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldValueVarName(field) + " = null;");
        codeBuilder.last().appendln("            builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("            while(val.hasNext()) {");
        codeBuilder.last().appendln("                final " + javaPrimitive + " v = val.next();");
        if (!(fieldType.isWrappedPrimitive() || entity.getNullPrimitiveArrayElementPolicy() != AdmEntity.NullArrayElementPolicy.Ignore && entity.getNullPrimitiveArrayElementPolicy() != AdmEntity.NullArrayElementPolicy.IgnoreUnlessSupported)) {
            codeBuilder.last().appendln("                if (v == null) continue;");
        }
        if (toProto != null) {
            codeBuilder.last().appendln("                builder()." + AdmProtobufGenerator.fieldAddMethodName(field) + "(" + toProto + ");");
        } else {
            codeBuilder.last().appendln("                builder()." + AdmProtobufGenerator.fieldAddMethodName(field) + "(new " + protoPrimitive + "(v));");
        }
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            val.toFirst();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldAdderMethodName(field) + "(final " + javaPrimitive + " v) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (!fieldType.isWrappedPrimitive() && entity.getNullPrimitiveArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("        if (v == null) {");
            codeBuilder.last().appendln("            throw new NullPointerException(\"Can't add a null value to an array field.\");");
            codeBuilder.last().appendln("        }");
        }
        if (!(fieldType.isWrappedPrimitive() || entity.getNullPrimitiveArrayElementPolicy() != AdmEntity.NullArrayElementPolicy.Ignore && entity.getNullPrimitiveArrayElementPolicy() != AdmEntity.NullArrayElementPolicy.IgnoreUnlessSupported)) {
            codeBuilder.last().appendln("                if (v == null) return;");
        }
        if (protoXbufGenCompatibility == AdmEncodingType.Xbuf && fieldType.getType() == AdmPrimitive.Type.Byte) {
            codeBuilder.last().appendln("        final byte [] existing = " + AdmProtobufGenerator.fieldValueVarName(field) + "();");
            codeBuilder.last().appendln("        final byte [] vArray;");
            codeBuilder.last().appendln("        if (existing == null || existing.length == 0) {");
            codeBuilder.last().appendln("            vArray = new byte [] {v};");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else () {");
            codeBuilder.last().appendln("            vArray = new byte [existing.length + 1];");
            codeBuilder.last().appendln("            java.lang.System.arraycopy(existing, 0, vArray, 0, existing.length);");
            codeBuilder.last().appendln("            vArray[vArray.length - 1] = v;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(vArray);");
        } else {
            if (!entity.isEmbedded() && entity.isTransactional()) {
                codeBuilder.last().appendln("        recordFieldUpdate(" + AdmProtobufGenerator.fieldFidVarName(field) + ", " + AdmProtobufGenerator.fieldGetterMethodName(field) + "());");
            }
            codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldValueVarName(field) + " = null;");
            if (toProto != null) {
                codeBuilder.last().appendln("        builder()." + AdmProtobufGenerator.fieldAddMethodName(field) + "(" + toProto + ");");
            } else {
                codeBuilder.last().appendln("        builder()." + AdmProtobufGenerator.fieldAddMethodName(field) + "(new " + protoPrimitive + "(v));");
            }
        }
        codeBuilder.last().appendln("    }");
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonGetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + javaPrimitive + "[] " + AdmProtobufGenerator.fieldGetterMethodName(field) + "() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("        return " + AdmProtobufGenerator.fieldGetterMethodName(field) + "EmptyIfNull();");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    final private " + javaPrimitive + "[] " + AdmProtobufGenerator.fieldGetterMethodName(field) + "Core() {");
        }
        if (protoXbufGenCompatibility == AdmEncodingType.Xbuf && fieldType.getType() == AdmPrimitive.Type.Byte) {
            codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldValueVarName(field) + " = messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "().toByteArray();");
        } else {
            codeBuilder.last().appendln("        if (" + AdmProtobufGenerator.fieldValueVarName(field) + " == null && messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "Count() > 0) {");
            codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldValueVarName(field) + " = new " + javaPrimitive + "[messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "Count()];");
            codeBuilder.last().appendln("            int i = 0;");
            codeBuilder.last().appendln("            for (" + protoPrimitive + " val : messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "List()) {");
            switch (fieldType.getType()) {
                case Byte: {
                    codeBuilder.last().appendln("                " + AdmProtobufGenerator.fieldValueVarName(field) + "[i++] = val.byteValue();");
                    break;
                }
                case Char: {
                    codeBuilder.last().appendln("                " + AdmProtobufGenerator.fieldValueVarName(field) + "[i++] = (char) val.shortValue();");
                    break;
                }
                case Short: {
                    codeBuilder.last().appendln("                " + AdmProtobufGenerator.fieldValueVarName(field) + "[i++] = val.shortValue();");
                    break;
                }
                case Integer: {
                    codeBuilder.last().appendln("                " + AdmProtobufGenerator.fieldValueVarName(field) + "[i++] = val.intValue();");
                    break;
                }
                case Long: {
                    codeBuilder.last().appendln("                " + AdmProtobufGenerator.fieldValueVarName(field) + "[i++] = val.longValue();");
                    break;
                }
                case Float: {
                    codeBuilder.last().appendln("                " + AdmProtobufGenerator.fieldValueVarName(field) + "[i++] = val.floatValue();");
                    break;
                }
                case Double: {
                    codeBuilder.last().appendln("                " + AdmProtobufGenerator.fieldValueVarName(field) + "[i++] = val.doubleValue();");
                    break;
                }
                case Boolean: {
                    codeBuilder.last().appendln("                " + AdmProtobufGenerator.fieldValueVarName(field) + "[i++] = val.booleanValue();");
                    break;
                }
                case String: {
                    codeBuilder.last().appendln("                " + AdmProtobufGenerator.fieldValueVarName(field) + "[i++] = val;");
                    break;
                }
                case UUID: 
                case Date: 
                case Currency: {
                    codeBuilder.last().appendln("                " + AdmProtobufGenerator.fieldValueVarName(field) + "[i++] = " + fromProto + ";");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported primitive array type '" + (Object)((Object)fieldType.getType()) + "'");
                }
            }
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("        return " + AdmProtobufGenerator.fieldValueVarName(field) + ";");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + javaPrimitive + "[] " + AdmProtobufGenerator.fieldGetterMethodName(field) + "EmptyIfNull() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("        final " + javaPrimitive + "[] val = " + AdmProtobufGenerator.fieldGetterMethodName(field) + "Core();");
        } else {
            codeBuilder.last().appendln("        final " + javaPrimitive + "[] val = " + AdmProtobufGenerator.fieldGetterMethodName(field) + "();");
        }
        switch (fieldType.getType()) {
            case Byte: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_BYTE_ARRAY;");
                break;
            }
            case Char: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_CHAR_ARRAY;");
                break;
            }
            case Short: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_SHORT_ARRAY;");
                break;
            }
            case Integer: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_INT_ARRAY;");
                break;
            }
            case Long: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_LONG_ARRAY;");
                break;
            }
            case Float: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_FLOAT_ARRAY;");
                break;
            }
            case Double: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_DOUBLE_ARRAY;");
                break;
            }
            case Boolean: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_BOOLEAN_ARRAY;");
                break;
            }
            case UUID: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_UUID_ARRAY;");
                break;
            }
            case Date: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_DATE_ARRAY;");
                break;
            }
            case String: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_STRING_ARRAY;");
                break;
            }
            case Currency: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_CURRENCY_ARRAY;");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported primitive array type '" + (Object)((Object)fieldType.getType()) + "'");
            }
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public " + zgIteratorType + " " + AdmProtobufGenerator.fieldGetterMethodName(field) + "Iterator() {");
        codeBuilder.last().appendln("        return new " + arrayIteratorType + "(" + AdmProtobufGenerator.fieldGetterMethodName(field) + "EmptyIfNull());");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("        builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldValueVarName(field) + " = null;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserEntityArrayFieldMethods(AdmEntity entity, AdmField field, boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        boolean hasInterface;
        AdmEntityArray fieldType = (AdmEntityArray)field.getType();
        boolean bl = hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        if (field.isDeprecated()) {
            codeBuilder.last().appendln("    @Deprecated");
        }
        codeBuilder.last().appendln("    private " + fieldType.getTemplatedJavaTypeName() + " " + AdmProtobufGenerator.fieldValueVarName(field) + ";");
        String finalModifier = AdmProtobufGenerator.fieldAccessorFinalModifier(entity);
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("            for (int i = 0; i < val.length; i++) {");
            codeBuilder.last().appendln("                if (val[i] == null) {");
            codeBuilder.last().appendln("                    throw new NullPointerException(\"Can't set entity array field with a null value at index '\" + i + \"'\");");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        }
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        if (val != " + AdmProtobufGenerator.fieldGetterMethodName(field) + "()) {");
            codeBuilder.last().appendln("            recordFieldUpdate(" + AdmProtobufGenerator.fieldFidVarName(field) + ", " + AdmProtobufGenerator.fieldGetterMethodName(field) + "());");
            codeBuilder.last().appendln("            builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldValueVarName(field) + " = val;");
            codeBuilder.last().appendln("        }");
        } else {
            codeBuilder.last().appendln("        builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldValueVarName(field) + " = val;");
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterFromMethodName(field) + "(final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        codeBuilder.last().appendln("        if (val == null) {");
        codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(null);");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        val.toFirst();");
        codeBuilder.last().appendln("        if (!val.hasNext()) {");
        codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(new " + fieldType.getType().getTemplatedJavaTypeName() + "[0]);");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        " + fieldType.getTemplatedJavaTypeName() + " vArray;");
        codeBuilder.last().appendln("        if (val instanceof %{com.neeve.lang.XArrayIterator}) {");
        codeBuilder.last().appendln("            final %{com.neeve.lang.XArrayIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> a = (%{com.neeve.lang.XArrayIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + ">) val;");
        codeBuilder.last().appendln("            vArray = a.array();");
        codeBuilder.last().appendln("            if (vArray.length != a.length()) {");
        codeBuilder.last().appendln("                vArray = new " + fieldType.getType().getTemplatedJavaTypeName() + "[a.length()];");
        codeBuilder.last().appendln("                java.lang.System.arraycopy(a.array(), a.offset(), vArray, 0, a.length());");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            int len = 0;");
        codeBuilder.last().appendln("            while(val.hasNext()) {");
        codeBuilder.last().appendln("               val.next();");
        codeBuilder.last().appendln("               len++;");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            vArray = new " + fieldType.getType().getTemplatedJavaTypeName() + "[len];");
        codeBuilder.last().appendln("            val.toFirst();");
        codeBuilder.last().appendln("            for(int i = 0; i < len; i++)  {");
        codeBuilder.last().appendln("               vArray[i] = val.next();");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            val.toFirst();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(vArray);");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldAdderMethodName(field) + "(final " + fieldType.getType().getTemplatedJavaTypeName() + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("        if (val == null) {");
            codeBuilder.last().appendln("            throw new NullPointerException(\"Can't add a null entity array field value.\");");
            codeBuilder.last().appendln("        }");
        } else if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Ignore || entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.IgnoreUnlessSupported) {
            codeBuilder.last().appendln("        if (val == null) {");
            codeBuilder.last().appendln("            return;");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("        " + fieldType.getType().getTemplatedJavaTypeName() + "[] vArray;");
        codeBuilder.last().appendln("        if (" + AdmProtobufGenerator.fieldValueVarName(field) + " == null) {");
        codeBuilder.last().appendln("            vArray = new " + fieldType.getType().getTemplatedJavaTypeName() + "[1];");
        codeBuilder.last().appendln("            vArray[0] = val;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            vArray = new " + fieldType.getType().getTemplatedJavaTypeName() + "[" + AdmProtobufGenerator.fieldValueVarName(field) + ".length + 1];");
        codeBuilder.last().appendln("            java.lang.System.arraycopy(" + AdmProtobufGenerator.fieldValueVarName(field) + ", 0, vArray, 0, " + AdmProtobufGenerator.fieldValueVarName(field) + ".length);");
        codeBuilder.last().appendln("            vArray[vArray.length - 1] = val;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(vArray);");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldLenderMethodName(field) + "From(final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> val) {");
        codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldSetterFromMethodName(field) + "(val);");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldLenderMethodName(field) + "(final " + fieldType.getType().getTemplatedJavaTypeName() + " val) {");
        codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldAdderMethodName(field) + "(val);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldLenderMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(val);");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonGetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmProtobufGenerator.fieldGetterMethodName(field) + "() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("    return " + AdmProtobufGenerator.fieldGetterMethodName(field) + "EmptyIfNull();");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    final private " + fieldType.getTemplatedJavaTypeName() + " " + AdmProtobufGenerator.fieldGetterMethodName(field) + "Core() {");
        }
        codeBuilder.last().appendln("        if (" + AdmProtobufGenerator.fieldValueVarName(field) + " == null && messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "Count() > 0) {");
        codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldValueVarName(field) + " = new " + fieldType.getType().getTemplatedJavaTypeName() + "[messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "Count()];");
        codeBuilder.last().appendln("            int i = 0;");
        codeBuilder.last().appendln("            for (" + this.protobufName(entity, fieldType.getType()) + " val : messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "List()) {");
        codeBuilder.last().appendln("                " + AdmProtobufGenerator.fieldValueVarName(field) + "[i++] = " + fieldType.getType().getTemplatedJavaTypeName() + ".createFromProtoMessage(val);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return " + AdmProtobufGenerator.fieldValueVarName(field) + ";");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmProtobufGenerator.fieldGetterMethodName(field) + "EmptyIfNull() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " val = " + AdmProtobufGenerator.fieldGetterMethodName(field) + "Core();");
        } else {
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " val = " + AdmProtobufGenerator.fieldGetterMethodName(field) + "();");
        }
        codeBuilder.last().appendln("        return val != null ? val : " + fieldType.getType().getTemplatedJavaTypeName() + ".EMPTY_ARRAY;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> " + AdmProtobufGenerator.fieldGetterMethodName(field) + "Iterator() {");
        codeBuilder.last().appendln("        return new %{com.neeve.lang.XArrayIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + ">(" + AdmProtobufGenerator.fieldGetterMethodName(field) + "EmptyIfNull());");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmProtobufGenerator.fieldTakerMethodName(field) + "() {");
        codeBuilder.last().appendln("        return " + AdmProtobufGenerator.fieldGetterMethodName(field) + "();");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("        builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldValueVarName(field) + " = null;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserEnumerationArrayFieldMethods(AdmEntity entity, AdmField field, boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        boolean hasInterface;
        AdmEnumerationArray fieldType = (AdmEnumerationArray)field.getType();
        boolean bl = hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        if (field.isDeprecated()) {
            codeBuilder.last().appendln("    @Deprecated");
        }
        codeBuilder.last().appendln("    private " + fieldType.getTemplatedJavaTypeName() + " " + AdmProtobufGenerator.fieldValueVarName(field) + ";");
        String finalModifier = AdmProtobufGenerator.fieldAccessorFinalModifier(entity);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("            for (int i = 0; i < val.length; i++) {");
            codeBuilder.last().appendln("                if (val[i] == null) {");
            codeBuilder.last().appendln("                    throw new NullPointerException(\"Can't set enum array field with a null value at index '\" + i + \"'\");");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        }
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        if (val != " + AdmProtobufGenerator.fieldGetterMethodName(field) + "()) {");
            codeBuilder.last().appendln("            recordFieldUpdate(" + AdmProtobufGenerator.fieldFidVarName(field) + ", " + AdmProtobufGenerator.fieldGetterMethodName(field) + "());");
            codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldValueVarName(field) + " = val;");
            codeBuilder.last().appendln("            builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("            if (val != null) {");
            codeBuilder.last().appendln("                for (int i = 0; i < val.length; i++) {");
            codeBuilder.last().appendln("                    if (val[i] != null) {");
            codeBuilder.last().appendln("                        builder()." + AdmProtobufGenerator.fieldAddMethodName(field) + "(" + this.protobufName(entity, fieldType.getType()) + ".valueOf(val[i].val));");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        } else {
            codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldValueVarName(field) + " = val;");
            codeBuilder.last().appendln("        builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("            for (int i = 0; i < val.length; i++) {");
            codeBuilder.last().appendln("                if (val[i] != null) {");
            codeBuilder.last().appendln("                    builder()." + AdmProtobufGenerator.fieldAddMethodName(field) + "(" + this.protobufName(entity, fieldType.getType()) + ".valueOf(val[i].val));");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterFromMethodName(field) + "(final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        codeBuilder.last().appendln("        if (val == null) {");
        codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(null);");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        val.toFirst();");
        codeBuilder.last().appendln("        if (!val.hasNext()) {");
        codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(new " + fieldType.getType().getTemplatedJavaTypeName() + "[0]);");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        " + fieldType.getTemplatedJavaTypeName() + " vArray;");
        codeBuilder.last().appendln("        if (val instanceof %{com.neeve.lang.XArrayIterator}) {");
        codeBuilder.last().appendln("            final %{com.neeve.lang.XArrayIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> a = (%{com.neeve.lang.XArrayIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + ">) val;");
        codeBuilder.last().appendln("            vArray = a.array();");
        codeBuilder.last().appendln("            if (vArray.length != a.length()) {");
        codeBuilder.last().appendln("                vArray = new " + fieldType.getType().getTemplatedJavaTypeName() + "[a.length()];");
        codeBuilder.last().appendln("                java.lang.System.arraycopy(a.array(), a.offset(), vArray, 0, a.length());");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            int len = 0;");
        codeBuilder.last().appendln("            while(val.hasNext()) {");
        codeBuilder.last().appendln("               val.next();");
        codeBuilder.last().appendln("               len++;");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            vArray = new " + fieldType.getType().getTemplatedJavaTypeName() + "[len];");
        codeBuilder.last().appendln("            val.toFirst();");
        codeBuilder.last().appendln("            for(int i = 0; i < len; i++)  {");
        codeBuilder.last().appendln("               vArray[i] = val.next();");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            val.toFirst();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(vArray);");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldAdderMethodName(field) + "(final " + fieldType.getType().getTemplatedJavaTypeName() + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("        if (val == null) {");
            codeBuilder.last().appendln("            throw new NullPointerException(\"Can't set enum array field with a null value.\");");
            codeBuilder.last().appendln("        }");
        } else if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Ignore || entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.IgnoreUnlessSupported) {
            codeBuilder.last().appendln("        if (val == null) {");
            codeBuilder.last().appendln("            return;");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("        " + fieldType.getType().getTemplatedJavaTypeName() + "[] vArray;");
        codeBuilder.last().appendln("        if (" + AdmProtobufGenerator.fieldValueVarName(field) + " == null) {");
        codeBuilder.last().appendln("            vArray = new " + fieldType.getType().getTemplatedJavaTypeName() + "[1];");
        codeBuilder.last().appendln("            vArray[0] = val;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            vArray = new " + fieldType.getType().getTemplatedJavaTypeName() + "[" + AdmProtobufGenerator.fieldValueVarName(field) + ".length + 1];");
        codeBuilder.last().appendln("            java.lang.System.arraycopy(" + AdmProtobufGenerator.fieldValueVarName(field) + ", 0, vArray, 0, " + AdmProtobufGenerator.fieldValueVarName(field) + ".length);");
        codeBuilder.last().appendln("            vArray[vArray.length - 1] = val;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(vArray);");
        codeBuilder.last().appendln("    }");
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterMethodName(field) + "List(final %{java.util.List}<" + fieldType.getType().getTemplatedJavaTypeName() + "> val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmProtobufGenerator.fieldFidVarName(field) + ", " + AdmProtobufGenerator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldValueVarName(field) + " = null;");
        codeBuilder.last().appendln("        builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("        if (val != null) {");
        codeBuilder.last().appendln("            for (int i = 0; i < val.size(); i++) {");
        codeBuilder.last().appendln("                final " + fieldType.getType().getTemplatedJavaTypeName() + " v = val.get(i);");
        codeBuilder.last().appendln("                if (v != null) {");
        codeBuilder.last().appendln("                    builder()." + AdmProtobufGenerator.fieldAddMethodName(field) + "(" + this.protobufName(entity, fieldType.getType()) + ".valueOf(v.val));");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonGetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmProtobufGenerator.fieldGetterMethodName(field) + "() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("    return " + AdmProtobufGenerator.fieldGetterMethodName(field) + "EmptyIfNull();");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    final private " + fieldType.getTemplatedJavaTypeName() + " " + AdmProtobufGenerator.fieldGetterMethodName(field) + "Core() {");
        }
        codeBuilder.last().appendln("        if (" + AdmProtobufGenerator.fieldValueVarName(field) + " == null && messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "Count() > 0) {");
        codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldValueVarName(field) + " = new " + fieldType.getType().getTemplatedJavaTypeName() + "[messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "Count()];");
        codeBuilder.last().appendln("            int i = 0;");
        codeBuilder.last().appendln("            for (" + this.protobufName(entity, fieldType.getType()) + " val : messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "List()) {");
        codeBuilder.last().appendln("                " + AdmProtobufGenerator.fieldValueVarName(field) + "[i++] = " + fieldType.getType().getTemplatedJavaTypeName() + ".fromValue(val.getNumber());");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return " + AdmProtobufGenerator.fieldValueVarName(field) + ";");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmProtobufGenerator.fieldGetterMethodName(field) + "EmptyIfNull() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " val = " + AdmProtobufGenerator.fieldGetterMethodName(field) + "Core();");
        } else {
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " val = " + AdmProtobufGenerator.fieldGetterMethodName(field) + "();");
        }
        codeBuilder.last().appendln("        return val != null ? val : " + fieldType.getType().getTemplatedJavaTypeName() + ".EMPTY_ARRAY;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public %{com.neeve.lang.XIndexedList}<" + fieldType.getType().getTemplatedJavaTypeName() + "> " + AdmProtobufGenerator.fieldGetterMethodName(field) + "List() {");
        codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldGetterMethodName(field) + "();");
        codeBuilder.last().appendln("        %{com.neeve.lang.XIndexedList}<" + fieldType.getType().getTemplatedJavaTypeName() + "> list = null;");
        codeBuilder.last().appendln("        if (" + AdmProtobufGenerator.fieldValueVarName(field) + " != null) {");
        codeBuilder.last().appendln("            list = new %{com.neeve.lang.XIndexedList}<" + fieldType.getType().getTemplatedJavaTypeName() + ">(" + AdmProtobufGenerator.fieldValueVarName(field) + ".length);");
        codeBuilder.last().appendln("            for(int i = 0; i < " + AdmProtobufGenerator.fieldValueVarName(field) + ".length; i++) {");
        codeBuilder.last().appendln("                list.add(" + AdmProtobufGenerator.fieldValueVarName(field) + "[i]);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            list = new %{com.neeve.lang.XIndexedList}<" + fieldType.getType().getTemplatedJavaTypeName() + ">(0);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return list;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> " + AdmProtobufGenerator.fieldGetterMethodName(field) + "Iterator() {");
        codeBuilder.last().appendln("        return new %{com.neeve.lang.XArrayIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + ">(" + AdmProtobufGenerator.fieldGetterMethodName(field) + "EmptyIfNull());");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("        builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldValueVarName(field) + " = null;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserEnumerationFieldMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmEnumeration fieldType = (AdmEnumeration)field.getType();
        boolean hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        String finalModifier = AdmProtobufGenerator.fieldAccessorFinalModifier(entity);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " old = " + AdmProtobufGenerator.fieldGetterMethodName(field) + "();");
            codeBuilder.last().appendln("        if (val != old) {");
            codeBuilder.last().appendln("            recordFieldUpdate(" + AdmProtobufGenerator.fieldIdxFieldVarName(field) + ", old, val);");
            codeBuilder.last().appendln("            if (val != null) {");
            codeBuilder.last().appendln("               builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(" + this.protobufName(entity, fieldType) + ".valueOf(val.val));");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("               builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        } else {
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("           builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(" + this.protobufName(entity, fieldType) + ".valueOf(val.val));");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("           builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("    }");
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonGetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmProtobufGenerator.fieldGetterMethodName(field) + "() {");
        codeBuilder.last().appendln("        final " + this.protobufName(entity, fieldType) + " val = messageOrBuilder()." + AdmProtobufGenerator.fieldCheckerMethodName(field) + "() ? messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "() : null;");
        codeBuilder.last().appendln("        return val == null ? null : " + fieldType.getTemplatedJavaTypeName() + ".fromValue(val.getNumber());");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("        builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public boolean " + AdmProtobufGenerator.fieldCheckerMethodName(field) + "() {");
        codeBuilder.last().appendln("        return messageOrBuilder()." + AdmProtobufGenerator.fieldCheckerMethodName(field) + "();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserEntityFieldMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmEntity fieldType = (AdmEntity)field.getType();
        boolean hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        String finalModifier = AdmProtobufGenerator.fieldAccessorFinalModifier(entity);
        if (entity.isEmbedded() || fieldType.isEmbedded()) {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln("    private " + fieldType.getTemplatedJavaTypeName() + " " + AdmProtobufGenerator.fieldValueVarName(field) + ";");
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            this.writeJsonSetterAnnotations(field, codeBuilder);
            if (!entity.isEmbedded() && entity.isTransactional()) {
                codeBuilder.newCodeSegment();
                codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
                this.writeReadOnlyValidator(entity, codeBuilder);
                codeBuilder.last().appendln("       final " + fieldType.getTemplatedJavaTypeName() + " old = " + AdmProtobufGenerator.fieldGetterMethodName(field) + "();");
                codeBuilder.last().appendln("        if (val != old) {");
                codeBuilder.last().appendln("            recordFieldUpdate(" + AdmProtobufGenerator.fieldIdxFieldVarName(field) + ", old, val);");
                codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldValueVarName(field) + " = val;");
                codeBuilder.last().appendln("            if (val != null) {");
                codeBuilder.last().appendln("               builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(val.message());");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("            else {");
                codeBuilder.last().appendln("               builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("    }");
            } else {
                codeBuilder.newCodeSegment();
                codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
                this.writeReadOnlyValidator(entity, codeBuilder);
                codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldValueVarName(field) + " = val;");
                codeBuilder.last().appendln("        if (val != null) {");
                codeBuilder.last().appendln("           builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(val.message());");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("           builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("    }");
            }
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldLenderMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
            codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(val);");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeFieldFluentMethods(entity, field, codeBuilder);
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            this.writeJsonGetterAnnotations(field, codeBuilder);
            codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmProtobufGenerator.fieldGetterMethodName(field) + "() {");
            codeBuilder.last().appendln("        if (" + AdmProtobufGenerator.fieldValueVarName(field) + " == null && messageOrBuilder()." + AdmProtobufGenerator.fieldCheckerMethodName(field) + "()) {");
            codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldValueVarName(field) + " = " + fieldType.getTemplatedJavaTypeName() + ".createFromProtoMessage(messageOrBuilder()." + AdmProtobufGenerator.fieldGetterMethodName(field) + "());");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        return " + AdmProtobufGenerator.fieldValueVarName(field) + ";");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldGetterToMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " to) {");
            codeBuilder.last().appendln("        if (" + AdmProtobufGenerator.fieldCheckerMethodName(field) + "()) {");
            codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldGetterMethodName(field) + "().copyInto(to);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            to.clearContent();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmProtobufGenerator.fieldTakerMethodName(field) + "() {");
            codeBuilder.last().appendln("        return " + AdmProtobufGenerator.fieldGetterMethodName(field) + "();");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeOptionalGetterMethods(entity, field, codeBuilder);
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldClearerMethodName(field) + "() {");
            codeBuilder.last().appendln("        builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldValueVarName(field) + " = null;");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public boolean " + AdmProtobufGenerator.fieldCheckerMethodName(field) + "() {");
            codeBuilder.last().appendln("        return messageOrBuilder()." + AdmProtobufGenerator.fieldCheckerMethodName(field) + "();");
            codeBuilder.last().appendln("    }");
        } else {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            this.writeJsonSetterAnnotations(field, codeBuilder);
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        if (val != " + AdmProtobufGenerator.fieldGetterMethodName(field) + "()) {");
            codeBuilder.last().appendln("            setChild(" + AdmProtobufGenerator.fieldFidVarName(field) + ", val);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeFieldFluentMethods(entity, field, codeBuilder);
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            this.writeJsonGetterAnnotations(field, codeBuilder);
            codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmProtobufGenerator.fieldGetterMethodName(field) + "() {");
            codeBuilder.last().appendln("        return (" + fieldType.getTemplatedJavaTypeName() + ")getChild(" + AdmProtobufGenerator.fieldFidVarName(field) + ");");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeOptionalGetterMethods(entity, field, codeBuilder);
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmProtobufGenerator.fieldClearerMethodName(field) + "() {");
            codeBuilder.last().appendln("        " + AdmProtobufGenerator.fieldSetterMethodName(field) + "(null);");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public boolean " + AdmProtobufGenerator.fieldCheckerMethodName(field) + "() {");
            codeBuilder.last().appendln("        return getChild(" + AdmProtobufGenerator.fieldFidVarName(field) + ") != null;");
            codeBuilder.last().appendln("    }");
        }
    }

    private final void writeUserCollectionFieldMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmCollection fieldType = (AdmCollection)field.getType();
        String finalModifier = AdmProtobufGenerator.fieldAccessorFinalModifier(entity);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmProtobufGenerator.fieldGetterMethodName(field) + "() {");
        codeBuilder.last().appendln("        " + fieldType.getTemplatedJavaTypeName() + " val = (" + fieldType.getTemplatedJavaTypeName() + ")getChild(" + AdmProtobufGenerator.fieldFidVarName(field) + ");");
        codeBuilder.last().appendln("        if (val == null) {");
        codeBuilder.last().appendln("            setChild(" + AdmProtobufGenerator.fieldFidVarName(field) + ", val = " + fieldType.getTemplatedJavaTypeName() + ".create());");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return val;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserFieldMethods(AdmEntity entity, AdmField field, AdmEncodingType protoXbufGenCompatibility, boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        AdmType fieldType = field.getType();
        this.writeFieldIdMethods(entity, field, codeBuilder);
        if (fieldType instanceof AdmPrimitive) {
            this.writeUserPrimitiveFieldMethods(entity, field, codeBuilder);
        } else if (fieldType instanceof AdmArray) {
            if (fieldType instanceof AdmPrimitiveArray) {
                this.writeUserPrimitiveArrayFieldMethods(entity, field, protoXbufGenCompatibility, generateArrayGetterEmptyIfNull, codeBuilder);
            } else if (fieldType instanceof AdmEntityArray) {
                this.writeUserEntityArrayFieldMethods(entity, field, generateArrayGetterEmptyIfNull, codeBuilder);
            } else if (fieldType instanceof AdmEnumerationArray) {
                this.writeUserEnumerationArrayFieldMethods(entity, field, generateArrayGetterEmptyIfNull, codeBuilder);
            }
        } else if (fieldType instanceof AdmEnumeration) {
            this.writeUserEnumerationFieldMethods(entity, field, codeBuilder);
        } else if (fieldType instanceof AdmEntity) {
            this.writeUserEntityFieldMethods(entity, field, codeBuilder);
        } else if (fieldType instanceof AdmCollection) {
            this.writeUserCollectionFieldMethods(entity, field, codeBuilder);
        } else {
            throw new IllegalArgumentException("unknown field type '" + fieldType.getTemplatedJavaTypeName() + "' (class=" + ((Object)((Object)fieldType)).getClass().getName() + ")");
        }
    }

    private final void writeFieldMethods(AdmEntity entity, List<AdmField> fields, AdmEncodingType protoXbufGenCompatibility, boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Field getter/setter methods -----");
        this.writeContainedEntityCollectionElementMethods(entity, codeBuilder);
        Iterator<AdmField> fieldIterator = fields.iterator();
        while (fieldIterator.hasNext()) {
            this.writeUserFieldMethods(entity, fieldIterator.next(), protoXbufGenCompatibility, generateArrayGetterEmptyIfNull, codeBuilder);
        }
        codeBuilder.last().appendln("    // ----- Field getter/setter methods -----");
    }

    private final void writeSerializeToByteArrayMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        boolean isEmbeddedEntity = type instanceof AdmEntity && ((AdmEntity)type).isEmbedded();
        codeBuilder.newCodeSegment();
        if (!isEmbeddedEntity) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public byte[] serializeToByteArray() {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        final byte[] bytes = message().toByteArray();");
        if (!(type instanceof AdmMessage)) {
            codeBuilder.last().appendln("        builder();");
        }
        codeBuilder.last().appendln("        return bytes;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToByteBufferMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        boolean isEmbeddedEntity = type instanceof AdmEntity && ((AdmEntity)type).isEmbedded();
        codeBuilder.newCodeSegment();
        if (!isEmbeddedEntity) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public %{java.nio.ByteBuffer} serializeToByteBuffer() {");
        codeBuilder.last().appendln("        return %{java.nio.ByteBuffer}.wrap(serializeToByteArray());");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToPacketMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public %{com.neeve.pkt.PktPacket} serializeToPacket() {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        final %{java.nio.ByteBuffer} serializedMessage = serializeToByteBuffer();");
        codeBuilder.last().appendln("        final %{com.neeve.pkt.PktSerializable}.DeserializeContext deserializeContext = %{com.neeve.pkt.PktSerializable}.DeserializeContext.create().setBuffer(serializedMessage);");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            final %{com.neeve.pkt.PktPacket} packet = %{com.neeve.pkt.PktFactory}.getInstance().createPacket(%{com.neeve.pkt.types.PktBodyTypesBase}.DATA);");
        codeBuilder.last().appendln("            packet.getBody().deserialize(deserializeContext, serializedMessage.remaining(), null);");
        if (!(type instanceof AdmMessage)) {
            codeBuilder.last().appendln("            builder();");
        }
        codeBuilder.last().appendln("            return packet;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
        codeBuilder.last().appendln("                throw (RuntimeException)e;");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                throw new RuntimeException(e);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromByteArrayMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        boolean isEmbeddedEntity = type instanceof AdmEntity && ((AdmEntity)type).isEmbedded();
        codeBuilder.newCodeSegment();
        if (!isEmbeddedEntity) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromByteArray(final byte[] array) {");
        codeBuilder.last().appendln("        " + this.protobufName(type) + " val;");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            val = " + this.protobufName(type) + ".parseFrom(array);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (com.google.protobuf.InvalidProtocolBufferException e) {");
        codeBuilder.last().appendln("            throw new RuntimeException(e);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        clearCachedFieldValues();");
        codeBuilder.last().appendln("        message(val);");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromByteBufferMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        boolean isEmbeddedEntity = type instanceof AdmEntity && ((AdmEntity)type).isEmbedded();
        codeBuilder.newCodeSegment();
        if (!isEmbeddedEntity) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromByteBuffer(final %{java.nio.ByteBuffer} buffer) {");
        codeBuilder.last().appendln("        " + this.protobufName(type) + " val;");
        codeBuilder.last().appendln("        buffer.mark();");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            val = " + this.protobufName(type) + ".parseFrom(%{com.neeve.util.UtlBuffer}.inputStream(buffer));");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (com.google.protobuf.InvalidProtocolBufferException e) {");
        codeBuilder.last().appendln("            throw new RuntimeException(e);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (java.io.IOException e) {");
        codeBuilder.last().appendln("            throw new RuntimeException(e);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        finally {");
        codeBuilder.last().appendln("            buffer.reset();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        clearCachedFieldValues();");
        codeBuilder.last().appendln("        message(val);");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromPacketMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromPacket(final %{com.neeve.pkt.PktPacket} packet) {");
        codeBuilder.last().appendln("        " + this.protobufName(type) + " val;");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            val = " + this.protobufName(type) + ".parseFrom(packet.getBody().getBuffer().inputStream(0));");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (com.google.protobuf.InvalidProtocolBufferException e) {");
        codeBuilder.last().appendln("            throw new RuntimeException(e);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (java.io.IOException e) {");
        codeBuilder.last().appendln("            throw new RuntimeException(e);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        clearCachedFieldValues();");
        codeBuilder.last().appendln("        message(val);");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSyncMethod(AdmScopedType type, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        boolean isEmbeddedEntity = type instanceof AdmEntity && ((AdmEntity)type).isEmbedded();
        codeBuilder.newCodeSegment();
        if (!isEmbeddedEntity) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public void sync() {");
        for (AdmField field : fields) {
            AdmType fieldType = field.getType();
            if (fieldType instanceof AdmEntity && ((AdmEntity)fieldType).isEmbedded()) {
                codeBuilder.last().appendln("        if (" + AdmProtobufGenerator.fieldValueVarName(field) + " != null) {");
                codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldValueVarName(field) + ".sync();");
                codeBuilder.last().appendln("            if (" + AdmProtobufGenerator.fieldValueVarName(field) + ".isDirty()) {");
                codeBuilder.last().appendln("                builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(" + AdmProtobufGenerator.fieldValueVarName(field) + ".message());");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("        }");
                continue;
            }
            if (!(fieldType instanceof AdmEntityArray)) continue;
            codeBuilder.last().appendln("        builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("        if (" + AdmProtobufGenerator.fieldValueVarName(field) + " != null) {");
            codeBuilder.last().appendln("            for (" + ((AdmEntityArray)fieldType).getType().getTemplatedJavaTypeName() + " v : " + AdmProtobufGenerator.fieldValueVarName(field) + ") {");
            codeBuilder.last().appendln("                if (v != null) {");
            codeBuilder.last().appendln("                    v.sync();");
            codeBuilder.last().appendln("                    builder()." + AdmProtobufGenerator.fieldAddMethodName(field) + "(v.message());");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        }
        if (!isEmbeddedEntity) {
            codeBuilder.last().appendln("        setMessage(%{com.neeve.sma.MessageView}.ENCODING_TYPE_PROTOBUF, message());");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeCopyMethods(AdmEntity type, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (type instanceof AdmMessage) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " copy() {");
        codeBuilder.last().appendln("        final " + type.getTemplatedJavaTypeName() + " copy = " + type.getTemplatedJavaTypeName() + ".create();");
        codeBuilder.last().appendln("        copyInto(copy);");
        codeBuilder.last().appendln("        return copy;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.newCodeSegment();
        if (type instanceof AdmMessage) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public void copyInto(final " + type.getTemplatedJavaTypeName() + " copy) {");
        codeBuilder.last().appendln("        if (copy.readOnly) {throw new IllegalStateException(\"copy target is read only\");}");
        if (type.isEmbedded()) {
            codeBuilder.last().appendln("        sync();");
            codeBuilder.last().appendln("        copy.clearContent();");
            codeBuilder.last().appendln("        if (_protoBuilder != null) {");
            codeBuilder.last().appendln("            copy.message(_protoBuilder.clone().build());");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else if (_protoMessage != null) {");
            codeBuilder.last().appendln("            copy.message(message());");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            if (!type.fields().isEmpty()) {
                codeBuilder.last().appendln("            copy.message(builder().clone().build());");
            } else {
                codeBuilder.last().appendln("            copy.clearContent();");
            }
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        copy.syncFieldBitmask();");
        } else {
            for (AdmField field : fields) {
                String copyFieldName;
                String copierFieldName;
                AdmType fieldType = field.getType();
                if (fieldType instanceof AdmPrimitive) {
                    codeBuilder.last().appendln("        if (" + AdmProtobufGenerator.fieldCheckerMethodName(field) + "()) {");
                    codeBuilder.last().appendln("           copy." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(this." + AdmProtobufGenerator.fieldGetterMethodName(field) + "());");
                    codeBuilder.last().appendln("        }");
                    codeBuilder.last().appendln("        else {");
                    codeBuilder.last().appendln("           copy." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
                    codeBuilder.last().appendln("        }");
                    codeBuilder.last().appendln("");
                    continue;
                }
                if (fieldType instanceof AdmPrimitiveArray) {
                    copierFieldName = "copier_" + field.getName();
                    codeBuilder.last().appendln("        final " + fieldType.getTemplatedPrimitiveTypeName() + " " + copierFieldName + " = this." + AdmProtobufGenerator.fieldGetterMethodName(field) + "();");
                    codeBuilder.last().appendln("        if (" + copierFieldName + " != null) {");
                    codeBuilder.last().appendln("            copy." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(" + copierFieldName + ".clone());");
                    codeBuilder.last().appendln("        }");
                    codeBuilder.last().appendln("        else {");
                    codeBuilder.last().appendln("            copy." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
                    codeBuilder.last().appendln("        }");
                    codeBuilder.last().appendln("");
                    continue;
                }
                if (fieldType instanceof AdmEntity) {
                    copierFieldName = "copier_" + field.getName();
                    this.writeSuppressDeprecationWarnings("        ", type, field.getType(), codeBuilder);
                    codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " " + copierFieldName + " = this." + AdmProtobufGenerator.fieldGetterMethodName(field) + "();");
                    codeBuilder.last().appendln("        if (" + copierFieldName + " != null) {");
                    codeBuilder.last().appendln("            copy." + AdmProtobufGenerator.fieldSetterMethodName(field) + "((" + fieldType.getTemplatedJavaTypeName() + ")" + copierFieldName + ".clone());");
                    codeBuilder.last().appendln("        }");
                    codeBuilder.last().appendln("        else {");
                    codeBuilder.last().appendln("            copy." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(null);");
                    codeBuilder.last().appendln("        }");
                    codeBuilder.last().appendln("");
                    continue;
                }
                if (fieldType instanceof AdmEntityArray) {
                    copierFieldName = "copier_" + field.getName();
                    copyFieldName = "copy_" + field.getName();
                    this.writeSuppressDeprecationWarnings("        ", type, field.getType(), codeBuilder);
                    codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " " + copierFieldName + " = " + AdmProtobufGenerator.fieldGetterMethodName(field) + "();");
                    codeBuilder.last().appendln("        if (" + copierFieldName + " != null) {");
                    this.writeSuppressDeprecationWarnings("            ", type, field.getType(), codeBuilder);
                    codeBuilder.last().appendln("            final " + fieldType.getTemplatedJavaTypeName() + " " + copyFieldName + " = new " + ((AdmEntityArray)fieldType).getType().getTemplatedJavaTypeName() + "[" + copierFieldName + ".length];");
                    codeBuilder.last().appendln("            for (int i = 0 ; i < " + copierFieldName + ".length ; i++) {");
                    codeBuilder.last().appendln("                " + copyFieldName + "[i] = (" + ((AdmEntityArray)fieldType).getType().getTemplatedJavaTypeName() + ")" + copierFieldName + "[i].clone();");
                    codeBuilder.last().appendln("            }");
                    codeBuilder.last().appendln("            copy." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(" + copyFieldName + ");");
                    codeBuilder.last().appendln("        }");
                    codeBuilder.last().appendln("        else {");
                    codeBuilder.last().appendln("            copy." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(null);");
                    codeBuilder.last().appendln("        }");
                    codeBuilder.last().appendln("");
                    continue;
                }
                if (fieldType instanceof AdmEnumeration) {
                    codeBuilder.last().appendln("        if (" + AdmProtobufGenerator.fieldCheckerMethodName(field) + "()) {");
                    codeBuilder.last().appendln("           copy." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(this." + AdmProtobufGenerator.fieldGetterMethodName(field) + "());");
                    codeBuilder.last().appendln("        }");
                    codeBuilder.last().appendln("        else {");
                    codeBuilder.last().appendln("           copy." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
                    codeBuilder.last().appendln("        }");
                    codeBuilder.last().appendln("");
                    continue;
                }
                if (!(fieldType instanceof AdmEnumerationArray)) continue;
                copierFieldName = "copier_" + field.getName();
                copyFieldName = "copy_" + field.getName();
                this.writeSuppressDeprecationWarnings("        ", type, field.getType(), codeBuilder);
                codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " " + copierFieldName + " = " + AdmProtobufGenerator.fieldGetterMethodName(field) + "();");
                codeBuilder.last().appendln("        if (" + copierFieldName + " != null) {");
                this.writeSuppressDeprecationWarnings("            ", type, field.getType(), codeBuilder);
                codeBuilder.last().appendln("            final " + fieldType.getTemplatedJavaTypeName() + " " + copyFieldName + " = new " + ((AdmEnumerationArray)fieldType).getType().getTemplatedJavaTypeName() + "[" + copierFieldName + ".length];");
                codeBuilder.last().appendln("            for (int i = 0 ; i < " + copierFieldName + ".length ; i++) {");
                codeBuilder.last().appendln("                " + copyFieldName + "[i] = " + copierFieldName + "[i];");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("            copy." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(" + copyFieldName + ");");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("            copy." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(null);");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("");
            }
        }
        if (type instanceof AdmMessage) {
            codeBuilder.last().appendln("        copyCopyableFieldsToCopy(copy);");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeMessageViewSerializerMethods(AdmScopedType type, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- MessageView methods -----");
        this.writeSerializeToByteArrayMethod(type, codeBuilder);
        this.writeSerializeToByteBufferMethod(type, codeBuilder);
        this.writeSerializeToPacketMethod(type, codeBuilder);
        this.writeDeserializeFromByteArrayMethod(type, codeBuilder);
        this.writeDeserializeFromByteBufferMethod(type, codeBuilder);
        this.writeDeserializeFromPacketMethod(type, codeBuilder);
        this.writeSyncMethod(type, fields, codeBuilder);
        if (type instanceof AdmMessage) {
            this.writeCopyMethods((AdmMessage)type, fields, codeBuilder);
        }
        codeBuilder.last().appendln("    // ----- MessageView methods -----");
    }

    private final void writeEmbeddedEntitySerializerMethods(AdmEntity entity, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Serialize/Deserialize methods -----");
        this.writeSerializeToByteArrayMethod(entity, codeBuilder);
        this.writeSerializeToByteBufferMethod(entity, codeBuilder);
        this.writeEmbeddedEntityIsBufferBacked(entity, codeBuilder);
        this.writeEmbeddedEntityGetSerializeToNativeLength(entity, codeBuilder);
        this.writeEmbeddedEntitySerializeToNativeMethod(entity, codeBuilder);
        this.writeDeserializeFromByteArrayMethod(entity, codeBuilder);
        this.writeDeserializeFromByteBufferMethod(entity, codeBuilder);
        this.writeSyncMethod(entity, fields, codeBuilder);
        this.writeEmbeddedEntityDeserializeFromNativeMethod(entity, codeBuilder);
        codeBuilder.last().appendln("    // ----- Serialize/Deserialize methods -----");
    }

    private final void writeGetContentEncodingMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public EncodingType getContentEncodingType() {");
        codeBuilder.last().appendln("        return EncodingType.Protobuf;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public %{com.neeve.pkt.PktPacket} serialize() {");
        if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("        return serializeForStoreCommit();");
        } else {
            codeBuilder.last().appendln("        return serializeToPacket();");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserialize(final %{com.neeve.pkt.PktPacket} packet) {");
        if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("        deserializeFromStoreReplicationOrInit(packet);");
            codeBuilder.last().appendln("        return this;");
        } else {
            codeBuilder.last().appendln("        return deserializeFromPacket(packet);");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeSetFieldValueMethod(AdmScopedType type, List<AdmField> fields, boolean transactional, AdmEncodingType protoXbufGenCompatibility, AdmSourceCodeBuilder codeBuilder) {
        if (!type.isDeprecated() && transactional && this.getDeprecatedFieldCount(type, fields, false, false) > 0) {
            codeBuilder.last().appendln("    @SuppressWarnings(\"deprecation\")");
        }
        codeBuilder.last().appendln("    final public %{com.neeve.ods.IStoreObject} setFieldValue(final int id, final Object val) {");
        if (transactional) {
            codeBuilder.last().appendln("        boolean processed = false;");
            for (AdmField field : fields) {
                AdmType fieldType = field.getType();
                if (fieldType instanceof AdmPrimitive) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmProtobufGenerator.fieldFidVarName(field) + ") {");
                    switch (((AdmPrimitive)fieldType).getType()) {
                        case UUID: {
                            codeBuilder.last().appendln("            builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
                            codeBuilder.last().appendln("            if (val != null) {");
                            codeBuilder.last().appendln("                builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.types.protobuf.AdmTypeHelper}.toAdmUUID((%{com.eaio.uuid.UUID})val));");
                            codeBuilder.last().appendln("            }");
                            break;
                        }
                        case Date: {
                            codeBuilder.last().appendln("            builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
                            codeBuilder.last().appendln("            if (val != null) {");
                            codeBuilder.last().appendln("            builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(((Date)val).getTime());");
                            codeBuilder.last().appendln("            }");
                            break;
                        }
                        case Currency: {
                            codeBuilder.last().appendln("            builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
                            codeBuilder.last().appendln("            if (val != null) {");
                            codeBuilder.last().appendln("            builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(((Currency)val).getCurrencyCode());");
                            codeBuilder.last().appendln("            }");
                            break;
                        }
                        case Byte: 
                        case Short: 
                        case Char: 
                        case Integer: 
                        case Long: 
                        case Float: 
                        case Double: 
                        case Boolean: 
                        case String: {
                            codeBuilder.last().appendln("            builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "((" + fieldType.getTemplatedJavaTypeName() + ")val);");
                        }
                    }
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (fieldType instanceof AdmPrimitiveArray) {
                    String javaPrimitive = null;
                    String protoPrimitive = null;
                    String protoConverter = null;
                    switch (((AdmPrimitiveArray)fieldType).getType()) {
                        case Byte: {
                            javaPrimitive = "byte";
                            protoPrimitive = "Integer";
                            break;
                        }
                        case Short: {
                            javaPrimitive = "short";
                            protoPrimitive = "Integer";
                            break;
                        }
                        case Char: {
                            javaPrimitive = "char";
                            protoPrimitive = "Integer";
                            break;
                        }
                        case Integer: {
                            javaPrimitive = "int";
                            protoPrimitive = "Integer";
                            break;
                        }
                        case Long: {
                            javaPrimitive = "long";
                            protoPrimitive = "Long";
                            break;
                        }
                        case Float: {
                            javaPrimitive = "float";
                            protoPrimitive = "Float";
                            break;
                        }
                        case Double: {
                            javaPrimitive = "double";
                            protoPrimitive = "Double";
                            break;
                        }
                        case Boolean: {
                            javaPrimitive = "boolean";
                            protoPrimitive = "Boolean";
                            break;
                        }
                        case String: {
                            javaPrimitive = "String";
                            protoPrimitive = "String";
                            break;
                        }
                        case Date: {
                            javaPrimitive = "Date";
                            protoPrimitive = "Date";
                            protoConverter = "v.getTime()";
                            break;
                        }
                        case Currency: {
                            javaPrimitive = "Currency";
                            protoPrimitive = "Currency";
                            protoConverter = "v.getCurrencyCode()";
                            break;
                        }
                        case UUID: {
                            javaPrimitive = "%{com.eaio.uuid.UUID}";
                            protoPrimitive = "AdmUUID";
                            protoConverter = "%{com.neeve.adm.types.protobuf.AdmTypeHelper}.toAdmUUID(v)";
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported primitive array type '" + (Object)((Object)((AdmPrimitiveArray)fieldType).getType()) + "'");
                        }
                    }
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmProtobufGenerator.fieldFidVarName(field) + ") {");
                    codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldValueVarName(field) + " = (" + javaPrimitive + "[])val;");
                    codeBuilder.last().appendln("            builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
                    codeBuilder.last().appendln("            if (val != null) {");
                    if (protoXbufGenCompatibility == AdmEncodingType.Xbuf && ((AdmPrimitiveArray)fieldType).getType() == AdmPrimitive.Type.Byte) {
                        codeBuilder.last().appendln("                builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(com.google.protobuf.ByteString.copyFrom((" + javaPrimitive + "[])val));");
                    } else {
                        codeBuilder.last().appendln("                for (" + javaPrimitive + " v : (" + javaPrimitive + "[])val) {");
                        if (protoConverter != null) {
                            codeBuilder.last().appendln("                    builder()." + AdmProtobufGenerator.fieldAddMethodName(field) + "(" + protoConverter + ");");
                        } else {
                            codeBuilder.last().appendln("                    builder()." + AdmProtobufGenerator.fieldAddMethodName(field) + "(new " + protoPrimitive + "(v));");
                        }
                        codeBuilder.last().appendln("                }");
                    }
                    codeBuilder.last().appendln("            }");
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (fieldType instanceof AdmEntity && ((AdmEntity)fieldType).isEmbedded()) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmProtobufGenerator.fieldFidVarName(field) + ") {");
                    codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldValueVarName(field) + " = (" + fieldType.getTemplatedJavaTypeName() + ")val;");
                    codeBuilder.last().appendln("            if (val != null) {");
                    codeBuilder.last().appendln("                builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(((" + fieldType.getTemplatedJavaTypeName() + ")val).message());");
                    codeBuilder.last().appendln("            }");
                    codeBuilder.last().appendln("            else {");
                    codeBuilder.last().appendln("                builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
                    codeBuilder.last().appendln("            }");
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (fieldType instanceof AdmEntityArray) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmProtobufGenerator.fieldFidVarName(field) + ") {");
                    codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldValueVarName(field) + " = (" + fieldType.getTemplatedJavaTypeName() + ")val;");
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (fieldType instanceof AdmEnumeration) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmProtobufGenerator.fieldFidVarName(field) + ") {");
                    codeBuilder.last().appendln("            if (val != null) {");
                    codeBuilder.last().appendln("               builder()." + AdmProtobufGenerator.fieldSetterMethodName(field) + "(" + this.protobufName(type, (AdmScopedType)fieldType) + ".valueOf(((" + fieldType.getTemplatedJavaTypeName() + ")val).val));");
                    codeBuilder.last().appendln("            }");
                    codeBuilder.last().appendln("            else {");
                    codeBuilder.last().appendln("               builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
                    codeBuilder.last().appendln("            }");
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (!(fieldType instanceof AdmEnumerationArray)) continue;
                codeBuilder.last().appendln("        if (!processed && id == " + AdmProtobufGenerator.fieldFidVarName(field) + ") {");
                codeBuilder.last().appendln("            " + AdmProtobufGenerator.fieldValueVarName(field) + " = (" + fieldType.getTemplatedJavaTypeName() + ")val;");
                codeBuilder.last().appendln("            builder()." + AdmProtobufGenerator.fieldClearerMethodName(field) + "();");
                codeBuilder.last().appendln("            if (val != null) {");
                codeBuilder.last().appendln("                for (" + ((AdmEnumerationArray)fieldType).getType().getTemplatedJavaTypeName() + " v : (" + fieldType.getTemplatedJavaTypeName() + ")val) {");
                codeBuilder.last().appendln("                    builder()." + AdmProtobufGenerator.fieldAddMethodName(field) + "(" + this.protobufName(((AdmEnumerationArray)fieldType).getType()) + ".valueOf(v.val));");
                codeBuilder.last().appendln("                }");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("            processed = true;");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("        if (!processed) {");
            codeBuilder.last().appendln("            super.setFieldValue(id, val);");
            codeBuilder.last().appendln("        }");
        } else {
            codeBuilder.last().appendln("        // this method will never be called since this class was generated as a non-transactional entity");
        }
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeImplementedIStoreObjectMethods(AdmFactoryType type, List<AdmField> fields, boolean transactional, AdmEncodingType protoXbufGenCompatibility, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- IStoreObject methods -----");
        this.writeGetContentEncodingMethod(type, codeBuilder);
        this.writeSerializeMethod(type, codeBuilder);
        this.writeDeserializeMethod(type, codeBuilder);
        if (!(type instanceof AdmCollection)) {
            this.writeSetFieldValueMethod(type, fields, transactional, protoXbufGenCompatibility, codeBuilder);
        }
        codeBuilder.last().appendln("    // ----- IStoreObject methods -----");
    }

    private final void writeImplementedCollectionMethods(AdmCollection collection, AdmSourceCodeBuilder codeBuilder) {
        switch (collection.getType()) {
            case List: 
            case Queue: {
                break;
            }
            case ByteMap: 
            case CharMap: 
            case ShortMap: 
            case IntMap: 
            case LongMap: 
            case FloatMap: 
            case DoubleMap: 
            case StringMap: {
                AdmType keyType = collection.getKeyType();
                AdmEntity valueType = collection.getContains();
                AdmField keyField = this.keyFieldFor(collection);
                if (keyField == null) {
                    throw new IllegalStateException("No key field of type '" + keyType.getName() + "' in entity '" + valueType.getQualifiedName(collection.getModel()) + "' which is declared as value of " + (Object)((Object)collection.getType()) + " collection '" + collection.getName() + "'");
                }
                String keyJavaType = "%{" + keyType.getJavaTypeName() + "}";
                if (keyType instanceof AdmPrimitive) {
                    AdmPrimitive primitiveKeyType = (AdmPrimitive)keyType;
                    switch (primitiveKeyType.getType()) {
                        case Long: {
                            keyJavaType = "long";
                            break;
                        }
                        case Boolean: {
                            keyJavaType = "boolean";
                            break;
                        }
                        case Byte: {
                            keyJavaType = "byte";
                            break;
                        }
                        case Char: {
                            keyJavaType = "char";
                            break;
                        }
                        case Double: {
                            keyJavaType = "double";
                            break;
                        }
                        case Float: {
                            keyJavaType = "float";
                            break;
                        }
                        case Integer: {
                            keyJavaType = "int";
                            break;
                        }
                        case Short: {
                            keyJavaType = "short";
                            break;
                        }
                        case String: {
                            keyJavaType = "String";
                            break;
                        }
                        case UUID: 
                        case Date: 
                        case Currency: {
                            keyJavaType = "%{" + keyType.getJavaTypeName() + "}";
                        }
                    }
                }
                codeBuilder.last().appendln("    // ----- Rog Map methods -----");
                codeBuilder.last().appendln("    @Override");
                codeBuilder.last().appendln("    final protected " + keyJavaType + " getMapElementKey(final %{" + valueType.getFullName() + "} value) {");
                codeBuilder.last().appendln("        return value." + AdmProtobufGenerator.fieldGetterMethodName(keyField) + "();");
                codeBuilder.last().appendln("    }");
                codeBuilder.last().appendln("");
                codeBuilder.last().appendln("    @Override");
                codeBuilder.last().appendln("    final protected void setMapElementKey(final %{" + valueType.getFullName() + "} value, final " + keyJavaType + " key) {");
                codeBuilder.last().appendln("        value." + AdmProtobufGenerator.fieldSetterMethodName(keyField) + "(key);");
                codeBuilder.last().appendln("    }");
                codeBuilder.last().appendln("    // ----- Rog Map methods -----");
                break;
            }
        }
    }

    private final int writeRogMetadataCoreInProtobufIDL(PrintWriter writer, int fldNo) {
        writer.println("   // X Platform fields ---");
        writer.println("   optional int32 xRogType = " + ++fldNo + ";");
        return fldNo;
    }

    final void generateProtobufIDL(AdmEntity entity, AdmEncodingType protoXbufGenCompatibility, PrintWriter writer) {
        List<AdmField> fields = this.prepareFieldList(entity);
        int fldNo = 0;
        writer.println("message " + entity.getName() + " {");
        if (!entity.isEmbedded()) {
            fldNo = this.writeRogMetadataCoreInProtobufIDL(writer, fldNo);
            writer.println("");
        }
        if (fields.size() > 0) {
            writer.println("   // User defined fields");
            for (AdmField field : fields) {
                if (field.getId() > 0) {
                    AdmType fieldType = field.getType();
                    if (fieldType instanceof AdmPrimitive) {
                        switch (((AdmPrimitive)fieldType).getType()) {
                            case Byte: 
                            case Short: 
                            case Char: {
                                writer.println("   optional int32 " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                break;
                            }
                            case Integer: {
                                writer.println("   optional int32 " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                break;
                            }
                            case Long: {
                                writer.println("   optional int64 " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                break;
                            }
                            case Float: {
                                writer.println("   optional float " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                break;
                            }
                            case Double: {
                                writer.println("   optional double " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                break;
                            }
                            case Boolean: {
                                writer.println("   optional bool " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                break;
                            }
                            case String: {
                                writer.println("   optional string " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                break;
                            }
                            case Date: {
                                writer.println("   optional int64 " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                break;
                            }
                            case UUID: {
                                writer.println("   optional com.neeve.adm.types.protobuf.AdmUUID " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                break;
                            }
                            case Currency: {
                                writer.println("   optional string " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                            }
                        }
                        continue;
                    }
                    if (fieldType instanceof AdmArray) {
                        if (fieldType instanceof AdmPrimitiveArray) {
                            switch (((AdmPrimitiveArray)fieldType).getType()) {
                                case Byte: {
                                    if (protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                                        writer.println("   optional bytes " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                        break;
                                    }
                                    writer.println("   repeated int32 " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                    break;
                                }
                                case Short: 
                                case Char: {
                                    if (protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                                        writer.println("   repeated int32 " + field.getName() + " = " + this.protobufFieldId(field.getId()) + " [packed=true];");
                                        break;
                                    }
                                    writer.println("   repeated int32 " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                    break;
                                }
                                case Integer: {
                                    if (protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                                        writer.println("   repeated int32 " + field.getName() + " = " + this.protobufFieldId(field.getId()) + " [packed=true];");
                                        break;
                                    }
                                    writer.println("   repeated int32 " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                    break;
                                }
                                case Long: {
                                    if (protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                                        writer.println("   repeated int64 " + field.getName() + " = " + this.protobufFieldId(field.getId()) + " [packed=true];");
                                        break;
                                    }
                                    writer.println("   repeated int64 " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                    break;
                                }
                                case Float: {
                                    if (protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                                        writer.println("   repeated float " + field.getName() + " = " + this.protobufFieldId(field.getId()) + " [packed=true];");
                                        break;
                                    }
                                    writer.println("   repeated float " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                    break;
                                }
                                case Double: {
                                    if (protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                                        writer.println("   repeated double " + field.getName() + " = " + this.protobufFieldId(field.getId()) + " [packed=true];");
                                        break;
                                    }
                                    writer.println("   repeated double " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                    break;
                                }
                                case Boolean: {
                                    if (protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                                        writer.println("   repeated bool " + field.getName() + " = " + this.protobufFieldId(field.getId()) + " [packed=true];");
                                        break;
                                    }
                                    writer.println("   repeated bool " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                    break;
                                }
                                case String: {
                                    writer.println("   repeated string " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                    break;
                                }
                                case Date: {
                                    if (protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                                        writer.println("   repeated int64 " + field.getName() + " = " + this.protobufFieldId(field.getId()) + " [packed=true];");
                                        break;
                                    }
                                    writer.println("   repeated int64 " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                    break;
                                }
                                case UUID: {
                                    writer.println("   repeated com.neeve.adm.types.protobuf.AdmUUID " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                    break;
                                }
                                case Currency: {
                                    writer.println("   repeated string " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                                }
                            }
                            continue;
                        }
                        if (fieldType instanceof AdmEntityArray) {
                            writer.println("   repeated " + ((AdmEntityArray)fieldType).getType().getFullName() + " " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                            continue;
                        }
                        if (!(fieldType instanceof AdmEnumerationArray)) continue;
                        writer.println("   repeated " + ((AdmEnumerationArray)fieldType).getType().getFullName() + " " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                        continue;
                    }
                    if (fieldType instanceof AdmEnumeration) {
                        writer.println("   optional " + fieldType.getFullName() + " " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                        continue;
                    }
                    if (fieldType instanceof AdmEntity) {
                        writer.println("   optional " + fieldType.getFullName() + " " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                        continue;
                    }
                    if (fieldType instanceof AdmCollection) {
                        writer.println("   optional " + fieldType.getFullName() + " " + field.getName() + " = " + this.protobufFieldId(field.getId()) + ";");
                        continue;
                    }
                    throw new IllegalArgumentException("unknown field type '" + field.getType().getName() + " = " + field.getId() + "'");
                }
                throw new IllegalStateException("field id must be set to a value > 0 for protobuf encoded entities and messages");
            }
        }
        writer.println("}");
    }

    final void generateProtobufIDL(AdmCollection collection, PrintWriter writer) {
        int fldNo = 0;
        writer.println("message " + collection.getName() + " {");
        fldNo = this.writeRogMetadataCoreInProtobufIDL(writer, fldNo);
        writer.println("}");
    }

    final void generateClass(AdmEntity entity, AdmEncodingType protoXbufGenCompatibility, boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        List<AdmField> fields = this.prepareFieldList(entity);
        codeBuilder.last().appendln("");
        this.writeClassDeclaration(entity, fields, codeBuilder);
        if (!entity.isEmbedded() && (entity.containsChildren() || !entity.containedInSet().isEmpty() || entity.isTransactional())) {
            this.writeFieldFidDeclarations(entity, fields, codeBuilder);
            codeBuilder.last().appendln("");
            this.writeIndexFieldDeclarations(entity, fields, codeBuilder);
            codeBuilder.last().appendln("");
        }
        if (entity.isMessage()) {
            this.writeRogMessageReflectorFieldDeclarations(entity, fields, AdmEncodingType.Protobuf.toString(), codeBuilder);
            codeBuilder.last().appendln("");
        }
        this.writeFieldBitmaskDeclaration(codeBuilder);
        if (entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeReadOnlyFieldDeclaration(entity, codeBuilder);
        }
        codeBuilder.last().appendln("");
        this.writeInitializer(fields, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeProtobufFields(entity, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeConstructors(entity, fields, codeBuilder);
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeXRogTypeGetterMethod(codeBuilder);
        }
        codeBuilder.last().appendln("");
        this.writeClearCachedFieldValuesMethod(fields, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeClearContentMethod(fields, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeJsonSerializeBitmaskSyncMethod(entity, fields, codeBuilder);
        this.writeJsonDeserializeBitmaskDesyncMethod(entity, fields, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeProtobufManagementMethods(entity, fields, codeBuilder);
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeImplementedIRogNodeMethods(entity, codeBuilder);
            codeBuilder.last().appendln("");
            this.writeOverridenRogNodeMethods(entity, fields, codeBuilder);
        } else {
            codeBuilder.last().appendln("");
            this.writeReadOnlyGetterSetterMethods(entity, fields, codeBuilder);
        }
        if (entity.isRoot() || entity.containsChildren()) {
            codeBuilder.last().appendln("");
            this.writeOverridenRogContainerNodeMethods(entity, fields, codeBuilder);
        }
        if (entity.isPojoShadow()) {
            codeBuilder.last().appendln("");
            this.writeImplementedIRogPojoShadowNodeMethods(entity, codeBuilder);
        }
        codeBuilder.last().appendln("");
        this.writeFieldMethods(entity, fields, protoXbufGenCompatibility, generateArrayGetterEmptyIfNull, codeBuilder);
        codeBuilder.last().appendln("");
        if (!entity.isEmbedded()) {
            this.writeMessageViewSerializerMethods(entity, fields, codeBuilder);
        } else {
            this.writeEmbeddedEntitySerializerMethods(entity, fields, codeBuilder);
        }
        if (entity.isMessage()) {
            codeBuilder.last().appendln("");
            this.writeRogMessageReflectorMethods(entity, fields, codeBuilder);
        }
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeImplementedIStoreObjectMethods(entity, fields, entity.isTransactional(), protoXbufGenCompatibility, codeBuilder);
        }
        if (entity.isEmbedded()) {
            this.writeEmbeddedEntityPoolingMethods(entity, codeBuilder);
        }
        if (entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeCloneMethod(entity, fields, codeBuilder);
            this.writeCopyMethods(entity, fields, codeBuilder);
        }
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeToJsonStringMethod(codeBuilder);
        }
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeVisitFieldsMethod(fields, codeBuilder);
        }
        this.writeIndexFieldsGetter(entity, fields, codeBuilder);
        this.writeValidatorMethods(entity, fields, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeToStringMethod(fields, !entity.isEmbedded(), codeBuilder);
        codeBuilder.last().appendln("}");
    }

    final void generateClass(AdmCollection collection, AdmSourceCodeBuilder codeBuilder) {
        ArrayList<AdmField> fields = new ArrayList<AdmField>();
        codeBuilder.last().appendln("");
        this.writeClassDeclaration(collection, codeBuilder);
        this.writeConstructors(collection, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeXRogTypeGetterMethod(codeBuilder);
        codeBuilder.last().appendln("");
        this.writeImplementedIStoreObjectMethods(collection, fields, true, null, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeImplementedCollectionMethods(collection, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeToJsonStringMethod(codeBuilder);
        codeBuilder.last().appendln("");
        this.writeToStringMethod(fields, true, codeBuilder);
    }
}

