/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.DDLStatementNode;
import com.akiban.sql.parser.ExistenceCheck;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ResultColumnList;
import com.akiban.sql.parser.ResultSetNode;
import com.akiban.sql.parser.TableElementList;
import com.akiban.sql.parser.TableName;
import com.akiban.sql.parser.Visitor;
import java.util.Properties;

public class CreateTableNode
extends DDLStatementNode {
    public static final int BASE_TABLE_TYPE = 0;
    public static final int SYSTEM_TABLE_TYPE = 1;
    public static final int VIEW_TYPE = 2;
    public static final int GLOBAL_TEMPORARY_TABLE_TYPE = 3;
    public static final int SYNONYM_TYPE = 4;
    public static final int VTI_TYPE = 5;
    public static final char ROW_LOCK_GRANULARITY = 'R';
    public static final char TABLE_LOCK_GRANULARITY = 'T';
    public static final char DEFAULT_LOCK_GRANULARITY = 'R';
    private char lockGranularity;
    private boolean onCommitDeleteRows;
    private boolean onRollbackDeleteRows;
    private Properties properties;
    private TableElementList tableElementList;
    protected int tableType;
    private ResultColumnList resultColumns;
    private ResultSetNode queryExpression;
    private boolean withData;
    private ExistenceCheck existenceCheck;

    @Override
    public void init(Object newObjectName, Object tableElementList, Object properties, Object lockGranularity, Object existenceCheck) throws StandardException {
        this.tableType = 0;
        this.lockGranularity = ((Character)lockGranularity).charValue();
        this.implicitCreateSchema = true;
        assert (this.lockGranularity == 'T' || this.lockGranularity == 'R');
        this.initAndCheck(newObjectName);
        this.tableElementList = (TableElementList)tableElementList;
        this.properties = (Properties)properties;
        this.existenceCheck = (ExistenceCheck)((Object)existenceCheck);
    }

    @Override
    public void init(Object newObjectName, Object tableElementList, Object properties, Object onCommitDeleteRows, Object onRollbackDeleteRows, Object existenceCheck) throws StandardException {
        this.tableType = 3;
        newObjectName = this.tempTableSchemaNameCheck(newObjectName);
        this.onCommitDeleteRows = (Boolean)onCommitDeleteRows;
        this.onRollbackDeleteRows = (Boolean)onRollbackDeleteRows;
        this.initAndCheck(newObjectName);
        this.tableElementList = (TableElementList)tableElementList;
        this.properties = (Properties)properties;
        this.existenceCheck = (ExistenceCheck)((Object)existenceCheck);
        assert (this.onRollbackDeleteRows);
    }

    @Override
    public void init(Object newObjectName, Object resultColumns, Object queryExpression, Object c) throws StandardException {
        this.tableType = 0;
        this.lockGranularity = (char)82;
        this.implicitCreateSchema = true;
        this.initAndCheck(newObjectName);
        this.resultColumns = (ResultColumnList)resultColumns;
        this.queryExpression = (ResultSetNode)queryExpression;
        this.existenceCheck = (ExistenceCheck)((Object)c);
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        CreateTableNode other = (CreateTableNode)node;
        this.lockGranularity = other.lockGranularity;
        this.onCommitDeleteRows = other.onCommitDeleteRows;
        this.onRollbackDeleteRows = other.onRollbackDeleteRows;
        this.properties = other.properties;
        this.tableElementList = (TableElementList)this.getNodeFactory().copyNode(other.tableElementList, this.getParserContext());
        this.tableType = other.tableType;
        this.resultColumns = (ResultColumnList)this.getNodeFactory().copyNode(other.resultColumns, this.getParserContext());
        this.queryExpression = (ResultSetNode)this.getNodeFactory().copyNode(other.queryExpression, this.getParserContext());
        this.withData = other.withData;
        this.existenceCheck = other.existenceCheck;
    }

    private Object tempTableSchemaNameCheck(Object objectName) throws StandardException {
        TableName tempTableName = (TableName)objectName;
        if (tempTableName != null) {
            if (tempTableName.getSchemaName() == null) {
                tempTableName.setSchemaName("SESSION");
            } else if (!"SESSION".equals(tempTableName.getSchemaName())) {
                throw new StandardException("Must specify SESSION schema");
            }
        }
        return tempTableName;
    }

    @Override
    public String toString() {
        String tempString = "";
        if (this.tableType == 3) {
            tempString = tempString + "onCommitDeleteRows: " + "\n" + this.onCommitDeleteRows + "\n";
            tempString = tempString + "onRollbackDeleteRows: " + "\n" + this.onRollbackDeleteRows + "\n";
        } else {
            tempString = tempString + (this.properties != null ? "properties: \n" + this.properties + "\n" : "") + (this.withData ? "withData: " + this.withData + "\n" : "") + "lockGranularity: " + this.lockGranularity + "\n";
        }
        tempString = tempString + "existenceCheck: " + (Object)((Object)this.existenceCheck) + "\n";
        return super.toString() + tempString;
    }

    public TableElementList getTableElementList() {
        return this.tableElementList;
    }

    public ResultSetNode getQueryExpression() {
        return this.queryExpression;
    }

    public boolean isWithData() {
        return this.withData;
    }

    public void markWithData() {
        this.withData = true;
    }

    public ExistenceCheck getExistenceCheck() {
        return this.existenceCheck;
    }

    @Override
    public void printSubNodes(int depth) {
        if (this.tableElementList != null) {
            this.printLabel(depth, "tableElementList: ");
            this.tableElementList.treePrint(depth + 1);
        }
        if (this.queryExpression != null) {
            this.printLabel(depth, "queryExpression: ");
            this.queryExpression.treePrint(depth + 1);
        }
    }

    @Override
    public String statementToString() {
        if (this.tableType == 3) {
            return "DECLARE GLOBAL TEMPORARY TABLE";
        }
        return "CREATE TABLE";
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.tableElementList != null) {
            this.tableElementList.accept(v);
        }
        if (this.queryExpression != null) {
            this.queryExpression.accept(v);
        }
    }
}

