/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto.test.unit;

import com.neeve.sto.StoField;
import com.neeve.sto.StoIntArrayField;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class StoIntArrayFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    public static final int[] createArray(int len) {
        int[] array = new int[len];
        for (int i = 0; i < array.length; ++i) {
            array[i] = random.nextInt(100000);
        }
        return array;
    }

    public static final int[] cloneArray(int[] original) {
        int[] clone = new int[original.length];
        System.arraycopy(original, 0, clone, 0, original.length);
        return clone;
    }

    public static final void compare(int[] array1, int[] array2, boolean same) {
        if (array1 == null) {
            Assert.assertNull((Object)array2);
        } else if (same) {
            Assert.assertSame((Object)array1, (Object)array2);
        } else if (array2 == null) {
            Assert.fail();
        } else if (array1.length != array2.length) {
            Assert.fail();
        } else {
            for (int i = 0; i < array1.length; ++i) {
                if (array1[i] == array2[i]) continue;
                Assert.fail();
            }
        }
    }

    private final void validate(StoIntArrayField field, String name, ByteBuffer buffer, int[] val, boolean same) {
        if (name == null) {
            Assert.assertNull((Object)field.getName());
        } else {
            Assert.assertEquals((Object)field.getName(), (Object)name);
        }
        if (buffer == null) {
            Assert.assertNull((Object)field.getBackingBuffer());
        } else {
            Assert.assertSame((Object)field.getBackingBuffer(), (Object)buffer);
        }
        Assert.assertEquals((Object)((Object)StoField.Type.INTEGER_ARRAY), (Object)((Object)field.getType()));
        StoIntArrayFieldTest.compare(val, (int[])field.getValue(), same);
    }

    private final void cloneAndValidate(StoIntArrayField field, String name, int[] val) {
        StoIntArrayField clone = (StoIntArrayField)field.clone();
        Assert.assertNotSame((Object)clone, (Object)field);
        this.validate(clone, name, null, val, false);
        Assert.assertTrue((boolean)field.contentsEquals(clone));
    }

    private final void validate(ByteBuffer buffer, int pos, int limit, int capacity) {
        Assert.assertEquals((long)buffer.position(), (long)pos);
        Assert.assertEquals((long)buffer.limit(), (long)limit);
        Assert.assertEquals((long)buffer.capacity(), (long)capacity);
    }

    @Test
    public void testStaticMethods() throws Exception {
        Assert.assertEquals((long)StoIntArrayField.getSerializedLength(StoIntArrayFieldTest.createArray(5)), (long)22L);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        StoIntArrayField.put(buffer, 5, null);
        Assert.assertEquals((long)StoIntArrayField.getSerializedLength(buffer, 5), (long)2L);
        this.validate(buffer, 0, 100, 100);
        StoIntArrayFieldTest.compare(StoIntArrayField.get(buffer, 5), null, false);
        this.validate(buffer, 0, 100, 100);
        int[] array1 = StoIntArrayFieldTest.createArray(0);
        StoIntArrayField.put(buffer, 5, array1);
        Assert.assertEquals((long)StoIntArrayField.getSerializedLength(buffer, 5), (long)2L);
        this.validate(buffer, 0, 100, 100);
        StoIntArrayFieldTest.compare(StoIntArrayField.get(buffer, 5), array1, false);
        this.validate(buffer, 0, 100, 100);
        array1 = StoIntArrayFieldTest.createArray(5);
        int[] array2 = StoIntArrayFieldTest.createArray(5);
        StoIntArrayField.put(buffer, 5, array1);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoIntArrayField.getSerializedLength(buffer, 5), (long)22L);
        this.validate(buffer, 0, 100, 100);
        StoIntArrayFieldTest.compare(StoIntArrayField.get(buffer, 5), array1, false);
        this.validate(buffer, 0, 100, 100);
        StoIntArrayField.put(buffer, 5, array2);
        this.validate(buffer, 0, 100, 100);
        StoIntArrayFieldTest.compare(StoIntArrayField.get(buffer, 5), array2, false);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullName() throws Exception {
        StoIntArrayField field = StoIntArrayField.create(null);
        this.validate(field, null, null, null, true);
        this.cloneAndValidate(field, null, null);
    }

    @Test
    public void testCreateWithNonNullName() throws Exception {
        StoIntArrayField field = StoIntArrayField.create("name");
        this.validate(field, "name", null, null, true);
        this.cloneAndValidate(field, "name", null);
    }

    @Test
    public void testIsVariableLength() throws Exception {
        Assert.assertTrue((boolean)StoIntArrayField.create(null).isVariableLength());
    }

    @Test
    public void testCreateWithNullNameSetValue() throws Exception {
        StoIntArrayField field = StoIntArrayField.create(null);
        int[] array = StoIntArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(field, null, null, array, true);
        this.cloneAndValidate(field, null, array);
    }

    @Test
    public void testCreateWithNonNullNameSetValue() throws Exception {
        StoIntArrayField field = StoIntArrayField.create("name");
        int[] array = StoIntArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(field, "name", null, array, true);
        this.cloneAndValidate(field, "name", array);
    }

    @Test
    public void testCreateWithNullNameBackByBuffer() throws Exception {
        StoIntArrayField field = StoIntArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 5);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, null, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBuffer() throws Exception {
        StoIntArrayField field = StoIntArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 9);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, null, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByBuffer() throws Exception {
        StoIntArrayField field = StoIntArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        int[] array = StoIntArrayFieldTest.createArray(5);
        field.setValue(array);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, array, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByBuffer() throws Exception {
        StoIntArrayField field = StoIntArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        int[] array = StoIntArrayFieldTest.createArray(5);
        field.setValue(array);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, array, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoIntArrayField field = StoIntArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        int[] array = StoIntArrayFieldTest.createArray(5);
        field.setValue(array);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, array, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoIntArrayField field = StoIntArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        int[] array = StoIntArrayFieldTest.createArray(5);
        field.setValue(array);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, array, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValue() throws Exception {
        StoIntArrayField field = StoIntArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        int[] array = StoIntArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, array, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValue() throws Exception {
        StoIntArrayField field = StoIntArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        int[] array = StoIntArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, array, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoIntArrayField field = StoIntArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        int[] array = StoIntArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, array, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoIntArrayField field = StoIntArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        int[] array = StoIntArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, array, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueSync() throws Exception {
        StoIntArrayField field = StoIntArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        int[] array = StoIntArrayFieldTest.createArray(5);
        field.setValue(array);
        field.sync(buffer, 45);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, array, true);
        this.validate(buffer, 0, 100, 100);
        StoIntArrayFieldTest.compare(StoIntArrayField.get(buffer, field.shiftForHeader(45)), array, false);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueSync() throws Exception {
        StoIntArrayField field = StoIntArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        int[] array = StoIntArrayFieldTest.createArray(5);
        field.setValue(array);
        field.sync(buffer, 52);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, array, true);
        this.validate(buffer, 0, 100, 100);
        StoIntArrayFieldTest.compare(StoIntArrayField.get(buffer, field.shiftForHeader(52)), array, false);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserialize() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        int[] array = StoIntArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 36);
        this.validate(buffer, 0, 100, 100);
        StoIntArrayField field2 = (StoIntArrayField)StoField.create(buffer, 36);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserialize() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        int[] array = StoIntArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 20);
        this.validate(buffer, 0, 100, 100);
        StoIntArrayField field2 = (StoIntArrayField)StoField.create(buffer, 20);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        int[] array = StoIntArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 46);
        this.validate(buffer, 0, 100, 100);
        StoIntArrayField field2 = (StoIntArrayField)StoField.create(buffer, 46);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        int[] array = StoIntArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 30);
        this.validate(buffer, 0, 100, 100);
        StoIntArrayField field2 = (StoIntArrayField)StoField.create(buffer, 30);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        int[] array = StoIntArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer1, 41);
        this.validate(buffer1, 0, 100, 100);
        StoIntArrayField field2 = (StoIntArrayField)StoField.create(buffer1, 41);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoIntArrayField field3 = (StoIntArrayField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, null, buffer2, array, false);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field3.contentsEquals(field2));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, null, array);
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create("name");
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        int[] array = StoIntArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer1, 32);
        this.validate(buffer1, 0, 100, 100);
        StoIntArrayField field2 = (StoIntArrayField)StoField.create(buffer1, 32);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoIntArrayField field3 = (StoIntArrayField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, "name", buffer2, array, false);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field2.contentsEquals(field3));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, "name", array);
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateDeserialize() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoIntArrayField field2 = (StoIntArrayField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateSetNullValueDeserialize() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(null);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoIntArrayField field2 = (StoIntArrayField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateSetEmptyValueDeserialize() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        int[] array = StoIntArrayFieldTest.createArray(0);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoIntArrayField field2 = (StoIntArrayField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateSetBackingBufferSync() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field1.sync(buffer2, 65);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateDeserializeSync() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        StoIntArrayField field2 = (StoIntArrayField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.sync(buffer2, 65);
    }

    @Test
    public void testContentsEqualsWithDifferentNamesFirstNonNull() throws Exception {
        Assert.assertFalse((boolean)StoIntArrayField.create("name").contentsEquals(StoIntArrayField.create(null)));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesSecondNonNull() throws Exception {
        Assert.assertFalse((boolean)StoIntArrayField.create(null).contentsEquals(StoIntArrayField.create("name")));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesBothNonNull() throws Exception {
        Assert.assertFalse((boolean)StoIntArrayField.create("name1").contentsEquals(StoIntArrayField.create("name2")));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesFirstNonNull() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create(null);
        StoIntArrayField field2 = StoIntArrayField.create(null);
        field1.setValue(StoIntArrayFieldTest.createArray(5));
        field2.setValue(null);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesSecondNonNull() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create(null);
        StoIntArrayField field2 = StoIntArrayField.create(null);
        field1.setValue(null);
        field2.setValue(StoIntArrayFieldTest.createArray(5));
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffLengths() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create(null);
        StoIntArrayField field2 = StoIntArrayField.create(null);
        field1.setValue(StoIntArrayFieldTest.createArray(5));
        field2.setValue(StoIntArrayFieldTest.createArray(4));
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffContent() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create(null);
        StoIntArrayField field2 = StoIntArrayField.create(null);
        field1.setValue(StoIntArrayFieldTest.createArray(5));
        field2.setValue(StoIntArrayFieldTest.createArray(5));
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesDefault() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create(null);
        StoIntArrayField field2 = StoIntArrayField.create(null);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesDefault() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create("name");
        StoIntArrayField field2 = StoIntArrayField.create("name");
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesNonDefault() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create(null);
        StoIntArrayField field2 = StoIntArrayField.create(null);
        field1.setValue(StoIntArrayFieldTest.createArray(5));
        field2.setValue(StoIntArrayFieldTest.cloneArray((int[])field1.getValue()));
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesNonDefault() throws Exception {
        StoIntArrayField field1 = StoIntArrayField.create("name");
        StoIntArrayField field2 = StoIntArrayField.create("name");
        field1.setValue(StoIntArrayFieldTest.createArray(5));
        field2.setValue(StoIntArrayFieldTest.cloneArray((int[])field1.getValue()));
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }
}

