/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto.test.unit;

import com.neeve.sto.StoBufferField;
import com.neeve.sto.StoByteArrayField;
import com.neeve.sto.StoField;
import com.neeve.sto.test.unit.StoByteArrayFieldTest;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class StoBufferFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    private final byte[] createArray(int len) {
        return StoByteArrayFieldTest.createArray(len);
    }

    private final void compare(byte[] array1, byte[] array2, boolean same) {
        StoByteArrayFieldTest.compare(array1, array2, same);
    }

    private final byte[] toArray(ByteBuffer buffer) {
        if (buffer != null) {
            byte[] array = new byte[buffer.capacity()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = buffer.get(i);
            }
            return array;
        }
        return null;
    }

    private final void validate(StoBufferField field, String name, ByteBuffer buffer, byte[] val) {
        if (name == null) {
            Assert.assertNull((Object)field.getName());
        } else {
            Assert.assertEquals((Object)field.getName(), (Object)name);
        }
        if (buffer == null) {
            Assert.assertNull((Object)field.getBackingBuffer());
        } else {
            Assert.assertSame((Object)field.getBackingBuffer(), (Object)buffer);
        }
        Assert.assertEquals((Object)((Object)StoField.Type.BUFFER), (Object)((Object)field.getType()));
        this.compare(val, this.toArray(field.getValue()), false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateWithNegativeLength() {
        StoBufferField.create((String)null, -1);
    }

    @Test
    public void testCreateWithNullNamePositiveLength() {
        this.validate(StoBufferField.create((String)null, 10), null, null, new byte[10]);
    }

    @Test
    public void testCreateWithNonNullNamePositiveLength() throws Exception {
        this.validate(StoBufferField.create("name", 10), "name", null, new byte[10]);
    }

    @Test
    public void testCreateWithZeroLength() {
        this.validate(StoBufferField.create((String)null, 0), null, null, new byte[0]);
    }

    @Test
    public void testIsVariableLength() throws Exception {
        Assert.assertFalse((boolean)StoBufferField.create((String)null, 10).isVariableLength());
    }

    @Test
    public void testCreateWithNullNameManipulateValue() throws Exception {
        StoBufferField field = StoBufferField.create((String)null, 5);
        byte[] array = this.createArray(5);
        field.getValue().put(array);
        this.validate(field, null, null, array);
    }

    @Test
    public void testCreateWithNonNullNameManipulateValue() throws Exception {
        StoBufferField field = StoBufferField.create("name", 5);
        byte[] array = this.createArray(5);
        field.getValue().put(array);
        this.validate(field, "name", null, array);
    }

    @Test
    public void testCreateWithNullNameBackByBuffer() throws Exception {
        StoBufferField field = StoBufferField.create((String)null, 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 5);
        this.validate(field, null, buffer, new byte[5]);
    }

    @Test
    public void testCreateWithNonNullNameBackByBuffer() throws Exception {
        StoBufferField field = StoBufferField.create("name", 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 9);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        this.validate(field, "name", buffer, new byte[5]);
    }

    @Test
    public void testCreateWithNullNameManipulateValueBackByBuffer() throws Exception {
        StoBufferField field = StoBufferField.create((String)null, 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        byte[] array = this.createArray(5);
        field.getValue().put(array);
        field.setBackingBuffer(buffer, 10);
        this.validate(field, null, buffer, array);
    }

    @Test
    public void testCreateWithNonNullNameManipulateValueBackByBuffer() throws Exception {
        StoBufferField field = StoBufferField.create("name", 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        byte[] array = this.createArray(5);
        field.getValue().put(array);
        field.setBackingBuffer(buffer, 12);
        this.validate(field, "name", buffer, array);
    }

    @Test
    public void testCreateWithNullNameManipulateValueBackByThenClearBuffer() throws Exception {
        StoBufferField field = StoBufferField.create((String)null, 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        byte[] array = this.createArray(5);
        field.getValue().put(array);
        field.setBackingBuffer(buffer, 10);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(field, null, null, array);
    }

    @Test
    public void testCreateWithNonNullNameManipulateValueBackByThenClearBuffer() throws Exception {
        StoBufferField field = StoBufferField.create("name", 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        byte[] array = this.createArray(5);
        field.getValue().put(array);
        field.setBackingBuffer(buffer, 12);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(field, "name", null, array);
    }

    @Test
    public void testCreateWithNullNameBackByThenClearBuffer() throws Exception {
        StoBufferField field = StoBufferField.create((String)null, 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 10);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(field, null, null, new byte[5]);
    }

    @Test
    public void testCreateWithNonNullNameBackByThenClearBuffer() throws Exception {
        StoBufferField field = StoBufferField.create("name", 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 12);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(field, "name", null, new byte[5]);
    }

    @Test
    public void testCreateWithNullNameBackByBufferManipulateValue() throws Exception {
        StoBufferField field = StoBufferField.create((String)null, 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        byte[] array = this.createArray(5);
        field.getValue().put(array);
        this.validate(field, null, buffer, array);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferManipulateValue() throws Exception {
        StoBufferField field = StoBufferField.create("name", 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        byte[] array = this.createArray(5);
        field.getValue().put(array);
        this.validate(field, "name", buffer, array);
    }

    @Test
    public void testCreateWithNullNameBackByBufferManipulateValueClearBuffer() throws Exception {
        StoBufferField field = StoBufferField.create((String)null, 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        byte[] array = this.createArray(5);
        field.getValue().put(array);
        field.clearBackingBuffer();
        this.validate(field, null, null, array);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferManipulateValueClearBuffer() throws Exception {
        StoBufferField field = StoBufferField.create("name", 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        byte[] array = this.createArray(5);
        field.getValue().put(array);
        field.clearBackingBuffer();
        this.validate(field, "name", null, array);
    }

    @Test
    public void testCreateWithNullNameSync() throws Exception {
        StoBufferField field = StoBufferField.create((String)null, 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.sync(buffer, 45);
        this.validate(field, null, null, new byte[5]);
        this.compare(StoByteArrayField.get(buffer, field.shiftForHeader(45)), new byte[5], false);
    }

    @Test
    public void testCreateWithNonNullNameSync() throws Exception {
        StoBufferField field = StoBufferField.create("name", 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.sync(buffer, 52);
        this.validate(field, "name", null, new byte[5]);
        this.compare(StoByteArrayField.get(buffer, field.shiftForHeader(52)), new byte[5], false);
    }

    @Test
    public void testCreateWithNullNameManipulateValueSync() throws Exception {
        StoBufferField field = StoBufferField.create((String)null, 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        byte[] array = this.createArray(5);
        field.getValue().put(array);
        field.sync(buffer, 45);
        this.validate(field, null, null, array);
        this.compare(StoByteArrayField.get(buffer, field.shiftForHeader(45)), array, false);
    }

    @Test
    public void testCreateWithNonNullNameManipulateValueSync() throws Exception {
        StoBufferField field = StoBufferField.create("name", 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        byte[] array = this.createArray(5);
        field.getValue().put(array);
        field.sync(buffer, 52);
        this.validate(field, "name", null, array);
        this.compare(StoByteArrayField.get(buffer, field.shiftForHeader(52)), array, false);
    }

    @Test
    public void testCreateWithNullNameDeserialise() throws Exception {
        StoBufferField field1 = StoBufferField.create((String)null, 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 76);
        StoBufferField field2 = (StoBufferField)StoField.create(buffer, 76);
        this.validate(field2, null, buffer, new byte[5]);
    }

    @Test
    public void testCreateWithNonNullNameDeserialise() throws Exception {
        StoBufferField field1 = StoBufferField.create("name", 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        StoBufferField field2 = (StoBufferField)StoField.create(buffer, 80);
        this.validate(field2, "name", buffer, new byte[5]);
    }

    @Test
    public void testCreateWithNullNameManipulateSetBackingBufferDeserialise() throws Exception {
        StoBufferField field1 = StoBufferField.create((String)null, 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        byte[] array = this.createArray(5);
        field1.getValue().put(array);
        field1.setBackingBuffer(buffer, 76);
        StoBufferField field2 = (StoBufferField)StoField.create(buffer, 76);
        this.validate(field2, null, buffer, array);
    }

    @Test
    public void testCreateWithNonNullNameManipulateSetBackingBufferDeserialise() throws Exception {
        StoBufferField field1 = StoBufferField.create("name", 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        byte[] array = this.createArray(5);
        field1.getValue().put(array);
        field1.setBackingBuffer(buffer, 80);
        StoBufferField field2 = (StoBufferField)StoField.create(buffer, 80);
        this.validate(field2, "name", buffer, array);
    }

    @Test
    public void testCreateWithNullNameSetBackingBufferManipulateDeserialise() throws Exception {
        StoBufferField field1 = StoBufferField.create((String)null, 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 76);
        byte[] array = this.createArray(5);
        field1.getValue().put(array);
        StoBufferField field2 = (StoBufferField)StoField.create(buffer, 76);
        this.validate(field2, null, buffer, array);
    }

    @Test
    public void testCreateWithNonNullNameSetBackingBufferManipulateDeserialise() throws Exception {
        StoBufferField field1 = StoBufferField.create("name", 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        byte[] array = this.createArray(5);
        field1.getValue().put(array);
        StoBufferField field2 = (StoBufferField)StoField.create(buffer, 80);
        this.validate(field2, "name", buffer, array);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserialiseClearBuffer() throws Exception {
        StoBufferField field1 = StoBufferField.create((String)null, 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 76);
        StoBufferField field2 = (StoBufferField)StoField.create(buffer, 76);
        field2.clearBackingBuffer();
        this.validate(field2, null, null, new byte[5]);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserialiseClearBuffer() throws Exception {
        StoBufferField field1 = StoBufferField.create("name", 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        StoBufferField field2 = (StoBufferField)StoField.create(buffer, 80);
        field2.clearBackingBuffer();
        this.validate(field2, "name", null, new byte[5]);
    }

    @Test
    public void testCreateWithNullNameManipulateValueSetBackingBufferDeserialiseClearBuffer() throws Exception {
        StoBufferField field1 = StoBufferField.create((String)null, 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        byte[] array = this.createArray(5);
        field1.getValue().put(array);
        field1.setBackingBuffer(buffer, 76);
        StoBufferField field2 = (StoBufferField)StoField.create(buffer, 76);
        field2.clearBackingBuffer();
        this.validate(field2, null, null, array);
    }

    @Test
    public void testCreateWithNonNullNameManipulateValueSetBackingBufferDeserialiseClearBuffer() throws Exception {
        StoBufferField field1 = StoBufferField.create("name", 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        byte[] array = this.createArray(5);
        field1.getValue().put(array);
        field1.setBackingBuffer(buffer, 80);
        StoBufferField field2 = (StoBufferField)StoField.create(buffer, 80);
        field2.clearBackingBuffer();
        this.validate(field2, "name", null, array);
    }

    @Test
    public void testCreateWithNullNameSetBackingBufferManipulateValueDeserialiseClearBuffer() throws Exception {
        StoBufferField field1 = StoBufferField.create((String)null, 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 76);
        byte[] array = this.createArray(5);
        field1.getValue().put(array);
        StoBufferField field2 = (StoBufferField)StoField.create(buffer, 76);
        field2.clearBackingBuffer();
        this.validate(field2, null, null, array);
    }

    @Test
    public void testCreateWithNonNullNameSetBackingBufferManipulateValueDeserialiseClearBuffer() throws Exception {
        StoBufferField field1 = StoBufferField.create("name", 5);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        byte[] array = this.createArray(5);
        field1.getValue().put(array);
        StoBufferField field2 = (StoBufferField)StoField.create(buffer, 80);
        field2.clearBackingBuffer();
        this.validate(field2, "name", null, array);
    }
}

