/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.nio;

import com.neeve.emx.nio.EmxNioAlarmEvent;
import com.neeve.emx.nio.EmxNioObject;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;

final class EmxNioDispatcherWaitQueueAlarm
extends EmxNioObject {
    private UtlList alarmlist = UtlList.create();

    EmxNioDispatcherWaitQueueAlarm() {
    }

    private final void listInsert(Alarm alarm, long currentTime) {
        if (currentTime == 0L) {
            currentTime = System.currentTimeMillis();
        }
        if (this.tracer.debug) {
            this.tracer.log("Inserting alarm event " + alarm.event + " into alarm list (ring time=" + alarm.ringTime + ")...", Tracer.Level.DEBUG);
        }
        UtlList element = this.alarmlist;
        boolean added = false;
        while ((element = element.next()) != null) {
            if (alarm.ringTime > ((Alarm)element).ringTime) continue;
            element.insertBefore((UtlListElement)alarm);
            added = true;
            break;
        }
        if (!added) {
            this.alarmlist.append((UtlListElement)alarm);
        }
        alarm.addedTime = currentTime;
    }

    private final boolean listRemove(Alarm alarm) {
        if (alarm.isLinked()) {
            alarm.unlink();
            return true;
        }
        return false;
    }

    final void add(EmxNioAlarmEvent event) {
        long currentTime = System.currentTimeMillis();
        if (this.tracer.debug) {
            this.tracer.log("Alarm event " + event + " add.", Tracer.Level.DEBUG);
        }
        if (event.getTag() == null) {
            int interval = event.getInterval();
            Alarm alarm = new Alarm(interval, currentTime + (long)interval, event);
            event.setTag((Object)alarm);
            this.listInsert(alarm, currentTime);
        } else {
            this.reset(event, currentTime);
        }
    }

    final void reset(EmxNioAlarmEvent event, long lastDispatchTime) {
        Alarm alarm = (Alarm)((Object)event.getTag());
        if (this.tracer.debug) {
            this.tracer.log("Alarm event " + event + " reset [" + lastDispatchTime + "].", Tracer.Level.DEBUG);
        }
        if (alarm != null) {
            this.listRemove(alarm);
            alarm.ringTime = lastDispatchTime + (long)alarm.interval;
            this.listInsert(alarm, lastDispatchTime);
            if (this.tracer.debug) {
                this.tracer.log("Alarm event " + event + " successfully reset.", Tracer.Level.DEBUG);
            }
        } else {
            throw new InternalError("Attempt to reset an alarm event that is not attached to an alarm object");
        }
    }

    final boolean remove(EmxNioAlarmEvent event) {
        Alarm alarm = (Alarm)((Object)event.getTag());
        boolean removed = false;
        if (this.tracer.debug) {
            this.tracer.log("Alarm event " + event + " remove.", Tracer.Level.DEBUG);
        }
        if (alarm != null) {
            removed = this.listRemove(alarm);
            if (removed) {
                if (this.tracer.debug) {
                    this.tracer.log("Alarm event " + event + " successfully removed from alarm wait queue.", Tracer.Level.DEBUG);
                }
            } else if (this.tracer.debug) {
                this.tracer.log("Alarm event " + event + " is tagged but not present in alarm wait queue.", Tracer.Level.DEBUG);
            }
        } else if (this.tracer.debug) {
            this.tracer.log("Alarm event " + event + " is not tagged.", Tracer.Level.DEBUG);
        }
        return removed;
    }

    final UtlList get(UtlList list) {
        Alarm alarm;
        if (this.tracer.debug) {
            this.tracer.log("Triggered alarm events get (list size=" + this.count() + ")", Tracer.Level.DEBUG);
        }
        while ((alarm = (Alarm)this.alarmlist.next()) != null) {
            if (this.tracer.debug) {
                this.tracer.log("Checking alarm event " + alarm.event + "(added time = " + alarm.addedTime + " ring time=" + alarm.ringTime + ").", Tracer.Level.DEBUG);
            }
            if (System.currentTimeMillis() < alarm.ringTime) break;
            if (this.tracer.debug) {
                this.tracer.log("Alarm event " + alarm.event + " timeout has expired.", Tracer.Level.DEBUG);
            }
            if (!this.listRemove(alarm)) {
                throw new InternalError("Failed to removed alarm even though present in alarm list!");
            }
            list.append((UtlListElement)alarm.event);
        }
        if (this.tracer.debug) {
            this.tracer.log("Returning " + list.count() + " triggered alarm events.", Tracer.Level.DEBUG);
        }
        return list;
    }

    final int getMinTriggerTime() {
        UtlListElement element = this.alarmlist.next();
        return (int)Math.max(element == null ? Integer.MAX_VALUE : ((Alarm)element).ringTime - System.currentTimeMillis(), 0L);
    }

    final int count() {
        return this.alarmlist.count();
    }

    private final class Alarm
    extends UtlListElement {
        final int interval;
        final EmxNioAlarmEvent event;
        long addedTime;
        long ringTime;

        Alarm(int interval, long ringTime, EmxNioAlarmEvent event) {
            this.interval = interval;
            this.ringTime = ringTime;
            this.event = event;
        }
    }
}

