/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solxf.impl;

import com.neeve.solxf.ISolTopic;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlReferenceTracker;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class SolTopic
extends UtlListElement
implements UtlPool.Item<SolTopic>,
ISolTopic {
    private UtlPool<SolTopic> pool;
    private AtomicInteger ownershipCount = new AtomicInteger(1);
    private final UtlReferenceTracker refTracker = UtlReferenceTracker.enabled(this.getClass()) ? new UtlReferenceTracker((Object)this) : null;
    protected static final int MAX_TOPIC_LEN = 256;

    protected SolTopic() {
    }

    protected abstract void reset();

    @Override
    public final ISolTopic acquire() {
        int val = this.ownershipCount.incrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onAcquire(val);
        }
        if (val <= 1 && this.pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed topic");
        }
        return this;
    }

    @Override
    public final void dispose() {
        int val = this.ownershipCount.decrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onDispose(val);
        }
        if (val < 0 && this.pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed topic");
        }
        if (val == 0 && this.pool != null) {
            this.pool.put((UtlPool.Item)this);
        }
    }

    public final SolTopic init() {
        this.reset();
        this.ownershipCount.set(1);
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onInit(1);
        }
        return this;
    }

    public final SolTopic setPool(UtlPool<SolTopic> pool) {
        this.pool = pool;
        return this;
    }

    public final UtlPool<SolTopic> getPool() {
        return this.pool;
    }
}

