/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util.test.unit;

import com.google.common.collect.ImmutableMap;
import com.neeve.util.UtlTailoring;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class UtlTailoringTest {
    @Test
    public void substSimpleVar() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"FOO", (Object)"BAZ"));
        Assert.assertEquals((Object)"BAZ", (Object)UtlTailoring.substitute("${FOO}", propertySource));
    }

    @Test
    public void substSimpleVarWithLiteralSeparator() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"FOO", (Object)"BAR", (Object)"BAR", (Object)"BAZ"));
        Assert.assertEquals((Object)"BAR/BAZ", (Object)UtlTailoring.substitute("${FOO}/${BAR}", propertySource));
    }

    @Test
    public void undefinedSimpleVar() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource(Collections.emptyMap());
        Assert.assertEquals((Object)"${FOO}", (Object)UtlTailoring.substitute("${FOO}", propertySource));
    }

    @Test
    public void substNestedVar() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"BAR", (Object)"BOZ", (Object)"FOOBOZ", (Object)"BAZ"));
        Assert.assertEquals((Object)"BAZ", (Object)UtlTailoring.substitute("${FOO${BAR}}", propertySource));
    }

    @Test
    public void substNestedVarWithUndefinedVarInDefaultSection() throws Exception {
        Assume.assumeTrue((String)"Not properly supported by the old parser", (boolean)UtlTailoring.ENABLE_NEW_SPRING_STYLE_SUBSTITUTION_PARSER);
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"BAR", (Object)"BOZ", (Object)"FOOBOZ", (Object)"BAZ"));
        Assert.assertEquals((Object)"BAZ", (Object)UtlTailoring.substitute("${FOO${BAR}::${BAZ}}", propertySource));
    }

    @Test
    public void substDefinedVarWithDefinedVarInDefaultSection() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"FOO", (Object)"FOOVAL", (Object)"BAR", (Object)"BARVAL"));
        Assert.assertEquals((Object)"FOOVAL", (Object)UtlTailoring.substitute("${FOO::${BAR}}", propertySource));
    }

    @Test
    public void substUndefinedVarWithDefinedVarInDefaultSectionAndLiteral() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"BAR", (Object)"BARVAL"));
        Assert.assertEquals((Object)"BARVAL/BAZ", (Object)UtlTailoring.substitute("${FOO::${BAR}/BAZ}", propertySource));
    }

    @Test
    public void substDefinedVarWithUndefinedVarInDefaultSection() throws Exception {
        Assume.assumeTrue((String)"Not properly supported by the old parser", (boolean)UtlTailoring.ENABLE_NEW_SPRING_STYLE_SUBSTITUTION_PARSER);
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"FOO", (Object)"FOOVAL"));
        Assert.assertEquals((Object)"FOOVAL", (Object)UtlTailoring.substitute("${FOO::${BAR}}", propertySource));
    }

    @Test
    public void undefinedVarWithUndefinedVarInDefaultSection() throws Exception {
        Assume.assumeTrue((String)"Not properly supported by the old parser", (boolean)UtlTailoring.ENABLE_NEW_SPRING_STYLE_SUBSTITUTION_PARSER);
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource(Collections.emptyMap());
        Assert.assertEquals((Object)"${BAR}/BAZ", (Object)UtlTailoring.substitute("${FOO::${BAR}/BAZ}", propertySource));
    }

    @Test
    public void missingClosingBrace() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource(Collections.emptyMap());
        Assert.assertEquals((Object)"${FOO", (Object)UtlTailoring.substitute("${FOO", propertySource));
    }

    @Test
    public void missingClosingBraceAfterDefault() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource(Collections.emptyMap());
        Assert.assertEquals((Object)"${FOO::BAR", (Object)UtlTailoring.substitute("${FOO::BAR", propertySource));
    }

    @Test
    public void missingClosingBraceAfterUndefinedDefaultVar() throws Exception {
        Assume.assumeTrue((String)"This behavior is not backward-compatible with the old parser", (boolean)UtlTailoring.ENABLE_NEW_SPRING_STYLE_SUBSTITUTION_PARSER);
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource(Collections.emptyMap());
        Assert.assertEquals((Object)"${FOO::${BAR}", (Object)UtlTailoring.substitute("${FOO::${BAR}", propertySource));
    }

    @Test
    public void substRecursive() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"FOO", (Object)"${BAR}", (Object)"BAR", (Object)"BAZ"));
        Assert.assertEquals((Object)"BAZ", (Object)UtlTailoring.substitute("${FOO}", propertySource));
    }

    @Test
    public void substRecursive2() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"FOO", (Object)"${BAR}", (Object)"BAR", (Object)"${BAZ}", (Object)"BAZ", (Object)"BOZ"));
        Assert.assertEquals((Object)"BOZ", (Object)UtlTailoring.substitute("${FOO}", propertySource));
    }

    @Test(timeout=5000L)
    public void substRecursiveWithCycles() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"FOO", (Object)"${BAR}", (Object)"BAR", (Object)"${FOO}"));
        try {
            UtlTailoring.substitute("${FOO}", propertySource);
            Assert.fail((String)"Expected TailoringException");
        }
        catch (UtlTailoring.TailoringException e) {
            Assert.assertEquals((Object)"Substitution cycle detected: ${FOO}->${BAR}->${FOO}", (Object)e.getMessage());
        }
    }

    @Test
    public void substSameVarInDefaultSection() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"BAR", (Object)"BARVAL"));
        Assert.assertEquals((Object)"BARVALBARVALBARVAL", (Object)UtlTailoring.substitute("${FOO::${BAR}${BAR}${BAR}}", propertySource));
    }

    @Test
    public void substSameVar() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"FOO", (Object)"FOOVAL"));
        Assert.assertEquals((Object)"FOOVALFOOVALFOOVAL", (Object)UtlTailoring.substitute("${FOO}${FOO}${FOO}", propertySource));
    }

    @Test
    public void substNestedWithSameVar() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"FOO", (Object)"FOOVAL", (Object)"FOOFOOVAL", (Object)"FOOFOOVAL", (Object)"FOOFOOFOOVAL", (Object)"WOW"));
        Assert.assertEquals((Object)"WOW", (Object)UtlTailoring.substitute("${FOO${FOO${FOO}}}", propertySource));
    }

    @Test
    public void leadingAndTrailingLiteral() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"BAR", (Object)"BAR"));
        Assert.assertEquals((Object)"FOOBARBAZ", (Object)UtlTailoring.substitute("FOO${BAR}BAZ", propertySource));
    }

    @Test
    public void substDefinedVarFollowedByNestedUndefinedVar() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"FOO", (Object)"FOO"));
        Assert.assertEquals((Object)"${FOO${BAR}}", (Object)UtlTailoring.substitute("${FOO${BAR}}", propertySource));
    }

    @Test
    public void substUndefinedVarWithCycleInDefault() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"BAR", (Object)"${FOO}"));
        Assert.assertEquals((Object)"${FOO}", (Object)UtlTailoring.substitute("${FOO::${BAR}}", propertySource));
    }

    @Test
    public void substNestedDefaults() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"BAZ", (Object)"BOZ"));
        Assert.assertEquals((Object)"BOZ", (Object)UtlTailoring.substitute("${FOO::${BAR::${BAZ}}}", propertySource));
    }

    @Test
    public void partialSubstWithSyntaxError() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"FOO", (Object)"BAR"));
        Assert.assertEquals((Object)"TEST FOO BAR ${", (Object)UtlTailoring.substitute("TEST FOO ${FOO} ${", propertySource));
    }

    @Test
    public void preserveDefaults() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource(Collections.emptyMap());
        Assert.assertEquals((Object)"${FOO::BAZ}", (Object)UtlTailoring.springScanAndReplace("${FOO::BAZ}", propertySource, true));
    }

    @Test
    public void preserveDefaultsWithUndefinedNestedVarInDefault() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource(Collections.emptyMap());
        Assert.assertEquals((Object)"${FOO::${BAZ::BOZ}}", (Object)UtlTailoring.springScanAndReplace("${FOO::${BAZ::BOZ}}", propertySource, true));
    }

    @Test
    public void preserveDefaultsWithDefinedNestedVarInDefault() throws Exception {
        UtlTailoring.PropertySource propertySource = UtlTailoringTest.makePropertySource((Map<String, String>)ImmutableMap.of((Object)"BAZ", (Object)"BAZ"));
        Assert.assertEquals((Object)"${FOO::BAZ}", (Object)UtlTailoring.springScanAndReplace("${FOO::${BAZ::BOZ}}", propertySource, true));
    }

    private static UtlTailoring.PropertySource makePropertySource(final Map<String, String> map) {
        return new UtlTailoring.PropertySource(){

            @Override
            public String getValue(String key, String defaultValue) {
                String value = (String)map.get(key);
                if (value == null) {
                    return defaultValue;
                }
                return value;
            }
        };
    }
}

