/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.SequenceBarrier;
import com.neeve.util.UtlEnv;
import java.io.IOException;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import vanilla.java.affinity.AffinityLock;
import vanilla.java.affinity.AffinitySupport;
import vanilla.java.affinity.CpuLayout;
import vanilla.java.affinity.impl.NoCpuLayout;

public final class UtlThread {
    private static final CpuLayout cpuLayout;
    private static final Logger affinityLogger;
    private static final WeakHashMap<Thread, ThreadStats> threadStats;
    private static final ThreadMXBean threadBean;
    private static final Method zgThreadAccessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ThreadStats registerOrGetThreadStats(Thread thread) {
        WeakHashMap<Thread, ThreadStats> weakHashMap = threadStats;
        synchronized (weakHashMap) {
            ThreadStats record = threadStats.get(thread);
            if (record == null) {
                record = new ThreadStats();
                record.thread = thread;
                threadStats.put(thread, record);
            }
            record.thread = thread;
            return record;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregister(Thread thread) {
        WeakHashMap<Thread, ThreadStats> weakHashMap = threadStats;
        synchronized (weakHashMap) {
            threadStats.remove(thread);
        }
    }

    public static final boolean cpuAffinityMasksEnabled() {
        return UtlEnv.getValue("nv.enablecpuaffinitymasks", false);
    }

    public static final boolean threadWaitStatsEnabled() {
        return UtlEnv.getValue("nv.threadwaitstatsenabled", true);
    }

    public static final void setCPUAffinityMask(long mask) {
        block4: {
            if (cpuLayout != null && UtlThread.cpuAffinityMasksEnabled()) {
                try {
                    if (cpuLayout != null) {
                        AffinitySupport.setAffinity((long)mask);
                        Thread thread = Thread.currentThread();
                        String affinityString = UtlThread.decodeAffinityMask(mask, true);
                        thread.setName(Thread.currentThread().getName() + " (aff=" + affinityString + ")");
                        ThreadStats stats = UtlThread.registerOrGetThreadStats(thread);
                        stats.mask = mask;
                        stats.affinityString = affinityString;
                    }
                }
                catch (Throwable thrown) {
                    thrown.printStackTrace();
                    if (thrown.getCause() == null) break block4;
                    thrown.getCause().printStackTrace();
                }
            }
        }
    }

    public static void setCPUAffinityMask(String affinity) {
        if (cpuLayout != null && UtlThread.cpuAffinityMasksEnabled()) {
            UtlThread.setCPUAffinityMask(UtlThread.parseAffinityMask(affinity));
        }
    }

    public static String getDefaultCPUAffinityMask() {
        return UtlEnv.getValue("nv.defaultcpuaffinitymask", "0");
    }

    public static void setDefaultCPUAffinityMask() {
        UtlThread.setCPUAffinityMask(UtlThread.getDefaultCPUAffinityMask());
    }

    public static long parseAffinityMask(String affinity) {
        if (affinity.startsWith("[")) {
            if (!affinity.endsWith("]")) {
                throw new IllegalArgumentException("Invalid affinity mask: '" + affinity + "' expected 'mask | [x,y,...,z]'");
            }
            long mask = 0L;
            for (String core : affinity.substring(1, affinity.length() - 1).split(",")) {
                short coreNum;
                if (core.indexOf("(") > 0) {
                    core = core.substring(0, core.indexOf("("));
                }
                if ((coreNum = Short.parseShort(core.trim())) > 64) {
                    throw new IllegalArgumentException("Support for cpu affinity beyond core 64 not supported");
                }
                mask |= 1L << coreNum;
            }
            return mask;
        }
        try {
            return Long.parseLong(affinity);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid affinity mask: '" + affinity + "' expected 'mask | [x,y,...,z]'");
        }
    }

    public static final String decodeAffinityMask(long mask) {
        return UtlThread.decodeAffinityMask(mask, false);
    }

    public static final String decodeAffinityMask(long mask, boolean physicalFormat) {
        if (mask == 0L) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        boolean first = true;
        for (int i = 0; i < 64; ++i) {
            if ((1L << i & mask) == 0L) continue;
            if (!first) {
                buf.append(",");
            } else {
                first = false;
            }
            buf.append(i);
            if (!physicalFormat || cpuLayout == null) continue;
            buf.append("(");
            buf.append("s").append(cpuLayout.socketId(i));
            buf.append("c").append(cpuLayout.coreId(i));
            buf.append("t").append(cpuLayout.threadId(i));
            buf.append(")");
        }
        buf.append("]");
        return buf.toString();
    }

    public static final void dumpProcessorLayout(Appendable to) {
        if (cpuLayout != null) {
            try {
                to.append(cpuLayout.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        try {
            to.append("Processor Layout Unavailable");
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void dumpAffinitizationState(Appendable to, String prefix) {
        if (cpuLayout != null) {
            try {
                if (!UtlThread.cpuAffinityMasksEnabled()) {
                    to.append(prefix).append("Thread affinitization is not enabled.");
                    return;
                }
                ArrayList<ThreadStats> records = new ArrayList<ThreadStats>();
                WeakHashMap<Thread, ThreadStats> weakHashMap = threadStats;
                synchronized (weakHashMap) {
                    Iterator<Thread> threadIterator = threadStats.keySet().iterator();
                    while (threadIterator.hasNext()) {
                        Thread t = threadIterator.next();
                        if (t.isAlive()) continue;
                        threadIterator.remove();
                    }
                    records.addAll(threadStats.values());
                }
                long defaultAffMask = UtlThread.parseAffinityMask(UtlThread.getDefaultCPUAffinityMask());
                HashSet<Thread> affinitizedSet = new HashSet<Thread>();
                for (int c = 0; c < cpuLayout.cpus(); ++c) {
                    if (c > 0) {
                        to.append("\n");
                    }
                    to.append(prefix).append(String.format("Cpu %2d (", c));
                    to.append(String.format("socket: %-2d,", cpuLayout.socketId(c)));
                    to.append(String.format(" coreid: %-2d,", cpuLayout.coreId(c)));
                    to.append(String.format(" thread: %-2d", cpuLayout.threadId(c)));
                    to.append(")");
                    if ((1L << c & defaultAffMask) != 0L) {
                        to.append(" (DEFAULT)");
                    }
                    boolean noThreads = true;
                    for (int i = 0; i < records.size(); ++i) {
                        ThreadStats record = (ThreadStats)records.get(i);
                        if ((1L << c & record.mask) == 0L) continue;
                        noThreads = false;
                        affinitizedSet.add(record.thread);
                        to.append("\n").append(prefix).append("  -").append(record.thread.getName());
                        to.append(" [id=").append(String.valueOf(record.thread.getId()));
                        to.append(", state=").append(record.thread.getState().toString()).append("]");
                    }
                    if (!noThreads) continue;
                    to.append("\n").append(prefix).append("  -").append("No Threads");
                }
                Thread[] allThreadArray = new Thread[Thread.activeCount() + 10];
                int count = Thread.enumerate(allThreadArray);
                HashSet<Thread> allThreads = new HashSet<Thread>();
                for (int i = 0; i < count; ++i) {
                    allThreads.add(allThreadArray[i]);
                }
                allThreads.removeAll(affinitizedSet);
                if (allThreads.isEmpty()) return;
                to.append("\n\n").append(prefix).append("Unaffinitized:");
                for (Thread t : allThreads) {
                    to.append("\n").append(prefix).append("  -").append(t.getName());
                    to.append(" [id=").append(String.valueOf(t.getId()));
                    to.append(", state=").append(t.getState().toString()).append("]");
                    to.append(threadStats.containsKey(t) ? "(configured)" : "(not configured)");
                }
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        try {
            to.append(prefix).append("Processor Layout Unavailable");
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static final ThreadStats getThreadStats(Thread thread) {
        ThreadStats record = threadStats.get(thread);
        if (record == null) {
            return null;
        }
        return record;
    }

    public static final Thread[] getAllThreads() {
        Thread[] threads = null;
        try {
            threads = (Thread[])zgThreadAccessor.invoke((Object)threadBean, (Object[])null);
        }
        catch (Throwable thrown) {
            Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
            threads = new Thread[threadSet.size()];
            int c = 0;
            Iterator<Thread> iterator = Thread.getAllStackTraces().keySet().iterator();
            while (iterator.hasNext()) {
                Thread t;
                threads[c] = t = iterator.next();
            }
        }
        return threads;
    }

    public static void triggerThreadDump(Appendable output) {
        ThreadInfo[] threadInfos = threadBean.dumpAllThreads(true, true);
        Thread[] threads = UtlThread.getAllThreads();
        try {
            output.append("Full thread dump (Hummingbird):\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (int i = 0; i < threadInfos.length; ++i) {
            ThreadInfo ti = threadInfos[i];
            Thread thread = null;
            if (threads != null) {
                for (int j = 0; j < threads.length; ++j) {
                    if (threads[j] == null || threads[j].getId() != ti.getThreadId()) continue;
                    thread = threads[j];
                    break;
                }
            }
            try {
                output.append("\n\"").append(ti.getThreadName()).append("\" ").append("#").append(Long.toString(ti.getThreadId()));
                if (thread != null && thread.isDaemon()) {
                    output.append(" daemon");
                }
                output.append(" prio=").append(thread == null ? "?" : Integer.toString(thread.getPriority()));
                output.append(" tid=").append(Long.toString(ti.getThreadId()));
                output.append(" ").append(ti.getThreadState().name().toLowerCase());
                output.append("\n   java.lang.Thread.State: ").append(ti.getThreadState().name());
                if (ti.isSuspended()) {
                    output.append(" (suspended)");
                }
                if (ti.isInNative()) {
                    output.append(" (in native)");
                }
                LockInfo lockinfo = ti.getLockInfo();
                MonitorInfo[] monitors = ti.getLockedMonitors();
                LockInfo[] locks = ti.getLockedSynchronizers();
                for (int s = 0; s < ti.getStackTrace().length; ++s) {
                    StackTraceElement ste = ti.getStackTrace()[s];
                    output.append("\n   at ").append(ste.toString());
                    if (s == 0 && lockinfo != null) {
                        output.append("\n   - waiting on <").append(Integer.toString(lockinfo.getIdentityHashCode())).append("> (a ").append(lockinfo.getClassName()).append(")");
                        if (ti.getLockOwnerId() != -1L || ti.getLockOwnerName() != null) {
                            output.append(" (owner: ").append(ti.getLockOwnerName()).append(", id=" + ti.getLockOwnerId()).append(")");
                        }
                    }
                    if (monitors == null) continue;
                    for (int m = 0; m < monitors.length; ++m) {
                        if (!ste.equals(monitors[m].getLockedStackFrame())) continue;
                        output.append("\n   - locked <").append(Integer.toString(monitors[m].getIdentityHashCode())).append("> (a ").append(monitors[m].getClassName()).append(")");
                    }
                }
                if (locks.length > 0) {
                    output.append("\n\n   Number of locked synchronizers = ").append(Integer.toString(locks.length));
                    for (int k = 0; k < locks.length; ++k) {
                        output.append("\n   -").append(locks[k].toString());
                    }
                }
                output.append("\n");
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final SequenceBarrier asIntrumentedSequenceBarrier(SequenceBarrier barrier) {
        if (UtlThread.threadWaitStatsEnabled()) {
            return new WaitTrackingSequenceBarrier(barrier);
        }
        return barrier;
    }

    public static final void main(String[] args) {
        StringBuffer sb = new StringBuffer();
        UtlThread.dumpProcessorLayout(sb);
        System.out.println(sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block15: {
            affinityLogger = Logger.getLogger(AffinityLock.class.getName());
            threadStats = new WeakHashMap();
            CpuLayout layout = null;
            Level level = affinityLogger.getLevel();
            try {
                affinityLogger.setLevel(Level.WARNING);
                layout = AffinityLock.cpuLayout();
            }
            catch (Throwable thrown) {
                layout = new NoCpuLayout(Runtime.getRuntime().availableProcessors());
            }
            finally {
                affinityLogger.setLevel(level);
            }
            cpuLayout = layout instanceof NoCpuLayout ? null : layout;
            try {
                if (cpuLayout == null && UtlThread.cpuAffinityMasksEnabled()) {
                    System.err.println("WARNING: UNABLE TO DETERMINE CPU LAYOUT. CPU AFFINITIZATION WILL NOT BE PERFORMED.");
                }
                UtlThread.parseAffinityMask(UtlThread.getDefaultCPUAffinityMask());
            }
            catch (Exception e) {
                System.err.println("Error parsing affinity mask settings: " + e.getLocalizedMessage());
                e.printStackTrace();
            }
            threadBean = ManagementFactory.getThreadMXBean();
            Method zgThreadAccessorCandidate = null;
            try {
                zgThreadAccessorCandidate = threadBean.getClass().getDeclaredMethod("getThreads", new Class[0]);
                if (zgThreadAccessorCandidate.getReturnType().equals(Thread[].class)) {
                    zgThreadAccessorCandidate.setAccessible(true);
                    ((Thread[])zgThreadAccessorCandidate.invoke((Object)threadBean, new Object[0])).hashCode();
                    break block15;
                }
                throw new Exception("Unexpected return type on native ThreadMX bean accessor '" + zgThreadAccessorCandidate + "'");
            }
            catch (Throwable thrown) {
                zgThreadAccessorCandidate = null;
            }
            finally {
                zgThreadAccessor = zgThreadAccessorCandidate;
            }
        }
    }

    public static final class ThreadStats {
        private final boolean waitTimeRecordingEnabled = UtlThread.threadWaitStatsEnabled();
        private volatile Thread thread;
        private volatile long waitTime;
        private volatile long waitCount;
        private volatile long waitStart;
        private volatile long mask;
        private volatile String affinityString;

        private ThreadStats() {
        }

        public final void preWait() {
            if (!this.waitTimeRecordingEnabled) {
                return;
            }
            ++this.waitCount;
            this.waitStart = System.nanoTime();
        }

        public final void postWait() {
            if (!this.waitTimeRecordingEnabled) {
                return;
            }
            this.waitTime += System.nanoTime() - this.waitStart;
            this.waitStart = -1L;
        }

        public final Thread getThread() {
            return this.thread;
        }

        public final String getAffinityString() {
            return this.affinityString;
        }

        public final long getAffinityMask() {
            return this.mask;
        }

        public long getWaitTime() {
            long wait = this.waitTime;
            long current = this.waitStart;
            return current == -1L ? wait : System.nanoTime() - current + wait;
        }

        public long getWaitCount() {
            return this.waitCount;
        }
    }

    private static class WaitTrackingSequenceBarrier
    implements SequenceBarrier {
        private final SequenceBarrier delegate;
        private ThreadStats threadStats;

        WaitTrackingSequenceBarrier(SequenceBarrier sequenceBarrier) {
            this.delegate = sequenceBarrier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final long waitFor(long sequence) throws AlertException, InterruptedException {
            if (this.threadStats == null) {
                this.threadStats = UtlThread.registerOrGetThreadStats(Thread.currentThread());
            }
            this.threadStats.preWait();
            try {
                long l = this.delegate.waitFor(sequence);
                return l;
            }
            finally {
                this.threadStats.postWait();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final long waitFor(long sequence, long timeout, TimeUnit units) throws AlertException, InterruptedException {
            if (this.threadStats == null) {
                this.threadStats = UtlThread.registerOrGetThreadStats(Thread.currentThread());
            }
            this.threadStats.preWait();
            try {
                long l = this.delegate.waitFor(sequence, timeout, units);
                return l;
            }
            finally {
                this.threadStats.postWait();
            }
        }

        public final long getCursor() {
            return this.delegate.getCursor();
        }

        public final boolean isAlerted() {
            return this.delegate.isAlerted();
        }

        public final void alert() {
            this.delegate.alert();
        }

        public final void clearAlert() {
            this.delegate.clearAlert();
        }

        public final void checkAlert() throws AlertException {
            this.delegate.checkAlert();
        }
    }
}

