/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.test.unit;

import com.eaio.uuid.UUID;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.pkt.PktBuffer;
import com.neeve.rog.impl.RogDirectMetadata;
import com.neeve.sma.MessageTransportHeaders;
import com.neeve.test.UnitTest;
import com.neeve.util.UtlBuffer;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class RogDirectMetadataTest
extends UnitTest {
    String V2_SERIALIZED_METADATA = "<02000001 ff00000f ff000000 0a000000 0b000000 02000000 00000000 0a000000 00000000 0a000000 00000000 07000000 00000000 06000000 04000000 03000000 00000000 05000500 51000900 56000500 5f4d7942 75734d79 4368616e 6e656c4d 794b6579>";
    String V3_SERIALIZED_METADATA = "<0300001f ff000001 ff000000 0a000000 0b000000 02000000 00000000 0a000000 00000000 0a000000 00000000 07000000 00000000 06000000 04000000 03000000 00000000 0500054d 79427573 00094d79 4368616e 6e656c00 054d794b 6579>";
    String V4_SERIALIZED_METADATA = "<0400003f ff000003 ff000000 0a000000 0b000000 02f60a8e 1055b111 e9b88bae b6d08acc ff000000 0000001b 58000000 00000017 70000000 0000002e e0000000 04000000 03000000 00000000 0500054d 79427573 00094d79 4368616e 6e656c00 054d794b 6579>";
    private final PktBuffer serializedBuffer = PktBuffer.create(null, (int)1, (boolean)false);

    private final PktBuffer serialize(RogDirectMetadata metadata) {
        this.serializedBuffer.reset();
        metadata.serialize((IOElasticBuffer)this.serializedBuffer, 0);
        return this.serializedBuffer;
    }

    private final RogDirectMetadata populate(RogDirectMetadata metadata, UUID pid) {
        metadata.setInMsgsInTransaction(true);
        metadata.setIsInboundMessage(true);
        metadata.setIsInternal(true);
        metadata.setIsLastTransaction(true);
        metadata.setIsMessage(true);
        metadata.setIsOutboundMessage(true);
        metadata.setIsReplayedMessage(true);
        metadata.setOutMsgsInTransaction(true);
        metadata.setPossibleDuplicate(true);
        metadata.setGraphId(2);
        metadata.setMessageFlow(3);
        metadata.setMessageSender(4);
        metadata.setMessageSequenceNumber(5L);
        metadata.setOutTs(6L);
        metadata.setPreProcessingTs(7L);
        metadata.setEnqueueTs(12L);
        metadata.setTransactionInSequenceNumber(10);
        metadata.setTransactionOutSequenceNumber(11);
        metadata.setParentId(pid);
        metadata.setMessageBus("MyBus");
        metadata.setMessageChannel("MyChannel");
        metadata.setMessageKey("MyKey");
        return metadata;
    }

    private final void validate(RogDirectMetadata metadata, UUID pid) {
        Assert.assertEquals((Object)true, (Object)metadata.getInMsgsInTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.getIsInboundMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsInternal());
        Assert.assertEquals((Object)true, (Object)metadata.getIsLastTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.getIsMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsOutboundMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsReplayedMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getOutMsgsInTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.isPossibleDuplicate());
        Assert.assertEquals((long)2L, (long)metadata.getGraphId());
        Assert.assertEquals((long)3L, (long)metadata.getMessageFlow());
        Assert.assertEquals((long)4L, (long)metadata.getMessageSender());
        Assert.assertEquals((long)5L, (long)metadata.getMessageSequenceNumber());
        Assert.assertEquals((long)6L, (long)metadata.getOutTs());
        Assert.assertEquals((long)6000L, (long)metadata.getOutTsMicros());
        Assert.assertEquals((long)7L, (long)metadata.getPreProcessingTs());
        Assert.assertEquals((long)7000L, (long)metadata.getPreProcessingTsMicros());
        Assert.assertEquals((long)10L, (long)metadata.getTransactionInSequenceNumber());
        Assert.assertEquals((long)12L, (long)metadata.getEnqueueTs());
        Assert.assertEquals((long)12000L, (long)metadata.getEnqueueTsMicros());
        Assert.assertEquals((long)11L, (long)metadata.getTransactionOutSequenceNumber());
        Assert.assertEquals((Object)pid, (Object)metadata.getParentId());
        Assert.assertEquals((Object)"MyBus", (Object)metadata.getMessageBus());
        Assert.assertEquals((Object)"MyChannel", (Object)metadata.getMessageChannel());
        Assert.assertEquals((Object)"MyKey", (Object)metadata.getMessageKey());
    }

    private final void validateEmpty(RogDirectMetadata metadata) {
        this.serialize(metadata);
        Assert.assertEquals((String)"Wrong length for empty metadata", (long)5L, (long)this.serializedBuffer.getLength());
        Assert.assertEquals((Object)false, (Object)metadata.getInMsgsInTransaction());
        Assert.assertEquals((Object)false, (Object)metadata.getIsInboundMessage());
        Assert.assertEquals((Object)false, (Object)metadata.getIsInternal());
        Assert.assertEquals((Object)false, (Object)metadata.getIsLastTransaction());
        Assert.assertEquals((Object)false, (Object)metadata.getIsMessage());
        Assert.assertEquals((Object)false, (Object)metadata.getIsOutboundMessage());
        Assert.assertEquals((Object)false, (Object)metadata.getIsReplayedMessage());
        Assert.assertEquals((Object)false, (Object)metadata.getOutMsgsInTransaction());
        Assert.assertEquals((Object)false, (Object)metadata.isPossibleDuplicate());
        Assert.assertEquals((long)0L, (long)metadata.getGraphId());
        Assert.assertEquals((long)0L, (long)metadata.getMessageFlow());
        Assert.assertEquals((long)0L, (long)metadata.getMessageSender());
        Assert.assertEquals((long)0L, (long)metadata.getMessageSequenceNumber());
        Assert.assertEquals((long)0L, (long)metadata.getOutTs());
        Assert.assertEquals((long)0L, (long)metadata.getPreProcessingTs());
        Assert.assertEquals((long)0L, (long)metadata.getTransactionInSequenceNumber());
        Assert.assertEquals((long)0L, (long)metadata.getTransactionOutSequenceNumber());
        Assert.assertEquals(null, (Object)metadata.getParentId());
        Assert.assertEquals(null, (Object)metadata.getMessageBus());
        Assert.assertEquals(null, (Object)metadata.getMessageChannel());
        Assert.assertEquals(null, (Object)metadata.getMessageKey());
    }

    @Test
    public void testSetInMsgsInTransaction_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setInMsgsInTransaction(false);
        Assert.assertFalse((boolean)metadata.getInMsgsInTransaction());
        Assert.assertTrue((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getInMsgsInTransaction());
        Assert.assertTrue((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getInMsgsInTransaction());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertFalse((boolean)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getInMsgsInTransaction());
        metadata2.setInMsgsInTransaction(true);
        Assert.assertTrue((boolean)metadata2.getInMsgsInTransaction());
        Assert.assertTrue((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getInMsgsInTransaction());
        Assert.assertTrue((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getInMsgsInTransaction());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertTrue((boolean)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getInMsgsInTransaction());
        metadata3.setInMsgsInTransaction(false);
        Assert.assertFalse((boolean)metadata3.getInMsgsInTransaction());
        Assert.assertFalse((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata3)).getInMsgsInTransaction());
        Assert.assertFalse((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata3)).getInMsgsInTransaction());
    }

    @Test
    public void testSetOutMsgsInTransaction_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setOutMsgsInTransaction(false);
        Assert.assertFalse((boolean)metadata.getOutMsgsInTransaction());
        Assert.assertTrue((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getOutMsgsInTransaction());
        Assert.assertTrue((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getOutMsgsInTransaction());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertFalse((boolean)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getOutMsgsInTransaction());
        metadata2.setOutMsgsInTransaction(true);
        Assert.assertTrue((boolean)metadata2.getOutMsgsInTransaction());
        Assert.assertTrue((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getOutMsgsInTransaction());
        Assert.assertTrue((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getOutMsgsInTransaction());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertTrue((boolean)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getOutMsgsInTransaction());
        metadata3.setOutMsgsInTransaction(false);
        Assert.assertFalse((boolean)metadata3.getOutMsgsInTransaction());
        Assert.assertFalse((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata3)).getOutMsgsInTransaction());
        Assert.assertFalse((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata3)).getOutMsgsInTransaction());
    }

    @Test
    public void testSetIsMessage_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setIsMessage(false);
        Assert.assertFalse((boolean)metadata.getIsMessage());
        Assert.assertTrue((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getIsMessage());
        Assert.assertTrue((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getIsMessage());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertFalse((boolean)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getIsMessage());
        metadata2.setIsMessage(true);
        Assert.assertTrue((boolean)metadata2.getIsMessage());
        Assert.assertTrue((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getIsMessage());
        Assert.assertTrue((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getIsMessage());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertTrue((boolean)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getIsMessage());
        metadata3.setIsMessage(false);
        Assert.assertFalse((boolean)metadata3.getIsMessage());
        Assert.assertFalse((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata3)).getIsMessage());
        Assert.assertFalse((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata3)).getIsMessage());
    }

    @Test
    public void testSetIsInboundMessage_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setIsInboundMessage(false);
        Assert.assertFalse((boolean)metadata.getIsInboundMessage());
        Assert.assertTrue((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getIsInboundMessage());
        Assert.assertTrue((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getIsInboundMessage());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertFalse((boolean)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getIsInboundMessage());
        metadata2.setIsInboundMessage(true);
        Assert.assertTrue((boolean)metadata2.getIsInboundMessage());
        Assert.assertTrue((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getIsInboundMessage());
        Assert.assertTrue((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getIsInboundMessage());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertTrue((boolean)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getIsInboundMessage());
        metadata3.setIsInboundMessage(false);
        Assert.assertFalse((boolean)metadata3.getIsInboundMessage());
        Assert.assertFalse((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata3)).getIsInboundMessage());
        Assert.assertFalse((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata3)).getIsInboundMessage());
    }

    @Test
    public void testSetIsOutboundMessage_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setIsOutboundMessage(false);
        Assert.assertFalse((boolean)metadata.getIsOutboundMessage());
        Assert.assertTrue((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getIsOutboundMessage());
        Assert.assertTrue((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getIsOutboundMessage());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertFalse((boolean)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getIsOutboundMessage());
        metadata2.setIsOutboundMessage(true);
        Assert.assertTrue((boolean)metadata2.getIsOutboundMessage());
        Assert.assertTrue((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getIsOutboundMessage());
        Assert.assertTrue((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getIsOutboundMessage());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertTrue((boolean)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getIsOutboundMessage());
        metadata3.setIsOutboundMessage(false);
        Assert.assertFalse((boolean)metadata3.getIsOutboundMessage());
        Assert.assertFalse((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata3)).getIsOutboundMessage());
        Assert.assertFalse((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata3)).getIsOutboundMessage());
    }

    @Test
    public void testSetIsReplayedMessage_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setIsReplayedMessage(false);
        Assert.assertFalse((boolean)metadata.getIsReplayedMessage());
        Assert.assertTrue((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getIsReplayedMessage());
        Assert.assertTrue((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getIsReplayedMessage());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertFalse((boolean)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getIsReplayedMessage());
        metadata2.setIsReplayedMessage(true);
        Assert.assertTrue((boolean)metadata2.getIsReplayedMessage());
        Assert.assertTrue((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getIsReplayedMessage());
        Assert.assertTrue((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getIsReplayedMessage());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertTrue((boolean)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getIsReplayedMessage());
        metadata3.setIsReplayedMessage(false);
        Assert.assertFalse((boolean)metadata3.getIsReplayedMessage());
        Assert.assertFalse((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata3)).getIsReplayedMessage());
        Assert.assertFalse((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata3)).getIsReplayedMessage());
    }

    @Test
    public void testSetIsLastTransaction_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setIsLastTransaction(false);
        Assert.assertFalse((boolean)metadata.getIsLastTransaction());
        Assert.assertTrue((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getIsLastTransaction());
        Assert.assertTrue((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getIsLastTransaction());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertFalse((boolean)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getIsLastTransaction());
        metadata2.setIsLastTransaction(true);
        Assert.assertTrue((boolean)metadata2.getIsLastTransaction());
        Assert.assertTrue((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getIsLastTransaction());
        Assert.assertTrue((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getIsLastTransaction());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertTrue((boolean)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getIsLastTransaction());
        metadata3.setIsLastTransaction(false);
        Assert.assertFalse((boolean)metadata3.getIsLastTransaction());
        Assert.assertFalse((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata3)).getIsLastTransaction());
        Assert.assertFalse((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata3)).getIsLastTransaction());
    }

    @Test
    public void testSetIsInternal_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setIsInternal(false);
        Assert.assertFalse((boolean)metadata.getIsInternal());
        Assert.assertTrue((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getIsInternal());
        Assert.assertTrue((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getIsInternal());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertFalse((boolean)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getIsInternal());
        metadata2.setIsInternal(true);
        Assert.assertTrue((boolean)metadata2.getIsInternal());
        Assert.assertTrue((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getIsInternal());
        Assert.assertTrue((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getIsInternal());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertTrue((boolean)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getIsInternal());
        metadata3.setIsInternal(false);
        Assert.assertFalse((boolean)metadata3.getIsInternal());
        Assert.assertFalse((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata3)).getIsInternal());
        Assert.assertFalse((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata3)).getIsInternal());
    }

    @Test
    public void testSetPossibleDuplicate_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setPossibleDuplicate(false);
        Assert.assertFalse((boolean)metadata.isPossibleDuplicate());
        Assert.assertTrue((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).isPossibleDuplicate());
        Assert.assertTrue((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).isPossibleDuplicate());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertFalse((boolean)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).isPossibleDuplicate());
        metadata2.setPossibleDuplicate(true);
        Assert.assertTrue((boolean)metadata2.isPossibleDuplicate());
        Assert.assertTrue((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).isPossibleDuplicate());
        Assert.assertTrue((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).isPossibleDuplicate());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertTrue((boolean)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).isPossibleDuplicate());
        metadata3.setPossibleDuplicate(false);
        Assert.assertFalse((boolean)metadata3.isPossibleDuplicate());
        Assert.assertFalse((boolean)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata3)).isPossibleDuplicate());
        Assert.assertFalse((boolean)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata3)).isPossibleDuplicate());
    }

    @Test
    public void testSetTransactionInSequenceNumber_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setTransactionInSequenceNumber(99);
        Assert.assertEquals((long)99L, (long)metadata.getTransactionInSequenceNumber());
        Assert.assertEquals((long)10L, (long)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getTransactionInSequenceNumber());
        Assert.assertEquals((long)10L, (long)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getTransactionInSequenceNumber());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertEquals((long)99L, (long)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getTransactionInSequenceNumber());
        metadata2.setTransactionInSequenceNumber(100);
        Assert.assertEquals((long)100L, (long)metadata2.getTransactionInSequenceNumber());
        Assert.assertEquals((long)100L, (long)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getTransactionInSequenceNumber());
        Assert.assertEquals((long)100L, (long)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getTransactionInSequenceNumber());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertEquals((long)100L, (long)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getTransactionInSequenceNumber());
    }

    @Test(expected=IllegalStateException.class)
    public void testSetTransactionInSequenceNumber_SetAfterNonCopyDeserialize() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        metadata2.setTransactionInSequenceNumber(99);
    }

    @Test
    public void testSetTransactionOutSequenceNumber_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setTransactionOutSequenceNumber(99);
        Assert.assertEquals((long)99L, (long)metadata.getTransactionOutSequenceNumber());
        Assert.assertEquals((long)11L, (long)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getTransactionOutSequenceNumber());
        Assert.assertEquals((long)11L, (long)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getTransactionOutSequenceNumber());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertEquals((long)99L, (long)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getTransactionOutSequenceNumber());
        metadata2.setTransactionOutSequenceNumber(100);
        Assert.assertEquals((long)100L, (long)metadata2.getTransactionOutSequenceNumber());
        Assert.assertEquals((long)100L, (long)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getTransactionOutSequenceNumber());
        Assert.assertEquals((long)100L, (long)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getTransactionOutSequenceNumber());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertEquals((long)100L, (long)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getTransactionOutSequenceNumber());
    }

    @Test(expected=IllegalStateException.class)
    public void testSetTransactionOutSequenceNumber_SetAfterNonCopyDeserialize() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        metadata2.setTransactionOutSequenceNumber(99);
        Assert.assertEquals((long)99L, (long)metadata2.getTransactionOutSequenceNumber());
    }

    @Test
    public void testSetGraphId_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setGraphId(99);
        Assert.assertEquals((long)99L, (long)metadata.getGraphId());
        Assert.assertEquals((long)2L, (long)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getGraphId());
        Assert.assertEquals((long)2L, (long)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getGraphId());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertEquals((long)99L, (long)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getGraphId());
        metadata2.setGraphId(100);
        Assert.assertEquals((long)100L, (long)metadata2.getGraphId());
        Assert.assertEquals((long)100L, (long)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getGraphId());
        Assert.assertEquals((long)100L, (long)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getGraphId());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertEquals((long)100L, (long)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getGraphId());
    }

    @Test(expected=IllegalStateException.class)
    public void testSetGraphId_SetAfterNonCopyDeserialize() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        metadata2.setGraphId(99);
        Assert.assertEquals((long)99L, (long)metadata2.getGraphId());
    }

    @Test
    public void testSetParentId_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        UUID uuid1 = metadata.getParentId();
        UUID uuid2 = new UUID();
        metadata.setParentId(uuid2);
        Assert.assertEquals((Object)uuid2, (Object)metadata.getParentId());
        Assert.assertEquals((Object)uuid1, (Object)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getParentId());
        Assert.assertEquals((Object)uuid1, (Object)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getParentId());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertEquals((Object)uuid2, (Object)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getParentId());
        UUID uuid3 = new UUID();
        metadata2.setParentId(uuid3);
        Assert.assertEquals((Object)uuid3, (Object)metadata2.getParentId());
        Assert.assertEquals((Object)uuid3, (Object)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getParentId());
        Assert.assertEquals((Object)uuid3, (Object)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getParentId());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertEquals((Object)uuid3, (Object)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getParentId());
    }

    @Test(expected=IllegalStateException.class)
    public void testSetParentId_SetAfterNonCopyDeserialize() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        UUID uuid = new UUID();
        metadata2.setParentId(uuid);
        Assert.assertEquals((Object)uuid, (Object)metadata2.getParentId());
    }

    @Test
    public void testSetPreProcessingTs_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setPreProcessingTs(99L);
        Assert.assertEquals((long)99L, (long)metadata.getPreProcessingTs());
        Assert.assertEquals((long)7L, (long)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getPreProcessingTs());
        Assert.assertEquals((long)7L, (long)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getPreProcessingTs());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertEquals((long)99L, (long)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getPreProcessingTs());
        metadata2.setPreProcessingTs(100L);
        Assert.assertEquals((long)100L, (long)metadata2.getPreProcessingTs());
        Assert.assertEquals((long)100L, (long)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getPreProcessingTs());
        Assert.assertEquals((long)100L, (long)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getPreProcessingTs());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertEquals((long)100L, (long)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getPreProcessingTs());
    }

    @Test(expected=IllegalStateException.class)
    public void testSetPreProcessingTs_SetAfterNonCopyDeserialize() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        metadata2.setPreProcessingTs(99L);
        Assert.assertEquals((long)99L, (long)metadata2.getPreProcessingTs());
    }

    @Test
    public void testSetOutTs_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setOutTs(99L);
        Assert.assertEquals((long)99L, (long)metadata.getOutTs());
        Assert.assertEquals((long)6L, (long)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getOutTs());
        Assert.assertEquals((long)6L, (long)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getOutTs());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertEquals((long)99L, (long)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getOutTs());
        metadata2.setOutTs(100L);
        Assert.assertEquals((long)100L, (long)metadata2.getOutTs());
        Assert.assertEquals((long)100L, (long)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getOutTs());
        Assert.assertEquals((long)100L, (long)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getOutTs());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertEquals((long)100L, (long)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getOutTs());
    }

    @Test(expected=IllegalStateException.class)
    public void testSetOutTs_SetAfterNonCopyDeserialize() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        metadata2.setOutTs(99L);
        Assert.assertEquals((long)99L, (long)metadata2.getOutTs());
    }

    @Test
    public void testSetEqueueTs_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setEnqueueTs(100L);
        Assert.assertEquals((long)100L, (long)metadata.getEnqueueTs());
        Assert.assertEquals((long)12L, (long)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getEnqueueTs());
        Assert.assertEquals((long)12L, (long)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getEnqueueTs());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertEquals((long)100L, (long)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getEnqueueTs());
        metadata2.setEnqueueTs(101L);
        Assert.assertEquals((long)101L, (long)metadata2.getEnqueueTs());
        Assert.assertEquals((long)101L, (long)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getEnqueueTs());
        Assert.assertEquals((long)101L, (long)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getEnqueueTs());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertEquals((long)101L, (long)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getEnqueueTs());
    }

    @Test(expected=IllegalStateException.class)
    public void testSetEnqueueTs_SetAfterNonCopyDeserialize() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        metadata2.setEnqueueTs(100L);
        Assert.assertEquals((long)100L, (long)metadata2.getEnqueueTs());
    }

    @Test
    public void testSetMessageSender_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setMessageSender(99);
        Assert.assertEquals((long)99L, (long)metadata.getMessageSender());
        Assert.assertEquals((long)4L, (long)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getMessageSender());
        Assert.assertEquals((long)4L, (long)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getMessageSender());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertEquals((long)99L, (long)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getMessageSender());
        metadata2.setMessageSender(100);
        Assert.assertEquals((long)100L, (long)metadata2.getMessageSender());
        Assert.assertEquals((long)100L, (long)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getMessageSender());
        Assert.assertEquals((long)100L, (long)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getMessageSender());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertEquals((long)100L, (long)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getMessageSender());
    }

    @Test(expected=IllegalStateException.class)
    public void testSetMessageSender_SetAfterNonCopyDeserialize() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        metadata2.setMessageSender(99);
        Assert.assertEquals((long)99L, (long)metadata2.getMessageSender());
    }

    @Test
    public void testSetMessageFlow_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setMessageFlow(99);
        Assert.assertEquals((long)99L, (long)metadata.getMessageFlow());
        Assert.assertEquals((long)3L, (long)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getMessageFlow());
        Assert.assertEquals((long)3L, (long)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getMessageFlow());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertEquals((long)99L, (long)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getMessageFlow());
        metadata2.setMessageFlow(100);
        Assert.assertEquals((long)100L, (long)metadata2.getMessageFlow());
        Assert.assertEquals((long)100L, (long)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getMessageFlow());
        Assert.assertEquals((long)100L, (long)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getMessageFlow());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertEquals((long)100L, (long)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getMessageFlow());
    }

    @Test(expected=IllegalStateException.class)
    public void testSetMessageFlow_SetAfterNonCopyDeserialize() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        metadata2.setMessageFlow(99);
        Assert.assertEquals((long)99L, (long)metadata2.getMessageFlow());
    }

    @Test
    public void testSetMessageSequenceNumber_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setMessageSequenceNumber(99L);
        Assert.assertEquals((long)99L, (long)metadata.getMessageSequenceNumber());
        Assert.assertEquals((long)5L, (long)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getMessageSequenceNumber());
        Assert.assertEquals((long)5L, (long)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getMessageSequenceNumber());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertEquals((long)99L, (long)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getMessageSequenceNumber());
        metadata2.setMessageSequenceNumber(100L);
        Assert.assertEquals((long)100L, (long)metadata2.getMessageSequenceNumber());
        Assert.assertEquals((long)100L, (long)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getMessageSequenceNumber());
        Assert.assertEquals((long)100L, (long)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getMessageSequenceNumber());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertEquals((long)100L, (long)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getMessageSequenceNumber());
    }

    @Test(expected=IllegalStateException.class)
    public void testSetMessageSequenceNumber_SetAfterNonCopyDeserialize() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        metadata2.setMessageSequenceNumber(99L);
        Assert.assertEquals((long)99L, (long)metadata2.getMessageSequenceNumber());
    }

    @Test
    public void testSetMessageBus_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setMessageBus("value");
        Assert.assertEquals((Object)"value", (Object)metadata.getMessageBus());
        Assert.assertEquals((Object)"MyBus", (Object)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getMessageBus());
        Assert.assertEquals((Object)"MyBus", (Object)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getMessageBus());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertEquals((Object)"value", (Object)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getMessageBus());
        metadata2.setMessageBus("value2");
        Assert.assertEquals((Object)"value2", (Object)metadata2.getMessageBus());
        Assert.assertEquals((Object)"value2", (Object)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getMessageBus());
        Assert.assertEquals((Object)"value2", (Object)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getMessageBus());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertEquals((Object)"value2", (Object)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getMessageBus());
    }

    @Test(expected=IllegalStateException.class)
    public void testSetMessageBus_SetAfterNonCopyDeserialize() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        metadata2.setMessageBus("value");
    }

    @Test
    public void testSetMessageChannel_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setMessageChannel("value");
        Assert.assertEquals((Object)"value", (Object)metadata.getMessageChannel());
        Assert.assertEquals((Object)"MyChannel", (Object)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getMessageChannel());
        Assert.assertEquals((Object)"MyChannel", (Object)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getMessageChannel());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertEquals((Object)"value", (Object)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getMessageChannel());
        metadata2.setMessageChannel("value2");
        Assert.assertEquals((Object)"value2", (Object)metadata2.getMessageChannel());
        Assert.assertEquals((Object)"value2", (Object)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getMessageChannel());
        Assert.assertEquals((Object)"value2", (Object)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getMessageChannel());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertEquals((Object)"value2", (Object)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getMessageChannel());
    }

    @Test(expected=IllegalStateException.class)
    public void testSetMessageChannel_SetAfterNonCopyDeserialize() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        metadata2.setMessageChannel("value");
    }

    @Test
    public void testSetMessageKey_SetGetSerializeDeserialize() {
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, new UUID());
        this.serialize(metadata);
        metadata.setMessageKey("value");
        Assert.assertEquals((Object)"value", (Object)metadata.getMessageKey());
        Assert.assertEquals((Object)"MyKey", (Object)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serializedBuffer).getMessageKey());
        Assert.assertEquals((Object)"MyKey", (Object)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serializedBuffer).getMessageKey());
        this.serialize(metadata);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        Assert.assertEquals((Object)"value", (Object)metadata2.deserialize((IOElasticBuffer)this.serializedBuffer).getMessageKey());
        metadata2.setMessageKey("value2");
        Assert.assertEquals((Object)"value2", (Object)metadata2.getMessageKey());
        Assert.assertEquals((Object)"value2", (Object)RogDirectMetadata.create(false).deserialize((IOElasticBuffer)this.serialize(metadata2)).getMessageKey());
        Assert.assertEquals((Object)"value2", (Object)RogDirectMetadata.create(true).deserialize((IOElasticBuffer)this.serialize(metadata2)).getMessageKey());
        RogDirectMetadata metadata3 = RogDirectMetadata.create(false);
        Assert.assertEquals((Object)"value2", (Object)metadata3.deserialize((IOElasticBuffer)this.serializedBuffer).getMessageKey());
    }

    @Test(expected=IllegalStateException.class)
    public void testSetMessageKey_SetAfterNonCopyDeserialize() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        metadata2.setMessageKey("value");
    }

    @Test
    public void testSetMessageBusAsRawEmpty() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        XString emptyRaw = XString.create((String)"");
        PktBuffer buffer = PktBuffer.create(null, (int)Math.max(1, emptyRaw.getSerializedLength()), (boolean)false);
        buffer.setLength(0);
        buffer = (PktBuffer)emptyRaw.copyInto((IOElasticBuffer)buffer, 0);
        emptyRaw = XString.create();
        emptyRaw.setValue((IOElasticBuffer)buffer, 0, buffer.getLength());
        metadata1.setMessageBusAsRaw(emptyRaw);
        Assert.assertEquals((Object)"", (Object)metadata1.getMessageBus());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        Assert.assertEquals((Object)"", (Object)metadata2.getMessageBusAsRaw().getValue());
    }

    @Test
    public void testSetMessageBusAsRaw() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        XString rawKey = XString.create((String)"Value1");
        PktBuffer buffer = PktBuffer.create(null, (int)rawKey.getSerializedLength(), (boolean)false);
        buffer = (PktBuffer)rawKey.copyInto((IOElasticBuffer)buffer, 0);
        rawKey = XString.create();
        rawKey.setValue((IOElasticBuffer)buffer, 0, buffer.getLength());
        metadata1.setMessageBusAsRaw(rawKey);
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        Assert.assertEquals((Object)"Value1", (Object)metadata2.getMessageBusAsRaw().getValue());
    }

    @Test
    public void testSetMessageBusAsRawNull() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        metadata1.setMessageBusAsRaw(null);
        Assert.assertEquals(null, (Object)metadata1.getMessageBus());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        Assert.assertEquals(null, (Object)metadata2.getMessageBusAsRaw());
    }

    @Test
    public void testSetMessageChannelAsRawEmpty() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        XString emptyRaw = XString.create((String)"");
        PktBuffer buffer = PktBuffer.create(null, (int)Math.max(1, emptyRaw.getSerializedLength()), (boolean)false);
        buffer.setLength(0);
        buffer = (PktBuffer)emptyRaw.copyInto((IOElasticBuffer)buffer, 0);
        emptyRaw = XString.create();
        emptyRaw.setValue((IOElasticBuffer)buffer, 0, buffer.getLength());
        metadata1.setMessageChannelAsRaw(emptyRaw);
        Assert.assertEquals((Object)"", (Object)metadata1.getMessageChannel());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        Assert.assertEquals((Object)"", (Object)metadata2.getMessageChannelAsRaw().getValue());
    }

    @Test
    public void testSetMessageChannelAsRaw() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        XString rawKey = XString.create((String)"Value1");
        PktBuffer buffer = PktBuffer.create(null, (int)rawKey.getSerializedLength(), (boolean)false);
        buffer = (PktBuffer)rawKey.copyInto((IOElasticBuffer)buffer, 0);
        rawKey = XString.create();
        rawKey.setValue((IOElasticBuffer)buffer, 0, buffer.getLength());
        metadata1.setMessageChannelAsRaw(rawKey);
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        Assert.assertEquals((Object)"Value1", (Object)metadata2.getMessageChannelAsRaw().getValue());
    }

    @Test
    public void testSetMessageChannelAsRawNull() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        metadata1.setMessageChannelAsRaw(null);
        Assert.assertEquals(null, (Object)metadata1.getMessageChannel());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        Assert.assertEquals(null, (Object)metadata2.getMessageChannelAsRaw());
    }

    @Test
    public void testSetMessageKeyAsRawEmpty() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        XString emptyRaw = XString.create((String)"");
        PktBuffer buffer = PktBuffer.create(null, (int)Math.max(1, emptyRaw.getSerializedLength()), (boolean)false);
        buffer.setLength(0);
        buffer = (PktBuffer)emptyRaw.copyInto((IOElasticBuffer)buffer, 0);
        emptyRaw = XString.create();
        emptyRaw.setValue((IOElasticBuffer)buffer, 0, buffer.getLength());
        metadata1.setMessageKeyAsRaw(emptyRaw);
        Assert.assertEquals((Object)"", (Object)metadata1.getMessageKey());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        Assert.assertEquals((Object)"", (Object)metadata2.getMessageKeyAsRaw().getValue());
    }

    @Test
    public void testSetMessageKeyAsRaw() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        XString rawKey = XString.create((String)"Value1");
        PktBuffer buffer = PktBuffer.create(null, (int)rawKey.getSerializedLength(), (boolean)false);
        buffer = (PktBuffer)rawKey.copyInto((IOElasticBuffer)buffer, 0);
        rawKey = XString.create();
        rawKey.setValue((IOElasticBuffer)buffer, 0, buffer.getLength());
        metadata1.setMessageKeyAsRaw(rawKey);
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        Assert.assertEquals((Object)"Value1", (Object)metadata2.getMessageKeyAsRaw().getValue());
    }

    @Test
    public void testSetMessageKeyAsRawNull() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        metadata1.setMessageKeyAsRaw(null);
        Assert.assertEquals(null, (Object)metadata1.getMessageKey());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        Assert.assertEquals(null, (Object)metadata2.getMessageKeyAsRaw());
    }

    @Test
    public void testSetTransportHeadersNull() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        metadata1.setMessageTransportHeaders(null);
        Assert.assertEquals(null, (Object)metadata1.getMessageTransportHeaders());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        Assert.assertEquals(null, (Object)metadata2.getMessageTransportHeaders());
    }

    @Test
    public void testSetTransportHeadersNoProps() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        metadata1.setMessageTransportHeaders(MessageTransportHeaders.create());
        Assert.assertEquals(Collections.emptyMap(), (Object)metadata1.getMessageTransportHeaders().toMap());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        Assert.assertEquals(Collections.emptyMap(), (Object)metadata1.getMessageTransportHeaders().toMap());
    }

    @Test
    public void testSetTransportHeaders() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        LinkedHashMap<String, Object> headerValues = new LinkedHashMap<String, Object>();
        headerValues.put("booleanKey", true);
        headerValues.put("byteKey", (byte)2);
        headerValues.put("charKey", Character.valueOf('c'));
        headerValues.put("shortKey", (short)4);
        headerValues.put("intKey", 5);
        headerValues.put("longKey", 6L);
        headerValues.put("floatKey", Float.valueOf(7.7f));
        headerValues.put("doubleKey", 7.7);
        headerValues.put("strKey", "str8");
        headerValues.put("booleanKey2", false);
        headerValues.put("byteKey2", -2);
        headerValues.put("charKey2", Character.valueOf('9'));
        headerValues.put("shortKey2", (short)-4);
        headerValues.put("intKey2", -5);
        headerValues.put("longKey2", -6L);
        headerValues.put("floatKey2", Float.valueOf(-14.4f));
        headerValues.put("doubleKey2", -15.15);
        headerValues.put("strKey2", "str16");
        headerValues.put("binKey1", new byte[]{1, 2, 3});
        MessageTransportHeaders headers = MessageTransportHeaders.create();
        for (Map.Entry header : headerValues.entrySet()) {
            headers.addHeader((CharSequence)header.getKey(), header.getValue());
        }
        metadata1.setMessageTransportHeaders(headers);
        RogDirectMetadataTest.assertMapEquals("wrong header values", headerValues, metadata1.getMessageTransportHeaders().toMap());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        RogDirectMetadataTest.assertMapEquals("wrong header values", headerValues, metadata1.getMessageTransportHeaders().toMap());
        Assert.assertEquals((Object)headers.toString(), (Object)metadata1.getMessageTransportHeaders().toString());
        if (RogDirectMetadataTest.verbose()) {
            System.out.println("Message Transport Headers: " + metadata1.getMessageTransportHeaders().toString());
        }
        metadata1.toString();
        metadata1.metadataToJsonString(true);
        metadata1.metadataToJsonString(false);
    }

    @Test
    public void testSetTransportHeadersXString() {
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, new UUID());
        LinkedHashMap<String, Object> headerValues = new LinkedHashMap<String, Object>();
        headerValues.put("booleanKey", true);
        headerValues.put("byteKey", (byte)2);
        headerValues.put("charKey", Character.valueOf('c'));
        headerValues.put("shortKey", (short)4);
        headerValues.put("intKey", 5);
        headerValues.put("longKey", 6L);
        headerValues.put("floatKey", Float.valueOf(7.7f));
        headerValues.put("doubleKey", 7.7);
        headerValues.put("strKey", "str8");
        headerValues.put("booleanKey2", false);
        headerValues.put("byteKey2", -2);
        headerValues.put("charKey2", Character.valueOf('9'));
        headerValues.put("shortKey2", (short)-4);
        headerValues.put("intKey2", -5);
        headerValues.put("longKey2", -6L);
        headerValues.put("floatKey2", Float.valueOf(-14.4f));
        headerValues.put("doubleKey2", -15.15);
        headerValues.put("strKey2", "str16");
        headerValues.put("binKey1", new byte[]{1, 2, 3});
        MessageTransportHeaders headers = MessageTransportHeaders.create();
        for (Map.Entry header : headerValues.entrySet()) {
            headers.addHeader(XString.create((String)((String)header.getKey()), (boolean)true, (boolean)true), header.getValue());
        }
        metadata1.setMessageTransportHeaders(headers);
        RogDirectMetadataTest.assertMapEquals("wrong header values", headerValues, metadata1.getMessageTransportHeaders().toMap());
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        RogDirectMetadataTest.assertMapEquals("wrong header values", headerValues, metadata1.getMessageTransportHeaders().toMap());
        Assert.assertEquals((Object)headers.toString(), (Object)metadata1.getMessageTransportHeaders().toString());
        if (RogDirectMetadataTest.verbose()) {
            System.out.println("Message Transport Headers: " + metadata1.getMessageTransportHeaders().toString());
        }
        metadata1.toString();
        metadata1.metadataToJsonString(true);
        metadata1.metadataToJsonString(false);
    }

    public static void assertMapEquals(String message, Map<String, Object> expected, Map<String, Object> actual) {
        boolean diff = false;
        if (expected.keySet().equals(actual.keySet())) {
            for (Map.Entry<String, Object> source : expected.entrySet()) {
                Object e = source.getValue();
                Object a = actual.get(source.getKey());
                if (e == null) {
                    if (a == null) continue;
                    diff = true;
                } else if (e instanceof byte[]) {
                    try {
                        Assert.assertArrayEquals((byte[])((byte[])e), (byte[])((byte[])a));
                        continue;
                    }
                    catch (AssertionError ex) {
                        diff = true;
                    }
                } else {
                    if (e.equals(a)) continue;
                    diff = true;
                }
                break;
            }
        } else {
            diff = true;
        }
        if (diff) {
            Assert.fail((String)(message + " expected: <" + expected + "> but was <" + actual + ">"));
        }
    }

    @Test
    public void testSetGet() {
        UUID pid = new UUID();
        this.validate(this.populate(RogDirectMetadata.create(), pid), pid);
    }

    @Test
    public void testCreateFromSerialized() {
        UUID pid = new UUID();
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, pid);
        this.validate(RogDirectMetadata.createFrom((IOElasticBuffer)this.serialize(metadata)), pid);
    }

    @Test
    public void testDeserialize() {
        UUID pid = new UUID();
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, pid);
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        this.validate(metadata2, pid);
    }

    @Test
    public void testCopyDeserialize() {
        UUID pid = new UUID();
        RogDirectMetadata metadata1 = RogDirectMetadata.create(true);
        this.populate(metadata1, pid);
        RogDirectMetadata metadata2 = RogDirectMetadata.create(true);
        metadata2.deserialize((IOElasticBuffer)this.serialize(metadata1));
        this.validate(metadata2, pid);
    }

    @Test
    public void testDeserializeNullMetadata() {
        UUID pid = new UUID();
        RogDirectMetadata metadata1 = RogDirectMetadata.create();
        this.populate(metadata1, pid);
        this.serialize(metadata1);
        metadata1.deserialize((IOElasticBuffer)((PktBuffer)null));
        this.validateEmpty(metadata1);
    }

    @Test
    public void testDeserializeV2Metadata() {
        UUID pid = new UUID(10L, 10L);
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, pid);
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        ByteBuffer buf = UtlBuffer.fromDump((String)this.V2_SERIALIZED_METADATA);
        IOElasticBuffer iobuf = IOElasticBuffer.create(null, (int)buf.remaining(), (boolean)false);
        iobuf.putFrom(0, buf, buf.remaining());
        metadata2.deserialize(iobuf);
        Assert.assertEquals((Object)true, (Object)metadata.getInMsgsInTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.getIsInboundMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsInternal());
        Assert.assertEquals((Object)true, (Object)metadata.getIsLastTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.getIsMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsOutboundMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsReplayedMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getOutMsgsInTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.isPossibleDuplicate());
        Assert.assertEquals((long)2L, (long)metadata.getGraphId());
        Assert.assertEquals((long)3L, (long)metadata.getMessageFlow());
        Assert.assertEquals((long)4L, (long)metadata.getMessageSender());
        Assert.assertEquals((long)5L, (long)metadata.getMessageSequenceNumber());
        Assert.assertEquals((long)6L, (long)metadata.getOutTs());
        Assert.assertEquals((long)6000L, (long)metadata.getOutTsMicros());
        Assert.assertEquals((long)7L, (long)metadata.getPreProcessingTs());
        Assert.assertEquals((long)7000L, (long)metadata.getPreProcessingTsMicros());
        Assert.assertEquals((long)10L, (long)metadata.getTransactionInSequenceNumber());
        Assert.assertEquals((long)11L, (long)metadata.getTransactionOutSequenceNumber());
        Assert.assertEquals((Object)pid, (Object)metadata.getParentId());
        Assert.assertEquals((Object)"MyBus", (Object)metadata.getMessageBus());
        Assert.assertEquals((Object)"MyChannel", (Object)metadata.getMessageChannel());
        Assert.assertEquals((Object)"MyKey", (Object)metadata.getMessageKey());
    }

    @Test
    public void testDeserializeV2MetadataCopyDeserialize() {
        UUID pid = new UUID(10L, 10L);
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, pid);
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        ByteBuffer buf = UtlBuffer.fromDump((String)this.V2_SERIALIZED_METADATA);
        IOElasticBuffer iobuf = IOElasticBuffer.create(null, (int)buf.remaining(), (boolean)false);
        iobuf.putFrom(0, buf, buf.remaining());
        metadata2.deserialize(iobuf, true);
        Assert.assertEquals((Object)true, (Object)metadata.getInMsgsInTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.getIsInboundMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsInternal());
        Assert.assertEquals((Object)true, (Object)metadata.getIsLastTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.getIsMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsOutboundMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsReplayedMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getOutMsgsInTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.isPossibleDuplicate());
        Assert.assertEquals((long)2L, (long)metadata.getGraphId());
        Assert.assertEquals((long)3L, (long)metadata.getMessageFlow());
        Assert.assertEquals((long)4L, (long)metadata.getMessageSender());
        Assert.assertEquals((long)5L, (long)metadata.getMessageSequenceNumber());
        Assert.assertEquals((long)6L, (long)metadata.getOutTs());
        Assert.assertEquals((long)6000L, (long)metadata.getOutTsMicros());
        Assert.assertEquals((long)7L, (long)metadata.getPreProcessingTs());
        Assert.assertEquals((long)7000L, (long)metadata.getPreProcessingTsMicros());
        Assert.assertEquals((long)10L, (long)metadata.getTransactionInSequenceNumber());
        Assert.assertEquals((long)11L, (long)metadata.getTransactionOutSequenceNumber());
        Assert.assertEquals((Object)pid, (Object)metadata.getParentId());
        Assert.assertEquals((Object)"MyBus", (Object)metadata.getMessageBus());
        Assert.assertEquals((Object)"MyChannel", (Object)metadata.getMessageChannel());
        Assert.assertEquals((Object)"MyKey", (Object)metadata.getMessageKey());
    }

    @Test
    public void testDeserializeV3Metadata() {
        UUID pid = new UUID(10L, 10L);
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, pid);
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        ByteBuffer buf = UtlBuffer.fromDump((String)this.V3_SERIALIZED_METADATA);
        IOElasticBuffer iobuf = IOElasticBuffer.create(null, (int)buf.remaining(), (boolean)false);
        iobuf.putFrom(0, buf, buf.remaining());
        metadata2.deserialize(iobuf);
        Assert.assertEquals((Object)true, (Object)metadata.getInMsgsInTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.getIsInboundMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsInternal());
        Assert.assertEquals((Object)true, (Object)metadata.getIsLastTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.getIsMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsOutboundMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsReplayedMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getOutMsgsInTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.isPossibleDuplicate());
        Assert.assertEquals((long)2L, (long)metadata.getGraphId());
        Assert.assertEquals((long)3L, (long)metadata.getMessageFlow());
        Assert.assertEquals((long)4L, (long)metadata.getMessageSender());
        Assert.assertEquals((long)5L, (long)metadata.getMessageSequenceNumber());
        Assert.assertEquals((long)6L, (long)metadata.getOutTs());
        Assert.assertEquals((long)6000L, (long)metadata.getOutTsMicros());
        Assert.assertEquals((long)7L, (long)metadata.getPreProcessingTs());
        Assert.assertEquals((long)7000L, (long)metadata.getPreProcessingTsMicros());
        Assert.assertEquals((long)10L, (long)metadata.getTransactionInSequenceNumber());
        Assert.assertEquals((long)11L, (long)metadata.getTransactionOutSequenceNumber());
        Assert.assertEquals((Object)pid, (Object)metadata.getParentId());
        Assert.assertEquals((Object)"MyBus", (Object)metadata.getMessageBus());
        Assert.assertEquals((Object)"MyChannel", (Object)metadata.getMessageChannel());
        Assert.assertEquals((Object)"MyKey", (Object)metadata.getMessageKey());
    }

    @Test
    public void testDeserializeV3MetadataCopyDeserialize() {
        UUID pid = new UUID(10L, 10L);
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, pid);
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        ByteBuffer buf = UtlBuffer.fromDump((String)this.V3_SERIALIZED_METADATA);
        IOElasticBuffer iobuf = IOElasticBuffer.create(null, (int)buf.remaining(), (boolean)false);
        iobuf.putFrom(0, buf, buf.remaining());
        metadata2.deserialize(iobuf, true);
        Assert.assertEquals((Object)true, (Object)metadata.getInMsgsInTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.getIsInboundMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsInternal());
        Assert.assertEquals((Object)true, (Object)metadata.getIsLastTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.getIsMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsOutboundMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsReplayedMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getOutMsgsInTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.isPossibleDuplicate());
        Assert.assertEquals((long)2L, (long)metadata.getGraphId());
        Assert.assertEquals((long)3L, (long)metadata.getMessageFlow());
        Assert.assertEquals((long)4L, (long)metadata.getMessageSender());
        Assert.assertEquals((long)5L, (long)metadata.getMessageSequenceNumber());
        Assert.assertEquals((long)6L, (long)metadata.getOutTs());
        Assert.assertEquals((long)6000L, (long)metadata.getOutTsMicros());
        Assert.assertEquals((long)7L, (long)metadata.getPreProcessingTs());
        Assert.assertEquals((long)7000L, (long)metadata.getPreProcessingTsMicros());
        Assert.assertEquals((long)10L, (long)metadata.getTransactionInSequenceNumber());
        Assert.assertEquals((long)11L, (long)metadata.getTransactionOutSequenceNumber());
        Assert.assertEquals((Object)pid, (Object)metadata.getParentId());
        Assert.assertEquals((Object)"MyBus", (Object)metadata.getMessageBus());
        Assert.assertEquals((Object)"MyChannel", (Object)metadata.getMessageChannel());
        Assert.assertEquals((Object)"MyKey", (Object)metadata.getMessageKey());
    }

    @Test
    public void testDeserializeV4Metadata() {
        UUID pid = new UUID(10L, 10L);
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, pid);
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        ByteBuffer buf = UtlBuffer.fromDump((String)this.V4_SERIALIZED_METADATA);
        IOElasticBuffer iobuf = IOElasticBuffer.create(null, (int)buf.remaining(), (boolean)false);
        iobuf.putFrom(0, buf, buf.remaining());
        metadata2.deserialize(iobuf);
        Assert.assertEquals((Object)true, (Object)metadata.getInMsgsInTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.getIsInboundMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsInternal());
        Assert.assertEquals((Object)true, (Object)metadata.getIsLastTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.getIsMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsOutboundMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsReplayedMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getOutMsgsInTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.isPossibleDuplicate());
        Assert.assertEquals((long)2L, (long)metadata.getGraphId());
        Assert.assertEquals((long)3L, (long)metadata.getMessageFlow());
        Assert.assertEquals((long)4L, (long)metadata.getMessageSender());
        Assert.assertEquals((long)5L, (long)metadata.getMessageSequenceNumber());
        Assert.assertEquals((long)6L, (long)metadata.getOutTs());
        Assert.assertEquals((long)6000L, (long)metadata.getOutTsMicros());
        Assert.assertEquals((long)7L, (long)metadata.getPreProcessingTs());
        Assert.assertEquals((long)7000L, (long)metadata.getPreProcessingTsMicros());
        Assert.assertEquals((long)10L, (long)metadata.getTransactionInSequenceNumber());
        Assert.assertEquals((long)11L, (long)metadata.getTransactionOutSequenceNumber());
        Assert.assertEquals((Object)pid, (Object)metadata.getParentId());
        Assert.assertEquals((Object)"MyBus", (Object)metadata.getMessageBus());
        Assert.assertEquals((Object)"MyChannel", (Object)metadata.getMessageChannel());
        Assert.assertEquals((Object)"MyKey", (Object)metadata.getMessageKey());
    }

    @Test
    public void testDeserializeV4MetadataCopyDeserialize() {
        UUID pid = new UUID(10L, 10L);
        RogDirectMetadata metadata = RogDirectMetadata.create();
        this.populate(metadata, pid);
        RogDirectMetadata metadata2 = RogDirectMetadata.create();
        ByteBuffer buf = UtlBuffer.fromDump((String)this.V4_SERIALIZED_METADATA);
        IOElasticBuffer iobuf = IOElasticBuffer.create(null, (int)buf.remaining(), (boolean)false);
        iobuf.putFrom(0, buf, buf.remaining());
        metadata2.deserialize(iobuf, true);
        Assert.assertEquals((Object)true, (Object)metadata.getInMsgsInTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.getIsInboundMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsInternal());
        Assert.assertEquals((Object)true, (Object)metadata.getIsLastTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.getIsMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsOutboundMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getIsReplayedMessage());
        Assert.assertEquals((Object)true, (Object)metadata.getOutMsgsInTransaction());
        Assert.assertEquals((Object)true, (Object)metadata.isPossibleDuplicate());
        Assert.assertEquals((long)2L, (long)metadata.getGraphId());
        Assert.assertEquals((long)3L, (long)metadata.getMessageFlow());
        Assert.assertEquals((long)4L, (long)metadata.getMessageSender());
        Assert.assertEquals((long)5L, (long)metadata.getMessageSequenceNumber());
        Assert.assertEquals((long)6L, (long)metadata.getOutTs());
        Assert.assertEquals((long)6000L, (long)metadata.getOutTsMicros());
        Assert.assertEquals((long)7L, (long)metadata.getPreProcessingTs());
        Assert.assertEquals((long)7000L, (long)metadata.getPreProcessingTsMicros());
        Assert.assertEquals((long)10L, (long)metadata.getTransactionInSequenceNumber());
        Assert.assertEquals((long)11L, (long)metadata.getTransactionOutSequenceNumber());
        Assert.assertEquals((Object)pid, (Object)metadata.getParentId());
        Assert.assertEquals((Object)"MyBus", (Object)metadata.getMessageBus());
        Assert.assertEquals((Object)"MyChannel", (Object)metadata.getMessageChannel());
        Assert.assertEquals((Object)"MyKey", (Object)metadata.getMessageKey());
    }
}

