/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.neeve.rog.impl.RogGraphVisitor;
import com.neeve.rog.impl.RogNode;
import com.neeve.util.UtlTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ToStringVisitor
extends RogGraphVisitor {
    private final StringBuilder sb;
    private final LinkedHashSet<RogNode> visited = new LinkedHashSet();
    private final ArrayList<String> indents = new ArrayList();
    private Deque<String> extraIndents = new LinkedList<String>();
    private final String header;
    private final String indent;
    private boolean printCollectionContents = true;
    private boolean dump = true;

    ToStringVisitor() {
        this.sb = new StringBuilder();
        this.dump = false;
        this.header = "";
        this.indent = "  ";
    }

    ToStringVisitor(StringBuilder sb, boolean dump, String header, String indent) {
        this.sb = sb;
        this.dump = dump;
        this.header = header;
        this.indent = indent;
    }

    @Override
    public void beginFieldVisit(RogNode node) {
        if (this.visited.isEmpty()) {
            this.sb.append(node.getClass().getSimpleName()).append("[id=").append(node.getId()).append("]{");
        }
        this.visited.add(node);
    }

    private final void startNewField() {
        this.newLineIndent();
    }

    private final void newLineIndent() {
        this.sb.append("\n");
        this.indent();
    }

    @Override
    public void endFieldVisit(RogNode node) {
        this.visited.remove(node);
        if (this.dump) {
            this.extraIndents.push(this.indent);
            this.startNewField();
            this.sb.append("id=").append(node.getId());
            this.startNewField();
            this.sb.append("inStore=").append(node.getBinding() != null);
            this.startNewField();
            this.sb.append("graphId=").append(node.getGraphId());
            if (node.getParentId() != null) {
                this.startNewField();
                this.sb.append("parentId=" + node.getParentId());
            }
            this.startNewField();
            this.extraIndents.pop();
        }
        this.newLineIndent();
        this.sb.append("}");
    }

    @Override
    public boolean visitField(RogNode parent, String fieldName, RogNode container) {
        if (container == null) {
            return false;
        }
        this.startNewField();
        this.sb.append(fieldName);
        if (fieldName != null && fieldName.length() > 0) {
            this.sb.append(" ");
        }
        this.sb.append("(").append(container.getClass().getSimpleName()).append("[id=").append(container.getId()).append("])");
        if (container == parent) {
            this.sb.append("=self");
            return false;
        }
        if (this.visited.contains(container)) {
            this.sb.append("=circular_ref[" + container.getId() + "]");
            return false;
        }
        if (container instanceof Collection && ((Collection)((Object)container)).isEmpty()) {
            Collection collection = (Collection)((Object)container);
            if (collection.isEmpty()) {
                this.sb.append(" (empty)");
                return false;
            }
            if (!this.printCollectionContents) {
                this.sb.append(" (size: ").append(collection.size()).append(")");
                return false;
            }
            this.sb.append(" (empty)");
            return false;
        }
        if (container instanceof Map) {
            Map map = (Map)((Object)container);
            if (map.isEmpty()) {
                this.sb.append(" (empty)");
                return false;
            }
            if (!this.printCollectionContents) {
                this.sb.append(" (size: ").append(map.size()).append(")");
                return false;
            }
        }
        this.sb.append("{");
        return true;
    }

    @Override
    public boolean visitField(RogNode parent, String fieldName, Object field) {
        if (field == null) {
            return false;
        }
        this.startNewField();
        this.sb.append(fieldName);
        if (fieldName != null && fieldName.length() > 0) {
            this.sb.append(" ");
        }
        this.sb.append("(").append(field.getClass().getSimpleName()).append(")");
        this.sb.append("=");
        if (field.getClass().isArray()) {
            this.handleArray(parent, fieldName, field);
            return false;
        }
        if (field instanceof Date) {
            this.sb.append(UtlTime.format((Date)((Date)field)));
        } else if (field instanceof Character) {
            this.sb.append(((Character)field).charValue());
        } else {
            this.sb.append(field.toString());
        }
        return false;
    }

    private final void handleArray(RogNode parent, String fieldName, Object array) {
        List<?> list = this.arrayToList(array);
        if (list.isEmpty()) {
            this.sb.append(" (empty)");
            return;
        }
        if (!this.printCollectionContents) {
            this.sb.append(" (size: ").append(list.size()).append(")");
            return;
        }
        this.sb.append("{");
        this.extraIndents.push(this.indent);
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            if (o instanceof RogNode) {
                this.visitField(parent, "[" + i + "]", (RogNode)o);
                continue;
            }
            this.visitField(parent, "[" + i + "]", o);
        }
        this.extraIndents.pop();
        this.newLineIndent();
        this.sb.append("}");
    }

    public String getString() {
        return this.sb.toString();
    }

    private final void indent() {
        while (this.indents.size() <= this.visited.size()) {
            if (this.indents.isEmpty()) {
                if (this.dump) {
                    this.indents.add(this.header + this.indent);
                    continue;
                }
                this.indents.add(this.header);
                continue;
            }
            this.indents.add(this.indents.get(this.indents.size() - 1) + this.indent);
        }
        this.sb.append(this.indents.get(this.visited.size()));
        for (String extra : this.extraIndents) {
            this.sb.append(extra);
        }
    }

    private List<?> arrayToList(Object o) {
        if (!o.getClass().isArray()) {
            throw new IllegalArgumentException("Not an array:" + o.getClass());
        }
        Class<?> paramClass = o.getClass().getComponentType();
        if (paramClass == Integer.TYPE) {
            int[] p = (int[])o;
            Integer[] rc = new Integer[p.length];
            for (int i = 0; i < p.length; ++i) {
                rc[i] = p[i];
            }
            return Arrays.asList(rc);
        }
        if (paramClass == Boolean.TYPE) {
            boolean[] p = (boolean[])o;
            Boolean[] rc = new Boolean[p.length];
            for (int i = 0; i < p.length; ++i) {
                rc[i] = p[i];
            }
            return Arrays.asList(rc);
        }
        if (paramClass == Double.TYPE) {
            double[] p = (double[])o;
            Double[] rc = new Double[p.length];
            for (int i = 0; i < p.length; ++i) {
                rc[i] = p[i];
            }
            return Arrays.asList(rc);
        }
        if (paramClass == Float.TYPE) {
            float[] p = (float[])o;
            Float[] rc = new Float[p.length];
            for (int i = 0; i < p.length; ++i) {
                rc[i] = Float.valueOf(p[i]);
            }
            return Arrays.asList(rc);
        }
        if (paramClass == Long.TYPE) {
            long[] p = (long[])o;
            Long[] rc = new Long[p.length];
            for (int i = 0; i < p.length; ++i) {
                rc[i] = p[i];
            }
            return Arrays.asList(rc);
        }
        if (paramClass == Byte.TYPE) {
            byte[] p = (byte[])o;
            Byte[] rc = new Byte[p.length];
            for (int i = 0; i < p.length; ++i) {
                rc[i] = p[i];
            }
            return Arrays.asList(rc);
        }
        if (paramClass == Short.TYPE) {
            short[] p = (short[])o;
            Short[] rc = new Short[p.length];
            for (int i = 0; i < p.length; ++i) {
                rc[i] = p[i];
            }
            return Arrays.asList(rc);
        }
        if (paramClass == Character.TYPE) {
            char[] p = (char[])o;
            Character[] rc = new Character[p.length];
            for (int i = 0; i < p.length; ++i) {
                rc[i] = Character.valueOf(p[i]);
            }
            return Arrays.asList(rc);
        }
        return Arrays.asList((Object[])o);
    }
}

