/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.util.test.unit;

import com.neeve.query.impl.util.UtlQueryRegex;
import org.junit.Assert;
import org.junit.Test;

public class UtlQueryRegexTest {
    @Test
    public void testLike() {
        Assert.assertTrue((String)"exact match", (boolean)UtlQueryRegex.like("asdf", "asdf"));
        Assert.assertTrue((String)"exact match, case insensitive", (boolean)UtlQueryRegex.like("asdf", "ASDF"));
        Assert.assertTrue((String)"starts with a", (boolean)UtlQueryRegex.like("asdf", "a%"));
        Assert.assertTrue((String)"ends with f", (boolean)UtlQueryRegex.like("asdf", "%f"));
        Assert.assertTrue((String)"starts with a, ends with f", (boolean)UtlQueryRegex.like("asdf", "a%f"));
        Assert.assertTrue((String)"contains s", (boolean)UtlQueryRegex.like("asdf", "%s%"));
        Assert.assertTrue((String)"any four chars", (boolean)UtlQueryRegex.like("asdf", "____"));
        Assert.assertTrue((String)"exactly 2 middle chars", (boolean)UtlQueryRegex.like("asdf", "a__f"));
        Assert.assertTrue((String)"starts with a-c, ends with d-f", (boolean)UtlQueryRegex.like("asdf", "[a-c]%[d-f]"));
        Assert.assertTrue((String)"starts but does not end with a-c, case insensitive", (boolean)UtlQueryRegex.like("asdf", "[A-C]%[^A-C]"));
        Assert.assertFalse((String)"contains x", (boolean)UtlQueryRegex.like("asdf", "x"));
        Assert.assertFalse((String)"one letter between a and f", (boolean)UtlQueryRegex.like("asdf", "a_f"));
    }

    @Test
    public void testTokenization() {
        String sql = "select a,b, c from junk where one < two and three<four";
        String[] tokens = UtlQueryRegex.tokens(sql);
        Assert.assertEquals((String)"First column is a", (Object)"a,", (Object)tokens[1]);
        Assert.assertEquals((String)"Second column is b", (Object)"b,", (Object)tokens[2]);
        Assert.assertEquals((String)"Third column is c", (Object)"c", (Object)tokens[3]);
    }
}

