/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.neeve.ci.XRuntime;
import com.neeve.discovery.DiscoveryCacheEvents;
import com.neeve.discovery.DiscoveryCacheFactory;
import com.neeve.discovery.EDiscoveryException;
import com.neeve.discovery.EDiscoveryJVMShuttingDownException;
import com.neeve.discovery.IDiscoveryCache;
import com.neeve.discovery.IDiscoveryCacheEventHandler;
import com.neeve.discovery.IDiscoveryEntity;
import com.neeve.emx.EmxNwLnkProps;
import com.neeve.link.ELnkOpFailedException;
import com.neeve.link.ILnkClientEndpoint;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkFactory;
import com.neeve.link.LnkSynchronousConnector;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreCommitCompletionStatus;
import com.neeve.ods.IStoreMember;
import com.neeve.ods.IStoreReplicatorNotificationHandler;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsFatalException;
import com.neeve.ods.OdsObject;
import com.neeve.ods.StoreCommitEntry;
import com.neeve.ods.StoreReplicatorDescriptor;
import com.neeve.ods.StoreReplicatorOperation;
import com.neeve.ods.impl.EStoreReplicatorMemberLinkException;
import com.neeve.ods.impl.StoreBindingImpl;
import com.neeve.ods.impl.StoreCommitCompletionStatus;
import com.neeve.ods.impl.StoreReplicatorEventMultiplexer;
import com.neeve.ods.impl.StoreReplicatorLinkAcceptor;
import com.neeve.ods.impl.StoreReplicatorMember;
import com.neeve.ods.impl.StoreReplicatorMemberTable;
import com.neeve.ods.impl.StoreReplicatorOutboundCommitQueue;
import com.neeve.ods.impl.StoreReplicatorStats;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.pkt.types.PktBodyOdsBackupHello;
import com.neeve.pkt.types.PktBodyOdsBackupInitEnd;
import com.neeve.pkt.types.PktBodyOdsCommitAck;
import com.neeve.pkt.types.PktBodyOdsMemberConnect;
import com.neeve.pkt.types.PktBodyOdsMemberConnectReply;
import com.neeve.pkt.types.PktBodyOdsPrimaryHello;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlThrowable;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public final class StoreReplicator
extends OdsObject
implements IDiscoveryCacheEventHandler {
    private final StoreBindingImpl binding;
    private final StoreReplicatorDescriptor descriptor;
    private final IStoreReplicatorNotificationHandler notificationHandler;
    private final StoreReplicatorMemberTable members;
    private final StoreReplicatorOutboundCommitQueue outboundCommits;
    private final StoreCommitEntry inboundCommitEntry;
    private final Initializer initializer;
    private final HashMap<String, Object> linkParams;
    private final int initWaitTime;
    private final int initWaitExtensionUnit;
    private final boolean failOnMultiplePrimaries;
    private final short memberElectionPriority;
    private final boolean suppressDiscoveryShutdownHook;
    private final Tracer instructionTracer;
    private StoreReplicatorStats stats;
    private StoreReplicatorEventMultiplexer multiplexer;
    private StoreReplicatorLinkAcceptor acceptor;
    private IDiscoveryCache discoveryCache;
    private StoreReplicatorMember self;
    private volatile StoreReplicatorMember primary;
    private volatile State state;
    public static final String PROP_STORE_NAME = "storeName";
    public static final String PROP_STORE_REPLICATOR_LOCALIFADDR = "localIfAddr";
    public static final String PROP_STORE_REPLICATOR_LOCALPORT = "localPort";
    public static final String PROP_STORE_REPLICATOR_LINKPARAMS = "linkParams";
    public static final String PROP_STORE_REPLICATOR_LINKREADER_CPUAFFINITYMASK = "linkReaderCpuAffinityMask";
    public static final String PROP_STORE_REPLICATOR_DISCOVERY_DESCRIPTOR = "discoveryDescriptor";
    public static final String PROP_STORE_REPLICATOR_INIT_WAIT_TIME = "initWaitTime";
    public static final String PROP_STORE_REPLICATOR_INIT_WAIT_EXTENSION_UNIT = "initWaitExtensionUnit";
    public static final String PROP_STORE_REPLICATOR_FAILONMULTIPLEPRIMARIES = "failOnMultiplePrimaries";
    public static final String PROP_STORE_REPLICATOR_SUPPRESSDISCOVERYSHUTDOWNHOOK = "suppressDiscoveryShutdownHook";
    public static final String PROP_STORE_REPLICATOR_MEMBER_ELECTION_PRIORITY = "memberElectionPriority";
    public static final String PROP_STORE_REPLICATOR_DETACHED_SEND = "detachedSend";
    public static final String PROP_STORE_REPLICATOR_SENDER_CPUAFFINITYMASK = "senderCpuAffinityMask";
    public static final String PROP_STORE_REPLICATOR_SENDER_QUEUEDEPTH = "senderQueueDepth";
    public static final String PROP_STORE_REPLICATOR_SENDER_QUEUEWAITSTRATEGY = "senderQueueWaitStrategy";
    public static final String PROP_STORE_REPLICATOR_DETACHED_DISPATCH = "detachedDispatch";
    public static final String PROP_STORE_REPLICATOR_DISPATCHER_CPUAFFINITYMASK = "dispatcherCpuAffinityMask";
    public static final String PROP_STORE_REPLICATOR_DISPATCHER_QUEUEDEPTH = "dispatcherQueueDepth";
    public static final String PROP_STORE_REPLICATOR_DISPATCHER_QUEUEWAITSTRATEGY = "dispatcherQueueWaitStrategy";
    private final String DISCOVERY_CACHE_ENTITY_TYPE = "ODSStoreMember";

    private StoreReplicator(StoreBindingImpl binding, StoreReplicatorDescriptor descriptor, IStoreReplicatorNotificationHandler notificationHandler) throws OdsException {
        super(null);
        try {
            boolean suppressDiscoveryShutdownHook;
            int memberElectionPriority;
            boolean failOnMultiplePrimaries;
            int initWaitExtensionUnit;
            int initWaitTime;
            this.binding = binding;
            this.descriptor = descriptor;
            this.notificationHandler = notificationHandler;
            this.members = new StoreReplicatorMemberTable();
            this.outboundCommits = new StoreReplicatorOutboundCommitQueue();
            this.inboundCommitEntry = StoreCommitEntry.create();
            this.initializer = new Initializer();
            this.linkParams = new HashMap();
            String linkParamsStr = descriptor.getProperty(PROP_STORE_REPLICATOR_LINKPARAMS);
            if (XRuntime.optimizeForLatency() || XRuntime.optimizeForThroughput()) {
                linkParamsStr = "maxreadspintime=1000000,eagerread=true" + (linkParamsStr != null ? "," + linkParamsStr : "");
            }
            if (linkParamsStr != null) {
                StringTokenizer tokenizer = new StringTokenizer(linkParamsStr, ",");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    String[] keyValue = token.split("=");
                    if (keyValue.length == 2) {
                        this.linkParams.put(keyValue[0], keyValue[1]);
                        continue;
                    }
                    throw new IllegalArgumentException("invalid replication link parameter '" + token + "'");
                }
            }
            try {
                initWaitTime = Integer.parseInt(descriptor.getProperty(PROP_STORE_REPLICATOR_INIT_WAIT_TIME, "5000"));
            }
            catch (Exception e) {
                this.tracer.log(this.getTracePrefix() + "failed to parse '" + PROP_STORE_REPLICATOR_INIT_WAIT_TIME + "' configuration parameter from descriptor [" + e.toString() + "].", Tracer.Level.WARNING);
                initWaitTime = 5000;
            }
            this.initWaitTime = initWaitTime;
            try {
                initWaitExtensionUnit = Integer.parseInt(descriptor.getProperty(PROP_STORE_REPLICATOR_INIT_WAIT_EXTENSION_UNIT, "100"));
            }
            catch (Exception e) {
                this.tracer.log(this.getTracePrefix() + "failed to parse '" + PROP_STORE_REPLICATOR_INIT_WAIT_EXTENSION_UNIT + "' configuration parameter from descriptor [" + e.toString() + "].", Tracer.Level.WARNING);
                initWaitExtensionUnit = 100;
            }
            this.initWaitExtensionUnit = initWaitExtensionUnit;
            try {
                failOnMultiplePrimaries = Boolean.parseBoolean(descriptor.getProperty(PROP_STORE_REPLICATOR_FAILONMULTIPLEPRIMARIES, "true"));
            }
            catch (Exception e) {
                this.tracer.log(this.getTracePrefix() + "failed to parse '" + PROP_STORE_REPLICATOR_FAILONMULTIPLEPRIMARIES + "' configuration parameter from descriptor [" + e.toString() + "].", Tracer.Level.WARNING);
                failOnMultiplePrimaries = true;
            }
            this.failOnMultiplePrimaries = failOnMultiplePrimaries;
            try {
                memberElectionPriority = Math.max(0, Math.min(255, Short.parseShort(descriptor.getProperty(PROP_STORE_REPLICATOR_MEMBER_ELECTION_PRIORITY, "255"))));
            }
            catch (Exception e) {
                this.tracer.log(this.getTracePrefix() + "failed to parse '" + PROP_STORE_REPLICATOR_MEMBER_ELECTION_PRIORITY + "' configuration parameter from descriptor [" + e.toString() + "].", Tracer.Level.WARNING);
                memberElectionPriority = 255;
            }
            this.memberElectionPriority = memberElectionPriority;
            try {
                suppressDiscoveryShutdownHook = Boolean.parseBoolean(descriptor.getProperty(PROP_STORE_REPLICATOR_SUPPRESSDISCOVERYSHUTDOWNHOOK, "false"));
            }
            catch (Exception e) {
                this.tracer.log(this.getTracePrefix() + "failed to parse '" + PROP_STORE_REPLICATOR_SUPPRESSDISCOVERYSHUTDOWNHOOK + "' configuration parameter from descriptor [" + e.toString() + "].", Tracer.Level.WARNING);
                suppressDiscoveryShutdownHook = true;
            }
            this.suppressDiscoveryShutdownHook = suppressDiscoveryShutdownHook;
            this.instructionTracer = Tracer.get((String)"nv.ods.replicator.instruction");
            if (this.tracer.verbose) {
                this.instructionTracer.setLevel(Tracer.Level.VERBOSE);
            } else if (this.tracer.debug) {
                this.instructionTracer.setLevel(Tracer.Level.DEBUG);
            }
        }
        catch (Throwable e) {
            throw e instanceof OdsException ? (OdsException)e : new OdsException(e);
        }
    }

    public static final StoreReplicator create(StoreBindingImpl binding, StoreReplicatorDescriptor descriptor, IStoreReplicatorNotificationHandler notificationHandler) throws OdsException {
        if (binding == null) {
            throw new IllegalArgumentException("store binding cannot be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        return new StoreReplicator(binding, descriptor, notificationHandler);
    }

    private final void setState(State state) {
        this.state = state;
    }

    private final boolean shouldConnectToMember(IDiscoveryEntity entity) {
        return entity.getName().compareTo(this.memberNameToEntityName(this.binding.getMemberName())) < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ILnkPeerEndpoint connectToMember(String linkDescriptor) throws Exception {
        ILnkClientEndpoint cep = null;
        ILnkPeerEndpoint pep = null;
        try {
            String localHostAddr = this.descriptor.getProperty(PROP_STORE_REPLICATOR_LOCALIFADDR);
            String moddedDescriptor = this.multiplexer.touch(linkDescriptor) + (localHostAddr != null ? "&localifaddr=" + localHostAddr : "") + "&threadingmodel=strmtw";
            this.tracer.log(this.getTracePrefix() + "connecting to peer with " + moddedDescriptor, Tracer.Level.VERBOSE);
            cep = LnkFactory.getInstance().createClientEndpoint(moddedDescriptor, null);
            pep = LnkSynchronousConnector.create().run(cep, Integer.MAX_VALUE);
        }
        finally {
            if (pep == null && cep != null) {
                try {
                    cep.close();
                }
                catch (Exception e) {
                    this.tracer.log(this.getTracePrefix() + "failed to close link client endpoint on ODS member connect failure [" + e.toString() + "].", Tracer.Level.WARNING);
                }
            }
        }
        return pep;
    }

    private final void createDiscovery() throws OdsException {
        boolean configuredDiscovery = true;
        String discoveryCacheDescriptorStr = this.descriptor.getProperty(PROP_STORE_REPLICATOR_DISCOVERY_DESCRIPTOR);
        if (discoveryCacheDescriptorStr == null) {
            this.tracer.log(this.getTracePrefix() + "using the default discovery cache descriptor.", Tracer.Level.VERBOSE);
            discoveryCacheDescriptorStr = DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR;
            configuredDiscovery = false;
        }
        discoveryCacheDescriptorStr = discoveryCacheDescriptorStr + "&initWaitTime=0";
        this.tracer.log(this.getTracePrefix() + "opening discovery cache '" + UtlAddressDescriptor.parse((String)discoveryCacheDescriptorStr, null).toPasswordSanitizedFullString() + "'...", Tracer.Level.VERBOSE);
        try {
            this.discoveryCache = DiscoveryCacheFactory.getInstance().createCache(discoveryCacheDescriptorStr, 1);
            this.discoveryCache.addEventHandler((IDiscoveryCacheEventHandler)this);
        }
        catch (EDiscoveryException e) {
            throw new OdsException(e);
        }
        if (this.linkParams.get("flushtimeout") == null) {
            this.linkParams.put("flushtimeout", String.valueOf(this.discoveryCache.getMaxEntityAge() * 1000));
        }
        if (this.tracer.isEnabled(Tracer.Level.INFO)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getTracePrefix());
            UtlAddressDescriptor discoveryDescriptor = UtlAddressDescriptor.parse((String)discoveryCacheDescriptorStr, null);
            sb.append(" [discovery: ");
            discoveryDescriptor.appendShortStringTo((Appendable)sb);
            sb.append(" (").append(configuredDiscovery ? "configured" : "default").append(")]");
            this.tracer.log(sb.toString(), Tracer.Level.INFO);
        }
    }

    private final void openDiscovery(List<UtlAddressDescriptor> descriptors) throws OdsException {
        String myEntityName = this.memberNameToEntityName(this.binding.getMemberName());
        this.self = new StoreReplicatorMember(this, this.binding.getMemberName(), this.discoveryCache.create("ODSStoreMember", myEntityName, descriptors));
        try {
            int flags = 0;
            if (this.suppressDiscoveryShutdownHook) {
                this.tracer.log(this.getTracePrefix() + "Suppressing discovery JVM shutdown hook...", Tracer.Level.INFO);
                flags |= 1;
            }
            this.discoveryCache.open(flags);
        }
        catch (EDiscoveryException e) {
            throw new OdsException(e);
        }
        if (this.tracer.isEnabled(Tracer.Level.INFO)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getTracePrefix());
            sb.append("Advertising store cluster acceptor '").append(myEntityName).append("' with address ");
            ((UtlAddressDescriptor)this.self.getEntity().getAddressDescriptors().get(0)).appendShortStringTo((Appendable)sb);
            this.tracer.log(sb.toString(), Tracer.Level.INFO);
        }
        this.tracer.log(this.getTracePrefix() + "adding myself to discovery cache...", Tracer.Level.VERBOSE);
        try {
            this.discoveryCache.add(this.self.getEntity());
        }
        catch (EDiscoveryJVMShuttingDownException e) {
            this.tracer.log(this.getTracePrefix() + "...JVM is shutting down.", Tracer.Level.VERBOSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeDiscovery() {
        IDiscoveryCache cache = this.discoveryCache;
        if (cache != null) {
            IDiscoveryCache iDiscoveryCache = cache;
            synchronized (iDiscoveryCache) {
                cache = this.discoveryCache;
                this.discoveryCache = null;
            }
        }
        if (cache != null) {
            if (this.self != null) {
                try {
                    cache.remove(this.self.getEntity());
                }
                catch (EDiscoveryJVMShuttingDownException eDiscoveryJVMShuttingDownException) {
                    // empty catch block
                }
            }
            this.tracer.log(this.getTracePrefix() + "removed myself from discovery cache...", Tracer.Level.VERBOSE);
            try {
                cache.removeEventHandler((IDiscoveryCacheEventHandler)this);
            }
            catch (EDiscoveryJVMShuttingDownException eDiscoveryJVMShuttingDownException) {
                // empty catch block
            }
            cache.close();
            this.tracer.log(this.getTracePrefix() + "closed the discovery cache.", Tracer.Level.VERBOSE);
        }
    }

    private final List<UtlAddressDescriptor> openLinkAcceptor() throws OdsException {
        String localHostAddr;
        try {
            localHostAddr = this.descriptor.getProperty(PROP_STORE_REPLICATOR_LOCALIFADDR);
            if (localHostAddr == null) {
                localHostAddr = XRuntime.getLocalHostAddress();
            }
        }
        catch (UnknownHostException e) {
            throw new OdsException("Unable to determine local host's address");
        }
        String localPort = this.descriptor.getProperty(PROP_STORE_REPLICATOR_LOCALPORT, "0");
        UtlAddressDescriptor acceptorDescriptor = UtlAddressDescriptor.parse((String)("tcp://" + localHostAddr + ":" + localPort + "&threadingmodel=strmtw"), this.linkParams);
        this.acceptor = new StoreReplicatorLinkAcceptor(this, acceptorDescriptor);
        this.acceptor.open();
        Object localPortBoundVal = acceptorDescriptor.props.get(EmxNwLnkProps.Socket.localportbound.toString());
        if (localPortBoundVal == null || !(localPortBoundVal instanceof Integer)) {
            this.closeLinkAcceptor();
            throw new OdsException("Failed to determine the port the acceptor is actually bound to");
        }
        this.tracer.log(this.getTracePrefix() + "opened store acceptor '" + acceptorDescriptor.toFullString() + "'...", Tracer.Level.CONFIG);
        LinkedList<UtlAddressDescriptor> connectorDescriptors = new LinkedList<UtlAddressDescriptor>();
        connectorDescriptors.add(UtlAddressDescriptor.parse((String)("tcp://" + localHostAddr + ":" + localPortBoundVal), null));
        return connectorDescriptors;
    }

    private final void closeLinkAcceptor() {
        if (this.acceptor != null) {
            this.acceptor.close();
            this.acceptor = null;
        }
    }

    private final void openEventMultiplexer() throws Exception {
        this.multiplexer.open();
    }

    private final void closeEventMultiplexer(boolean dispatchMemberDownEvents) {
        if (this.multiplexer != null) {
            this.multiplexer.close(dispatchMemberDownEvents);
        }
    }

    private final int getInitMemberCount() {
        int initMemberCount = 0;
        Iterator<StoreReplicatorMember> iterator = this.members.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getState() != StoreReplicatorMember.State.Init) continue;
            ++initMemberCount;
        }
        return initMemberCount;
    }

    private final void closeMemberTable(boolean dispatchMemberDownEvents) {
        if (this.members != null) {
            this.tracer.log(this.getTracePrefix() + "closing member table (count=" + this.members.size() + ", dispatch member down=" + dispatchMemberDownEvents + ")...", Tracer.Level.VERBOSE);
            if (dispatchMemberDownEvents) {
                ListIterator<Map.Entry<IDiscoveryEntity, StoreReplicatorMember>> iterator = this.members.fastEntryIterator();
                while (iterator.hasNext()) {
                    this.binding.onMemberDown(iterator.next().getValue());
                }
            }
            this.members.close();
            if (this.self != null) {
                this.self.close();
            }
            if (this.primary != null) {
                this.primary.close();
            }
        }
    }

    private final String memberNameToEntityName(String memberName) {
        return this.getStoreName() + "/" + memberName;
    }

    final String entityNameToMemberName(String entityName) {
        return entityName.substring(entityName.lastIndexOf(47) + 1);
    }

    private final boolean isEntityAMemberOfThisStore(IDiscoveryEntity entity) {
        return entity.getType().equals("ODSStoreMember") && entity.getName().startsWith(this.getStoreName() + "/");
    }

    private final boolean isEntityMyself(IDiscoveryEntity entity) {
        return this.self.getEntity() == entity;
    }

    private final void dispatchOperationNotification(StoreReplicatorOperation operation, Object data) {
        try {
            this.notificationHandler.onOperation(operation, data);
        }
        catch (Throwable e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Notification handler faulted with error [" + e.toString() + "] with the following stack trace:\n");
            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
            this.tracer.log(this.getTracePrefix() + "" + sb.toString(), Tracer.Level.WARNING);
        }
    }

    private final void setPrimary(StoreReplicatorMember member) {
        this.primary = member;
        this.tracer.log(this.getTracePrefix() + "set primary to '" + this.primary + "'].", Tracer.Level.VERBOSE);
        IStoreBinding.Role role = this.getRole();
        IStoreBinding.Role newRole = null;
        if (this.primary == this.self) {
            if (role != IStoreBinding.Role.Primary) {
                newRole = IStoreBinding.Role.Primary;
                this.binding.onRoleChange(newRole);
            }
        } else if (role != IStoreBinding.Role.Backup) {
            newRole = IStoreBinding.Role.Backup;
            this.binding.onRoleChange(newRole);
        }
        if (newRole != null) {
            this.tracer.log(this.getTracePrefix() + "dispatched role change event [new role='" + (Object)((Object)newRole) + "'].", Tracer.Level.VERBOSE);
        }
    }

    private final void scheduleMemberHandshakeStart(IStoreMember member) {
        this.tracer.log(this.getTracePrefix() + "scheduling synchronization handshake with member '" + member.getName() + "'...", Tracer.Level.VERBOSE);
        try {
            this.multiplexer.scheduleMemberHandshakeStartReady(member);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getTracePrefix() + "failed to schedule member handshake ready processing for member '" + member.getName() + "' [" + e.toString() + "]...").append("\n");
            sb.append("Stack Trace:").append("\n");
            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
            sb.append("Failing member...").append("\n");
            this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
            member.fail(e);
        }
    }

    private final void doPrimaryElect() {
        this.tracer.log(this.getTracePrefix() + "electing primary...", Tracer.Level.VERBOSE);
        StoreReplicatorMember newPrimary = this.self;
        Iterator<StoreReplicatorMember> iterator = this.members.iterator();
        while (iterator.hasNext()) {
            StoreReplicatorMember member = iterator.next();
            if (member.getName().compareToIgnoreCase(newPrimary.getName()) >= 0) continue;
            newPrimary = member;
        }
        this.setPrimary(newPrimary);
        if (this.primary == this.self) {
            this.tracer.log(this.getTracePrefix() + "primary is self.", Tracer.Level.VERBOSE);
            if (this.state == State.INIT) {
                this.tracer.log(this.getTracePrefix() + "primary elected as self during initialization. completing initialization...", Tracer.Level.VERBOSE);
                this.initializer.complete(null);
                this.setState(State.NORMAL);
            }
            if (this.members.size() > 0) {
                iterator = this.members.iterator();
                while (iterator.hasNext()) {
                    this.scheduleMemberHandshakeStart(iterator.next());
                }
            } else {
                this.tracer.log(this.getTracePrefix() + "no members to handshake with.", Tracer.Level.VERBOSE);
            }
        } else {
            this.tracer.log(this.getTracePrefix() + "primary is not self.", Tracer.Level.VERBOSE);
        }
    }

    private final boolean processRoleInMemberConnect(StoreReplicatorMember member, IStoreBinding.Role memberRole) {
        IStoreBinding.Role myRole = this.getRole();
        if (memberRole == null) {
            this.tracer.log(this.getTracePrefix() + "member is joining my cluster (myRole=" + (Object)((Object)myRole) + "). all is good.", Tracer.Level.VERBOSE);
        } else if (memberRole == IStoreBinding.Role.Backup) {
            if (myRole != null) {
                this.tracer.log(this.getTracePrefix() + "a backup member of a partitioned cluster is connecting to me (myRole=" + (Object)((Object)myRole) + "). rejecting connection...", Tracer.Level.WARNING);
                member.fail(null);
                return false;
            }
        } else {
            if (myRole != null) {
                switch (myRole) {
                    case Primary: {
                        if (this.failOnMultiplePrimaries) {
                            throw new OdsFatalException("multiple cluster primaries");
                        }
                        this.tracer.log(this.getTracePrefix() + "a primary member of a partitioned cluster is connecting to me (myRole=" + (Object)((Object)myRole) + "). rejecting connection (per multiple primary configuration policy)...", Tracer.Level.WARNING);
                        member.fail(null);
                        break;
                    }
                    case Backup: {
                        this.tracer.log(this.getTracePrefix() + "a primary member of a partitioned cluster is connecting to me (myRole=" + (Object)((Object)myRole) + "). rejecting connection...", Tracer.Level.WARNING);
                        member.fail(null);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown role '" + (Object)((Object)myRole) + "'");
                    }
                }
                return false;
            }
            this.setPrimary(member);
        }
        if (this.primary == this.self) {
            this.scheduleMemberHandshakeStart(member);
        }
        return true;
    }

    private final void close(boolean dispatchMemberDownEvents) {
        if (this.stats != null) {
            this.stats.close();
        }
        this.closeDiscovery();
        this.closeLinkAcceptor();
        this.closeEventMultiplexer(dispatchMemberDownEvents);
    }

    final String getTracePrefix() {
        return this.binding.getTracePrefix("R");
    }

    final StoreReplicatorDescriptor getDescriptor() {
        return this.descriptor;
    }

    final String getStoreName() {
        return this.descriptor.getProperty(PROP_STORE_NAME, this.descriptor.getName());
    }

    final String getMemberName() {
        return this.binding.getMemberName();
    }

    final short getMemberElectionPriority() {
        return this.memberElectionPriority;
    }

    final IStoreBinding.Role getRole() {
        return this.binding.getRole();
    }

    final State getState() {
        return this.state;
    }

    final StoreReplicatorMember getPrimary() {
        return this.primary;
    }

    final StoreBindingImpl getBinding() {
        return this.binding;
    }

    final StoreReplicatorEventMultiplexer getEventMultiplexer() {
        return this.multiplexer;
    }

    final StoreReplicatorOutboundCommitQueue getOutboundCommitQueue() {
        return this.outboundCommits;
    }

    final void handleEntityUp(IDiscoveryEntity entity) {
        if (this.checked && this.multiplexer.getDispatcherThread() != Thread.currentThread()) {
            throw new InternalError("'HandleEntityUp' dispatched by a thread different from the multiplexer dispatcher thread.");
        }
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'HandleEntityUp' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(E) HandleEntityUp (" + (Object)((Object)this.state) + ") {" + entity.hashCode() + ", " + entity.getType() + ", " + entity.getName() + "}.", Tracer.Level.VERBOSE);
        }
        if (this.state == State.INIT || this.state == State.NORMAL) {
            if (this.isEntityAMemberOfThisStore(entity)) {
                this.tracer.log(this.getTracePrefix() + "entity is a member of this store.", Tracer.Level.VERBOSE);
                if (!this.isEntityMyself(entity)) {
                    this.binding.onMemberFound(entity);
                } else {
                    this.tracer.log(this.getTracePrefix() + "entity is myself. nothing to be done.", Tracer.Level.VERBOSE);
                }
            } else {
                this.tracer.log(this.getTracePrefix() + "entity is not member of this store. nothing to be done.", Tracer.Level.VERBOSE);
            }
        } else {
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. Ignoring...", Tracer.Level.VERBOSE);
                    break;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. Ignoring...", Tracer.Level.VERBOSE);
                }
            }
        }
    }

    final void handleMemberTableOpenWaitCompletion() {
        if (this.checked && this.multiplexer.getDispatcherThread() != Thread.currentThread()) {
            throw new InternalError("'HandleMemberTableOpenWaitCompletion' dispatched by a thread different from the multiplexer dispatcher thread.");
        }
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'HandleMemberTableOpenWaitCompletion' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(E) HandleMemberTableOpenWaitCompletion (" + (Object)((Object)this.state) + ") {}.", Tracer.Level.VERBOSE);
        }
        if (this.state == State.INIT) {
            this.binding.onMemberTableOpenWaitCompletion();
        } else {
            switch (this.state) {
                case NORMAL: {
                    this.tracer.log(this.getTracePrefix() + "store binding initialization already complete. Ignoring...", Tracer.Level.VERBOSE);
                    break;
                }
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. Ignoring...", Tracer.Level.VERBOSE);
                    break;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. Ignoring...", Tracer.Level.VERBOSE);
                }
            }
        }
    }

    final void handleMemberHandshakeStartReady(IStoreMember member) {
        if (this.checked && this.multiplexer.getDispatcherThread() != Thread.currentThread()) {
            throw new InternalError("'HandleMemberHandshakeStartReady' dispatched by a thread different from the multiplexer dispatcher thread.");
        }
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'HandleMemberHandshakeStartReady' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(E) HandleMemberHandshakeStartReady (" + (Object)((Object)this.state) + ") {" + member.getName() + "}.", Tracer.Level.VERBOSE);
        }
        if (this.state == State.INIT || this.state == State.NORMAL) {
            this.binding.onMemberHandshakeStartReady(member);
        } else {
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. Ignoring...", Tracer.Level.VERBOSE);
                    break;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. Ignoring...", Tracer.Level.VERBOSE);
                }
            }
        }
    }

    final void handleMemberInitReady(IStoreMember member) {
        if (this.checked && this.multiplexer.getDispatcherThread() != Thread.currentThread()) {
            throw new InternalError("'HandleMemberInitReady' dispatched by a thread different from the multiplexer dispatcher thread.");
        }
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'HandleMemberInitReady' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(E) HandleMemberInitReady (" + (Object)((Object)this.state) + ") {" + member.getName() + "}.", Tracer.Level.VERBOSE);
        }
        if (this.state == State.INIT || this.state == State.NORMAL) {
            this.binding.onMemberInitReady(member);
        } else {
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. Ignoring...", Tracer.Level.VERBOSE);
                    break;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. Ignoring...", Tracer.Level.VERBOSE);
                }
            }
        }
    }

    final void handleEntityDown(IDiscoveryEntity entity, String calledFrom) {
        if (this.checked && this.multiplexer.getDispatcherThread() != Thread.currentThread()) {
            throw new InternalError("'HandleEntityDown' dispatched by a thread different from the multiplexer dispatcher thread.");
        }
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'HandleEntityDown' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(E) HandleEntityDown (" + (Object)((Object)this.state) + ") {" + entity.hashCode() + ", " + entity.getType() + ", " + entity.getName() + ", " + calledFrom + "}.", Tracer.Level.VERBOSE);
        }
        if (this.state == State.INIT || this.state == State.NORMAL) {
            if (this.isEntityAMemberOfThisStore(entity)) {
                this.tracer.log(this.getTracePrefix() + "entity is a member of this store. scheduling for processing...", Tracer.Level.VERBOSE);
                this.binding.onMemberLost(entity);
            } else {
                this.tracer.log(this.getTracePrefix() + "entity is not member of this store. nothing to be done.", Tracer.Level.VERBOSE);
            }
        } else {
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. Ignoring...", Tracer.Level.VERBOSE);
                    break;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. Ignoring...", Tracer.Level.VERBOSE);
                }
            }
        }
    }

    final void handleLinkAccept(ILnkPeerEndpoint pep) throws Exception {
        try {
            if (this.state == State.CLOSED) {
                throw new InternalError("received 'HandleLinkAccept' for processing in '" + (Object)((Object)this.state) + "' state!");
            }
            if (this.instructionTracer.verbose) {
                this.instructionTracer.log(this.getTracePrefix() + "(E) HandleLinkAccept (" + (Object)((Object)this.state) + ") {" + pep + "}.", Tracer.Level.VERBOSE);
            }
            if (this.state != State.INIT && this.state != State.NORMAL) {
                switch (this.state) {
                    case FAILED: {
                        throw new Exception("store binding has failed");
                    }
                }
                throw new Exception("store state=" + (Object)((Object)this.state));
            }
            this.multiplexer.addReplicatorLink(pep);
        }
        catch (Exception e) {
            this.tracer.log(this.getTracePrefix() + "failed to add accepted link to multiplexer [" + e.toString() + "]. Closing link...", Tracer.Level.WARNING);
            try {
                pep.close((short)-1);
            }
            catch (ELnkOpFailedException e1) {
                this.tracer.log(this.getTracePrefix() + "failed to close link after multiplexer add failed [" + e1.toString() + "].", Tracer.Level.WARNING);
            }
        }
    }

    final void handleMemberConnect(ILnkPeerEndpoint pep, PktPacket packet) throws Exception {
        IStoreBinding.Role role;
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'HandleMemberConnect' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        PktBodyOdsMemberConnect memberConnect = (PktBodyOdsMemberConnect)packet.getBody();
        String memberName = memberConnect.getMemberName();
        IStoreBinding.Role role2 = role = memberConnect.getRole() == null ? null : IStoreBinding.Role.valueOf(memberConnect.getRole().toString());
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(E) HandleMemberConnect (" + (Object)((Object)this.state) + ") {" + memberName + ", " + (Object)((Object)role) + "}.", Tracer.Level.VERBOSE);
        }
        if (this.state != State.INIT && this.state != State.NORMAL) {
            switch (this.state) {
                case FAILED: {
                    throw new Exception("store binding has failed");
                }
            }
            throw new Exception("store binding state=" + (Object)((Object)this.state));
        }
        this.binding.onMemberConnect(pep, memberName, role);
    }

    final void handleMemberConnectReply(StoreReplicatorMember source, PktPacket packet) {
        IStoreBinding.Role role;
        if (this.checked && this.multiplexer.getDispatcherThread() != Thread.currentThread()) {
            throw new InternalError("'HandleMemberConnectReply' dispatched by a thread different from the multiplexer dispatcher thread.");
        }
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'HandleMemberConnectReply' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        PktBodyOdsMemberConnectReply memberConnectReply = (PktBodyOdsMemberConnectReply)packet.getBody();
        String memberName = memberConnectReply.getMemberName();
        IStoreBinding.Role role2 = role = memberConnectReply.getRole() == null ? null : IStoreBinding.Role.valueOf(memberConnectReply.getRole().toString());
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(E) HandleMemberConnectReply (" + (Object)((Object)this.state) + ") {" + source + ", " + memberName + ", " + (Object)((Object)role) + "}", Tracer.Level.VERBOSE);
        }
        if (this.state == State.INIT || this.state == State.NORMAL) {
            this.binding.onMemberConnectReply(source, role);
        } else {
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. Ignoring...", Tracer.Level.VERBOSE);
                    break;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. Ignoring...", Tracer.Level.VERBOSE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void handleInitStart(StoreReplicatorMember source, PktPacket packet) {
        if (this.checked && this.multiplexer.getDispatcherThread() != Thread.currentThread()) {
            throw new InternalError("'HandleInitStart' dispatched by a thread different from the multiplexer dispatcher thread.");
        }
        if (this.state == State.NORMAL || this.state == State.CLOSED) {
            throw new InternalError("received 'HandleInitStart' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        PktSubheaderODS subheaderODS = packet.getHeader().getODSSubheader();
        if (subheaderODS == null) {
            this.tracer.log(this.getTracePrefix() + "received a corrupt inbound init start packet from '" + source + "' (no ODS subheader). Discarding...", Tracer.Level.WARNING);
            packet.dispose();
            return;
        }
        PktBuffer persisterMetadata = subheaderODS.getPersisterMetadata();
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(E) HandleInitStart (" + (Object)((Object)this.state) + ") {" + source + ", " + (persisterMetadata != null ? persisterMetadata.getLength() : 0) + "}.", Tracer.Level.VERBOSE);
        }
        try {
            if (this.state == State.INIT) {
                if (this.checked && source != this.primary) {
                    throw new InternalError("received init start from a backup (primary='" + this.primary + "', source='" + source + "')!");
                }
                ++this.stats.numPacketsReceived;
                this.binding.onInitStart(source, persisterMetadata);
                return;
            }
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. ignoring...", Tracer.Level.VERBOSE);
                    return;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. ignoring...", Tracer.Level.VERBOSE);
                    return;
                }
            }
        }
        finally {
            packet.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void handleInitEntry(StoreReplicatorMember source, PktPacket packet) {
        if (this.checked && this.multiplexer.getDispatcherThread() != Thread.currentThread()) {
            throw new InternalError("'HandleInitEntry' dispatched by a thread different from the multiplexer dispatcher thread.");
        }
        if (this.state == State.NORMAL || this.state == State.CLOSED) {
            throw new InternalError("received 'HandleInitEntry' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        PktSubheaderODS subheaderODS = packet.getHeader().getODSSubheader();
        if (subheaderODS == null) {
            this.tracer.log(this.getTracePrefix() + "received a corrupt inbound init entry packet from '" + source + "' (no ODS subheader). Discarding...", Tracer.Level.WARNING);
            packet.dispose();
            return;
        }
        this.inboundCommitEntry.init(packet);
        if (this.instructionTracer.debug) {
            this.instructionTracer.log(this.getTracePrefix() + "(E) HandleInitEntry (" + (Object)((Object)this.state) + ") {" + source + ", " + this.inboundCommitEntry.commitEnd + "}.", Tracer.Level.DEBUG);
        }
        try {
            if (this.state == State.INIT) {
                if (this.checked && source != this.primary) {
                    throw new InternalError("received init entry from a backup (primary='" + this.primary + "', source='" + source + "')!");
                }
                ++this.stats.numPacketsReceived;
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix() + "entry is an object " + this.inboundCommitEntry.operation.toString().toUpperCase() + " (objectId=" + this.inboundCommitEntry.id + ").", Tracer.Level.DEBUG);
                }
                this.binding.onInitEntry(this.inboundCommitEntry);
                return;
            }
            switch (this.state) {
                case FAILED: {
                    if (!this.tracer.debug) return;
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. Ignoring...", Tracer.Level.DEBUG);
                    return;
                }
                default: {
                    if (!this.tracer.debug) return;
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. Ignoring...", Tracer.Level.DEBUG);
                    return;
                }
            }
        }
        finally {
            this.inboundCommitEntry.fin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void handleInitComplete(StoreReplicatorMember source, PktPacket packet) {
        if (this.checked && this.multiplexer.getDispatcherThread() != Thread.currentThread()) {
            throw new InternalError("'HandleInitComplete' dispatched by a thread different from the multiplexer dispatcher thread.");
        }
        if (this.state == State.NORMAL || this.state == State.CLOSED) {
            throw new InternalError("received 'HandleInitComplete' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        PktBodyOdsBackupInitEnd body = (PktBodyOdsBackupInitEnd)packet.getBody();
        long transactionId = body.getTransactionId();
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(E) HandleInitComplete (" + (Object)((Object)this.state) + ") {" + source + ", " + transactionId + "}.", Tracer.Level.VERBOSE);
        }
        try {
            if (this.state == State.INIT) {
                if (this.checked && source != this.primary) {
                    throw new InternalError("received init complete from a backup (primary='" + this.primary + "', source='" + source + "')!");
                }
                ++this.stats.numPacketsReceived;
                this.binding.onInitComplete(source, transactionId);
                this.initializer.complete(null);
                this.setState(State.NORMAL);
                return;
            }
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. Ignoring...", Tracer.Level.VERBOSE);
                    return;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. Ignoring...", Tracer.Level.VERBOSE);
                    return;
                }
            }
        }
        finally {
            packet.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void handleCommitEntry(StoreReplicatorMember source, PktPacket packet) {
        if (this.checked && this.multiplexer.getDispatcherThread() != Thread.currentThread()) {
            throw new InternalError("'HandleCommitEntry' dispatched by a thread different from the multiplexer dispatcher thread.");
        }
        if (this.state == State.INIT || this.state == State.CLOSED) {
            throw new InternalError("received 'HandleCommitEntry' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        PktSubheaderODS subheaderODS = packet.getHeader().getODSSubheader();
        if (subheaderODS == null) {
            this.tracer.log(this.getTracePrefix() + "received a corrupt inbound commit entry packet from '" + source + "' (no ODS subheader). Discarding...", Tracer.Level.WARNING);
            packet.dispose();
            return;
        }
        boolean commitAckRequired = subheaderODS.getFlagCommitAckRequired();
        this.inboundCommitEntry.init(packet);
        if (this.instructionTracer.debug) {
            this.instructionTracer.log(this.getTracePrefix() + "(E) HandleCommitEntry (" + (Object)((Object)this.state) + ") {" + source + ", " + this.inboundCommitEntry.commitStart + ", " + this.inboundCommitEntry.commitEnd + ", " + commitAckRequired + "}.", Tracer.Level.DEBUG);
        }
        try {
            if (this.state == State.NORMAL) {
                if (this.checked && source != this.primary) {
                    throw new InternalError("received commit entry from a backup (primary='" + this.primary + "', source='" + source + "')!");
                }
                ++this.stats.numPacketsReceived;
                if (this.inboundCommitEntry.commitEnd) {
                    ++this.stats.numCommitsReceived;
                }
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix() + "entry is an object " + this.inboundCommitEntry.operation.toString().toUpperCase() + " (objectId=" + this.inboundCommitEntry.id + ").", Tracer.Level.DEBUG);
                }
                long postWireTs = packet.getInTs();
                long preWireTs = packet.getOutTs();
                long postProcTs = 0L;
                postProcTs = this.binding.onCommitEntry(StoreBindingImpl.StoreCommitEntrySource.Replicator, this.inboundCommitEntry, commitAckRequired, preWireTs, postWireTs);
                if (!this.inboundCommitEntry.commitEnd) return;
                if (commitAckRequired) {
                    try {
                        if (this.tracer.debug) {
                            this.tracer.log(this.getTracePrefix() + "ack required. Sending ack...", Tracer.Level.DEBUG);
                        }
                        long ackPreWireTs = source.sendCommitAck(this.inboundCommitEntry.transactionId);
                        ++this.stats.numCommitAcksSent;
                        if (!this.binding.captureStoreLatencyStats || postProcTs <= 0L || ackPreWireTs <= 0L) return;
                        this.binding.stats.s2w.add((double)(ackPreWireTs - postProcTs));
                        return;
                    }
                    catch (EStoreReplicatorMemberLinkException e) {
                        this.tracer.log(this.getTracePrefix() + "failure in sending commit ack [cause=" + (e.getMessage() != null ? e.getMessage() : e.toString()) + "] to member '" + source.getName() + "'. failing member...", Tracer.Level.SEVERE);
                        source.fail(e);
                    }
                    return;
                } else {
                    if (!this.tracer.debug) return;
                    this.tracer.log(this.getTracePrefix() + "ack not solicited.", Tracer.Level.DEBUG);
                }
                return;
            }
            switch (this.state) {
                case FAILED: {
                    if (!this.tracer.debug) return;
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. Ignoring...", Tracer.Level.DEBUG);
                    return;
                }
                default: {
                    if (!this.tracer.debug) return;
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. Ignoring...", Tracer.Level.DEBUG);
                    return;
                }
            }
        }
        finally {
            this.inboundCommitEntry.fin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void handleCommitAck(StoreReplicatorMember source, PktPacket packet) {
        if (this.checked && this.multiplexer.getDispatcherThread() != Thread.currentThread()) {
            throw new InternalError("'HandleCommitAck' dispatched by a thread different from the multiplexer dispatcher thread.");
        }
        if (this.state == State.INIT || this.state == State.CLOSED) {
            throw new InternalError("received 'HandleCommitAck' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        PktBodyOdsCommitAck commitAck = (PktBodyOdsCommitAck)packet.getBody();
        long transactionId = commitAck.getTransactionId();
        if (this.instructionTracer.debug) {
            this.instructionTracer.log(this.getTracePrefix() + "(E) HandleCommitAck (" + (Object)((Object)this.state) + ") {" + source + ", " + transactionId + "}.", Tracer.Level.DEBUG);
        }
        try {
            if (this.state == State.NORMAL) {
                ++this.stats.numCommitAcksReceived;
                StoreCommitCompletionStatus completionStatus = this.outboundCommits.get(transactionId);
                if (completionStatus != null) {
                    completionStatus.setReplicationStatus(source, null);
                    if (completionStatus.isComplete()) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.getTracePrefix() + "transaction #" + transactionId + " is complete. Dispatching commit complete event...", Tracer.Level.DEBUG);
                        }
                        this.outboundCommits.remove(transactionId);
                        completionStatus.getCompletionEvent().setPostWireTs(packet.getInTs());
                        this.binding.onCommitComplete(completionStatus);
                        return;
                    } else {
                        if (!this.tracer.debug) return;
                        this.tracer.log(this.getTracePrefix() + "transaction #" + transactionId + " is not yet complete.", Tracer.Level.DEBUG);
                    }
                    return;
                } else {
                    this.tracer.log(this.getTracePrefix() + "failed to find commit context for inbound commit ack (ACK source=" + source + ", transaction #=" + transactionId + "). Ignoring...", Tracer.Level.WARNING);
                }
                return;
            }
            switch (this.state) {
                case FAILED: {
                    if (!this.tracer.debug) return;
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. Ignoring...", Tracer.Level.DEBUG);
                    return;
                }
                default: {
                    if (!this.tracer.debug) return;
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. Ignoring...", Tracer.Level.DEBUG);
                    return;
                }
            }
        }
        finally {
            packet.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void handlePrimaryHello(StoreReplicatorMember source, PktPacket packet) {
        if (this.checked && this.multiplexer.getDispatcherThread() != Thread.currentThread()) {
            throw new InternalError("'HandlePrimaryHello' dispatched by a thread different from the multiplexer dispatcher thread.");
        }
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'HandlePrimaryHello' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        PktBodyOdsPrimaryHello primaryHello = (PktBodyOdsPrimaryHello)packet.getBody();
        long lastCommittedTransactionId = primaryHello.getLastCommittedTransactionId();
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(E) HandlePrimaryHello (" + (Object)((Object)this.state) + ") {" + source + ", " + lastCommittedTransactionId + "}", Tracer.Level.VERBOSE);
        }
        try {
            if (this.state == State.INIT || this.state == State.NORMAL) {
                this.binding.onMemberHandshakePrimaryHello(source, lastCommittedTransactionId);
                return;
            }
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. Ignoring...", Tracer.Level.VERBOSE);
                    return;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. Ignoring...", Tracer.Level.VERBOSE);
                    return;
                }
            }
        }
        finally {
            packet.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void handleBackupHello(StoreReplicatorMember source, PktPacket packet) {
        if (this.checked && this.multiplexer.getDispatcherThread() != Thread.currentThread()) {
            throw new InternalError("'HandleBackupHello' dispatched by a thread different from the multiplexer dispatcher thread.");
        }
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'HandleBackupHello' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        PktBodyOdsBackupHello backupHello = (PktBodyOdsBackupHello)packet.getBody();
        long lastCommittedTransactionId = backupHello.getLastCommittedTransactionId();
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(E) HandleBackupHello (" + (Object)((Object)this.state) + ") {" + source + ", " + lastCommittedTransactionId + "}", Tracer.Level.VERBOSE);
        }
        try {
            if (this.state == State.INIT || this.state == State.NORMAL) {
                this.binding.onMemberHandshakeBackupHello(source, lastCommittedTransactionId);
                return;
            }
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. Ignoring...", Tracer.Level.VERBOSE);
                    return;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. Ignoring...", Tracer.Level.VERBOSE);
                    return;
                }
            }
        }
        finally {
            packet.dispose();
        }
    }

    final void handleFailure(Exception e) {
        if (this.checked && this.multiplexer.getDispatcherThread() != Thread.currentThread()) {
            throw new InternalError("'HandleFailure' dispatched by a thread different from the multiplexer dispatcher thread.");
        }
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'HandleFailure' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(E) HandleFailure (" + (Object)((Object)this.state) + ") {" + e + "}", Tracer.Level.VERBOSE);
        }
        if (this.state == State.INIT) {
            this.initializer.complete(e);
            this.setState(State.FAILED);
        } else if (this.state == State.NORMAL) {
            Iterator<StoreCommitCompletionStatus> iterator = this.outboundCommits.completeAndClear(e).iterator();
            while (iterator.hasNext()) {
                this.binding.onCommitComplete(iterator.next());
            }
            this.setState(State.FAILED);
            this.binding.onFail(e);
        } else {
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. ignoring...", Tracer.Level.VERBOSE);
                    break;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. ignoring...", Tracer.Level.VERBOSE);
                }
            }
        }
    }

    final void handleClose(boolean dispatchMemberDownEvents) {
        if (this.checked && this.multiplexer.getDispatcherThread() != Thread.currentThread()) {
            throw new InternalError("'HandleClose' dispatched by a thread different from the multiplexer dispatcher thread.");
        }
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'HandleClose' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(E) HandleClose (" + (Object)((Object)this.state) + ") {" + dispatchMemberDownEvents + "}", Tracer.Level.VERBOSE);
        }
        if (this.state == State.INIT || this.state == State.NORMAL || this.state == State.FAILED) {
            this.closeMemberTable(dispatchMemberDownEvents);
            this.setState(State.CLOSED);
        } else {
            switch (this.state) {
                default: 
            }
            this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. ignoring...", Tracer.Level.VERBOSE);
        }
    }

    final StoreReplicatorStats getStats() {
        return this.stats;
    }

    final StoreReplicatorMember getMember() {
        return this.self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void open() throws OdsException {
        block21: {
            try {
                if (this.state == null) {
                    this.stats = new StoreReplicatorStats(this, this.binding.getMemberName(), "nv.ods.replicator.stats.interval");
                    this.multiplexer = new StoreReplicatorEventMultiplexer(this);
                    if (this.notificationHandler != null) {
                        this.dispatchOperationNotification(StoreReplicatorOperation.Open, null);
                    }
                    this.setState(State.INIT);
                    if (this.instructionTracer.verbose) {
                        this.instructionTracer.log(this.getTracePrefix() + "(A) Open (" + (Object)((Object)this.state) + ")", Tracer.Level.VERBOSE);
                    }
                    try {
                        this.openEventMultiplexer();
                        this.createDiscovery();
                        List<UtlAddressDescriptor> connectorDescriptors = this.openLinkAcceptor();
                        this.openDiscovery(connectorDescriptors);
                        this.tracer.log(this.getTracePrefix() + "waiting for member initialization to complete (interval=" + this.initWaitTime + "ms)...", Tracer.Level.VERBOSE);
                        this.multiplexer.scheduleMemberTableOpenWaitCompletion(this.initWaitTime);
                        Exception status = null;
                        try {
                            status = this.initializer.waitForCompletion();
                        }
                        finally {
                            block20: {
                                try {
                                    if (this.multiplexer.getState() == StoreReplicatorEventMultiplexer.State.Open) {
                                        this.multiplexer.unscheduleMemberTableOpenWaitCompletion();
                                    }
                                }
                                catch (Exception e) {
                                    if (status != null) break block20;
                                    throw e;
                                }
                            }
                        }
                        if (this.instructionTracer.verbose) {
                            this.instructionTracer.log(this.getTracePrefix() + "(A) Open (continued...) (" + (Object)((Object)this.state) + ")", Tracer.Level.VERBOSE);
                        }
                        if (status != null) {
                            throw status;
                        }
                        this.tracer.log(this.getTracePrefix() + "initialization successfully completed (primary is '" + (this.primary == this.self ? "self" : this.primary) + "').", Tracer.Level.VERBOSE);
                        this.tracer.log(this.getTracePrefix() + "store successfully opened.", Tracer.Level.VERBOSE);
                        break block21;
                    }
                    catch (Exception e) {
                        try {
                            this.close(true);
                        }
                        catch (Exception e1) {
                            this.tracer.log(this.getTracePrefix() + "failure while closing binding on open failure [open exception=" + e.toString() + ", close exception=" + e1.toString() + "]", Tracer.Level.WARNING);
                        }
                        throw e instanceof OdsException ? (OdsException)e : new OdsException(e);
                    }
                }
                throw new IllegalStateException("illegal state '" + (Object)((Object)this.state) + "'");
            }
            catch (Throwable e) {
                throw e instanceof OdsException ? (OdsException)e : new OdsException(e);
            }
        }
    }

    final void processMemberFound(IDiscoveryEntity entity) {
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'ProcessMemberFound' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.notificationHandler != null) {
            this.dispatchOperationNotification(StoreReplicatorOperation.ProcessMemberFound, entity);
        }
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(A) ProcessMemberFound (" + (Object)((Object)this.state) + ") {" + entity.hashCode() + ", " + entity.getType() + "', " + entity.getName() + ", " + ((UtlAddressDescriptor)entity.getAddressDescriptors().get(0)).toFullString() + "}.", Tracer.Level.VERBOSE);
        }
        if (this.state == State.INIT || this.state == State.NORMAL) {
            if (this.members.get(entity) == null) {
                this.tracer.log(this.getTracePrefix() + "added entity as member '" + this.entityNameToMemberName(entity.getName()) + "'.", Tracer.Level.VERBOSE);
                StoreReplicatorMember member = new StoreReplicatorMember(this, this.entityNameToMemberName(entity.getName()), entity);
                this.members.put(entity, member);
                if (this.shouldConnectToMember(entity)) {
                    this.binding.onMemberUp(member);
                    ILnkPeerEndpoint pep = null;
                    try {
                        UtlAddressDescriptor connectDescriptor = (UtlAddressDescriptor)entity.getAddressDescriptors().get(0);
                        connectDescriptor = UtlAddressDescriptor.parse((String)connectDescriptor.toShortString(), this.linkParams);
                        this.tracer.log(this.getTracePrefix() + "connecting to store member " + this.entityNameToMemberName(entity.getName()) + " using '" + connectDescriptor.toFullString() + "'", Tracer.Level.INFO);
                        pep = this.connectToMember(connectDescriptor.toFullString());
                    }
                    catch (Exception e) {
                        this.tracer.log(this.getTracePrefix() + "failure in connecting to store member [" + e.toString() + "].", Tracer.Level.SEVERE);
                        this.processMemberLost(entity);
                        return;
                    }
                    this.tracer.log(this.getTracePrefix() + "attaching member to established link...", Tracer.Level.VERBOSE);
                    pep.setAttachment((Object)member);
                    member.setLink(pep);
                    try {
                        this.tracer.log(this.getTracePrefix() + "adding link to multiplexer...", Tracer.Level.VERBOSE);
                        this.multiplexer.addReplicatorLink(pep);
                    }
                    catch (Exception e) {
                        this.tracer.log(this.getTracePrefix() + "failure in adding link to multiplexer [" + e.toString() + "].", Tracer.Level.SEVERE);
                        this.processMemberLost(entity);
                        return;
                    }
                }
                this.tracer.log(this.getTracePrefix() + "member will connect to me. nothing else to be done.", Tracer.Level.VERBOSE);
            } else {
                this.tracer.log(this.getTracePrefix() + "member already in table. nothing to be done.", Tracer.Level.VERBOSE);
            }
        } else {
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. ignoring...", Tracer.Level.VERBOSE);
                    break;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. ignoring...", Tracer.Level.VERBOSE);
                }
            }
        }
    }

    final void processMemberConnect(ILnkPeerEndpoint pep, String memberName, IStoreBinding.Role memberRole) {
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'ProcessMemberConnect' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.notificationHandler != null) {
            this.dispatchOperationNotification(StoreReplicatorOperation.ProcessMemberConnect, memberName);
        }
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(A) ProcessMemberConnect (State='" + (Object)((Object)this.state) + "') Args {member='" + memberName + "', role='" + (Object)((Object)memberRole) + "'}.", Tracer.Level.VERBOSE);
        }
        if (this.state == State.INIT || this.state == State.NORMAL) {
            this.tracer.log(this.getTracePrefix() + "finding member entity....", Tracer.Level.VERBOSE);
            IDiscoveryEntity entity = this.discoveryCache.get("ODSStoreMember", this.memberNameToEntityName(memberName));
            if (entity != null) {
                if (this.checked && this.shouldConnectToMember(entity)) {
                    throw new InternalError("received a member connect from a member (name='" + memberName + "') whom we should be connecting to!");
                }
                this.tracer.log(this.getTracePrefix() + "finding member....", Tracer.Level.VERBOSE);
                StoreReplicatorMember member = this.members.get(entity);
                if (member == null) {
                    this.tracer.log(this.getTracePrefix() + "member not found. adding as member '" + this.entityNameToMemberName(entity.getName()) + "'...", Tracer.Level.VERBOSE);
                    member = new StoreReplicatorMember(this, this.entityNameToMemberName(entity.getName()), entity);
                    this.members.put(entity, member);
                }
                if (member.getState() != StoreReplicatorMember.State.Init) {
                    throw new InternalError("member '" + member + "' state in member connect processing is not in Init state (state=" + (Object)((Object)member.getState()) + ")!");
                }
                if (pep.getAttachment() != null) {
                    throw new InternalError("link on which a member connect was received (member='" + member + "') is already associated with another member!");
                }
                this.binding.onMemberUp(member);
                this.tracer.log(this.getTracePrefix() + "attaching link to member....", Tracer.Level.VERBOSE);
                pep.setAttachment((Object)member);
                member.setLink(pep);
                this.tracer.log(this.getTracePrefix() + "opening member...", Tracer.Level.VERBOSE);
                try {
                    member.open(false);
                }
                catch (Exception e) {
                    this.tracer.log(this.getTracePrefix() + "failure in opening member [" + e.toString() + "].", Tracer.Level.SEVERE);
                    this.processMemberLost(entity);
                    return;
                }
                this.processRoleInMemberConnect(member, memberRole);
            } else {
                this.tracer.log(this.getTracePrefix() + "failure in processing member connect [connecting member discovery entity not found]. closing link...", Tracer.Level.WARNING);
                this.multiplexer.closeLink(pep);
            }
        } else {
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. ignoring...", Tracer.Level.VERBOSE);
                    break;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. ignoring...", Tracer.Level.VERBOSE);
                }
            }
        }
    }

    final void processMemberConnectReply(IStoreMember member, IStoreBinding.Role memberRole) {
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'ProcessMemberConnectReply' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.notificationHandler != null) {
            this.dispatchOperationNotification(StoreReplicatorOperation.ProcessMemberConnectReply, member);
        }
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(A) ProcessMemberConnectReply (" + (Object)((Object)this.state) + ") {" + member + ", " + (Object)((Object)memberRole) + "}.", Tracer.Level.VERBOSE);
        }
        if (this.state == State.INIT || this.state == State.NORMAL) {
            if (this.processRoleInMemberConnect((StoreReplicatorMember)member, memberRole)) {
                ((StoreReplicatorMember)member).setOpen();
            }
        } else {
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. ignoring...", Tracer.Level.VERBOSE);
                    break;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. ignoring...", Tracer.Level.VERBOSE);
                }
            }
        }
    }

    final void startMemberHandshake(IStoreMember member) {
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'StartMemberHandshake' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.notificationHandler != null) {
            this.dispatchOperationNotification(StoreReplicatorOperation.StartMemberHandshake, member);
        }
        StoreReplicatorMember dest = (StoreReplicatorMember)member;
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(A) StartMemberHandshake (" + (Object)((Object)this.state) + ") {" + member + "}.", Tracer.Level.VERBOSE);
        }
        try {
            if (this.state == State.INIT || this.state == State.NORMAL) {
                dest.sendPrimaryHello(this.binding.getLastCommittedTransactionId());
            } else {
                switch (this.state) {
                    case FAILED: {
                        this.tracer.log(this.getTracePrefix() + "store binding has failed. ignoring...", Tracer.Level.VERBOSE);
                        break;
                    }
                    default: {
                        this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. ignoring...", Tracer.Level.VERBOSE);
                    }
                }
            }
        }
        catch (EStoreReplicatorMemberLinkException e) {
            this.tracer.log(this.getTracePrefix() + "failure in sending primary hello [cause=" + (e.getMessage() != null ? e.getMessage() : e.toString()) + "] to member '" + dest.getName() + "'. failing member...", Tracer.Level.SEVERE);
            dest.fail(e);
        }
    }

    final void processMemberHandshakePrimaryHello(IStoreMember member, long lastCommittedTransactionId) {
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'ProcessMemberHandshakePrimaryHello' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.notificationHandler != null) {
            this.dispatchOperationNotification(StoreReplicatorOperation.ProcessMemberHandshakePrimaryHello, member);
        }
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(A) ProcessMemberHandshakePrimaryHello (" + (Object)((Object)this.state) + ") {" + member + ", " + lastCommittedTransactionId + "}", Tracer.Level.VERBOSE);
        }
        if (this.state == State.INIT || this.state == State.NORMAL) {
            StoreReplicatorMember source = (StoreReplicatorMember)member;
            if (this.primary != null && this.primary != source) {
                throw new OdsFatalException("received primary hello from wrong primary (exp=" + this.primary + ", actual=" + source + ")");
            }
            if (this.primary == null) {
                this.setPrimary(source);
            }
            try {
                this.tracer.log(this.getTracePrefix() + "sending backup hello...", Tracer.Level.VERBOSE);
                source.sendBackupHello(this.binding.getLastCommittedTransactionId());
            }
            catch (EStoreReplicatorMemberLinkException e) {
                this.tracer.log(this.getTracePrefix() + "failure in sending backup hello [cause=" + (e.getMessage() != null ? e.getMessage() : e.toString()) + "] to member '" + source.getName() + "'. failing member...", Tracer.Level.SEVERE);
                source.fail(e);
            }
        } else {
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. ignoring...", Tracer.Level.VERBOSE);
                    break;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. ignoring...", Tracer.Level.VERBOSE);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void processMemberHandshakeBackupHello(IStoreMember member, long lastCommittedTransactionId) {
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'ProcessMemberHandshakeBackupHello' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.notificationHandler != null) {
            this.dispatchOperationNotification(StoreReplicatorOperation.ProcessMemberHandshakeBackupHello, member);
        }
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(A) ProcessMemberHandshakeBackupHello (" + (Object)((Object)this.state) + ") {" + member + ", " + lastCommittedTransactionId + "}", Tracer.Level.VERBOSE);
        }
        if (this.state == State.INIT || this.state == State.NORMAL) {
            if (lastCommittedTransactionId != 0L) throw new OdsFatalException("multiple backups in cluster is currently not supported");
            this.tracer.log(this.getTracePrefix() + "backup in INIT state. scheduling backup initialization...", Tracer.Level.VERBOSE);
            try {
                this.multiplexer.scheduleMemberInitReady(member);
                return;
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.getTracePrefix() + "failed to schedule member init processing for member '" + member.getName() + "' [" + e.toString() + "]...").append("\n");
                sb.append("Stack Trace:").append("\n");
                sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                sb.append("Failing member...").append("\n");
                this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                member.fail(e);
            }
            return;
        } else {
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. ignoring...", Tracer.Level.VERBOSE);
                    return;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. ignoring...", Tracer.Level.VERBOSE);
                }
            }
        }
    }

    final boolean startMemberInit(IStoreMember member, PktBuffer persisterMetadata) throws EStoreReplicatorMemberLinkException {
        if (this.state == State.CLOSED) {
            throw new InternalError("received StartMemberInit for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.notificationHandler != null) {
            this.dispatchOperationNotification(StoreReplicatorOperation.StartMemberInit, member);
        }
        StoreReplicatorMember dest = (StoreReplicatorMember)member;
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(A) StartMemberInit (" + (Object)((Object)this.state) + ") {" + member + "}", Tracer.Level.VERBOSE);
        }
        try {
            if (this.state == State.INIT || this.state == State.NORMAL) {
                dest.sendBackupInitStart(persisterMetadata);
                ++this.stats.numPacketsSent;
                this.tracer.log(this.getTracePrefix() + "member initialization started successfully.", Tracer.Level.VERBOSE);
                return true;
            }
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. ignoring...", Tracer.Level.VERBOSE);
                    break;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. ignoring...", Tracer.Level.VERBOSE);
                    break;
                }
            }
        }
        catch (EStoreReplicatorMemberLinkException e) {
            this.tracer.log(this.getTracePrefix() + "failure in sending member init start [cause=" + (e.getMessage() != null ? e.getMessage() : e.toString()) + "] to member '" + dest.getName() + "'. failing member...", Tracer.Level.SEVERE);
            throw e;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final boolean sendMemberInitEntry(IStoreMember member, StoreCommitEntry commitEntry) throws EStoreReplicatorMemberLinkException {
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'SendMemberInitEntry' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.notificationHandler != null) {
            this.dispatchOperationNotification(StoreReplicatorOperation.SendMemberInitEntry, commitEntry);
        }
        StoreReplicatorMember dest = (StoreReplicatorMember)member;
        if (this.instructionTracer.debug) {
            this.instructionTracer.log(this.getTracePrefix() + "(A) SendMemberInitEntry (" + (Object)((Object)this.state) + ") {" + member + "}", Tracer.Level.DEBUG);
        }
        try {
            if (this.state == State.INIT || this.state == State.NORMAL) {
                PktPacket packet = commitEntry.serializedObject;
                packet.getHeader().getODSSubheader().setFlagCommitEntryInInit(true);
                try {
                    dest.sendCommitEntry(packet, 0);
                    ++this.stats.numPacketsSent;
                    if (this.tracer.debug) {
                        this.tracer.log(this.getTracePrefix() + "sent initialization entry to member.", Tracer.Level.DEBUG);
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    packet.dispose();
                }
            }
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. ignoring...", Tracer.Level.VERBOSE);
                    return false;
                }
            }
            this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. ignoring...", Tracer.Level.VERBOSE);
            return false;
        }
        catch (EStoreReplicatorMemberLinkException e) {
            this.tracer.log(this.getTracePrefix() + "failure in sending member init entry [cause=" + (e.getMessage() != null ? e.getMessage() : e.toString()) + "] to member '" + dest.getName() + "'. failing member...", Tracer.Level.SEVERE);
            throw e;
        }
    }

    final void completeMemberInit(IStoreMember member, long transactionId) throws EStoreReplicatorMemberLinkException {
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'CompleteMemberInit' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.notificationHandler != null) {
            this.dispatchOperationNotification(StoreReplicatorOperation.CompleteMemberInit, member);
        }
        StoreReplicatorMember dest = (StoreReplicatorMember)member;
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(A) CompleteMemberInit (" + (Object)((Object)this.state) + ") {" + member + ", " + transactionId + "}", Tracer.Level.VERBOSE);
        }
        try {
            if (this.state == State.INIT || this.state == State.NORMAL) {
                dest.sendBackupInitEnd(transactionId);
                dest.setReady();
                ++this.stats.numPacketsSent;
                this.tracer.log(this.getTracePrefix() + "member initialization completed successfully.", Tracer.Level.VERBOSE);
            } else {
                switch (this.state) {
                    case FAILED: {
                        this.tracer.log(this.getTracePrefix() + "store binding has failed. Ignoring...", Tracer.Level.VERBOSE);
                        break;
                    }
                    default: {
                        this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. Ignoring...", Tracer.Level.VERBOSE);
                    }
                }
            }
        }
        catch (EStoreReplicatorMemberLinkException e) {
            this.tracer.log(this.getTracePrefix() + "failure in sending member init complete [cause=" + (e.getMessage() != null ? e.getMessage() : e.toString()) + "] to member '" + dest.getName() + "'. failing member...", Tracer.Level.SEVERE);
            throw e;
        }
    }

    final void processMemberTableOpenWaitCompletion() {
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'ProcessMemberTableOpenWaitCompletion' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.notificationHandler != null) {
            this.dispatchOperationNotification(StoreReplicatorOperation.ProcessMemberTableOpenWaitCompletion, null);
        }
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(A) ProcessMemberTableOpenWaitCompletion (" + (Object)((Object)this.state) + ") {}.", Tracer.Level.VERBOSE);
        }
        if (this.state == State.INIT) {
            if (!this.initializer.isComplete()) {
                if (this.primary == null) {
                    int initMemberCount = this.getInitMemberCount();
                    if (initMemberCount == 0) {
                        this.tracer.log(this.getTracePrefix() + "all members (count=" + this.members.size() + ") have stabilized.", Tracer.Level.VERBOSE);
                        this.doPrimaryElect();
                    } else {
                        this.tracer.log(this.getTracePrefix() + "" + initMemberCount + " members have not yet stabilized. Continuing to wait for " + this.initWaitExtensionUnit + "ms...", Tracer.Level.VERBOSE);
                        try {
                            this.multiplexer.scheduleMemberTableOpenWaitCompletion(this.initWaitExtensionUnit);
                        }
                        catch (Exception e) {
                            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
                        }
                    }
                } else {
                    this.tracer.log(this.getTracePrefix() + "primary '" + this.primary + "' has already been elected. initialization is complete.", Tracer.Level.VERBOSE);
                }
            } else {
                this.tracer.log(this.getTracePrefix() + "initialization is already complete.", Tracer.Level.VERBOSE);
            }
        } else {
            switch (this.state) {
                case NORMAL: {
                    this.tracer.log(this.getTracePrefix() + "store binding initialization already complete. Ignoring...", Tracer.Level.VERBOSE);
                    break;
                }
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. ignoring...", Tracer.Level.VERBOSE);
                    break;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. ignoring...", Tracer.Level.VERBOSE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean sendCommitEntry(StoreCommitEntry commitEntry, IStoreCommitCompletionStatus completionStatus, long postSerializeTs) {
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'SendCommitEntry' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.notificationHandler != null) {
            if (commitEntry.commitStart) {
                this.dispatchOperationNotification(StoreReplicatorOperation.CommitStart, null);
            }
            switch (commitEntry.operation) {
                case Put: {
                    this.dispatchOperationNotification(StoreReplicatorOperation.CommitEntryPut, commitEntry);
                    break;
                }
                case Update: {
                    this.dispatchOperationNotification(StoreReplicatorOperation.CommitEntryUpdate, commitEntry);
                    break;
                }
                case Remove: {
                    this.dispatchOperationNotification(StoreReplicatorOperation.CommitEntryRemove, commitEntry);
                    break;
                }
                case Send: {
                    this.dispatchOperationNotification(StoreReplicatorOperation.CommitEntrySend, commitEntry);
                    break;
                }
                default: {
                    throw new InternalError("unknown store operation '" + (Object)((Object)commitEntry.operation) + "'");
                }
            }
            if (commitEntry.commitEnd) {
                this.dispatchOperationNotification(StoreReplicatorOperation.CommitEnd, null);
            }
        }
        if (this.instructionTracer.debug) {
            this.instructionTracer.log(this.getTracePrefix() + "(A) SendCommitEntry (State='" + (Object)((Object)this.state) + "') Args {transactionId=" + commitEntry.transactionId + "}", Tracer.Level.DEBUG);
        }
        if (this.state == State.NORMAL) {
            boolean solicitAck;
            StoreCommitCompletionStatus completionStatusImpl = (StoreCommitCompletionStatus)completionStatus;
            boolean bl = solicitAck = completionStatusImpl != null;
            if (solicitAck && !commitEntry.commitEnd) {
                throw new InternalError("ack solicited on a commit entry that is not the last entry!");
            }
            try {
                if (this.members.size() > 0) {
                    if (solicitAck) {
                        this.outboundCommits.put(commitEntry.transactionId, completionStatusImpl);
                    }
                    if (solicitAck) {
                        commitEntry.serializedObject.getHeader().getODSSubheader().setFlagCommitAckRequired(true);
                    }
                    StoreReplicatorEventMultiplexer.MemberList memberList = this.multiplexer.getFreshReplicationMemberList();
                    ListIterator<Map.Entry<IDiscoveryEntity, StoreReplicatorMember>> iterator = this.members.fastEntryIterator();
                    int numMembersSentTo = 0;
                    while (iterator.hasNext()) {
                        StoreReplicatorMember member = iterator.next().getValue();
                        if (!member.isReady()) continue;
                        try {
                            if (solicitAck) {
                                completionStatusImpl.addMember(member);
                            }
                            memberList.members[numMembersSentTo++] = member;
                        }
                        catch (Exception e) {
                            throw new InternalError("failed to add member to completion status object [" + e.toString() + "]");
                        }
                    }
                    memberList.memberCount = numMembersSentTo;
                    this.multiplexer.sendCommitEntry(commitEntry, memberList, completionStatusImpl, postSerializeTs, this.binding.captureStoreLatencyStats ? this.binding.stats.s2w : null);
                    ++this.stats.numPacketsSent;
                    if (commitEntry.commitEnd) {
                        ++this.stats.numCommitsSent;
                    }
                    if (solicitAck && numMembersSentTo == 0) {
                        this.outboundCommits.remove(commitEntry.transactionId);
                        boolean bl2 = true;
                        return bl2;
                    }
                    boolean bl3 = solicitAck ? false : commitEntry.commitEnd;
                    return bl3;
                }
                boolean bl4 = commitEntry.commitEnd;
                return bl4;
            }
            finally {
                if (solicitAck) {
                    completionStatusImpl.closeMemberAddition();
                }
            }
        }
        switch (this.state) {
            case FAILED: {
                this.tracer.log(this.getTracePrefix() + "store binding has failed. ignoring...", Tracer.Level.VERBOSE);
                break;
            }
            default: {
                throw new IllegalStateException("send of commit entry requested in '" + (Object)((Object)this.state) + "' state");
            }
        }
        return true;
    }

    final void processMemberLost(IDiscoveryEntity entity) {
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'ProcessMemberLost' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.notificationHandler != null) {
            this.dispatchOperationNotification(StoreReplicatorOperation.ProcessMemberLost, entity);
        }
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(A) ProcessMemberLost (" + (Object)((Object)this.state) + ") {" + entity.hashCode() + ", " + entity.getType() + "', " + entity.getName() + "}.", Tracer.Level.VERBOSE);
        }
        if (this.state == State.INIT || this.state == State.NORMAL) {
            StoreReplicatorMember member = this.members.get(entity);
            if (member != null) {
                this.tracer.log(this.getTracePrefix() + "closing member...", Tracer.Level.VERBOSE);
                member.close();
                this.tracer.log(this.getTracePrefix() + "removing from table...", Tracer.Level.VERBOSE);
                this.members.remove(entity);
                this.tracer.log(this.getTracePrefix() + "removing from discovery cache.", Tracer.Level.VERBOSE);
                if (!this.discoveryCache.closed()) {
                    try {
                        this.discoveryCache.remove(entity);
                    }
                    catch (EDiscoveryJVMShuttingDownException e) {
                        this.tracer.log(this.getTracePrefix() + "...JVM is shutting down.", Tracer.Level.VERBOSE);
                    }
                } else {
                    this.tracer.log(this.getTracePrefix() + "...cache is closed.", Tracer.Level.VERBOSE);
                }
                Iterator<StoreCommitCompletionStatus> iterator = this.outboundCommits.setStatusAndRemoveCompleted(member, new Exception("member failed")).iterator();
                while (iterator.hasNext()) {
                    this.binding.onCommitComplete(iterator.next());
                }
                this.binding.onMemberDown(member);
                if (member == this.primary) {
                    this.tracer.log(this.getTracePrefix() + "primary is down.", Tracer.Level.VERBOSE);
                    this.primary = null;
                    if (this.state == State.INIT) {
                        this.tracer.log(this.getTracePrefix() + " primary went down during initialization. completing initialization with failure...", Tracer.Level.VERBOSE);
                        this.initializer.complete(new Exception("primary failed before initialization was complete"));
                    } else {
                        this.tracer.log(this.getTracePrefix() + "electing new primary...", Tracer.Level.VERBOSE);
                        this.doPrimaryElect();
                    }
                } else {
                    this.tracer.log(this.getTracePrefix() + "down member is not primary.", Tracer.Level.VERBOSE);
                }
            } else {
                this.tracer.log(this.getTracePrefix() + "entity is not present as a member. nothing to be done.", Tracer.Level.VERBOSE);
            }
        } else {
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. ignoring...", Tracer.Level.VERBOSE);
                    break;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. ignoring...", Tracer.Level.VERBOSE);
                }
            }
        }
    }

    final void fail(Exception e) {
        if (this.state == State.CLOSED) {
            throw new InternalError("received 'Fail' for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.notificationHandler != null) {
            this.dispatchOperationNotification(StoreReplicatorOperation.Fail, e);
        }
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(A) Fail (" + (Object)((Object)this.state) + ") {" + (e == null ? "null" : e.toString()) + "}.", Tracer.Level.VERBOSE);
        }
        if (this.state == State.INIT || this.state == State.NORMAL) {
            this.multiplexer.scheduleFail(e);
        } else {
            switch (this.state) {
                case FAILED: {
                    this.tracer.log(this.getTracePrefix() + "store binding has failed. ignoring...", Tracer.Level.VERBOSE);
                    break;
                }
                default: {
                    this.tracer.log(this.getTracePrefix() + "store binding is  '" + (Object)((Object)this.state) + "'. ignoring...", Tracer.Level.VERBOSE);
                }
            }
        }
    }

    final void close(int flags) {
        if (this.notificationHandler != null) {
            this.dispatchOperationNotification(StoreReplicatorOperation.Close, null);
        }
        if (this.instructionTracer.verbose) {
            this.instructionTracer.log(this.getTracePrefix() + "(A) Close (" + (Object)((Object)this.state) + ")", Tracer.Level.VERBOSE);
        }
        if (this.state != State.CLOSED) {
            if (this.outboundCommits != null) {
                this.tracer.log(this.getTracePrefix() + "completing incomplete commits....", Tracer.Level.VERBOSE);
                Set<StoreCommitCompletionStatus> completed = this.outboundCommits.completeAndClear(new Exception("binding closed by user"));
                this.tracer.log(this.getTracePrefix() + "..." + completed.size() + " commits.", Tracer.Level.VERBOSE);
                for (StoreCommitCompletionStatus status : completed) {
                    if ((flags & 1) != 0) continue;
                    this.binding.onCommitComplete(status);
                }
            }
            this.tracer.log(this.getTracePrefix() + "shutting down the binding....", Tracer.Level.VERBOSE);
            this.close(false);
            this.tracer.log(this.getTracePrefix() + "binding is closed.", Tracer.Level.VERBOSE);
        } else {
            this.tracer.log(this.getTracePrefix() + "binding is already closed.", Tracer.Level.VERBOSE);
        }
    }

    public final void onEvent(IDiscoveryCache cache, int type, Object data) {
        if (this.checked && this.multiplexer == null) {
            throw new InternalError("discovery cache event handler invoked but multiplexer not opened!");
        }
        if (this.state == State.CLOSED) {
            throw new InternalError("received event from discovery cache for processing in '" + (Object)((Object)this.state) + "' state!");
        }
        if (this.state == State.INIT || this.state == State.NORMAL) {
            switch (type) {
                case 0: {
                    DiscoveryCacheEvents.DiscoveryCacheAddEventData eventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)data;
                    if (this.instructionTracer.verbose) {
                        this.instructionTracer.log(this.getTracePrefix() + "(E) HandleEntityAdd (" + (Object)((Object)this.state) + ") {" + (eventData.oldEntity != null) + "}...", Tracer.Level.VERBOSE);
                    }
                    try {
                        if (eventData.oldEntity != null) {
                            if (this.notificationHandler != null) {
                                this.dispatchOperationNotification(StoreReplicatorOperation.HandleEntityRemove, eventData.oldEntity);
                            }
                            this.multiplexer.scheduleEntityDown(eventData.oldEntity);
                        }
                        if (this.notificationHandler != null) {
                            this.dispatchOperationNotification(StoreReplicatorOperation.HandleEntityAdd, eventData.newEntity);
                        }
                        this.multiplexer.scheduleEntityUp(eventData.newEntity);
                    }
                    catch (Exception e) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(this.getTracePrefix() + "failure in processing discovery cache entity ADD event [" + e.toString() + "]...").append("\n");
                        sb.append("Stack Trace:").append("\n");
                        sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                        this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                    }
                    break;
                }
                case 1: {
                    if (this.instructionTracer.verbose) {
                        this.instructionTracer.log(this.getTracePrefix() + "(E) HandleEntityRemove (" + (Object)((Object)this.state) + ")...", Tracer.Level.VERBOSE);
                    }
                    DiscoveryCacheEvents.DiscoveryCacheRemoveEventData eventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)data;
                    if (eventData.cause == DiscoveryCacheEvents.EntityRemovalCause.ExplicitLocal) break;
                    try {
                        if (this.notificationHandler != null) {
                            this.dispatchOperationNotification(StoreReplicatorOperation.HandleEntityRemove, eventData.removedEntity);
                        }
                        this.multiplexer.scheduleEntityDown(eventData.removedEntity);
                        break;
                    }
                    catch (Exception e) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(this.getTracePrefix() + "failure in processing discovery cache entity REMOVE event [" + e.toString() + "]...").append("\n");
                        sb.append("Stack Trace:").append("\n");
                        sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                        this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                    }
                }
            }
        }
    }

    private static final class Initializer {
        private boolean complete;
        private Exception completionStatus;

        private Initializer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void complete(Exception status) {
            Initializer initializer = this;
            synchronized (initializer) {
                this.completionStatus = status;
                this.complete = true;
                this.notifyAll();
            }
        }

        final boolean isComplete() {
            return this.complete;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Exception waitForCompletion() {
            Initializer initializer = this;
            synchronized (initializer) {
                while (!this.complete) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.completionStatus;
            }
        }
    }

    static enum State {
        INIT,
        NORMAL,
        FAILED,
        CLOSED;

    }
}

