/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.mon.util;

import com.neeve.lang.XIntLinkedHashMap;
import com.neeve.lang.XIterator;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.lang.XString;
import com.neeve.server.mon.SrvMonAdminClientStats;
import com.neeve.server.mon.SrvMonAppBusBindingStats;
import com.neeve.server.mon.SrvMonAppEngineStats;
import com.neeve.server.mon.SrvMonAppEventMultiplexerFeederQueueStats;
import com.neeve.server.mon.SrvMonAppEventMultiplexerStats;
import com.neeve.server.mon.SrvMonAppMessageLoggerStats;
import com.neeve.server.mon.SrvMonAppStats;
import com.neeve.server.mon.SrvMonAppStoreBindingICRSenderStats;
import com.neeve.server.mon.SrvMonAppStoreBindingPersisterStats;
import com.neeve.server.mon.SrvMonAppStoreBindingStats;
import com.neeve.server.mon.SrvMonDisruptorStats;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.SrvMonIntHistogram;
import com.neeve.server.mon.SrvMonIntSeries;
import com.neeve.server.mon.SrvMonLongHistogram;
import com.neeve.server.mon.SrvMonLongSeries;
import com.neeve.server.mon.SrvMonMsgTypeStats;
import com.neeve.server.mon.SrvMonPoolStats;
import com.neeve.server.mon.SrvMonSysDiskStats;
import com.neeve.server.mon.SrvMonSysGCCollectorStats;
import com.neeve.server.mon.SrvMonSysIndividualThreadStats;
import com.neeve.server.mon.SrvMonSysStats;
import com.neeve.server.mon.SrvMonUserCounterStat;
import com.neeve.server.mon.SrvMonUserGaugeStat;
import com.neeve.server.mon.SrvMonUserSeriesStat;
import com.neeve.server.mon.SrvMonUserStats;
import com.neeve.server.mon.util.SrvMonUtil;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlUnit;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public final class SrvMonHeartbeatTracer {
    private long startTime = -1L;
    private long stampTime = -1L;
    private final Pools pools = new Pools();
    private final Threads threads = new Threads();
    private final AdminClients adminClients = new AdminClients();
    private final Apps apps = new Apps();
    private MessageLoggerStats heartbeatLoggerStats;
    private static final long gb = 0x40000000L;
    private static final long mb = 0x100000L;
    private static final long kb = 1024L;
    private boolean filterAdminApps = true;
    private boolean traceAppStats = true;
    private boolean traceSysStats = true;
    private boolean traceThreadStats = true;
    private boolean traceAdminClientStats = true;
    private boolean traceUserStats = true;
    private boolean tracePoolStats = true;
    private static final long billion = 1000000000L;
    private static final long million = 1000000L;
    private static final long hunthou = 100000L;
    private static final long thou = 1000L;

    public final void setFilterAdminApps(boolean val) {
        this.filterAdminApps = val;
    }

    public final boolean getFilterAdminApps() {
        return this.filterAdminApps;
    }

    public final boolean isTraceAppStats() {
        return this.traceAppStats;
    }

    public final void setTraceAppStats(boolean traceAppStats) {
        this.traceAppStats = traceAppStats;
    }

    public final boolean isTraceSysStats() {
        return this.traceSysStats;
    }

    public final void setTraceSysStats(boolean traceSysStats) {
        this.traceSysStats = traceSysStats;
    }

    public final boolean isTraceThreadStats() {
        return this.traceThreadStats;
    }

    public final void setTraceThreadStats(boolean traceThreadStats) {
        this.traceThreadStats = traceThreadStats;
    }

    public final boolean isTraceUserStats() {
        return this.traceUserStats;
    }

    public final void setTraceUserStats(boolean traceUserStats) {
        this.traceUserStats = traceUserStats;
    }

    public final boolean isTracePoolStats() {
        return this.tracePoolStats;
    }

    public final void setTracePoolStats(boolean tracePoolStats) {
        this.tracePoolStats = tracePoolStats;
    }

    public final boolean isTraceAdminClientStats() {
        return this.traceAdminClientStats;
    }

    public final void setTraceAdminClientStats(boolean traceAdminClientStats) {
        this.traceAdminClientStats = traceAdminClientStats;
    }

    private static final String memToStr(long val) {
        if (val >= 0x40000000L) {
            return String.format("%.1f", Float.valueOf((float)val / 1.0737418E9f)) + "G";
        }
        if (val >= 0x100000L) {
            return String.format("%d", val / 0x100000L) + "M";
        }
        return String.format("%d", val / 1024L) + "K";
    }

    private static final String counterToStr(long val) {
        if (val >= 1000000000L) {
            return String.format("%.1f", (double)val / 1.0E9) + "B";
        }
        if (val >= 1000000L) {
            return String.format("%.1f", (double)val / 1000000.0) + "M";
        }
        if (val >= 100000L) {
            return String.format("%d", val / 1000L) + "K";
        }
        return String.format("%d", val);
    }

    private static final void formatSeriesForPrint(String prefix, String name, SrvMonIntSeries timings, StringBuilder sb) {
        if (null != timings && timings.getLastSequenceNumber() > 0L) {
            sb.append(prefix).append("[").append(name).append("(sno=");
            sb.append(timings.getLastSequenceNumber()).append(", ");
            sb.append("#points=").append(timings.getNumDataPoints()).append(", ");
            sb.append("#skipped=").append(timings.getSkippedDatapoints()).append(")]\n");
            SrvMonHeartbeatTracer.formatHistogramForPrint(prefix + "...", name + " (interval)", timings.getIntervalStats(), sb);
            SrvMonHeartbeatTracer.formatHistogramForPrint(prefix + "...", name + " ( running)", timings.getRunningStats(), sb);
        }
    }

    private static final void formatHistogramForPrint(String prefix, String seriesName, SrvMonIntHistogram histo, StringBuilder sb) {
        sb.append(prefix).append("[").append(String.format("%5s", seriesName)).append("]").append(" [");
        if (null != histo) {
            sb.append("sample=").append(histo.getSampleSize()).append(", ");
            sb.append("min=").append(histo.getMinimum()).append(" ");
            sb.append("max=").append(histo.getMaximum()).append(" ");
            sb.append("mean=").append(histo.getMean()).append(" ");
            sb.append("median=").append(histo.getMedian()).append(" ");
            sb.append("75%ile=").append(histo.getPct75()).append(" ");
            sb.append("90%ile=").append(histo.getPct90()).append(" ");
            sb.append("99%ile=").append(histo.getPct99()).append(" ");
            sb.append("99.9%ile=").append(histo.getPct999()).append(" ");
            sb.append("99.99%ile=").append(histo.getPct9999());
        }
        sb.append("]").append("\n");
    }

    private static final void formatSeriesForPrint(String prefix, String name, SrvMonLongSeries timings, StringBuilder sb) {
        if (null != timings && timings.getLastSequenceNumber() > 0L) {
            sb.append(prefix).append("[").append(name).append("(sno=");
            sb.append(timings.getLastSequenceNumber()).append(", ");
            sb.append("#points=").append(timings.getNumDataPoints()).append(", ");
            sb.append("#skipped=").append(timings.getSkippedDatapoints()).append(")]\n");
            SrvMonHeartbeatTracer.formatHistogramForPrint(prefix + "...", name + " (interval)", timings.getIntervalStats(), sb);
            SrvMonHeartbeatTracer.formatHistogramForPrint(prefix + "...", name + " ( running)", timings.getRunningStats(), sb);
        }
    }

    private static final void formatHistogramForPrint(String prefix, String seriesName, SrvMonLongHistogram histo, StringBuilder sb) {
        sb.append(prefix).append("[").append(String.format("%5s", seriesName)).append("]").append(" [");
        if (null != histo) {
            sb.append("sample=").append(histo.getSampleSize()).append(", ");
            sb.append("min=").append(histo.getMinimum()).append(" ");
            sb.append("max=").append(histo.getMaximum()).append(" ");
            sb.append("mean=").append(histo.getMean()).append(" ");
            sb.append("median=").append(histo.getMedian()).append(" ");
            sb.append("75%ile=").append(histo.getPct75()).append(" ");
            sb.append("90%ile=").append(histo.getPct90()).append(" ");
            sb.append("99%ile=").append(histo.getPct99()).append(" ");
            sb.append("99.9%ile=").append(histo.getPct999()).append(" ");
            sb.append("99.99%ile=").append(histo.getPct9999());
        }
        sb.append("]").append("\n");
    }

    public final void printStats(SrvMonHeartbeatMessage srvMessage, String appName, Apps.EntityType entityType, String entityName, StringBuilder sb) {
        block11: {
            XIterator<SrvMonAppStats> appStatsIt;
            block10: {
                long lastHeartbeat = this.stampTime;
                this.stampTime = srvMessage.getCollectionStartWallTime();
                if (this.startTime == -1L) {
                    this.startTime = this.stampTime;
                }
                if (this.traceSysStats) {
                    sb.append("\n");
                    sb.append("[System Stats]").append("\n");
                    SrvMonSysStats sysStats = srvMessage.getSysStats();
                    Sys.formatForPrint(srvMessage.getCollectionStartWallTime(), srvMessage.getServerName(), srvMessage.getServerPid(), srvMessage.getAppsInfoEmptyIfNull().length, sysStats, srvMessage.getCollectionEndTime() - srvMessage.getCollectionStartTime(), sb);
                    if (srvMessage.hasHeartbeatLoggerStats()) {
                        if (this.heartbeatLoggerStats == null) {
                            this.heartbeatLoggerStats = new MessageLoggerStats("XVM Heartbeat Logger", srvMessage.getHeartbeatLoggerStats());
                        }
                        this.heartbeatLoggerStats.stamp(srvMessage.getHeartbeatLoggerStats());
                        if (lastHeartbeat > 0L) {
                            sb.append("\n");
                            this.heartbeatLoggerStats.formatForPrint(this.stampTime - lastHeartbeat, this.stampTime - this.startTime, sb);
                        }
                    }
                }
                if (this.traceThreadStats) {
                    sb.append("\n");
                    sb.append("[Thread Stats]").append("\n");
                    this.threads.formatForPrint(srvMessage.getSysStats(), sb);
                }
                if (this.tracePoolStats) {
                    sb.append("[Pool Stats]").append("\n");
                    this.pools.formatForPrint(srvMessage.getPoolStatsIterator(), sb);
                }
                if (this.traceAdminClientStats) {
                    sb.append("[AdminClient Stats]").append("\n");
                    this.adminClients.formatForPrint(srvMessage.getAdminClientStatsIterator(), sb);
                }
                if (!this.traceAppStats) break block10;
                sb.append("\n");
                appStatsIt = srvMessage.getAppsStatsIterator();
                while (appStatsIt.hasNext()) {
                    SrvMonAppStats appStats = (SrvMonAppStats)appStatsIt.next();
                    if (this.filterAdminApps && "admin".equals(appStats.getAppName()) || appName != null && !appName.equalsIgnoreCase(appStats.getAppName())) continue;
                    this.apps.formatForPrint(entityType, entityName, appStats, srvMessage.getCollectionStartWallTime(), sb);
                }
                break block11;
            }
            if (!this.traceUserStats) break block11;
            sb.append("\n");
            appStatsIt = srvMessage.getAppsStatsIterator();
            while (appStatsIt.hasNext()) {
                SrvMonAppStats appStats = (SrvMonAppStats)appStatsIt.next();
                if (this.filterAdminApps && "admin".equals(appStats.getAppName()) || appName != null && !appName.equalsIgnoreCase(appStats.getAppName())) continue;
                this.apps.formatForPrint(Apps.EntityType.UserStat, null, appStats, srvMessage.getCollectionStartWallTime(), sb);
            }
        }
    }

    public final void printStats(SrvMonHeartbeatMessage srvMessage, StringBuilder sb) {
        this.printStats(srvMessage, null, null, null, sb);
    }

    public static final class Apps {
        private final XLinkedHashMap<String, AppStats> appsStats = new XLinkedHashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final AppStats getAppStats(SrvMonAppStats stats, long collectionTime) {
            XLinkedHashMap<String, AppStats> xLinkedHashMap = this.appsStats;
            synchronized (xLinkedHashMap) {
                AppStats appStats = (AppStats)this.appsStats.get((Object)stats.getAppName());
                if (appStats == null) {
                    appStats = new AppStats(stats, collectionTime);
                    this.appsStats.put((Object)stats.getAppName(), (Object)appStats);
                }
                return appStats;
            }
        }

        public final StringBuilder formatForPrint(EntityType entityType, String entityName, SrvMonAppStats stats, long collectionTime, StringBuilder sb) {
            return this.getAppStats(stats, collectionTime).formatForPrint(entityType, entityName, stats, collectionTime, sb);
        }

        private final class AppStats {
            private final NumberFormat format;
            private EngineStats engineStats;
            private StoreBindingStats storeBindingStats;
            private Map<String, BusBindingStats> busBindingsStats = new HashMap<String, BusBindingStats>();
            private long startTime;
            private long stampTime;

            AppStats(SrvMonAppStats stats, long collectionTime) {
                this.format = NumberFormat.getInstance();
                this.format.setMaximumFractionDigits(2);
                this.stampTime = this.startTime = collectionTime;
                this.refresh(stats);
            }

            private final void refresh(SrvMonAppStats stats) {
            }

            private final void stamp(SrvMonAppStats stats) {
                SrvMonAppBusBindingStats[] monBusBindingsStats;
                if (stats.getEngineStats() != null) {
                    if (this.engineStats == null) {
                        this.engineStats = new EngineStats(stats.getEngineStats());
                    }
                    this.engineStats.stamp(stats.getEngineStats());
                }
                if (stats.getStoreBindingStats() != null) {
                    if (this.storeBindingStats == null) {
                        this.storeBindingStats = new StoreBindingStats(stats.getStoreBindingStats());
                    }
                    this.storeBindingStats.stamp(stats.getStoreBindingStats());
                }
                if ((monBusBindingsStats = stats.getBusBindingStats()) != null) {
                    for (SrvMonAppBusBindingStats monBusBindingStats : monBusBindingsStats) {
                        BusBindingStats busBindingStats = this.busBindingsStats.get(monBusBindingStats.getBusBindingName());
                        if (busBindingStats == null) {
                            busBindingStats = new BusBindingStats(monBusBindingStats);
                            this.busBindingsStats.put(monBusBindingStats.getBusBindingName(), busBindingStats);
                        }
                        busBindingStats.stamp(monBusBindingStats);
                    }
                }
                this.refresh(stats);
            }

            private final void formatForPrint(EntityType entityType, String entityName, SrvMonAppStats stats, long deltaTime, long totalTime, StringBuilder sb) {
                switch (entityType) {
                    case Engine: {
                        sb.append("[App (").append((CharSequence)stats.getAppNameUnsafe()).append(") Engine Stats]\n");
                        if (this.engineStats != null) {
                            this.engineStats.formatForPrint(deltaTime, totalTime, sb);
                            sb.append("\n");
                            SrvMonAppEventMultiplexerStats mxStats = stats.getEventMultiplexerStats();
                            sb.append("[Event Multiplexer (").append((CharSequence)stats.getAppNameUnsafe()).append(")]\n");
                            if (mxStats != null) {
                                this.formatForPrint(mxStats.getDisruptorStats(), sb);
                                sb.append("Schedule Queue (size=").append(mxStats.hasScheduleQueueSize() ? Integer.valueOf(mxStats.getScheduleQueueSize()) : "?").append(")").append("\n");
                                this.formatForPrint(mxStats, mxStats.getFeederQueueStats(), sb);
                            }
                            sb.append("\n");
                            if (this.engineStats.inboundLoggerStats != null) {
                                this.engineStats.inboundLoggerStats.formatForPrint(deltaTime, totalTime, sb);
                            } else {
                                sb.append("[").append("Inbound Message Logger").append("]").append("\n");
                                sb.append("<No Inbound Message Logger>").append("\n");
                            }
                            sb.append("\n");
                            if (this.engineStats.outboundLoggerStats != null) {
                                this.engineStats.outboundLoggerStats.formatForPrint(deltaTime, totalTime, sb);
                            } else {
                                sb.append("[").append("Outbound Message Logger").append("]").append("\n");
                                sb.append("<No Outbound Message Logger>").append("\n");
                            }
                            sb.append("\n");
                            if (this.engineStats.perTransactionStatsLoggerStats != null) {
                                this.engineStats.perTransactionStatsLoggerStats.formatForPrint(deltaTime, totalTime, sb);
                            } else {
                                sb.append("[").append("Per Transaction Stats Logger").append("]").append("\n");
                                sb.append("<No Per Transaction Stats Logger>").append("\n");
                            }
                            sb.append("\n");
                            this.formatForPrint(EntityType.UserStat, null, stats, deltaTime, totalTime, sb);
                            break;
                        }
                        sb.append("...no engine!\n");
                        break;
                    }
                    case EventMultiplexer: {
                        break;
                    }
                    case StoreBinding: {
                        sb.append("[App (").append((CharSequence)stats.getAppNameUnsafe()).append(") Store Binding Stats]").append("\n");
                        if (this.storeBindingStats != null) {
                            this.storeBindingStats.formatForPrint(entityType, stats.getStoreBindingStats(), deltaTime, totalTime, sb);
                            break;
                        }
                        sb.append("...no store\n");
                        break;
                    }
                    case StoreBindingPersister: {
                        sb.append("[App (").append((CharSequence)stats.getAppNameUnsafe()).append(") Store Binding Persister Stats]").append("\n");
                        if (this.storeBindingStats != null) {
                            this.storeBindingStats.formatForPrint(entityType, stats.getStoreBindingStats(), deltaTime, totalTime, sb);
                            break;
                        }
                        sb.append("...no store\n");
                        break;
                    }
                    case StoreBindingICRSender: {
                        sb.append("[App (").append((CharSequence)stats.getAppNameUnsafe()).append(") Store Binding ICR Sender Stats]").append("\n");
                        if (this.storeBindingStats != null) {
                            this.storeBindingStats.formatForPrint(entityType, stats.getStoreBindingStats(), deltaTime, totalTime, sb);
                            break;
                        }
                        sb.append("...no store\n");
                        break;
                    }
                    case BusBinding: {
                        sb.append("[App (").append((CharSequence)stats.getAppNameUnsafe()).append(")  Bus Binding (" + entityName + ")]").append("\n");
                        SrvMonAppBusBindingStats monBusBindingStats = null;
                        if (stats.getBusBindingStats() != null) {
                            for (SrvMonAppBusBindingStats s : stats.getBusBindingStats()) {
                                if (entityName == null || !entityName.equals(s.getBusBindingName())) continue;
                                monBusBindingStats = s;
                                break;
                            }
                        }
                        if (monBusBindingStats != null) {
                            if (this.busBindingsStats.get(entityName) != null) {
                                this.busBindingsStats.get(entityName).formatForPrint(stats.getAppNameUnsafe().getValue(), deltaTime, totalTime, sb);
                                break;
                            }
                            sb.append("...no bus binding '" + entityName + "'").append("\n");
                            break;
                        }
                        sb.append("...no bus binding '" + entityName + "' (in supplied stats!)\n");
                        break;
                    }
                    case UserStat: {
                        if (entityName == null) {
                            sb.append("[App (").append((CharSequence)stats.getAppNameUnsafe()).append(") User Stats]\n");
                        }
                        boolean found = false;
                        SrvMonUserStats userStats = stats.getUserStats();
                        if (userStats != null) {
                            XIterator<SrvMonUserCounterStat> counters = stats.getUserStats().getCountersIterator();
                            if (entityName == null && counters.hasNext()) {
                                sb.append("...Counters {\n");
                            }
                            while (counters.hasNext()) {
                                SrvMonUserCounterStat counter = (SrvMonUserCounterStat)counters.next();
                                if (entityName == null) {
                                    sb.append("......");
                                }
                                if (entityName != null && counter.getNameUnsafe().compareTo((CharSequence)entityName) != 0) continue;
                                sb.append((CharSequence)counter.getNameUnsafe()).append(": ").append(counter.getCount()).append("\n");
                                found = true;
                            }
                            if (entityName == null && counters.toFirst().hasNext()) {
                                sb.append("...}\n");
                            }
                            XIterator<SrvMonUserGaugeStat> gauges = stats.getUserStats().getGaugesIterator();
                            if (entityName == null && gauges.hasNext()) {
                                sb.append("...Gauges{\n");
                            }
                            while (gauges.hasNext()) {
                                SrvMonUserGaugeStat gauge = (SrvMonUserGaugeStat)gauges.next();
                                if (entityName == null) {
                                    sb.append("......");
                                }
                                if (entityName != null && gauge.getNameUnsafe().compareTo((CharSequence)entityName) != 0) continue;
                                sb.append((CharSequence)gauge.getNameUnsafe()).append(": ").append(SrvMonUtil.getGaugeValue(gauge)).append("\n");
                                found = true;
                            }
                            if (entityName == null && gauges.toFirst().hasNext()) {
                                sb.append("...}\n");
                            }
                            XIterator<SrvMonUserSeriesStat> userSeries = stats.getUserStats().getSeriesIterator();
                            if (entityName == null && userSeries.hasNext()) {
                                sb.append("...Series{\n");
                            }
                            while (userSeries.hasNext()) {
                                SrvMonUserSeriesStat series = (SrvMonUserSeriesStat)userSeries.next();
                                if (entityName != null && series.getNameUnsafe().compareTo((CharSequence)entityName) != 0) continue;
                                SrvMonHeartbeatTracer.formatSeriesForPrint(entityName == null ? "......" : "", series.getName(), series.getLongSeries(), sb);
                                found = true;
                            }
                            if (entityName == null && userSeries.toFirst().hasNext()) {
                                sb.append("...}\n");
                            }
                        }
                        if (found) break;
                        if (entityName == null) {
                            sb.append("...no user stats.\n");
                            break;
                        }
                        sb.append("...no '").append(entityName).append("' stat found!\n");
                        break;
                    }
                }
            }

            final void formatForPrint(SrvMonDisruptorStats stats, StringBuilder sb) {
                sb.append("Disruptor {");
                if (stats != null) {
                    int capacity = stats.getCapacity();
                    int remaining = stats.getRemaining();
                    int used = capacity - remaining;
                    int usagePct = used * 100 / capacity;
                    sb.append("[").append(this.format.format(used)).append(" of ").append(this.format.format(capacity)).append("] ").append(usagePct).append("%").append(" (").append((Object)stats.getClaimStrategy()).append(", ").append((Object)stats.getWaitStrategy()).append(")");
                } else {
                    sb.append("\n").append("... No Disruptor stats available").append("\n");
                }
                sb.append("}");
                if (stats != null) {
                    sb.append("\n");
                    SrvMonHeartbeatTracer.formatSeriesForPrint("", "o2p", stats.getOfferToPollLatencies(), sb);
                }
                sb.append("\n");
            }

            final void formatForPrint(SrvMonAppEventMultiplexerStats mxStats, SrvMonAppEventMultiplexerFeederQueueStats[] stats, StringBuilder sb) {
                sb.append("Feeder Queues (max=").append(mxStats.hasMaxConcurrency() ? Integer.valueOf(mxStats.getMaxConcurrency()) : "?");
                sb.append(",lastDecongest=").append(mxStats.hasLastDecongested() ? Integer.valueOf(mxStats.getLastDecongested()) : "?").append("){");
                if (stats != null) {
                    for (int i = 0; i < stats.length; ++i) {
                        if (stats[i] != null && stats[i].hasOwner()) {
                            XString owner = stats[i].getOwnerUnsafe();
                            int size = stats[i].getSize();
                            int decongestCount = stats[i].getDecongestCount();
                            sb.append("\n...").append((CharSequence)owner).append(": size=").append(this.format.format(size)).append(", decongestCount=").append(decongestCount);
                            SrvMonHeartbeatTracer.formatSeriesForPrint("", "o2p", stats[i].getOfferToPollLatencies(), sb);
                            continue;
                        }
                        sb.append("...?");
                    }
                }
                sb.append("}").append("\n");
            }

            final StringBuilder formatForPrint(EntityType entityType, String entityName, SrvMonAppStats stats, long collectionTime, StringBuilder sb) {
                long deltaTime = collectionTime - this.stampTime;
                long totalTime = collectionTime - this.startTime;
                this.stamp(stats);
                this.stampTime = collectionTime;
                if (deltaTime > 0L && totalTime > 0L) {
                    if (entityType != null) {
                        this.formatForPrint(entityType, entityName, stats, deltaTime, totalTime, sb);
                    } else {
                        this.formatForPrint(EntityType.Engine, null, stats, deltaTime, totalTime, sb);
                        this.formatForPrint(EntityType.StoreBinding, null, stats, deltaTime, totalTime, sb);
                        this.formatForPrint(EntityType.StoreBindingPersister, null, stats, deltaTime, totalTime, sb);
                        this.formatForPrint(EntityType.StoreBindingICRSender, null, stats, deltaTime, totalTime, sb);
                        for (String busBindingName : this.busBindingsStats.keySet()) {
                            this.formatForPrint(EntityType.BusBinding, busBindingName, stats, deltaTime, totalTime, sb);
                        }
                    }
                }
                return sb;
            }

            private final class BusBindingStats {
                private long numMsgsRcvdLast;
                private long numMsgsInBatchesRcvdLast;
                private long numMsgBatchesRcvdLast;
                private long numMsgsEnqueuedLast;
                private long numMsgsSentLast;
                private long numFlushesSyncLast;
                private long numMsgsFlushedSyncLast;
                private long numFlushesAsyncLast;
                private long numAsyncFlushCompletionsLast;
                private long numMsgsFlushedAsyncLast;
                private long numStabilityRcvdLast;
                private long numStabilityInBatchesRcvdLast;
                private long numStabilityBatchesRcvdLast;
                private long numPacketsRcvdLast;
                private long numCommitsLast;
                private long numRollbacksLast;
                private long numPartialRollbacksLast;
                private long numMsgsRcvdCurrent;
                private long numMsgsInBatchesRcvdCurrent;
                private long numMsgBatchesRcvdCurrent;
                private long numMsgsEnqueuedCurrent;
                private long numMsgsSentCurrent;
                private long numFlushesSyncCurrent;
                private long numMsgsFlushedSyncCurrent;
                private long numFlushesAsyncCurrent;
                private long numAsyncFlushCompletionsCurrent;
                private long numMsgsFlushedAsyncCurrent;
                private long numStabilityRcvdCurrent;
                private long numStabilityInBatchesRcvdCurrent;
                private long numStabilityBatchesRcvdCurrent;
                private long numPacketsRcvdCurrent;
                private long numCommitsCurrent;
                private long numRollbacksCurrent;
                private long numPartialRollbacksCurrent;
                private int numClientsCurrent;
                private int numChannelsUpCurrent;
                private int numBindingFailuresCurrent;
                private SrvMonAppBusBindingStats busManagerStats;
                private long numMsgsFlushedCurrent;
                private long numMsgsFlushedLast;

                BusBindingStats(SrvMonAppBusBindingStats stats) {
                    this.refresh(stats);
                }

                private final void refresh(SrvMonAppBusBindingStats stats) {
                    this.numMsgsRcvdCurrent = stats.getNumMsgsRcvd();
                    this.numMsgsInBatchesRcvdCurrent = stats.getNumMsgsInBatchesRcvd();
                    this.numMsgBatchesRcvdCurrent = stats.getNumMsgBatchesRcvd();
                    this.numMsgsEnqueuedCurrent = stats.getNumMsgsEnqueued();
                    this.numMsgsSentCurrent = stats.getNumMsgsSent();
                    this.numFlushesSyncCurrent = stats.getNumFlushesSync();
                    this.numMsgsFlushedSyncCurrent = stats.getNumMsgsFlushedSync();
                    this.numFlushesAsyncCurrent = stats.getNumFlushesAsync();
                    this.numAsyncFlushCompletionsCurrent = stats.getNumAsyncFlushCompletions();
                    this.numMsgsFlushedAsyncCurrent = stats.getNumMsgsFlushedAsync();
                    this.numStabilityRcvdCurrent = stats.getNumStabilityRcvd();
                    this.numStabilityInBatchesRcvdCurrent = stats.getNumStabilityInBatchesRcvd();
                    this.numStabilityBatchesRcvdCurrent = stats.getNumStabilityBatchesRcvd();
                    this.numPacketsRcvdCurrent = stats.getNumPacketsRcvd();
                    this.numCommitsCurrent = stats.getNumCommits();
                    this.numRollbacksCurrent = stats.getNumRollbacks();
                    this.numPartialRollbacksCurrent = stats.getNumPartialRollbacks();
                    this.numClientsCurrent = stats.getNumClients();
                    this.numChannelsUpCurrent = stats.getNumChannelsUp();
                    this.numBindingFailuresCurrent = stats.getNumBindingFailures();
                    this.numMsgsFlushedCurrent = stats.getNumFlushesAsync() + stats.getNumMsgsFlushedSync();
                    this.busManagerStats = stats;
                }

                final void stamp(SrvMonAppBusBindingStats stats) {
                    this.numMsgsRcvdLast = this.numMsgsRcvdCurrent;
                    this.numMsgsInBatchesRcvdLast = this.numMsgsInBatchesRcvdCurrent;
                    this.numMsgBatchesRcvdLast = this.numMsgBatchesRcvdCurrent;
                    this.numMsgsEnqueuedLast = this.numMsgsEnqueuedCurrent;
                    this.numMsgsSentLast = this.numMsgsSentCurrent;
                    this.numFlushesSyncLast = this.numFlushesSyncCurrent;
                    this.numMsgsFlushedSyncLast = this.numMsgsFlushedSyncCurrent;
                    this.numFlushesAsyncLast = this.numFlushesAsyncCurrent;
                    this.numAsyncFlushCompletionsLast = this.numAsyncFlushCompletionsCurrent;
                    this.numMsgsFlushedAsyncLast = this.numMsgsFlushedAsyncCurrent;
                    this.numStabilityRcvdLast = this.numStabilityRcvdCurrent;
                    this.numStabilityInBatchesRcvdLast = this.numStabilityInBatchesRcvdCurrent;
                    this.numStabilityBatchesRcvdLast = this.numStabilityBatchesRcvdCurrent;
                    this.numPacketsRcvdLast = this.numPacketsRcvdCurrent;
                    this.numCommitsLast = this.numCommitsCurrent;
                    this.numRollbacksLast = this.numRollbacksCurrent;
                    this.numMsgsFlushedLast = this.numMsgsFlushedCurrent;
                    this.refresh(stats);
                }

                final void formatForPrint(String appName, long deltaTime, long totalTime, StringBuilder sb) {
                    double msgRecvRate = (double)this.numMsgsRcvdCurrent * 1000.0 / (double)totalTime;
                    double deltaNumMsgsRcvd = this.numMsgsRcvdCurrent - this.numMsgsRcvdLast;
                    double deltaMsgRecvRate = (double)(this.numMsgsRcvdCurrent - this.numMsgsRcvdLast) * 1000.0 / (double)deltaTime;
                    double msgInBatchRecvRate = (double)this.numMsgsInBatchesRcvdCurrent * 1000.0 / (double)totalTime;
                    double deltaMsgInBatchRecv = this.numMsgsInBatchesRcvdCurrent - this.numMsgsInBatchesRcvdLast;
                    double deltaMsgInBatchRecvRate = (double)(this.numMsgsInBatchesRcvdCurrent - this.numMsgsInBatchesRcvdLast) * 1000.0 / (double)deltaTime;
                    double msgBatchRecvRate = (double)this.numMsgBatchesRcvdCurrent * 1000.0 / (double)totalTime;
                    double deltaMsgBatchRecv = this.numMsgBatchesRcvdCurrent - this.numMsgBatchesRcvdLast;
                    double deltaMsgBatchRecvRate = (double)(this.numMsgBatchesRcvdCurrent - this.numMsgBatchesRcvdLast) * 1000.0 / (double)deltaTime;
                    double msgEnqueRate = (double)this.numMsgsEnqueuedCurrent * 1000.0 / (double)totalTime;
                    double deltaNumMsgsEnqueued = this.numMsgsEnqueuedCurrent - this.numMsgsEnqueuedLast;
                    double deltaMsgEnqueRate = (double)(this.numMsgsEnqueuedCurrent - this.numMsgsEnqueuedLast) * 1000.0 / (double)deltaTime;
                    double msgSendRate = (double)this.numMsgsSentCurrent * 1000.0 / (double)totalTime;
                    double deltaNumMsgsSent = this.numMsgsSentCurrent - this.numMsgsSentLast;
                    double deltaMsgSendRate = (double)(this.numMsgsSentCurrent - this.numMsgsSentLast) * 1000.0 / (double)deltaTime;
                    double deltaNumSyncFlushes = this.numFlushesSyncCurrent - this.numFlushesSyncLast;
                    double syncFlushRate = (double)this.numFlushesSyncCurrent * 1000.0 / (double)totalTime;
                    double deltaSyncFlushRate = (double)(this.numFlushesSyncCurrent - this.numFlushesSyncLast) * 1000.0 / (double)deltaTime;
                    double msgsSyncFlushRate = (double)this.numMsgsFlushedSyncCurrent * 1000.0 / (double)totalTime;
                    double deltaNumMsgsFlushedSync = this.numMsgsFlushedSyncCurrent - this.numMsgsFlushedSyncLast;
                    double deltaMsgsSyncFlushRate = (double)(this.numMsgsFlushedSyncCurrent - this.numMsgsFlushedSyncLast) * 1000.0 / (double)deltaTime;
                    double asyncFlushRate = (double)this.numFlushesAsyncCurrent * 1000.0 / (double)totalTime;
                    double deltaNumAsync = this.numFlushesAsyncCurrent - this.numFlushesAsyncLast;
                    double deltaAsyncFlushRate = (double)(this.numFlushesAsyncCurrent - this.numFlushesAsyncLast) * 1000.0 / (double)deltaTime;
                    double msgsAsyncFlushRate = (double)this.numMsgsFlushedAsyncCurrent * 1000.0 / (double)totalTime;
                    double deltaNumMsgsFlushedAsync = this.numMsgsFlushedAsyncCurrent - this.numMsgsFlushedAsyncLast;
                    double deltaMsgsAsyncFlushRate = (double)(this.numMsgsFlushedAsyncCurrent - this.numMsgsFlushedAsyncLast) * 1000.0 / (double)deltaTime;
                    double stabilityRecvRate = (double)this.numStabilityRcvdCurrent * 1000.0 / (double)totalTime;
                    double deltaNumStabilityRcvd = this.numStabilityRcvdCurrent - this.numStabilityRcvdLast;
                    double deltaStabilityRecvRate = (double)(this.numStabilityRcvdCurrent - this.numStabilityRcvdLast) * 1000.0 / (double)deltaTime;
                    double stabilityBatchRecvRate = (double)this.numStabilityBatchesRcvdCurrent * 1000.0 / (double)totalTime;
                    double deltaNumStabilityBatchesRcvd = this.numStabilityBatchesRcvdCurrent - this.numStabilityBatchesRcvdLast;
                    double deltaStabilityBatchRecvRate = (double)(this.numStabilityBatchesRcvdCurrent - this.numStabilityBatchesRcvdLast) * 1000.0 / (double)deltaTime;
                    double packetRecvRate = (double)this.numPacketsRcvdCurrent * 1000.0 / (double)totalTime;
                    double deltaPacketRecv = this.numPacketsRcvdCurrent - this.numPacketsRcvdLast;
                    double deltaPacketRecvRate = (double)(this.numPacketsRcvdCurrent - this.numPacketsRcvdLast) * 1000.0 / (double)deltaTime;
                    double commitRate = (double)this.numCommitsCurrent * 1000.0 / (double)totalTime;
                    double deltaNumCommits = this.numCommitsCurrent - this.numCommitsLast;
                    double deltaCommitRate = (double)(this.numCommitsCurrent - this.numCommitsLast) * 1000.0 / (double)deltaTime;
                    long avgRecvBatchSize = this.numMsgBatchesRcvdCurrent == 0L ? 0L : this.numMsgsInBatchesRcvdCurrent / this.numMsgBatchesRcvdCurrent;
                    long deltaAvgRecvBatchSize = this.numMsgBatchesRcvdCurrent - this.numMsgBatchesRcvdLast == 0L ? 0L : (this.numMsgsInBatchesRcvdCurrent - this.numMsgsInBatchesRcvdLast) / (this.numMsgBatchesRcvdCurrent - this.numMsgBatchesRcvdLast);
                    long avgStabilityBatchSize = this.numStabilityBatchesRcvdCurrent == 0L ? 0L : this.numStabilityInBatchesRcvdCurrent / this.numStabilityBatchesRcvdCurrent;
                    long deltaAvgStabilityBatchSize = this.numStabilityBatchesRcvdCurrent - this.numStabilityBatchesRcvdLast == 0L ? 0L : (this.numStabilityInBatchesRcvdCurrent - this.numStabilityInBatchesRcvdLast) / (this.numStabilityBatchesRcvdCurrent - this.numStabilityBatchesRcvdLast);
                    double deltaNumMsgsFlushed = this.numMsgsFlushedCurrent - this.numMsgsFlushedLast;
                    double msgsFlushedRate = (double)(this.numMsgsFlushedCurrent * 1000L) / (double)totalTime;
                    double deltaMsgsFlushedRate = (double)(this.numMsgsFlushedCurrent - this.numMsgsFlushedLast) * 1000.0 / (double)totalTime;
                    double deltaNumRollbacks = this.numRollbacksCurrent - this.numRollbacksLast;
                    double rollbackRate = (double)(this.numRollbacksCurrent * 1000L) / (double)totalTime;
                    double deltaRollbackRate = (double)(this.numRollbacksCurrent - this.numRollbacksLast) * 1000.0 / (double)totalTime;
                    double deltaNumPartialRollbacks = this.numPartialRollbacksCurrent - this.numPartialRollbacksLast;
                    double partialRollbackRate = (double)(this.numPartialRollbacksCurrent * 1000L) / (double)totalTime;
                    double deltaPartialRollbackRate = (double)(this.numPartialRollbacksCurrent - this.numPartialRollbacksLast) * 1000.0 / (double)totalTime;
                    long numFlushesCurrent = this.numFlushesSyncCurrent + this.numFlushesAsyncCurrent;
                    double numFlushesLast = this.numFlushesSyncLast + this.numFlushesAsyncLast;
                    double deltaNumFlushes = (double)numFlushesCurrent - numFlushesLast;
                    double flushRate = numFlushesCurrent * 1000L / totalTime;
                    double deltaFlushRate = (double)(this.numFlushesSyncLast + this.numFlushesAsyncLast) * 1000.0 / (double)totalTime;
                    int syncFlushPct = (int)(numFlushesCurrent == 0L ? 0L : this.numFlushesSyncCurrent * 100L / numFlushesCurrent);
                    int deltaSyncFlushPct = (int)(deltaNumFlushes == 0.0 ? 0.0 : (double)((this.numFlushesSyncCurrent - this.numFlushesSyncLast) * 100L) / deltaNumFlushes);
                    int asyncFlushPct = (int)(numFlushesCurrent == 0L ? 0L : this.numFlushesAsyncCurrent * 100L / numFlushesCurrent);
                    int deltaAsyncFlushPct = (int)(deltaNumFlushes == 0.0 ? 0.0 : (double)((this.numFlushesAsyncCurrent - this.numFlushesAsyncLast) * 100L) / deltaNumFlushes);
                    int syncMsgFlushPct = (int)(this.numMsgsFlushedCurrent == 0L ? 0L : this.numMsgsFlushedSyncCurrent * 100L / this.numMsgsFlushedCurrent);
                    int deltaSyncMsgFlushPct = (int)(deltaNumMsgsFlushed == 0.0 ? 0.0 : (double)((this.numMsgsFlushedSyncCurrent - this.numMsgsFlushedSyncLast) * 100L) / deltaNumMsgsFlushed);
                    int asyncMsgFlushPct = (int)(this.numMsgsFlushedCurrent == 0L ? 0L : this.numMsgsFlushedAsyncCurrent * 100L / this.numMsgsFlushedCurrent);
                    int deltaAsyncMsgFlushPct = (int)(deltaNumMsgsFlushed == 0.0 ? 0.0 : (double)((this.numMsgsFlushedAsyncCurrent - this.numMsgsFlushedAsyncLast) * 100L) / deltaNumMsgsFlushed);
                    double deltaNumAsyncFlushCompletions = this.numAsyncFlushCompletionsCurrent - this.numAsyncFlushCompletionsLast;
                    double asyncFlushCompletionRate = this.numAsyncFlushCompletionsCurrent * 1000L / totalTime;
                    double deltaAsyncFlushCompletionRate = (double)(this.numAsyncFlushCompletionsCurrent - this.numAsyncFlushCompletionsLast) * 1000.0 / (double)totalTime;
                    sb.append(String.format("[Bus Manager (%s)]", this.busManagerStats.getBusBindingName())).append("\n");
                    sb.append("In.........{").append("\n");
                    sb.append(String.format("...Msg{%s(%s) %s(%s) %s(%s) %s(%s) %s(%s) %s(%s) %s(%s)}", AppStats.this.format.format(this.numMsgsRcvdCurrent), AppStats.this.format.format(deltaNumMsgsRcvd), AppStats.this.format.format(msgRecvRate), AppStats.this.format.format(deltaMsgRecvRate), AppStats.this.format.format(this.numMsgsInBatchesRcvdCurrent), AppStats.this.format.format(deltaMsgInBatchRecv), AppStats.this.format.format(msgInBatchRecvRate), AppStats.this.format.format(deltaMsgInBatchRecvRate), AppStats.this.format.format(this.numMsgBatchesRcvdCurrent), AppStats.this.format.format(deltaMsgBatchRecv), AppStats.this.format.format(msgBatchRecvRate), AppStats.this.format.format(deltaMsgBatchRecvRate), AppStats.this.format.format(avgRecvBatchSize), AppStats.this.format.format(deltaAvgRecvBatchSize))).append("\n");
                    sb.append(String.format("...Pkt{%s(%s) %s(%s)}", AppStats.this.format.format(this.numPacketsRcvdCurrent), AppStats.this.format.format(deltaPacketRecv), AppStats.this.format.format(packetRecvRate), AppStats.this.format.format(deltaPacketRecvRate))).append("\n");
                    sb.append(String.format("...Stab{%s(%s) %s(%s) %s(%s) %s(%s) %s(%s)}", AppStats.this.format.format(this.numStabilityRcvdCurrent), AppStats.this.format.format(deltaNumStabilityRcvd), AppStats.this.format.format(stabilityRecvRate), AppStats.this.format.format(deltaStabilityRecvRate), AppStats.this.format.format(this.numStabilityBatchesRcvdCurrent), AppStats.this.format.format(deltaNumStabilityBatchesRcvd), AppStats.this.format.format(stabilityBatchRecvRate), AppStats.this.format.format(deltaStabilityBatchRecvRate), AppStats.this.format.format(avgStabilityBatchSize), AppStats.this.format.format(deltaAvgStabilityBatchSize))).append("\n");
                    sb.append("}").append("\n");
                    sb.append("Out........{").append("\n");
                    sb.append(String.format("...Msg{%s(%s) %s(%s) %s(%s) %s(%s) %s}", AppStats.this.format.format(this.numMsgsEnqueuedCurrent), AppStats.this.format.format(deltaNumMsgsEnqueued), AppStats.this.format.format(msgEnqueRate), AppStats.this.format.format(deltaMsgEnqueRate), AppStats.this.format.format(this.numMsgsSentCurrent), AppStats.this.format.format(deltaNumMsgsSent), AppStats.this.format.format(msgSendRate), AppStats.this.format.format(deltaMsgSendRate), AppStats.this.format.format(this.numMsgsEnqueuedCurrent - this.numMsgsSentCurrent))).append("\n");
                    sb.append("...Flush{");
                    sb.append(AppStats.this.format.format(numFlushesCurrent) + "(" + AppStats.this.format.format(deltaNumFlushes) + ") ");
                    sb.append(AppStats.this.format.format(flushRate) + "(" + AppStats.this.format.format(deltaFlushRate) + ") ");
                    sb.append(AppStats.this.format.format(this.numFlushesSyncCurrent) + "(" + AppStats.this.format.format(syncFlushPct) + "%)(" + AppStats.this.format.format(deltaNumSyncFlushes) + "(" + AppStats.this.format.format(deltaSyncFlushPct) + "%)) ");
                    sb.append(AppStats.this.format.format(syncFlushRate) + "(" + AppStats.this.format.format(deltaSyncFlushRate) + ") ");
                    sb.append(AppStats.this.format.format(this.numFlushesAsyncCurrent) + "(" + AppStats.this.format.format(asyncFlushPct) + "%)(" + AppStats.this.format.format(deltaNumAsync) + "(" + AppStats.this.format.format(deltaAsyncFlushPct) + "%)) ");
                    sb.append(AppStats.this.format.format(asyncFlushRate) + "(" + AppStats.this.format.format(deltaAsyncFlushRate) + ") ");
                    sb.append(AppStats.this.format.format(this.numAsyncFlushCompletionsCurrent) + "(" + AppStats.this.format.format(deltaNumAsyncFlushCompletions) + ") ");
                    sb.append(AppStats.this.format.format(asyncFlushCompletionRate) + "(" + AppStats.this.format.format(deltaAsyncFlushCompletionRate) + ")");
                    sb.append("...}").append("\n");
                    sb.append("...Msg{");
                    sb.append(AppStats.this.format.format(this.numMsgsFlushedCurrent) + "(" + AppStats.this.format.format(deltaNumMsgsFlushed) + ") ");
                    sb.append(AppStats.this.format.format(msgsFlushedRate) + "(" + AppStats.this.format.format(deltaMsgsFlushedRate) + ") ");
                    sb.append(AppStats.this.format.format(this.numMsgsFlushedSyncCurrent) + "(" + AppStats.this.format.format(syncMsgFlushPct) + "%)(" + AppStats.this.format.format(deltaNumMsgsFlushedSync) + "(" + AppStats.this.format.format(deltaSyncMsgFlushPct) + "%)) ");
                    sb.append(AppStats.this.format.format(msgsSyncFlushRate) + "(" + AppStats.this.format.format(deltaMsgsSyncFlushRate) + ") ");
                    sb.append(AppStats.this.format.format(this.numMsgsFlushedAsyncCurrent) + "(" + AppStats.this.format.format(asyncMsgFlushPct) + "%)(" + AppStats.this.format.format(deltaNumMsgsFlushedAsync) + "(" + AppStats.this.format.format(deltaAsyncMsgFlushPct) + "%)) ");
                    sb.append(AppStats.this.format.format(msgsAsyncFlushRate) + "(" + AppStats.this.format.format(deltaMsgsAsyncFlushRate) + ")");
                    sb.append("...}").append("\n");
                    sb.append("}").append("\n");
                    sb.append("Txn........{");
                    sb.append(AppStats.this.format.format(this.numCommitsCurrent) + "(" + AppStats.this.format.format(deltaNumCommits) + ") ");
                    sb.append(AppStats.this.format.format(commitRate) + "(" + AppStats.this.format.format(deltaCommitRate) + ") ");
                    sb.append(AppStats.this.format.format(this.numRollbacksCurrent) + "(" + AppStats.this.format.format(deltaNumRollbacks) + ") ");
                    sb.append(AppStats.this.format.format(rollbackRate) + "(" + AppStats.this.format.format(deltaRollbackRate) + ")").append("\n");
                    sb.append(AppStats.this.format.format(this.numPartialRollbacksCurrent) + "(" + AppStats.this.format.format(deltaNumPartialRollbacks) + ") ");
                    sb.append(AppStats.this.format.format(partialRollbackRate) + "(" + AppStats.this.format.format(deltaPartialRollbackRate) + ")").append("\n");
                    sb.append("}").append("\n");
                    AppStats.this.formatForPrint(this.busManagerStats.getDisruptorStats(), sb);
                    sb.append("Clients....{");
                    sb.append(this.numClientsCurrent);
                    sb.append("}").append("\n");
                    sb.append("Channels...{");
                    sb.append(this.numChannelsUpCurrent);
                    sb.append("}").append("\n");
                    sb.append("Fails......{");
                    sb.append(this.numBindingFailuresCurrent);
                    sb.append("}").append("\n");
                    String bindingName = this.busManagerStats.getBusBindingName();
                    sb.append("\n").append("[Messaging Latencies (").append(appName).append("@").append(bindingName).append(")]").append("\n");
                    if (this.busManagerStats.getWireToWireLatencies() != null) {
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "c2o", this.busManagerStats.getCreateToSendLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "o2p", this.busManagerStats.getSendToPollLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "o2s", this.busManagerStats.getSendToSerializeLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "s", this.busManagerStats.getSerializeLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "s2w", this.busManagerStats.getSerializeToWireLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "ws", this.busManagerStats.getWireSendLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "w", this.busManagerStats.getWireLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "w2d", this.busManagerStats.getWireToDeserializeLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "d", this.busManagerStats.getDeserializeLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "d2i", this.busManagerStats.getDeserializeToReceiveLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "o2i", this.busManagerStats.getOriginToReceiveLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "w2w", this.busManagerStats.getWireToWireLatencies(), sb);
                    } else {
                        sb.append("[Binding not established. No latency manager]").append("\n");
                    }
                    if (bindingName != null) {
                        sb.append("\n");
                        sb.append("[Binding '" + bindingName + "']").append("\n");
                        sb.append("<Binding Details missing>");
                        sb.append("\n");
                    } else {
                        sb.append("[Binding not established. No binding level stats]").append("\n");
                    }
                }
            }

            private final class StoreBindingStats {
                private long numCommitsSentLast;
                private long numCommitEntriesSentLast;
                private long numCommitsReceivedLast;
                private long numCommitEntriesReceivedLast;
                private long numCommitCompletionsSentLast;
                private long numCommitCompletionsReceivedLast;
                private long sizeLast;
                private long dataSizeLast;
                private long numCommitsSentCurrent;
                private long numCommitEntriesSentCurrent;
                private long numCommitsReceivedCurrent;
                private long numCommitEntriesReceivedCurrent;
                private long numCommitCompletionsSentCurrent;
                private long numCommitCompletionsReceivedCurrent;
                private long sizeCurrent;
                private long dataSizeCurrent;
                private PersisterStats persisterStats;
                private ICRSenderStats icrSenderStats;
                private SrvMonAppStoreBindingStats storeBindingStats;

                StoreBindingStats(SrvMonAppStoreBindingStats stats) {
                    this.refresh(stats);
                }

                private final void refresh(SrvMonAppStoreBindingStats stats) {
                    this.numCommitsSentCurrent = stats.getNumCommitsSent();
                    this.numCommitEntriesSentCurrent = stats.getNumCommitEntriesSent();
                    this.numCommitsReceivedCurrent = stats.getNumCommitsReceived();
                    this.numCommitEntriesReceivedCurrent = stats.getNumCommitEntriesReceived();
                    this.numCommitCompletionsSentCurrent = stats.getNumCommitCompletionsSent();
                    this.numCommitCompletionsReceivedCurrent = stats.getNumCommitCompletionsReceived();
                    this.sizeCurrent = stats.getSize();
                    this.dataSizeCurrent = stats.getDataSize();
                    this.storeBindingStats = stats;
                }

                final void stamp(SrvMonAppStoreBindingStats stats) {
                    this.numCommitsSentLast = this.numCommitsSentCurrent;
                    this.numCommitEntriesSentLast = this.numCommitEntriesSentCurrent;
                    this.numCommitsReceivedLast = this.numCommitsReceivedCurrent;
                    this.numCommitEntriesReceivedLast = this.numCommitEntriesReceivedCurrent;
                    this.numCommitCompletionsSentLast = this.numCommitCompletionsSentCurrent;
                    this.numCommitCompletionsReceivedLast = this.numCommitCompletionsReceivedCurrent;
                    this.sizeLast = this.sizeCurrent;
                    this.dataSizeLast = this.sizeCurrent;
                    this.refresh(stats);
                    if (stats.getPersisterStats() != null) {
                        if (this.persisterStats == null) {
                            this.persisterStats = new PersisterStats(stats.getPersisterStats());
                        }
                        this.persisterStats.stamp(stats.getPersisterStats());
                    }
                    if (stats.getICRSenderStats() != null) {
                        if (this.icrSenderStats == null) {
                            this.icrSenderStats = new ICRSenderStats(stats.getICRSenderStats());
                        }
                        this.icrSenderStats.stamp(stats.getICRSenderStats());
                    }
                }

                private final void formatForPrint(long deltaTime, long totalTime, StringBuilder sb) {
                    double commitSendRate = (double)this.numCommitsSentCurrent * 1000.0 / (double)totalTime;
                    double deltaCommitSendRate = (double)(this.numCommitsSentCurrent - this.numCommitsSentLast) * 1000.0 / (double)deltaTime;
                    double commitEntriesSendRate = (double)this.numCommitEntriesSentCurrent * 1000.0 / (double)totalTime;
                    double deltaCommitEntriesSendRate = (double)(this.numCommitEntriesSentCurrent - this.numCommitEntriesSentLast) * 1000.0 / (double)deltaTime;
                    double commitReceiveRate = (double)this.numCommitsReceivedCurrent * 1000.0 / (double)totalTime;
                    double deltaCommitReceiveRate = (double)(this.numCommitsReceivedCurrent - this.numCommitsReceivedLast) * 1000.0 / (double)deltaTime;
                    double commitEntryReceiveRate = (double)this.numCommitEntriesReceivedCurrent * 1000.0 / (double)totalTime;
                    double deltaCommitEntryReceiveRate = (double)(this.numCommitEntriesReceivedCurrent - this.numCommitEntriesReceivedLast) * 1000.0 / (double)deltaTime;
                    double commitCompletionSendRate = (double)this.numCommitCompletionsSentCurrent * 1000.0 / (double)totalTime;
                    double deltaCommitCompletionSendRate = (double)(this.numCommitCompletionsSentCurrent - this.numCommitCompletionsSentLast) * 1000.0 / (double)deltaTime;
                    double commitCompletionReceiveRate = (double)this.numCommitCompletionsReceivedCurrent * 1000.0 / (double)totalTime;
                    double deltaCommitCompletionReceiveRate = (double)(this.numCommitCompletionsReceivedCurrent - this.numCommitCompletionsReceivedLast) * 1000.0 / (double)deltaTime;
                    long sizeDelta = this.sizeCurrent - this.sizeLast;
                    long dataSizeDelta = this.dataSizeCurrent - this.dataSizeLast;
                    sb.append("{");
                    sb.append("role=").append((Object)this.storeBindingStats.getRole()).append(" ");
                    sb.append("state=").append((Object)this.storeBindingStats.getState()).append(" ");
                    sb.append("size=").append(this.storeBindingStats.getSize()).append(" (").append(sizeDelta >= 0L ? "+" : "-").append(Math.abs(sizeDelta)).append(") ");
                    sb.append("data=").append(UtlUnit.readableBytesSize((long)this.storeBindingStats.getDataSize())).append(" (").append(dataSizeDelta >= 0L ? "+" : "-").append(UtlUnit.readableBytesSize((long)Math.abs(dataSizeDelta))).append(") ");
                    sb.append("}").append("\n");
                    sb.append("Commit......{").append("\n");
                    sb.append(String.format("...In{%s(%s %s) %s(%s %s) }", AppStats.this.format.format(this.numCommitsReceivedCurrent), AppStats.this.format.format(commitReceiveRate), AppStats.this.format.format(deltaCommitReceiveRate), AppStats.this.format.format(this.numCommitEntriesReceivedCurrent), AppStats.this.format.format(commitEntryReceiveRate), AppStats.this.format.format(deltaCommitEntryReceiveRate))).append("\n");
                    sb.append(String.format("...Out{%s(%s %s) %s(%s %s) }", AppStats.this.format.format(this.numCommitsSentCurrent), AppStats.this.format.format(commitSendRate), AppStats.this.format.format(deltaCommitSendRate), AppStats.this.format.format(this.numCommitEntriesSentCurrent), AppStats.this.format.format(commitEntriesSendRate), AppStats.this.format.format(deltaCommitEntriesSendRate))).append("\n");
                    sb.append(String.format("...Complete{%s(%s %s) %s(%s %s) }", AppStats.this.format.format(this.numCommitCompletionsReceivedCurrent), AppStats.this.format.format(commitCompletionReceiveRate), AppStats.this.format.format(deltaCommitCompletionReceiveRate), AppStats.this.format.format(this.numCommitCompletionsSentCurrent), AppStats.this.format.format(commitCompletionSendRate), AppStats.this.format.format(deltaCommitCompletionSendRate))).append("\n");
                    sb.append("}").append("\n");
                    sb.append("[Store Latencies]\n");
                    if (this.storeBindingStats.getCommitLatencies() != null) {
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "cqs", this.storeBindingStats.getCommitQueueSize(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "s", this.storeBindingStats.getSerializeLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "s2w", this.storeBindingStats.getSerializeToWireLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "s2p", this.storeBindingStats.getSerializeToPersistLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "w", this.storeBindingStats.getWireLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "w2d", this.storeBindingStats.getWireToDeserializeLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "d", this.storeBindingStats.getDeserializeLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "per", this.storeBindingStats.getPersistLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "icr", this.storeBindingStats.getIcrSendLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "idx", this.storeBindingStats.getIndexLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "c", this.storeBindingStats.getCommitLatencies(), sb);
                    } else {
                        sb.append("... no store latencies").append("\n");
                    }
                }

                final void formatForPrint(EntityType entityType, SrvMonAppStoreBindingStats stats, long deltaTime, long totalTime, StringBuilder sb) {
                    switch (entityType) {
                        case StoreBinding: {
                            this.formatForPrint(deltaTime, totalTime, sb);
                            break;
                        }
                        case StoreBindingPersister: {
                            if (this.persisterStats != null) {
                                this.persisterStats.formatForPrint(deltaTime, totalTime, sb);
                                break;
                            }
                            sb.append("[Persister]").append("\n");
                            sb.append("<no persister>").append("\n");
                            break;
                        }
                        case StoreBindingICRSender: {
                            if (this.icrSenderStats != null) {
                                this.icrSenderStats.formatForPrint(deltaTime, totalTime, sb);
                                break;
                            }
                            sb.append("[ICRSender]").append("\n");
                            sb.append("<no ICR sender>").append("\n");
                            break;
                        }
                    }
                }

                private final class ICRSenderStats {
                    private long numPutsRecordedLast;
                    private long numUpdatesRecordedLast;
                    private long numRemovesRecordedLast;
                    private long numSendsRecordedLast;
                    private long numCommitsLast;
                    private long numForksLast;
                    private long numPutsRecordedCurrent;
                    private long numUpdatesRecordedCurrent;
                    private long numRemovesRecordedCurrent;
                    private long numSendsRecordedCurrent;
                    private long numCommitsCurrent;
                    private long numForksCurrent;
                    private SrvMonAppStoreBindingICRSenderStats icrSenderStats;

                    ICRSenderStats(SrvMonAppStoreBindingICRSenderStats stats) {
                        this.refresh(stats);
                    }

                    private final void refresh(SrvMonAppStoreBindingICRSenderStats stats) {
                        this.numPutsRecordedCurrent = stats.getNumPutsRecorded();
                        this.numUpdatesRecordedCurrent = stats.getNumUpdatesRecorded();
                        this.numRemovesRecordedCurrent = stats.getNumRemovesRecorded();
                        this.numSendsRecordedCurrent = stats.getNumSendsRecorded();
                        this.numCommitsCurrent = stats.getNumCommits();
                        this.numForksCurrent = stats.getNumForks();
                        this.icrSenderStats = stats;
                    }

                    final void stamp(SrvMonAppStoreBindingICRSenderStats stats) {
                        this.numPutsRecordedLast = this.numPutsRecordedCurrent;
                        this.numUpdatesRecordedLast = this.numUpdatesRecordedCurrent;
                        this.numRemovesRecordedLast = this.numRemovesRecordedCurrent;
                        this.numSendsRecordedLast = this.numSendsRecordedCurrent;
                        this.numCommitsLast = this.numCommitsCurrent;
                        this.numForksLast = this.numForksCurrent;
                        this.refresh(stats);
                    }

                    final void formatForPrint(long deltaTime, long totalTime, StringBuilder sb) {
                        double putRecordRate = (double)this.numPutsRecordedCurrent * 1000.0 / (double)totalTime;
                        double deltaPutRecordRate = (double)(this.numPutsRecordedCurrent - this.numPutsRecordedLast) * 1000.0 / (double)deltaTime;
                        double updateRecordRate = (double)this.numUpdatesRecordedCurrent * 1000.0 / (double)totalTime;
                        double deltaUpdateRecordRate = (double)(this.numUpdatesRecordedCurrent - this.numUpdatesRecordedLast) * 1000.0 / (double)deltaTime;
                        double removeRecordRate = (double)this.numRemovesRecordedCurrent * 1000.0 / (double)totalTime;
                        double deltaRemoveRecordRate = (double)(this.numRemovesRecordedCurrent - this.numRemovesRecordedLast) * 1000.0 / (double)deltaTime;
                        double sendRecordRate = (double)this.numSendsRecordedCurrent * 1000.0 / (double)totalTime;
                        double deltaSendRecordRate = (double)(this.numSendsRecordedCurrent - this.numSendsRecordedLast) * 1000.0 / (double)deltaTime;
                        double commitRate = (double)this.numCommitsCurrent * 1000.0 / (double)totalTime;
                        double deltaCommitRate = (double)(this.numCommitsCurrent - this.numCommitsLast) * 1000.0 / (double)deltaTime;
                        double forkRate = (double)this.numForksCurrent * 1000.0 / (double)totalTime;
                        double deltaForkRate = (double)(this.numForksCurrent - this.numForksLast) * 1000.0 / (double)deltaTime;
                        sb.append("[ICRSender]").append("\n");
                        sb.append(String.format("Put {%s(%s %s)} Updates {%s(%s %s)} Removes {%s(%s %s)} Sends {%s(%s %s)} Commits {%s(%s %s)} Forks {%s(%s %s)}", AppStats.this.format.format(this.numPutsRecordedCurrent), AppStats.this.format.format(putRecordRate), AppStats.this.format.format(deltaPutRecordRate), AppStats.this.format.format(this.numUpdatesRecordedCurrent), AppStats.this.format.format(updateRecordRate), AppStats.this.format.format(deltaUpdateRecordRate), AppStats.this.format.format(this.numRemovesRecordedCurrent), AppStats.this.format.format(removeRecordRate), AppStats.this.format.format(deltaRemoveRecordRate), AppStats.this.format.format(this.numSendsRecordedCurrent), AppStats.this.format.format(sendRecordRate), AppStats.this.format.format(deltaSendRecordRate), AppStats.this.format.format(this.numCommitsCurrent), AppStats.this.format.format(commitRate), AppStats.this.format.format(deltaCommitRate), AppStats.this.format.format(this.numForksCurrent), AppStats.this.format.format(forkRate), AppStats.this.format.format(deltaForkRate))).append("\n");
                        AppStats.this.formatForPrint(this.icrSenderStats.getDisruptorStats(), sb);
                    }
                }

                private final class PersisterStats {
                    private long numPutsRecordedLast;
                    private long numUpdatesRecordedLast;
                    private long numRemovesRecordedLast;
                    private long numSendsRecordedLast;
                    private long numCommitsLast;
                    private long numForksLast;
                    private long fileSizeLast;
                    private long fileSizeUsedLast;
                    private long numPutsRecordedCurrent;
                    private long numUpdatesRecordedCurrent;
                    private long numRemovesRecordedCurrent;
                    private long numSendsRecordedCurrent;
                    private long numCommitsCurrent;
                    private long numForksCurrent;
                    private long fileSizeCurrent;
                    private long fileSizeUsedCurrent;
                    private SrvMonAppStoreBindingPersisterStats storeBindingPersisterStats;

                    PersisterStats(SrvMonAppStoreBindingPersisterStats stats) {
                        this.refresh(stats);
                    }

                    private final void refresh(SrvMonAppStoreBindingPersisterStats stats) {
                        this.numPutsRecordedCurrent = stats.getNumPutsRecorded();
                        this.numUpdatesRecordedCurrent = stats.getNumUpdatesRecorded();
                        this.numRemovesRecordedCurrent = stats.getNumRemovesRecorded();
                        this.numSendsRecordedCurrent = stats.getNumSendsRecorded();
                        this.numCommitsCurrent = stats.getNumCommits();
                        this.numForksCurrent = stats.getNumForks();
                        this.fileSizeCurrent = stats.getFileSize();
                        this.fileSizeUsedCurrent = stats.getFileSizeUsed();
                        this.storeBindingPersisterStats = stats;
                    }

                    final void stamp(SrvMonAppStoreBindingPersisterStats stats) {
                        this.numPutsRecordedLast = this.numPutsRecordedCurrent;
                        this.numUpdatesRecordedLast = this.numUpdatesRecordedCurrent;
                        this.numRemovesRecordedLast = this.numRemovesRecordedCurrent;
                        this.numSendsRecordedLast = this.numSendsRecordedCurrent;
                        this.numCommitsLast = this.numCommitsCurrent;
                        this.numForksLast = this.numForksCurrent;
                        this.fileSizeLast = this.fileSizeCurrent;
                        this.fileSizeUsedLast = this.fileSizeUsedCurrent;
                        this.refresh(stats);
                    }

                    final void formatForPrint(long deltaTime, long totalTime, StringBuilder sb) {
                        double putRecordRate = (double)this.numPutsRecordedCurrent * 1000.0 / (double)totalTime;
                        double deltaPutRecordRate = (double)(this.numPutsRecordedCurrent - this.numPutsRecordedLast) * 1000.0 / (double)deltaTime;
                        double updateRecordRate = (double)this.numUpdatesRecordedCurrent * 1000.0 / (double)totalTime;
                        double deltaUpdateRecordRate = (double)(this.numUpdatesRecordedCurrent - this.numUpdatesRecordedLast) * 1000.0 / (double)deltaTime;
                        double removeRecordRate = (double)this.numRemovesRecordedCurrent * 1000.0 / (double)totalTime;
                        double deltaRemoveRecordRate = (double)(this.numRemovesRecordedCurrent - this.numRemovesRecordedLast) * 1000.0 / (double)deltaTime;
                        double sendRecordRate = (double)this.numSendsRecordedCurrent * 1000.0 / (double)totalTime;
                        double deltaSendRecordRate = (double)(this.numSendsRecordedCurrent - this.numSendsRecordedLast) * 1000.0 / (double)deltaTime;
                        double commitRate = (double)this.numCommitsCurrent * 1000.0 / (double)totalTime;
                        double deltaCommitRate = (double)(this.numCommitsCurrent - this.numCommitsLast) * 1000.0 / (double)deltaTime;
                        double forkRate = (double)this.numForksCurrent * 1000.0 / (double)totalTime;
                        double deltaForkRate = (double)(this.numForksCurrent - this.numForksLast) * 1000.0 / (double)deltaTime;
                        double fileSizeRate = (double)this.fileSizeCurrent * 1000.0 / (double)totalTime;
                        double deltaFileSizeRate = (double)(this.fileSizeCurrent - this.fileSizeLast) * 1000.0 / (double)deltaTime;
                        double fileSizeUsedRate = (double)this.fileSizeUsedCurrent * 1000.0 / (double)totalTime;
                        double deltaFileSizeUsedRate = (double)(this.fileSizeUsedCurrent - this.fileSizeUsedLast) * 1000.0 / (double)deltaTime;
                        sb.append("[Persister]").append("\n");
                        sb.append(String.format("Put {%s(%s %s)} Updates {%s(%s %s)} Removes {%s(%s %s)} Sends {%s(%s %s)} Commits {%s(%s %s)}  Forks {%s(%s %s)}", AppStats.this.format.format(this.numPutsRecordedCurrent), AppStats.this.format.format(putRecordRate), AppStats.this.format.format(deltaPutRecordRate), AppStats.this.format.format(this.numUpdatesRecordedCurrent), AppStats.this.format.format(updateRecordRate), AppStats.this.format.format(deltaUpdateRecordRate), AppStats.this.format.format(this.numRemovesRecordedCurrent), AppStats.this.format.format(removeRecordRate), AppStats.this.format.format(deltaRemoveRecordRate), AppStats.this.format.format(this.numSendsRecordedCurrent), AppStats.this.format.format(sendRecordRate), AppStats.this.format.format(deltaSendRecordRate), AppStats.this.format.format(this.numCommitsCurrent), AppStats.this.format.format(commitRate), AppStats.this.format.format(deltaCommitRate), AppStats.this.format.format(this.numForksCurrent), AppStats.this.format.format(forkRate), AppStats.this.format.format(deltaForkRate))).append("\n");
                        AppStats.this.formatForPrint(this.storeBindingPersisterStats.getDisruptorStats(), sb);
                        sb.append(String.format("Writer {qsize=%s}", "-1")).append("\n");
                        sb.append(String.format("Disk Size{%s(%s %s)} Used{%s(%s %s)}", UtlFile.readableFileSize((long)this.fileSizeCurrent), UtlFile.readableFileSize((long)((long)fileSizeRate)), UtlFile.readableFileSize((long)((long)deltaFileSizeRate)), UtlFile.readableFileSize((long)this.fileSizeUsedCurrent), UtlFile.readableFileSize((long)((long)fileSizeUsedRate)), UtlFile.readableFileSize((long)((long)deltaFileSizeUsedRate)))).append("\n");
                    }
                }
            }

            private final class EngineStats {
                private long numMsgsRcvdBestEffortLast;
                private long numMsgsRcvdGuaranteedLast;
                private long numMsgsSentBestEffortLast;
                private long numMsgsSentGuaranteedLast;
                private long numEventsRcvdLast;
                private long numFlowEventsRcvdLast;
                private long numTransactionsLast;
                private long numMsgsSourcedLast;
                private long numMsgsFilteredLast;
                private long numMsgsRcvdBestEffortCurrent;
                private long numMsgsRcvdGuaranteedCurrent;
                private long numMsgsSentBestEffortCurrent;
                private long numMsgsSentGuaranteedCurrent;
                private long numEventsRcvdCurrent;
                private long numFlowEventsRcvdCurrent;
                private long numFlowEventsProcSuccessCurrent;
                private long numFlowEventsProcFailCurrent;
                private long numFlowEventsProcCompleteCurrent;
                private long numTransactionsCurrent;
                private long numCommitsStartedCurrent;
                private long numCommitsCompletedCurrent;
                private long numRollbacksCurrent;
                private long numPartialRollbacksCurrent;
                private long numDupMsgsRcvdCurrent;
                private long numMsgsSourcedCurrent;
                private long numMsgsFilteredCurrent;
                private long backupOutboundQueueSize;
                private long backupOutboundLogQueueSize;
                private long outboundSno;
                private long outboundStableSno;
                private long numMsgsResentCurrent;
                private long numFlowsCurrent;
                private long numEventsProcessed;
                private long numSendCommitsStartedCurrent;
                private long numSendCommitsCompletedCurrent;
                private long sendCommitCompletionQueueSizeCurrent;
                private long numStoreCommitsStartedCurrent;
                private long numstoreCommitsCompletedCurrent;
                private long storeCommitCompletionQueueSizeCurrent;
                private SrvMonAppEngineStats aepEngineStats;
                private MessageLoggerStats inboundLoggerStats;
                private MessageLoggerStats outboundLoggerStats;
                private MessageLoggerStats perTransactionStatsLoggerStats;
                private XIntLinkedHashMap<MessageTypeStats> msgTypeStatsTable = new XIntLinkedHashMap();

                EngineStats(SrvMonAppEngineStats stats) {
                    this.refresh(stats);
                    this.aepEngineStats = stats;
                }

                private final void refresh(SrvMonAppEngineStats stats) {
                    this.numMsgsRcvdBestEffortCurrent = stats.getNumMsgsRcvdBestEffort();
                    this.numMsgsRcvdGuaranteedCurrent = stats.getNumMsgsRcvdGuaranteed();
                    this.numMsgsSentBestEffortCurrent = stats.getNumMsgsSentBestEffort();
                    this.numMsgsSentGuaranteedCurrent = stats.getNumMsgsSentGuaranteed();
                    this.numEventsRcvdCurrent = stats.getNumEventsRcvd();
                    this.numFlowEventsRcvdCurrent = stats.getNumFlowEventsRcvd();
                    this.numFlowEventsProcSuccessCurrent = stats.getNumFlowEventsProcSuccess();
                    this.numFlowEventsProcFailCurrent = stats.getNumFlowEventsProcFail();
                    this.numFlowEventsProcCompleteCurrent = stats.getNumFlowEventsProcComplete();
                    this.numTransactionsCurrent = stats.getNumTransactions();
                    this.numCommitsStartedCurrent = stats.getNumCommitsStarted();
                    this.numCommitsCompletedCurrent = stats.getNumCommitsCompleted();
                    this.numRollbacksCurrent = stats.getNumRollbacks();
                    this.numPartialRollbacksCurrent = stats.getNumPartialRollbacks();
                    this.numDupMsgsRcvdCurrent = stats.getNumDupMsgsRcvd();
                    this.numMsgsSourcedCurrent = stats.getNumMsgsSourced();
                    this.numMsgsFilteredCurrent = stats.getNumMsgsFiltered();
                    this.backupOutboundQueueSize = stats.getBackupOutboundQueueSize();
                    this.backupOutboundLogQueueSize = stats.getBackupOutboundLogQueueSize();
                    this.outboundSno = stats.getOutboundSno();
                    this.outboundStableSno = stats.getOutboundStableSno();
                    this.numMsgsResentCurrent = stats.getNumMsgsResent();
                    this.numFlowsCurrent = stats.getNumFlows();
                    this.numEventsProcessed = 0L;
                    this.numSendCommitsStartedCurrent = stats.getNumSendCommitsStarted();
                    this.numSendCommitsCompletedCurrent = stats.getNumSendCommitsCompleted();
                    this.sendCommitCompletionQueueSizeCurrent = stats.getSendCommitCompletionQueueSize();
                    this.numStoreCommitsStartedCurrent = stats.getNumStoreCommitsStarted();
                    this.numstoreCommitsCompletedCurrent = stats.getNumSendCommitsCompleted();
                    this.storeCommitCompletionQueueSizeCurrent = stats.getStoreCommitCompletionQueueSize();
                    this.aepEngineStats = stats;
                }

                final void stamp(SrvMonAppEngineStats stats) {
                    this.numMsgsRcvdBestEffortLast = this.numMsgsRcvdBestEffortCurrent;
                    this.numMsgsRcvdGuaranteedLast = this.numMsgsRcvdGuaranteedCurrent;
                    this.numMsgsSentBestEffortLast = this.numMsgsSentBestEffortCurrent;
                    this.numMsgsSentGuaranteedLast = this.numMsgsSentGuaranteedCurrent;
                    this.numEventsRcvdLast = this.numEventsRcvdCurrent;
                    this.numFlowEventsRcvdLast = this.numFlowEventsRcvdCurrent;
                    this.numTransactionsLast = this.numTransactionsCurrent;
                    this.numMsgsSourcedLast = this.numMsgsSourcedCurrent;
                    this.numMsgsFilteredLast = this.numMsgsFilteredCurrent;
                    this.refresh(stats);
                    if (stats.hasInboundMessageLoggerStats()) {
                        if (this.inboundLoggerStats == null) {
                            this.inboundLoggerStats = new MessageLoggerStats("Inbound Message Logger", stats.getInboundMessageLoggerStats());
                        }
                        this.inboundLoggerStats.stamp(stats.getInboundMessageLoggerStats());
                    }
                    if (stats.hasOutboundMessageLoggerStats()) {
                        if (this.outboundLoggerStats == null) {
                            this.outboundLoggerStats = new MessageLoggerStats("Outbound Message Logger", stats.getOutboundMessageLoggerStats());
                        }
                        this.outboundLoggerStats.stamp(stats.getOutboundMessageLoggerStats());
                    }
                    if (stats.hasPerTransactionStatsLoggerStats()) {
                        if (this.perTransactionStatsLoggerStats == null) {
                            this.perTransactionStatsLoggerStats = new MessageLoggerStats("Per Transaction Stats Logger", stats.getPerTransactionStatsLoggerStats());
                        }
                        this.perTransactionStatsLoggerStats.stamp(stats.getPerTransactionStatsLoggerStats());
                    }
                    XIterator<SrvMonMsgTypeStats> msgsTypeStatsIt = stats.getMsgTypeStatsIterator();
                    while (msgsTypeStatsIt.hasNext()) {
                        SrvMonMsgTypeStats monMsgTypeStats = (SrvMonMsgTypeStats)msgsTypeStatsIt.next();
                        int key = monMsgTypeStats.getMessageFactoryId() << 16 | monMsgTypeStats.getMessageTypeId();
                        MessageTypeStats msgTypeStats = (MessageTypeStats)this.msgTypeStatsTable.get(key);
                        if (msgTypeStats == null) {
                            msgTypeStats = new MessageTypeStats(monMsgTypeStats.getMessageTypeName(), monMsgTypeStats.getMessageFactoryId(), monMsgTypeStats.getMessageTypeId());
                            this.msgTypeStatsTable.put(key, (Object)msgTypeStats);
                        }
                        msgTypeStats.stamp(monMsgTypeStats);
                    }
                }

                final void formatForPrint(long deltaTime, long totalTime, StringBuilder sb) {
                    long numMsgsRcvd = this.numMsgsRcvdBestEffortCurrent + this.numMsgsRcvdGuaranteedCurrent;
                    long numMsgsRcvdLast = this.numMsgsRcvdBestEffortLast + this.numMsgsRcvdGuaranteedLast;
                    double msgRecvRate = (double)numMsgsRcvd * 1000.0 / (double)totalTime;
                    double deltaMsgRecvRate = (double)(numMsgsRcvd - numMsgsRcvdLast) * 1000.0 / (double)deltaTime;
                    double bestEffortMsgRecvRate = (double)this.numMsgsRcvdBestEffortCurrent * 1000.0 / (double)totalTime;
                    double deltaBestEffortMsgRecvRate = (double)(this.numMsgsRcvdBestEffortCurrent - this.numMsgsRcvdBestEffortLast) * 1000.0 / (double)deltaTime;
                    double guaranteedMsgRecvRate = (double)this.numMsgsRcvdGuaranteedCurrent * 1000.0 / (double)totalTime;
                    double deltaGuaranteedMsgRecvRate = (double)(this.numMsgsRcvdGuaranteedCurrent - this.numMsgsRcvdGuaranteedLast) * 1000.0 / (double)deltaTime;
                    double msgSourceRate = (double)this.numMsgsSourcedCurrent * 1000.0 / (double)totalTime;
                    double deltaMsgSourceRate = (this.numMsgsSourcedCurrent - this.numMsgsSourcedLast) * 1000L / deltaTime;
                    double msgFilterRate = (double)this.numMsgsFilteredCurrent * 1000.0 / (double)totalTime;
                    double deltaMsgFilterRate = (this.numMsgsFilteredCurrent - this.numMsgsFilteredLast) * 1000L / deltaTime;
                    long numMsgsSent = this.numMsgsSentBestEffortCurrent + this.numMsgsSentGuaranteedCurrent;
                    long numMsgsSentLast = this.numMsgsSentBestEffortLast + this.numMsgsSentGuaranteedLast;
                    double msgSendRate = (double)numMsgsSent * 1000.0 / (double)totalTime;
                    double deltaMsgSendRate = (double)(numMsgsSent - numMsgsSentLast) * 1000.0 / (double)deltaTime;
                    double bestEffortMsgSendRate = (double)this.numMsgsSentBestEffortCurrent * 1000.0 / (double)totalTime;
                    double deltaBestEffortMsgSendRate = (double)(this.numMsgsSentBestEffortCurrent - this.numMsgsSentBestEffortLast) * 1000.0 / (double)deltaTime;
                    double guaranteedMsgSendRate = (double)this.numMsgsSentGuaranteedCurrent * 1000.0 / (double)totalTime;
                    double deltaGuaranteedMsgSendRate = (double)(this.numMsgsSentGuaranteedCurrent - this.numMsgsSentGuaranteedLast) * 1000.0 / (double)deltaTime;
                    double eventRecvRate = (double)this.numEventsRcvdCurrent * 1000.0 / (double)totalTime;
                    double deltaEventRecvRate = (double)(this.numEventsRcvdCurrent - this.numEventsRcvdLast) * 1000.0 / (double)deltaTime;
                    double flowEventRecvRate = (double)this.numFlowEventsRcvdCurrent * 1000.0 / (double)totalTime;
                    double deltaFlowEventRecvRate = (double)(this.numFlowEventsRcvdCurrent - this.numFlowEventsRcvdLast) * 1000.0 / (double)deltaTime;
                    double txnRate = (double)this.numTransactionsCurrent * 1000.0 / (double)totalTime;
                    double deltaTxnRate = (double)(this.numTransactionsCurrent - this.numTransactionsLast) * 1000.0 / (double)deltaTime;
                    long avgNumFlowEventsPerTransaction = this.numCommitsStartedCurrent == 0L ? 0L : this.numFlowEventsProcSuccessCurrent / this.numCommitsStartedCurrent;
                    sb.append(String.format("Flows.{%s}", AppStats.this.format.format(this.numFlowsCurrent))).append("\n");
                    sb.append(String.format("Msg...{In{%s(%s %s) %s(%s %s) %s(%s %s) %s(%s %s) %sX(%s %s) (%s)}  Out{%s(%s %s) %s(%s %s) %s(%s %s) (%s %s %s %s) (%s)}}", AppStats.this.format.format(numMsgsRcvd), AppStats.this.format.format(msgRecvRate), AppStats.this.format.format(deltaMsgRecvRate), AppStats.this.format.format(this.numMsgsRcvdBestEffortCurrent), AppStats.this.format.format(bestEffortMsgRecvRate), AppStats.this.format.format(deltaBestEffortMsgRecvRate), AppStats.this.format.format(this.numMsgsRcvdGuaranteedCurrent), AppStats.this.format.format(guaranteedMsgRecvRate), AppStats.this.format.format(deltaGuaranteedMsgRecvRate), AppStats.this.format.format(this.numMsgsSourcedCurrent), AppStats.this.format.format(msgSourceRate), AppStats.this.format.format(deltaMsgSourceRate), AppStats.this.format.format(this.numMsgsFilteredCurrent), AppStats.this.format.format(msgFilterRate), AppStats.this.format.format(deltaMsgFilterRate), AppStats.this.format.format(this.numDupMsgsRcvdCurrent), AppStats.this.format.format(numMsgsSent), AppStats.this.format.format(msgSendRate), AppStats.this.format.format(deltaMsgSendRate), AppStats.this.format.format(this.numMsgsSentBestEffortCurrent), AppStats.this.format.format(bestEffortMsgSendRate), AppStats.this.format.format(deltaBestEffortMsgSendRate), AppStats.this.format.format(this.numMsgsSentGuaranteedCurrent), AppStats.this.format.format(guaranteedMsgSendRate), AppStats.this.format.format(deltaGuaranteedMsgSendRate), AppStats.this.format.format(this.outboundSno), AppStats.this.format.format(this.outboundStableSno), AppStats.this.format.format(this.backupOutboundQueueSize), AppStats.this.format.format(this.backupOutboundLogQueueSize), AppStats.this.format.format(this.numMsgsResentCurrent))).append("\n");
                    sb.append(String.format("Ev....{%s/%s(%s %s) %s[%s, %s, %s](%s %s)}", AppStats.this.format.format(this.numEventsProcessed), AppStats.this.format.format(this.numEventsRcvdCurrent), AppStats.this.format.format(eventRecvRate), AppStats.this.format.format(deltaEventRecvRate), AppStats.this.format.format(this.numFlowEventsRcvdCurrent), AppStats.this.format.format(this.numFlowEventsProcSuccessCurrent), AppStats.this.format.format(this.numFlowEventsProcFailCurrent), AppStats.this.format.format(this.numFlowEventsProcCompleteCurrent), AppStats.this.format.format(flowEventRecvRate), AppStats.this.format.format(deltaFlowEventRecvRate))).append("\n");
                    sb.append(String.format("Txn...{%s[(%s, %s),(%s, %s (%s)), (%s, %s (%s) (%s)), %s](%s %s) %s}", AppStats.this.format.format(this.numTransactionsCurrent), AppStats.this.format.format(this.numCommitsStartedCurrent), AppStats.this.format.format(this.numCommitsCompletedCurrent), AppStats.this.format.format(this.numSendCommitsStartedCurrent), AppStats.this.format.format(this.numSendCommitsCompletedCurrent), AppStats.this.format.format(this.sendCommitCompletionQueueSizeCurrent), AppStats.this.format.format(this.numStoreCommitsStartedCurrent), AppStats.this.format.format(this.numstoreCommitsCompletedCurrent), AppStats.this.format.format(this.storeCommitCompletionQueueSizeCurrent), AppStats.this.format.format(this.numRollbacksCurrent), AppStats.this.format.format(this.numPartialRollbacksCurrent), AppStats.this.format.format(txnRate), AppStats.this.format.format(deltaTxnRate), avgNumFlowEventsPerTransaction)).append("\n");
                    sb.append("[Message Type Specific]\n");
                    XIterator messageTypeStatsIt = this.msgTypeStatsTable.reuseableValueIterator();
                    int msgTypeStatsCount = 0;
                    while (messageTypeStatsIt.hasNext()) {
                        MessageTypeStats messageTypeStats = (MessageTypeStats)messageTypeStatsIt.next();
                        messageTypeStats.formatForPrint(deltaTime, totalTime, sb);
                        ++msgTypeStatsCount;
                    }
                    if (msgTypeStatsCount == 0) {
                        sb.append("...0 message types.\n");
                    }
                    sb.append("\n[Transaction Latencies]\n");
                    if (this.aepEngineStats.getMsgSendCoreLatencies() != null) {
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "mpproc", this.aepEngineStats.getMsgPreProcLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "mproc", this.aepEngineStats.getMsgProcessingLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "msend", this.aepEngineStats.getMsgSendLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "msendc", this.aepEngineStats.getMsgSendCoreLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "cstart", this.aepEngineStats.getCommitStartLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "csend", this.aepEngineStats.getCommitSendLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "cstore", this.aepEngineStats.getCommitStoreLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "cepilo", this.aepEngineStats.getCommitEpilogueLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "cfull", this.aepEngineStats.getCommitFullLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "tleg1", this.aepEngineStats.getTransactionLeg1ProcessingTimes(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "tleg2", this.aepEngineStats.getTransactionLeg2ProcessingTimes(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "tleg3", this.aepEngineStats.getTransactionLeg3ProcessingTimes(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "inout", this.aepEngineStats.getInOutLatencies(), sb);
                        SrvMonHeartbeatTracer.formatSeriesForPrint("", "inack", this.aepEngineStats.getInAckLatencies(), sb);
                    } else {
                        sb.append("...no transaction latencies found").append("\n");
                    }
                    sb.append("[Event Latencies]\n");
                    boolean numEventLatencies = false;
                    if (!numEventLatencies) {
                        sb.append("...no event latencies.").append("\n");
                    }
                }

                private final class MessageTypeStats {
                    final String name;
                    final short factoryid;
                    private long numMsgsRcvdBestEffortLast;
                    private long numMsgsRcvdGuaranteedLast;
                    private long numMsgsSourcedLast;
                    private long numMsgsSentBestEffortLast;
                    private long numMsgsSentGuaranteedLast;
                    private long numMsgsFilteredLast;
                    private long numDupMsgsRcvdLast;
                    private long numMsgsResentLast;
                    private long numMsgsRcvdBestEffortCurrent;
                    private long numMsgsRcvdGuaranteedCurrent;
                    private long numMsgsSourcedCurrent;
                    private long numMsgsSentBestEffortCurrent;
                    private long numMsgsSentGuaranteedCurrent;
                    private long numMsgsFilteredCurrent;
                    private long numDupMsgsRcvdCurrent;
                    private long numMsgsResentCurrent;
                    private SrvMonIntSeries messageCreateToOfferLatencies;
                    private SrvMonIntSeries messageOfferToPollLatencies;
                    private SrvMonIntSeries messageFilteringLatencies;
                    private SrvMonIntSeries messagePreProcessingLatencies;
                    private SrvMonIntSeries messageProcessingLatencies;

                    MessageTypeStats(String name, short factoryid, short typeid) {
                        this.name = name;
                        this.factoryid = factoryid;
                    }

                    private final void refresh(SrvMonMsgTypeStats stats) {
                        this.numMsgsRcvdBestEffortCurrent = stats.getNumMsgsRcvdBestEffort();
                        this.numMsgsRcvdGuaranteedCurrent = stats.getNumMsgsRcvdGuaranteed();
                        this.numMsgsSourcedCurrent = stats.getNumMsgsSourced();
                        this.numMsgsSentBestEffortCurrent = stats.getNumMsgsSentBestEffort();
                        this.numMsgsSentGuaranteedCurrent = stats.getNumMsgsSentGuaranteed();
                        this.numMsgsFilteredCurrent = stats.getNumMsgsFiltered();
                        this.numDupMsgsRcvdCurrent = stats.getNumDupMsgsRcvd();
                        this.numMsgsResentCurrent = stats.getNumMsgsResent();
                        this.messageCreateToOfferLatencies = stats.getMsgCreateToOfferLatencies();
                        this.messageOfferToPollLatencies = stats.getMsgOfferToPollLatencies();
                        this.messageFilteringLatencies = stats.getMsgFilteringLatencies();
                        this.messagePreProcessingLatencies = stats.getMsgPreProcessingLatencies();
                        this.messageProcessingLatencies = stats.getMsgProcessingLatencies();
                    }

                    final void stamp(SrvMonMsgTypeStats stats) {
                        this.numMsgsRcvdBestEffortLast = this.numMsgsRcvdBestEffortCurrent;
                        this.numMsgsRcvdGuaranteedLast = this.numMsgsRcvdGuaranteedCurrent;
                        this.numMsgsSourcedLast = this.numMsgsSourcedCurrent;
                        this.numMsgsSentBestEffortLast = this.numMsgsSentBestEffortCurrent;
                        this.numMsgsSentGuaranteedLast = this.numMsgsSentGuaranteedCurrent;
                        this.numMsgsFilteredLast = this.numMsgsFilteredCurrent;
                        this.numDupMsgsRcvdLast = this.numDupMsgsRcvdCurrent;
                        this.numMsgsResentLast = this.numMsgsResentCurrent;
                        this.messageCreateToOfferLatencies = null;
                        this.messageOfferToPollLatencies = null;
                        this.messageFilteringLatencies = null;
                        this.messagePreProcessingLatencies = null;
                        this.messageProcessingLatencies = null;
                        this.refresh(stats);
                    }

                    final void formatForPrint(long deltaTime, long deltaTotalTime, StringBuilder sb) {
                        String numMsgsRcvdStr = AppStats.this.format.format(this.numMsgsRcvdBestEffortCurrent + this.numMsgsRcvdGuaranteedCurrent);
                        String msgRecvRateStr = AppStats.this.format.format((this.numMsgsRcvdBestEffortCurrent + this.numMsgsRcvdGuaranteedCurrent) * 1000L / deltaTotalTime);
                        String deltaMsgRecvRateStr = AppStats.this.format.format((this.numMsgsRcvdBestEffortCurrent + this.numMsgsRcvdGuaranteedCurrent - (this.numMsgsRcvdBestEffortLast + this.numMsgsRcvdGuaranteedLast)) * 1000L / deltaTime);
                        String numMsgsRcvdBestEffortStr = AppStats.this.format.format(this.numMsgsRcvdBestEffortCurrent);
                        String bestEffortMsgRecvRateStr = AppStats.this.format.format(this.numMsgsRcvdBestEffortCurrent * 1000L / deltaTotalTime);
                        String deltaBestEffortMsgRecvRateStr = AppStats.this.format.format((this.numMsgsRcvdBestEffortCurrent - this.numMsgsRcvdBestEffortLast) * 1000L / deltaTime);
                        String numMsgsRcvdGuaranteedStr = AppStats.this.format.format(this.numMsgsRcvdGuaranteedCurrent);
                        String guaranteedMsgRecvRateStr = AppStats.this.format.format(this.numMsgsRcvdGuaranteedCurrent * 1000L / deltaTotalTime);
                        String deltaGuaranteedMsgRecvRateStr = AppStats.this.format.format((this.numMsgsRcvdGuaranteedCurrent - this.numMsgsRcvdGuaranteedLast) * 1000L / deltaTime);
                        String numMsgsFilteredStr = AppStats.this.format.format(this.numMsgsFilteredCurrent);
                        String msgFilteredRateStr = AppStats.this.format.format(this.numMsgsFilteredCurrent * 1000L / deltaTotalTime);
                        String deltaMsgFilteredRateStr = AppStats.this.format.format((this.numMsgsFilteredCurrent - this.numMsgsFilteredLast) * 1000L / deltaTime);
                        String numMsgsSourcedStr = AppStats.this.format.format(this.numMsgsSourcedCurrent);
                        String msgSourceRateStr = AppStats.this.format.format(this.numMsgsSourcedCurrent * 1000L / deltaTotalTime);
                        String deltaMsgSourceRateStr = AppStats.this.format.format((this.numMsgsSourcedCurrent - this.numMsgsSourcedLast) * 1000L / deltaTime);
                        String numDupMsgsRcvdStr = AppStats.this.format.format(this.numDupMsgsRcvdCurrent);
                        String msgDupsRateStr = AppStats.this.format.format(this.numDupMsgsRcvdCurrent * 1000L / deltaTotalTime);
                        String deltaMsgDupsRateStr = AppStats.this.format.format((this.numDupMsgsRcvdCurrent - this.numDupMsgsRcvdLast) * 1000L / deltaTime);
                        String numMsgsSentStr = AppStats.this.format.format(this.numMsgsSentBestEffortCurrent + this.numMsgsSentGuaranteedCurrent);
                        String msgSendRateStr = AppStats.this.format.format((this.numMsgsSentBestEffortCurrent + this.numMsgsSentGuaranteedCurrent) * 1000L / deltaTotalTime);
                        String deltaMsgSendRateStr = AppStats.this.format.format((this.numMsgsSentBestEffortCurrent + this.numMsgsSentGuaranteedCurrent - (this.numMsgsSentBestEffortLast + this.numMsgsSentGuaranteedLast)) * 1000L / deltaTime);
                        String numMsgsSentBestEffortStr = AppStats.this.format.format(this.numMsgsSentBestEffortCurrent);
                        String bestEffortMsgSendRateStr = AppStats.this.format.format(this.numMsgsSentBestEffortCurrent * 1000L / deltaTotalTime);
                        String deltaBestEffortMsgSendRateStr = AppStats.this.format.format((this.numMsgsSentBestEffortCurrent - this.numMsgsSentBestEffortLast) * 1000L / deltaTime);
                        String numMsgsSentGuaranteedStr = AppStats.this.format.format(this.numMsgsSentGuaranteedCurrent);
                        String guaranteedMsgSendRateStr = AppStats.this.format.format(this.numMsgsSentGuaranteedCurrent * 1000L / deltaTotalTime);
                        String deltaGuaranteedMsgSendRateStr = AppStats.this.format.format((this.numMsgsSentGuaranteedCurrent - this.numMsgsSentGuaranteedLast) * 1000L / deltaTime);
                        String numMsgsResentStr = AppStats.this.format.format(this.numMsgsResentCurrent);
                        String msgResentRateStr = AppStats.this.format.format(this.numMsgsResentCurrent * 1000L / deltaTotalTime);
                        String deltaMsgResentRateStr = AppStats.this.format.format((this.numMsgsResentCurrent - this.numMsgsResentLast) * 1000L / deltaTime);
                        sb.append(this.factoryid).append(".").append(this.name);
                        sb.append(" In{");
                        sb.append(numMsgsRcvdStr + "(" + msgRecvRateStr + " " + deltaMsgRecvRateStr + ") ");
                        sb.append(numMsgsRcvdBestEffortStr + "(" + bestEffortMsgRecvRateStr + " " + deltaBestEffortMsgRecvRateStr + ") ");
                        sb.append(numMsgsRcvdGuaranteedStr + "(" + guaranteedMsgRecvRateStr + " " + deltaGuaranteedMsgRecvRateStr + ") ");
                        sb.append(numMsgsSourcedStr + "(" + msgSourceRateStr + " " + deltaMsgSourceRateStr + ") ");
                        sb.append(numMsgsFilteredStr + "(" + msgFilteredRateStr + " " + deltaMsgFilteredRateStr + ") ");
                        sb.append("(" + numDupMsgsRcvdStr + "(" + msgDupsRateStr + " " + deltaMsgDupsRateStr + ") )");
                        sb.append("}");
                        sb.append(" Out{");
                        sb.append(numMsgsSentStr + "(" + msgSendRateStr + " " + deltaMsgSendRateStr + ") ");
                        sb.append(numMsgsSentBestEffortStr + "(" + bestEffortMsgSendRateStr + " " + deltaBestEffortMsgSendRateStr + ") ");
                        sb.append(numMsgsSentGuaranteedStr + "(" + guaranteedMsgSendRateStr + " " + deltaGuaranteedMsgSendRateStr + ") ");
                        sb.append("(" + numMsgsResentStr + "(" + msgResentRateStr + " " + deltaMsgResentRateStr + ") )");
                        sb.append("}");
                        sb.append("\n");
                        sb.append("...[Latencies]");
                        sb.append("\n");
                        int sbLen = sb.length();
                        if (this.messageCreateToOfferLatencies != null) {
                            SrvMonHeartbeatTracer.formatSeriesForPrint("...", "c2o", this.messageCreateToOfferLatencies, sb);
                        }
                        if (this.messageOfferToPollLatencies != null) {
                            SrvMonHeartbeatTracer.formatSeriesForPrint("...", "o2p", this.messageOfferToPollLatencies, sb);
                        }
                        if (this.messagePreProcessingLatencies != null) {
                            SrvMonHeartbeatTracer.formatSeriesForPrint("...", "mpproc", this.messagePreProcessingLatencies, sb);
                        }
                        if (this.messageProcessingLatencies != null) {
                            SrvMonHeartbeatTracer.formatSeriesForPrint("...", "mproc", this.messageProcessingLatencies, sb);
                        }
                        if (this.messageFilteringLatencies != null) {
                            SrvMonHeartbeatTracer.formatSeriesForPrint("...", "mfilt", this.messageFilteringLatencies, sb);
                        }
                        if (sbLen == sb.length()) {
                            sb.append("......<none available>\n");
                        }
                    }
                }
            }
        }

        public static enum EntityType {
            Engine,
            UserStat,
            EventMultiplexer,
            StoreBinding,
            StoreBindingPersister,
            StoreBindingICRSender,
            BusBinding;

        }
    }

    private static final class MessageLoggerStats {
        private final NumberFormat format;
        private final String name;
        private long numMessagesRecorded;
        private long numCommitsLast;
        private long numForksLast;
        private long fileSizeLast;
        private long fileSizeUsedLast;
        private long numSendsRecordedCurrent;
        private long numCommitsCurrent;
        private long numForksCurrent;
        private long fileSizeCurrent;
        private long fileSizeUsedCurrent;
        private SrvMonAppMessageLoggerStats messageLoggerStats;

        MessageLoggerStats(String name, SrvMonAppMessageLoggerStats stats) {
            this.name = name;
            this.format = NumberFormat.getInstance();
            this.format.setMaximumFractionDigits(2);
            this.refresh(stats);
        }

        private final void refresh(SrvMonAppMessageLoggerStats stats) {
            this.numSendsRecordedCurrent = stats.getNumMessagesRecorded();
            this.numCommitsCurrent = stats.getNumCommits();
            this.numForksCurrent = stats.getNumForks();
            this.fileSizeCurrent = stats.getFileSize();
            this.fileSizeUsedCurrent = stats.getFileSizeUsed();
            this.messageLoggerStats = stats;
        }

        final void stamp(SrvMonAppMessageLoggerStats stats) {
            this.numMessagesRecorded = this.numSendsRecordedCurrent;
            this.numCommitsLast = this.numCommitsCurrent;
            this.numForksLast = this.numForksCurrent;
            this.fileSizeLast = this.fileSizeCurrent;
            this.fileSizeUsedLast = this.fileSizeUsedCurrent;
            this.refresh(stats);
        }

        final void formatForPrint(long deltaTime, long totalTime, StringBuilder sb) {
            double sendRecordRate = (double)this.numSendsRecordedCurrent * 1000.0 / (double)totalTime;
            double deltaSendRecordRate = (double)(this.numSendsRecordedCurrent - this.numMessagesRecorded) * 1000.0 / (double)deltaTime;
            double commitRate = (double)this.numCommitsCurrent * 1000.0 / (double)totalTime;
            double deltaCommitRate = (double)(this.numCommitsCurrent - this.numCommitsLast) * 1000.0 / (double)deltaTime;
            double forkRate = (double)this.numForksCurrent * 1000.0 / (double)totalTime;
            double deltaForkRate = (double)(this.numForksCurrent - this.numForksLast) * 1000.0 / (double)deltaTime;
            double fileSizeRate = (double)this.fileSizeCurrent * 1000.0 / (double)totalTime;
            double deltaFileSizeRate = (double)(this.fileSizeCurrent - this.fileSizeLast) * 1000.0 / (double)deltaTime;
            double fileSizeUsedRate = (double)this.fileSizeUsedCurrent * 1000.0 / (double)totalTime;
            double deltaFileSizeUsedRate = (double)(this.fileSizeUsedCurrent - this.fileSizeUsedLast) * 1000.0 / (double)deltaTime;
            sb.append("[").append(this.name).append("]").append("\n");
            sb.append(String.format("Messages {%s(%s %s)} Commits {%s(%s %s)} Forks {%s(%s %s)}", this.format.format(this.numSendsRecordedCurrent), this.format.format(sendRecordRate), this.format.format(deltaSendRecordRate), this.format.format(this.numCommitsCurrent), this.format.format(commitRate), this.format.format(deltaCommitRate), this.format.format(this.numForksCurrent), this.format.format(forkRate), this.format.format(deltaForkRate))).append("\n");
            this.formatForPrint(this.messageLoggerStats.getDisruptorStats(), sb);
            sb.append(String.format("Disk Size{%s(%s %s)} Used{%s(%s %s)}", UtlFile.readableFileSize((long)this.fileSizeCurrent), UtlFile.readableFileSize((long)((long)fileSizeRate)), UtlFile.readableFileSize((long)((long)deltaFileSizeRate)), UtlFile.readableFileSize((long)this.fileSizeUsedCurrent), UtlFile.readableFileSize((long)((long)fileSizeUsedRate)), UtlFile.readableFileSize((long)((long)deltaFileSizeUsedRate)))).append("\n");
        }

        final void formatForPrint(SrvMonDisruptorStats stats, StringBuilder sb) {
            sb.append("Disruptor {");
            if (stats != null) {
                int capacity = stats.getCapacity();
                int remaining = stats.getRemaining();
                int used = capacity - remaining;
                int usagePct = used * 100 / capacity;
                sb.append("[").append(this.format.format(used)).append(" of ").append(this.format.format(capacity)).append("] ").append(usagePct).append("%").append(" (").append((Object)stats.getClaimStrategy()).append(", ").append((Object)stats.getWaitStrategy()).append(")");
            } else {
                sb.append("\n").append("... No Disruptor stats available").append("\n");
            }
            sb.append("}");
            if (stats != null) {
                sb.append("\n");
                SrvMonHeartbeatTracer.formatSeriesForPrint("", "o2p", stats.getOfferToPollLatencies(), sb);
            }
            sb.append("\n");
        }
    }

    public static class AdminClients {
        private final void formatHeaderForPrint(StringBuilder sb) {
            sb.append(String.format("%-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-8s %-8s  %s", "LSENT", "TSENT", "TDROP", "HSENT", "HDROP", "FSCHD", "FEXEC", "OQCAP", "OQSIZ", "OQCNT", "OQFSIZ", "OQFCNT", "NAME")).append("\n");
        }

        public final StringBuilder formatForPrint(XIterator<SrvMonAdminClientStats> stats, StringBuilder sb) {
            this.formatHeaderForPrint(sb);
            if (!stats.hasNext()) {
                return sb;
            }
            while (stats.hasNext()) {
                SrvMonAdminClientStats stat = (SrvMonAdminClientStats)stats.next();
                sb.append(String.format("%-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-8s %-8s %s", SrvMonHeartbeatTracer.counterToStr(stat.getLifecyclesSent()), SrvMonHeartbeatTracer.counterToStr(stat.getTracesSent()), SrvMonHeartbeatTracer.counterToStr(stat.getTracesDropped()), SrvMonHeartbeatTracer.counterToStr(stat.getHeartbeatsSent()), SrvMonHeartbeatTracer.counterToStr(stat.getHeartbeatsDropped()), SrvMonHeartbeatTracer.counterToStr(stat.getFlushesScheduled()), SrvMonHeartbeatTracer.counterToStr(stat.getFlushesExecuted()), SrvMonHeartbeatTracer.counterToStr(stat.getOutboundQueueCapacity()), SrvMonHeartbeatTracer.counterToStr(stat.getOutboundQueueSize()), SrvMonHeartbeatTracer.counterToStr(stat.getOutboundQueueCount()), SrvMonHeartbeatTracer.counterToStr(stat.getOutboundQueueFlushSize()), SrvMonHeartbeatTracer.counterToStr(stat.getOutboundQueueFlushCount()), stat.getName())).append("\n");
            }
            return sb;
        }
    }

    public static final class Pools {
        private final XLinkedHashMap<String, PoolStats> poolsStats = new XLinkedHashMap();
        private final float depletionThreshold;

        public Pools() {
            float value = 1.0f;
            if (value <= 0.0f) {
                value = 101.0f;
            }
            this.depletionThreshold = value;
        }

        private final void formatHeaderForPrint(StringBuilder sb) {
            sb.append(String.format("%-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %s", "PUT", "DPUT", "GET", "DGET", "HIT", "DHIT", "MISS", "DMISS", "GROW", "DGROW", "EVIC", "DEVIC", "DWSH", "DDWSH", "PRE", "SIZE", "CAP", "MAX", "NAME")).append("\n");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final StringBuilder formatForPrint(XIterator<SrvMonPoolStats> stats, StringBuilder sb) {
            this.formatHeaderForPrint(sb);
            if (!stats.hasNext()) {
                return sb;
            }
            XLinkedHashMap<String, PoolStats> xLinkedHashMap = this.poolsStats;
            synchronized (xLinkedHashMap) {
                while (stats.hasNext()) {
                    SrvMonPoolStats stat = (SrvMonPoolStats)stats.next();
                    PoolStats poolStats = (PoolStats)this.poolsStats.get((Object)stat.getKey());
                    if (poolStats == null) {
                        poolStats = new PoolStats(stat);
                        this.poolsStats.put((Object)stat.getKey(), (Object)poolStats);
                    }
                    long putsCurrent = stat.getPuts();
                    long getsCurrent = stat.getGets();
                    long hitsCurrent = stat.getHits();
                    long missesCurrent = stat.getMisses();
                    long growthsCurrent = stat.getGrowths();
                    long evictsCurrent = stat.getEvicts();
                    long dwashesCurrent = stat.getDetachedWashes();
                    int sizeCurrent = stat.getSize();
                    int capacityCurrent = stat.getCapacity();
                    sb.append(String.format("%-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %s", SrvMonHeartbeatTracer.counterToStr(putsCurrent), SrvMonHeartbeatTracer.counterToStr(putsCurrent - poolStats.putsLast), SrvMonHeartbeatTracer.counterToStr(getsCurrent), SrvMonHeartbeatTracer.counterToStr(getsCurrent - poolStats.getsLast), SrvMonHeartbeatTracer.counterToStr(hitsCurrent), SrvMonHeartbeatTracer.counterToStr(hitsCurrent - poolStats.hitsLast), SrvMonHeartbeatTracer.counterToStr(missesCurrent), SrvMonHeartbeatTracer.counterToStr(missesCurrent - poolStats.missesLast), SrvMonHeartbeatTracer.counterToStr(growthsCurrent), SrvMonHeartbeatTracer.counterToStr(growthsCurrent - poolStats.growthsLast), SrvMonHeartbeatTracer.counterToStr(evictsCurrent), SrvMonHeartbeatTracer.counterToStr(evictsCurrent - poolStats.evictsLast), SrvMonHeartbeatTracer.counterToStr(dwashesCurrent), SrvMonHeartbeatTracer.counterToStr(dwashesCurrent - poolStats.dwashesLast), SrvMonHeartbeatTracer.counterToStr(stat.getPreallocated()), SrvMonHeartbeatTracer.counterToStr(sizeCurrent), SrvMonHeartbeatTracer.counterToStr(capacityCurrent), SrvMonHeartbeatTracer.counterToStr(stat.getMaxCapacity()), stat.getKey())).append("\n");
                    poolStats.stamp(putsCurrent, getsCurrent, hitsCurrent, missesCurrent, growthsCurrent, evictsCurrent, dwashesCurrent, stat.getSize());
                }
            }
            return sb;
        }

        private final class PoolStats {
            final int depletionThresholdDecrement;
            private long putsLast;
            private long getsLast;
            private long hitsLast;
            private long missesLast;
            private long growthsLast;
            private long evictsLast;
            private long dwashesLast;
            private int nextDepletionThreshold = -1;

            PoolStats(SrvMonPoolStats stats) {
                this.stamp(stats.getPuts(), stats.getGets(), stats.getHits(), stats.getMisses(), stats.getGrowths(), stats.getEvicts(), stats.getDetachedWashes(), stats.getSize());
                if (stats.getPreallocated() > 0 && stats.getSize() > 0 && Pools.this.depletionThreshold <= 100.0f) {
                    this.depletionThresholdDecrement = (int)((float)stats.getPreallocated() * Pools.this.depletionThreshold / 100.0f);
                    this.nextDepletionThreshold = Math.max(0, stats.getPreallocated() - this.depletionThresholdDecrement);
                } else {
                    this.depletionThresholdDecrement = 0;
                    this.nextDepletionThreshold = -1;
                }
            }

            final void stamp(long puts, long gets, long hits, long misses, long growths, long evicts, long dwashes, int size) {
                this.putsLast = puts;
                this.getsLast = gets;
                this.hitsLast = hits;
                this.missesLast = misses;
                this.growthsLast = growths;
                this.evictsLast = evicts;
                this.dwashesLast = dwashes;
                if (this.isAtOrBelowDepletionThreshold(size)) {
                    while (this.nextDepletionThreshold >= size) {
                        this.nextDepletionThreshold -= this.depletionThresholdDecrement;
                    }
                }
            }

            final boolean isAtOrBelowDepletionThreshold(int size) {
                if (this.depletionThresholdDecrement > 0) {
                    return size <= this.nextDepletionThreshold;
                }
                return false;
            }
        }
    }

    public static class Threads {
        private final Map<Long, ThreadStats> threadsStats = new TreeMap<Long, ThreadStats>();
        private final DecimalFormat percentFormat = new DecimalFormat("#.#");

        private final void formatHeaderForPrint(StringBuilder sb) {
            sb.append(String.format("%-5s %-9s %-7s %-7s %-5s %-5s %-5s %-15s %s", "ID", "CPU", "DCPU", "DUSER", "CPU%", "USER%", "WAIT%", "STATE", "NAME")).append("\n");
        }

        public final StringBuilder formatForPrint(SrvMonSysStats stats, StringBuilder sb) {
            if (!stats.hasThreadStats() || stats.getThreadStats().getIndividualThreadStats() == null) {
                sb.append("...None Reported\n");
                return sb;
            }
            this.formatHeaderForPrint(sb);
            for (ThreadStats threadStats : this.threadsStats.values()) {
                threadStats.clearExists();
            }
            for (SrvMonSysIndividualThreadStats individualThreadStats : stats.getThreadStats().getIndividualThreadStats()) {
                ThreadStats threadStats = this.threadsStats.get(individualThreadStats.getId());
                if (threadStats == null) {
                    threadStats = new ThreadStats(individualThreadStats);
                    this.threadsStats.put(individualThreadStats.getId(), threadStats);
                }
                threadStats.stamp(individualThreadStats);
            }
            Iterator<ThreadStats> iterator = this.threadsStats.values().iterator();
            while (iterator.hasNext()) {
                if (iterator.next().exists) continue;
                iterator.remove();
            }
            for (ThreadStats threadStats : this.threadsStats.values()) {
                long cpuTimeDelta = threadStats.cpuTimeCurrent - threadStats.cpuTimeLast;
                long usrTimeDelta = threadStats.usrTimeCurrent - threadStats.usrTimeLast;
                long waitTimeDelta = threadStats.waitTimeCurrent - threadStats.waitTimeLast;
                long collectTimeDelta = threadStats.collectTimeCurrent - threadStats.collectTimeLast;
                double cpuTimePct = threadStats.collectTimeLast > 0L ? Math.min(100.0, (double)cpuTimeDelta * 100.0 / (double)collectTimeDelta) : 0.0;
                double usrTimePct = Math.min(100.0, (double)usrTimeDelta * 100.0 / (double)collectTimeDelta);
                double waitTimePct = Math.min(100.0, (double)waitTimeDelta * 100.0 / (double)collectTimeDelta);
                if (threadStats.collectTimeLast > 0L) {
                    sb.append(String.format("%-5d %-9s %-7s %-7s %-5s %-5s %-5s %-15s %s", threadStats.id, UtlUnit.formatDuration((double)threadStats.cpuTimeCurrent, (TimeUnit)TimeUnit.NANOSECONDS), threadStats.collectTimeLast > 0L ? UtlUnit.formatDuration((double)cpuTimeDelta, (TimeUnit)TimeUnit.NANOSECONDS) : "-", threadStats.collectTimeLast > 0L ? UtlUnit.formatDuration((double)usrTimeDelta, (TimeUnit)TimeUnit.NANOSECONDS) : "-", this.percentFormat.format(cpuTimePct), this.percentFormat.format(usrTimePct), this.percentFormat.format(waitTimePct), threadStats.state, threadStats.name)).append("\n");
                    continue;
                }
                sb.append(String.format("%-5d %-9s %-7s %-7s %-5s %-5s %-5s %-15s %s", threadStats.id, UtlUnit.formatDuration((double)threadStats.cpuTimeCurrent, (TimeUnit)TimeUnit.NANOSECONDS), "-", "-", "-", "-", "-", threadStats.state, threadStats.name)).append("\n");
            }
            return sb;
        }

        private final class ThreadStats {
            private final long id;
            private String name;
            private String state;
            private long cpuTimeLast;
            private long usrTimeLast;
            private long waitTimeLast;
            private long collectTimeLast;
            private long cpuTimeCurrent;
            private long usrTimeCurrent;
            private long waitTimeCurrent;
            private long collectTimeCurrent;
            private boolean exists;

            ThreadStats(SrvMonSysIndividualThreadStats individualThreadStats) {
                this.id = individualThreadStats.getId();
                this.name = individualThreadStats.getName();
                this.init(individualThreadStats);
            }

            private final void init(SrvMonSysIndividualThreadStats individualThreadStats) {
                this.cpuTimeCurrent = individualThreadStats.getCpuTime();
                this.usrTimeCurrent = individualThreadStats.getUsrTime();
                this.state = individualThreadStats.getState();
            }

            final void clearExists() {
                this.exists = false;
            }

            final void stamp(SrvMonSysIndividualThreadStats individualThreadStats) {
                this.cpuTimeLast = this.cpuTimeCurrent;
                this.cpuTimeCurrent = individualThreadStats.getCpuTime();
                this.usrTimeLast = this.usrTimeCurrent;
                this.usrTimeCurrent = individualThreadStats.getUsrTime();
                this.waitTimeLast = this.waitTimeCurrent;
                this.waitTimeCurrent = individualThreadStats.getWaitTime();
                this.collectTimeLast = this.collectTimeCurrent;
                this.collectTimeCurrent = individualThreadStats.getCollectTime();
                this.state = individualThreadStats.getState();
                if (individualThreadStats.hasName() && individualThreadStats.getNameUnsafe().length() != this.name.length()) {
                    this.name = individualThreadStats.getName();
                }
                this.exists = true;
            }
        }
    }

    public static final class Sys {
        public static final void formatGeneralInfoForPrint(long collectionStartWallTime, String serverName, String serverPid, int appCount, long collectionElapsedTime, StringBuilder sb) {
            sb.append(String.format("%s '%s' server (pid=%s) %d apps (collection time=%d ns)", new Date(collectionStartWallTime), serverName, serverPid, appCount, collectionElapsedTime)).append("\n");
        }

        public static final void formatSystemInfoForPrint(SrvMonSysStats stats, StringBuilder sb) {
            sb.append(String.format("System: %d processors, load average: %.2f (load %.2f process, %.2f total system)", stats.getAvailableProcessors(), stats.getSystemLoadAverage(), stats.getProcessCpuLoad(), stats.getSystemCpuLoad())).append("\n");
        }

        public static final void formatMemoryInfoForPrint(SrvMonSysStats stats, StringBuilder sb) {
            sb.append(String.format("Memory (system): %s total, %s free, %s committed (Swap: %s total, %s free)", SrvMonHeartbeatTracer.memToStr(stats.getMemoryStats().getTotalPhysicalMemorySize()), SrvMonHeartbeatTracer.memToStr(stats.getMemoryStats().getFreePhysicalMemorySize()), SrvMonHeartbeatTracer.memToStr(stats.getMemoryStats().getCommittedVirtualMemorySize()), SrvMonHeartbeatTracer.memToStr(stats.getMemoryStats().getTotalSwapSpaceSize()), SrvMonHeartbeatTracer.memToStr(stats.getMemoryStats().getFreeSwapSpaceSize()))).append("\n");
            sb.append(String.format("Memory (proc): HEAP %s init, %s used, %s commit, %s max NON-HEAP %s init, %s used, %s commit, %s max OFF-HEAP %s live, %s pooled", SrvMonHeartbeatTracer.memToStr(stats.getMemoryStats().getHeapUsage().getInit()), SrvMonHeartbeatTracer.memToStr(stats.getMemoryStats().getHeapUsage().getUsed()), SrvMonHeartbeatTracer.memToStr(stats.getMemoryStats().getHeapUsage().getCommitted()), SrvMonHeartbeatTracer.memToStr(stats.getMemoryStats().getHeapUsage().getMax()), SrvMonHeartbeatTracer.memToStr(stats.getMemoryStats().getNonHeapUsage().getInit()), SrvMonHeartbeatTracer.memToStr(stats.getMemoryStats().getNonHeapUsage().getUsed()), SrvMonHeartbeatTracer.memToStr(stats.getMemoryStats().getNonHeapUsage().getCommitted()), SrvMonHeartbeatTracer.memToStr(stats.getMemoryStats().getNonHeapUsage().getMax()), SrvMonHeartbeatTracer.memToStr(stats.getMemoryStats().getOffHeapUsage().getUsedLive()), SrvMonHeartbeatTracer.memToStr(stats.getMemoryStats().getOffHeapUsage().getUsedPooled()))).append("\n");
        }

        public static final void formatDiskInfoForPrint(SrvMonSysStats stats, StringBuilder sb) {
            XIterator<SrvMonSysDiskStats> i = stats.getDiskStatsIterator();
            sb.append("Disk:\n");
            while (i.hasNext()) {
                SrvMonSysDiskStats diskStats = (SrvMonSysDiskStats)i.next();
                sb.append(String.format(String.format("  [%s Total: %s, Usable: %5s, Free: %5s]\n", diskStats.getRootPath(), UtlFile.readableFileSize((long)diskStats.getTotalSpace()), UtlFile.readableFileSize((long)diskStats.getUsableSpace()), UtlFile.readableFileSize((long)diskStats.getFreeSpace())), new Object[0]));
            }
        }

        public static final void formatThreadInfoForPrint(SrvMonSysStats stats, StringBuilder sb) {
            if (stats.hasThreadStats()) {
                sb.append(String.format("Threads: %d total (%d daemon) %d peak", stats.getThreadStats().getThreadCount(), stats.getThreadStats().getDaemonThreadCount(), stats.getThreadStats().getPeakThreadCount())).append("\n");
            }
        }

        public static final void formatJITInfoForPrint(SrvMonSysStats stats, StringBuilder sb) {
            sb.append(String.format("JIT: %s, time: %d ms", stats.getJitStats().getName(), stats.getJitStats().getTotalCompilationTime())).append("\n");
        }

        public static final void formatGCInfoForPrint(SrvMonSysStats stats, StringBuilder sb) {
            sb.append("GC:\n");
            int count = 0;
            for (SrvMonSysGCCollectorStats collectorStats : stats.getGcStats().getCollectorsStats()) {
                sb.append(String.format("...%s [%d collections, commulative time: %d ms]\n", collectorStats.getCollectorName(), collectorStats.getCollectionCount(), collectorStats.getCollectionTime()));
                ++count;
            }
            if (count == 0) {
                sb.append("...None Reported\n");
            }
        }

        public static final StringBuilder formatForPrint(long collectionStartWallTime, String serverName, String serverPid, int appCount, SrvMonSysStats stats, long collectionElapsedTime, StringBuilder sb) {
            Sys.formatGeneralInfoForPrint(collectionStartWallTime, serverName, serverPid, appCount, collectionElapsedTime, sb);
            Sys.formatSystemInfoForPrint(stats, sb);
            Sys.formatMemoryInfoForPrint(stats, sb);
            Sys.formatDiskInfoForPrint(stats, sb);
            Sys.formatThreadInfoForPrint(stats, sb);
            Sys.formatJITInfoForPrint(stats, sb);
            Sys.formatGCInfoForPrint(stats, sb);
            return sb;
        }
    }
}

