/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.client;

import com.neeve.client.ClientConnectionPoolEvents;
import com.neeve.client.ClientObject;
import com.neeve.client.EClientException;
import com.neeve.client.EClientOpFailedException;
import com.neeve.client.EClientOpTimeoutException;
import com.neeve.client.IClientConnectionPoolEventHandler;
import com.neeve.link.ILnkMessageFactory;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkRequest;
import com.neeve.pkt.PktPacket;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;

public abstract class ClientConnectionPool
extends ClientObject {
    private final IClientConnectionPoolEventHandler eventHandler;
    protected volatile State state;
    protected volatile ILnkMessageFactory messageFactory;

    protected ClientConnectionPool(IClientConnectionPoolEventHandler eventHandler) {
        this.eventHandler = eventHandler;
        this.state = State.INIT;
    }

    protected final IllegalStateException prepareIllegalStateException(State expected, State actual) {
        return new IllegalStateException("Illegal client connection state [exp=" + (Object)((Object)expected) + ", actual=" + (Object)((Object)actual) + "]");
    }

    protected final void dispatchEvent(int event, Object eventData) {
        if (this.eventHandler != null) {
            try {
                this.eventHandler.onEvent(this, event, eventData);
            }
            catch (Throwable e) {
                StringBuilder sb = new StringBuilder();
                sb.append("Client connection pool event handler [" + this.eventHandler + "] faulted with error [" + e.toString() + "] on event {" + event + "} with the following stack trace:\n");
                sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                sb.append("Ignoring...\n");
                this.tracer.log(sb.toString(), Tracer.Level.WARNING);
            }
        }
    }

    protected abstract boolean canSetMessageFactory();

    protected abstract void doOpen() throws EClientException;

    protected abstract boolean doSendStreaming(PktPacket var1, ILnkPeerEndpoint.FlushContext var2, int var3) throws EClientOpFailedException;

    protected abstract LnkRequest doSendSync(PktPacket var1, int var2) throws EClientOpTimeoutException, EClientOpFailedException;

    protected abstract void doFlush(ILnkPeerEndpoint.FlushContext var1) throws EClientException;

    protected abstract void doClose();

    protected final void onFailure(Exception e) {
        this.state = State.FAILED;
        this.dispatchEvent(7, new ClientConnectionPoolEvents.FailEventData(e));
    }

    public final State getState() {
        return this.state;
    }

    public final void setMessageFactory(ILnkMessageFactory messageFactory) {
        if (this.state == State.INIT) {
            if (messageFactory != null && !this.canSetMessageFactory()) {
                throw new UnsupportedOperationException("this connection pool implementation does not support user message factories");
            }
        } else {
            throw this.prepareIllegalStateException(State.INIT, this.state);
        }
        this.messageFactory = messageFactory;
    }

    public final void open() throws EClientException {
        if (this.state != State.INIT) {
            throw this.prepareIllegalStateException(State.INIT, this.state);
        }
        this.doOpen();
        this.state = State.OPEN;
    }

    public final boolean sendStreaming(PktPacket packet, ILnkPeerEndpoint.FlushContext flushContext, int flags) throws EClientOpFailedException {
        if (this.state == State.OPEN) {
            return this.doSendStreaming(packet, flushContext, flags);
        }
        throw this.prepareIllegalStateException(State.OPEN, this.state);
    }

    public final LnkRequest sendSync(PktPacket packet, int timeout) throws EClientOpTimeoutException, EClientOpFailedException {
        if (this.state == State.OPEN) {
            return this.doSendSync(packet, timeout);
        }
        throw this.prepareIllegalStateException(State.OPEN, this.state);
    }

    public final void flush(ILnkPeerEndpoint.FlushContext flushContext) throws EClientException {
        if (this.state != State.OPEN) {
            throw this.prepareIllegalStateException(State.OPEN, this.state);
        }
        this.doFlush(flushContext);
    }

    public final void close() {
        if (this.state != State.CLOSED) {
            try {
                if (this.state != State.INIT) {
                    this.doClose();
                }
            }
            finally {
                this.state = State.CLOSED;
            }
        }
    }

    public static enum State {
        INIT,
        OPEN,
        FAILED,
        CLOSED;

    }
}

