/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.test.unit.AepEngineQuiescenceTestAppDefaultHandler;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestApp;
import com.neeve.aep.test.unit.AepEngineTestAppAnnotatedHandlers;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.ci.XRuntime;
import com.neeve.event.IEventHandler;
import java.io.File;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AepEngineQuiescenceTest
extends AepEngineTest {
    private final Random random = new Random(System.currentTimeMillis());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public final void testEnableWaitForQuiescenceOnNonQuiescentBus() throws Exception {
        XRuntime.getProps().setProperty("nv.sma.qosoverride", "Guaranteed");
        try {
            AepEngineTestAppAnnotatedHandlers senderHandlers = new AepEngineTestAppAnnotatedHandlers();
            AepEngineQuiescenceTestAppDefaultHandler receiverHandlers = new AepEngineQuiescenceTestAppDefaultHandler();
            this.startSenderStandaloneReceiverStandalone(senderHandlers, null, null, null, receiverHandlers, 15, 15, 15, 0, AepEngine.HAPolicy.EventSourcing, false, false);
            receiverHandlers.setBlockOnMessageReceipt();
            try {
                ((AepEngine)((Object)this.engines.get(0))).sendMessage(senderHandlers.channel4, new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto).getMessage());
                Assert.assertTrue((boolean)receiverHandlers.waitForMessageReceipt(0));
                this.messagingController.enableWaitForQuiescence("aeptest1", true);
            }
            finally {
                receiverHandlers.releaseMessageReceiptBlock();
            }
        }
        finally {
            XRuntime.getProps().remove("nv.sma.qosoverride");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public final void testDisableWaitForQuiescenceOnNonQuiescentBus() throws Exception {
        XRuntime.getProps().setProperty("nv.sma.qosoverride", "Guaranteed");
        try {
            this.messagingController.enableWaitForQuiescence("aeptest1", true);
            AepEngineTestAppAnnotatedHandlers senderHandlers = new AepEngineTestAppAnnotatedHandlers();
            AepEngineQuiescenceTestAppDefaultHandler receiverHandlers = new AepEngineQuiescenceTestAppDefaultHandler();
            this.startSenderStandaloneReceiverStandalone(senderHandlers, null, null, null, receiverHandlers, 15, 15, 15, 0, AepEngine.HAPolicy.EventSourcing, false, false);
            receiverHandlers.setBlockOnMessageReceipt();
            try {
                ((AepEngine)((Object)this.engines.get(0))).sendMessage(senderHandlers.channel4, new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto).getMessage());
                Assert.assertTrue((boolean)receiverHandlers.waitForMessageReceipt(0));
                this.messagingController.enableWaitForQuiescence("aeptest1", false);
            }
            finally {
                receiverHandlers.releaseMessageReceiptBlock();
            }
        }
        finally {
            XRuntime.getProps().remove("nv.sma.qosoverride");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testWaitForQuiescence(AepEngineTestObject.EncodingType encoding) throws Exception {
        this.messagingController.enableWaitForQuiescence("aeptest1", true);
        AepEngineTestAppAnnotatedHandlers senderHandlers = new AepEngineTestAppAnnotatedHandlers();
        AepEngineQuiescenceTestAppDefaultHandler receiverHandlers = new AepEngineQuiescenceTestAppDefaultHandler();
        this.startSenderStandaloneReceiverStandalone(senderHandlers, null, null, null, receiverHandlers, 1, 1, 1, 0, AepEngine.HAPolicy.EventSourcing, false, false, encoding);
        receiverHandlers.setBlockOnMessageReceipt();
        Assert.assertTrue((boolean)this.messagingController.waitForQuiescence("aeptest1", 5000L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)this.messagingController.waitForPendingAcks("aeptest1", 5000L, TimeUnit.MILLISECONDS));
        this.messagingController.dumpPendingAck("aeptest1");
        this.messagingController.waitForQuiescence("aeptest1");
        ((AepEngine)((Object)this.engines.get(0))).sendMessage(senderHandlers.channel1, new AepEngineTestMessage(encoding).getMessage());
        ((AepEngine)((Object)this.engines.get(0))).sendMessage(senderHandlers.channel1, new AepEngineTestMessage(encoding).getMessage());
        try {
            long ts = System.currentTimeMillis();
            System.out.println("Testing waitForQuiescence=false");
            Assert.assertFalse((boolean)this.messagingController.waitForQuiescence("aeptest1", 5000L, TimeUnit.MILLISECONDS));
            Assert.assertFalse((boolean)this.messagingController.waitForQuiescence("aeptest1", 1000L, TimeUnit.MILLISECONDS));
            this.messagingController.dumpPendingAck("aeptest1");
            System.out.println("...quiescence wait time=" + (System.currentTimeMillis() - ts) + "ms");
            Assert.assertTrue((boolean)receiverHandlers.waitForMessageReceipt(0));
        }
        finally {
            receiverHandlers.releaseMessageReceiptBlock();
        }
        Assert.assertTrue((boolean)this.messagingController.waitForQuiescence("aeptest1", 1000L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)this.messagingController.waitForPendingAcks("aeptest1", 5000L, TimeUnit.MILLISECONDS));
        receiverHandlers.setBlockOnMessageReceipt();
        ((AepEngine)((Object)this.engines.get(0))).sendMessage(senderHandlers.channel1, new AepEngineTestMessage(encoding).getMessage());
        Assert.assertTrue((boolean)receiverHandlers.waitForMessageReceipt(0));
        receiverHandlers.releaseMessageReceiptBlock();
        this.messagingController.waitForQuiescence("aeptest1");
        Assert.assertTrue((boolean)this.messagingController.waitForPendingAcks("aeptest1", 0L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testWaitForQuiescence_GlobalChannelQosOverride() throws Exception {
        XRuntime.getProps().setProperty("nv.sma.qosoverride", "Guaranteed");
        try {
            this.testWaitForQuiescence(AepEngineTestObject.EncodingType.Proto);
        }
        finally {
            XRuntime.getProps().remove("nv.sma.qosoverride");
        }
    }

    @Test
    public void testWaitForQuiescence_BusSpecificQosOverride() throws Exception {
        XRuntime.getProps().setProperty("nv.sma.qosoverride", "BestEffort");
        XRuntime.getProps().setProperty("nv.sma.aeptest1.qosoverride", "Guaranteed");
        try {
            this.testWaitForQuiescence(AepEngineTestObject.EncodingType.Proto);
        }
        finally {
            XRuntime.getProps().remove("nv.sma.qosoverride");
            XRuntime.getProps().remove("nv.sma.aeptest1.qosoverride");
        }
    }

    @Test
    public void testWaitForQuiescence_ChannelSpecificQosOverrideProto() throws Exception {
        XRuntime.getProps().setProperty("nv.sma.qosoverride", "BestEffort");
        XRuntime.getProps().setProperty("nv.sma.aeptest1.qosoverride", "BestEffort");
        XRuntime.getProps().setProperty("nv.sma.aeptest1.channel1.qosoverride", "Guaranteed");
        try {
            this.testWaitForQuiescence(AepEngineTestObject.EncodingType.Proto);
        }
        finally {
            XRuntime.getProps().remove("nv.sma.qosoverride");
            XRuntime.getProps().remove("nv.sma.aeptest1.qosoverride");
            XRuntime.getProps().remove("nv.sma.aeptest1.channel1.qosoverride");
        }
    }

    @Test
    public void testWaitForQuiescence_ChannelSpecificQosOverrideXbuf() throws Exception {
        XRuntime.getProps().setProperty("nv.sma.qosoverride", "BestEffort");
        XRuntime.getProps().setProperty("nv.sma.aeptest1.qosoverride", "BestEffort");
        XRuntime.getProps().setProperty("nv.sma.aeptest1.channel1.qosoverride", "Guaranteed");
        try {
            this.testWaitForQuiescence(AepEngineTestObject.EncodingType.Xbuf);
        }
        finally {
            XRuntime.getProps().remove("nv.sma.qosoverride");
            XRuntime.getProps().remove("nv.sma.aeptest1.qosoverride");
            XRuntime.getProps().remove("nv.sma.aeptest1.channel1.qosoverride");
        }
    }

    @Test
    public void testWaitForQuiescence_ChannelSpecificQosOverrideJson() throws Exception {
        XRuntime.getProps().setProperty("nv.sma.qosoverride", "BestEffort");
        XRuntime.getProps().setProperty("nv.sma.aeptest1.qosoverride", "BestEffort");
        XRuntime.getProps().setProperty("nv.sma.aeptest1.channel1.qosoverride", "Guaranteed");
        try {
            this.testWaitForQuiescence(AepEngineTestObject.EncodingType.Json);
        }
        finally {
            XRuntime.getProps().remove("nv.sma.qosoverride");
            XRuntime.getProps().remove("nv.sma.aeptest1.qosoverride");
            XRuntime.getProps().remove("nv.sma.aeptest1.channel1.qosoverride");
        }
    }

    private final void testWaitForQuiescenceStress(int minBlockSize, int maxBlockSize, int numBlocks, boolean senderReceiverSameAgent) throws Exception {
        long ts;
        AepEngineTestMessage message;
        int blockSize;
        int i;
        AepEngineTestApp receiverHandlers;
        AepEngineTestApp senderHandlers;
        this.messagingController.enableWaitForQuiescence("aeptest1", true);
        if (senderReceiverSameAgent) {
            receiverHandlers = senderHandlers = new AepEngineQuiescenceTestAppDefaultHandler();
            AepEngine engine = this.createEngine("engine", AepEngine.HAPolicy.EventSourcing, null, null, null, null, false, false, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 15, 15, null, (IEventHandler)receiverHandlers, null, 0, false, false, null, null, null, false, false);
            engine.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
            engine.start();
            engine.waitForMessagingToStart();
        } else {
            senderHandlers = new AepEngineTestAppAnnotatedHandlers();
            receiverHandlers = new AepEngineQuiescenceTestAppDefaultHandler();
            this.startSenderStandaloneReceiverStandalone(senderHandlers, null, null, null, (IEventHandler)receiverHandlers, 15, 15, 15, 0, AepEngine.HAPolicy.EventSourcing, false, false);
        }
        Assert.assertTrue((boolean)this.messagingController.waitForQuiescence("aeptest1", 5000L, TimeUnit.MILLISECONDS));
        this.messagingController.waitForQuiescence("aeptest1");
        System.out.println("Timed wait...");
        int expected = 0;
        for (i = 0; i < numBlocks; ++i) {
            blockSize = minBlockSize + (maxBlockSize - minBlockSize > 0 ? this.random.nextInt(maxBlockSize - minBlockSize) : 0);
            System.out.println("Block " + (i + 1) + " (size=" + blockSize + ")...");
            for (int j = 0; j < blockSize; ++j) {
                message = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
                message.getMessage().setMessageBus("aeptest1");
                message.getMessage().setMessageChannel("channel4");
                ((AepEngine)((Object)this.engines.get(0))).sendMessage(senderHandlers.channel4, message.getMessage());
                ++expected;
            }
            ts = System.currentTimeMillis();
            Assert.assertTrue((boolean)this.messagingController.waitForQuiescence("aeptest1", 20000L, TimeUnit.MILLISECONDS));
            System.out.println("...quiescence wait time=" + (System.currentTimeMillis() - ts) + "ms");
            Assert.assertEquals((long)expected, (long)receiverHandlers.channel4MessageCount);
        }
        System.out.println("Non-timed wait...");
        for (i = 0; i < numBlocks; ++i) {
            blockSize = minBlockSize + (maxBlockSize - minBlockSize > 0 ? this.random.nextInt(maxBlockSize - minBlockSize) : 0);
            System.out.println("Block " + (i + 1) + " (size=" + blockSize + ")...");
            for (int j = 0; j < blockSize; ++j) {
                message = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
                message.getMessage().setMessageBus("aeptest1");
                message.getMessage().setMessageChannel("channel4");
                ((AepEngine)((Object)this.engines.get(0))).sendMessage(senderHandlers.channel4, message.getMessage());
                ++expected;
            }
            ts = System.currentTimeMillis();
            this.messagingController.waitForQuiescence("aeptest1");
            System.out.println("...quiescence wait time=" + (System.currentTimeMillis() - ts) + "ms");
            Assert.assertEquals((long)expected, (long)receiverHandlers.channel4MessageCount);
        }
    }

    @Ignore
    @Test
    public void testWaitForQuiescenceStress_SenderAndReceiverSameAgent_LargeBlockSize_GlobalChannelQosOverride() throws Exception {
        XRuntime.getProps().setProperty("nv.sma.qosoverride", "Guaranteed");
        try {
            this.testWaitForQuiescenceStress(8000, 12000, 10, true);
        }
        finally {
            XRuntime.getProps().remove("nv.sma.qosoverride");
        }
    }

    @Ignore
    @Test
    public void testWaitForQuiescenceStress_SenderAndReceiverSameAgent_SmallBlockSize_GlobalChannelQosOverride() throws Exception {
        XRuntime.getProps().setProperty("nv.sma.qosoverride", "Guaranteed");
        try {
            this.testWaitForQuiescenceStress(5, 10, 30000, true);
        }
        finally {
            XRuntime.getProps().remove("nv.sma.qosoverride");
        }
    }

    @Ignore
    @Test
    public void testWaitForQuiescenceStress_SenderAndReceiverSameAgent_SingleMessageBlock_GlobalChannelQosOverride() throws Exception {
        XRuntime.getProps().setProperty("nv.sma.qosoverride", "Guaranteed");
        try {
            this.testWaitForQuiescenceStress(1, 1, 30000, true);
        }
        finally {
            XRuntime.getProps().remove("nv.sma.qosoverride");
        }
    }

    @Ignore
    @Test
    public void testWaitForQuiescenceStress_SenderAndReceiverDiffAgent_LargeBlockSize_GlobalChannelQosOverride() throws Exception {
        XRuntime.getProps().setProperty("nv.sma.qosoverride", "Guaranteed");
        try {
            this.testWaitForQuiescenceStress(8000, 12000, 10, false);
        }
        finally {
            XRuntime.getProps().remove("nv.sma.qosoverride");
        }
    }

    @Ignore
    @Test
    public void testWaitForQuiescenceStress_SenderAndReceiverDiffAgent_SmallBlockSize_GlobalChannelQosOverride() throws Exception {
        XRuntime.getProps().setProperty("nv.sma.qosoverride", "Guaranteed");
        try {
            this.testWaitForQuiescenceStress(5, 10, 30000, false);
        }
        finally {
            XRuntime.getProps().remove("nv.sma.qosoverride");
        }
    }

    @Ignore
    @Test
    public void testWaitForQuiescenceStress_SenderAndReceiverDiffAgent_SingleMessageBlock_GlobalChannelQosOverride() throws Exception {
        XRuntime.getProps().setProperty("nv.sma.qosoverride", "Guaranteed");
        try {
            this.testWaitForQuiescenceStress(1, 1, 30000, false);
        }
        finally {
            XRuntime.getProps().remove("nv.sma.qosoverride");
        }
    }
}

