/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.RingBuffer;

public class EventPublisher<E> {
    private final RingBuffer<E> ringBuffer;

    public EventPublisher(RingBuffer<E> ringBuffer) {
        this.ringBuffer = ringBuffer;
    }

    public void publishEvent(EventTranslator<E> translator) {
        long sequence = this.ringBuffer.next();
        this.translateAndPublish(translator, sequence);
    }

    public boolean tryPublishEvent(EventTranslator<E> translator, int capacity) {
        try {
            long sequence = this.ringBuffer.tryNext(capacity);
            this.translateAndPublish(translator, sequence);
            return true;
        }
        catch (InsufficientCapacityException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translateAndPublish(EventTranslator<E> translator, long sequence) {
        try {
            translator.translateTo(this.ringBuffer.get(sequence), sequence);
        }
        finally {
            this.ringBuffer.publish(sequence);
        }
    }
}

