/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.event.alert;

import com.neeve.event.Event;
import com.neeve.event.IEventSource;
import com.neeve.event.alert.IAlertEvent;
import com.neeve.sma.MessageView;

public abstract class AlertEvent
extends Event
implements IAlertEvent {
    private long ts;
    private MessageView backingMessageView;

    protected AlertEvent(short type) {
        super(type);
    }

    protected final void init(IEventSource source) {
        super.init(source, null);
        this.ts = System.currentTimeMillis();
    }

    protected void reset() {
        this.ts = 0L;
        if (this.backingMessageView != null) {
            this.backingMessageView.dispose();
            this.backingMessageView = null;
        }
    }

    @Override
    public final long getEventTime() {
        return this.ts;
    }

    @Override
    public void setBackingMessage(MessageView view) {
        this.backingMessageView = view;
    }

    @Override
    public MessageView getBackingMessage() {
        return this.backingMessageView;
    }

    @Override
    public MessageView getTriggeringMessage() {
        return null;
    }

    public String toString() {
        return super.toString() + ", time=" + this.ts;
    }
}

