/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep;

import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.lang.XIntLinkedHashMap;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.lang.XString;
import com.neeve.rog.IRogMessage;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import java.util.Map;
import java.util.Properties;

public final class AepMessageSender {
    private final XLinkedHashMap<String, MessageChannelContext> channelIndexByChannelNameAsString = new XLinkedHashMap();
    private final XLinkedHashMap<XString, MessageChannelContext> channelIndexByChannelNameAsXString = new XLinkedHashMap();
    private final XLinkedHashMap<String, XLinkedHashMap<String, MessageChannelContext>> channelIndexByChannelAndBusNameAsString = new XLinkedHashMap();
    private final XLinkedHashMap<XString, XLinkedHashMap<XString, MessageChannelContext>> channelIndexByChannelAndBusNameAsXString = new XLinkedHashMap();
    private final XIntLinkedHashMap<MessageChannelContext> channelIndexByChannelId = new XIntLinkedHashMap();
    private final XLinkedHashMap<String, XIntLinkedHashMap<MessageChannelContext>> channelIndexByChannelIdAndBusNameAsString = new XLinkedHashMap();
    private final XLinkedHashMap<XString, XIntLinkedHashMap<MessageChannelContext>> channelIndexByChannelIdAndBusNameAsXString = new XLinkedHashMap();
    private AepEngine engine;

    private AepMessageSender() {
    }

    public static final AepMessageSender create() {
        return new AepMessageSender();
    }

    private final XLinkedHashMap<String, MessageChannelContext> getChannelIndexByChannelNameAsString(String busName) {
        XLinkedHashMap channelSubIndexByChannelNameAsString = (XLinkedHashMap)this.channelIndexByChannelAndBusNameAsString.get((Object)busName);
        if (channelSubIndexByChannelNameAsString == null) {
            channelSubIndexByChannelNameAsString = new XLinkedHashMap();
            this.channelIndexByChannelAndBusNameAsString.put((Object)busName, (Object)channelSubIndexByChannelNameAsString);
        }
        return channelSubIndexByChannelNameAsString;
    }

    private final XLinkedHashMap<XString, MessageChannelContext> getChannelIndexByChannelNameAsXString(XString busName) {
        XLinkedHashMap channelSubIndexByChannelNameAsXString = (XLinkedHashMap)this.channelIndexByChannelAndBusNameAsXString.get((Object)busName);
        if (channelSubIndexByChannelNameAsXString == null) {
            channelSubIndexByChannelNameAsXString = new XLinkedHashMap();
            this.channelIndexByChannelAndBusNameAsXString.put((Object)busName, (Object)channelSubIndexByChannelNameAsXString);
        }
        return channelSubIndexByChannelNameAsXString;
    }

    private final XIntLinkedHashMap<MessageChannelContext> getChannelIndexByChannelId(String busName) {
        XIntLinkedHashMap channelSubIndexByChannelId = (XIntLinkedHashMap)this.channelIndexByChannelIdAndBusNameAsString.get((Object)busName);
        if (channelSubIndexByChannelId == null) {
            channelSubIndexByChannelId = new XIntLinkedHashMap();
            this.channelIndexByChannelIdAndBusNameAsString.put((Object)busName, (Object)channelSubIndexByChannelId);
        }
        return channelSubIndexByChannelId;
    }

    private final XIntLinkedHashMap<MessageChannelContext> getChannelIndexByChannelId(XString busName) {
        XIntLinkedHashMap channelSubIndexByChannelId = (XIntLinkedHashMap)this.channelIndexByChannelIdAndBusNameAsXString.get((Object)busName);
        if (channelSubIndexByChannelId == null) {
            channelSubIndexByChannelId = new XIntLinkedHashMap();
            this.channelIndexByChannelIdAndBusNameAsXString.put((Object)busName, (Object)channelSubIndexByChannelId);
        }
        return channelSubIndexByChannelId;
    }

    private final void prepareChannelContextIndexes(Map<String, MessageBusDescriptor> busDescriptors) {
        for (String key : busDescriptors.keySet()) {
            for (MessageChannelDescriptor channelDescriptor : busDescriptors.get(key).getChannels()) {
                String busNameAsString = key;
                XString busNameAsXString = XString.create((String)busNameAsString, (boolean)true, (boolean)true);
                short channelId = channelDescriptor.getChannelId();
                String channelNameAsString = channelDescriptor.getName();
                XString channelNameAsXString = XString.create((String)channelNameAsString, (boolean)true, (boolean)true);
                MessageChannelContext channelContext = new MessageChannelContext(busNameAsXString, channelId, channelNameAsXString);
                this.getChannelIndexByChannelNameAsString(busNameAsString).put((Object)channelNameAsString, (Object)channelContext);
                this.getChannelIndexByChannelNameAsXString(busNameAsXString).put((Object)channelNameAsXString, (Object)channelContext);
                this.channelIndexByChannelNameAsString.put((Object)channelNameAsString, (Object)channelContext);
                this.channelIndexByChannelNameAsXString.put((Object)channelNameAsXString, (Object)channelContext);
                if (channelId < 0) continue;
                this.getChannelIndexByChannelId(busNameAsString).put((int)channelId, (Object)channelContext);
                this.getChannelIndexByChannelId(busNameAsXString).put((int)channelId, (Object)channelContext);
                this.channelIndexByChannelId.put((int)channelId, (Object)channelContext);
            }
        }
    }

    final AepMessageSender init(Map<String, MessageBusDescriptor> busDescriptors, AepEngine engine) {
        this.prepareChannelContextIndexes(busDescriptors);
        this.engine = engine;
        return this;
    }

    @EventHandler
    private final void onChannelUp(AepChannelUpEvent event) {
        MessageChannel channel = event.getMessageChannel();
        MessageChannelContext context = (MessageChannelContext)this.getChannelIndexByChannelNameAsString(channel.getMessageBusBinding().getName()).get((Object)channel.getName());
        if (context != null) {
            context.channel = channel;
        }
    }

    @EventHandler
    private final void onChannelDown(AepChannelDownEvent event) {
        MessageChannel channel = event.getMessageChannel();
        MessageChannelContext context = (MessageChannelContext)this.getChannelIndexByChannelNameAsString(channel.getMessageBusBinding().getName()).get((Object)channel.getName());
        if (context != null) {
            context.channel = null;
        }
    }

    private final IRogMessage prepareMessageForSend(IRogMessage message, MessageChannelContext channelContext) {
        message.setMessageBusAsRaw(channelContext.busName);
        message.setMessageChannelAsRaw(channelContext.channelName);
        return message;
    }

    private final MessageChannelContext getMessageChannelContext(String channelName) {
        MessageChannelContext channelContext = (MessageChannelContext)this.channelIndexByChannelNameAsString.get((Object)channelName);
        if (channelContext == null) {
            throw new IllegalArgumentException("channel '" + channelName + "' is not configured for the engine");
        }
        return channelContext;
    }

    private final MessageChannelContext getMessageChannelContext(XString channelName) {
        MessageChannelContext channelContext = (MessageChannelContext)this.channelIndexByChannelNameAsXString.get((Object)channelName);
        if (channelContext == null) {
            throw new IllegalArgumentException("channel '" + channelName + "' is not configured for the engine");
        }
        return channelContext;
    }

    private final MessageChannelContext getMessageChannelContext(String busName, String channelName) {
        XLinkedHashMap channelSubIndexByChannelNameAsString = (XLinkedHashMap)this.channelIndexByChannelAndBusNameAsString.get((Object)busName);
        if (channelSubIndexByChannelNameAsString == null) {
            throw new IllegalArgumentException("bus '" + busName + "' is not configured for the engine");
        }
        MessageChannelContext channelContext = (MessageChannelContext)channelSubIndexByChannelNameAsString.get((Object)channelName);
        if (channelContext == null) {
            throw new IllegalArgumentException("channel '" + channelName + "' is not configured in the '" + busName + "' bus for the engine");
        }
        return channelContext;
    }

    private final MessageChannelContext getMessageChannelContext(XString busName, XString channelName) {
        XLinkedHashMap channelSubIndexByChannelNameAsXString = (XLinkedHashMap)this.channelIndexByChannelAndBusNameAsXString.get((Object)busName);
        if (channelSubIndexByChannelNameAsXString == null) {
            throw new IllegalArgumentException("bus '" + busName + "' is not configured for the engine");
        }
        MessageChannelContext channelContext = (MessageChannelContext)channelSubIndexByChannelNameAsXString.get((Object)channelName);
        if (channelContext == null) {
            throw new IllegalArgumentException("channel '" + channelName + "' is not configured in the '" + busName + "' bus for the engine");
        }
        return channelContext;
    }

    private final MessageChannelContext getMessageChannelContext(int channelId) {
        MessageChannelContext channelContext = (MessageChannelContext)this.channelIndexByChannelId.get(channelId);
        if (channelContext == null) {
            throw new IllegalArgumentException("channel id '" + channelId + "' is not configured for the engine");
        }
        return channelContext;
    }

    private final MessageChannelContext getMessageChannelContext(String busName, int channelId) {
        XIntLinkedHashMap channelSubIndexByChannelId = (XIntLinkedHashMap)this.channelIndexByChannelIdAndBusNameAsString.get((Object)busName);
        if (channelSubIndexByChannelId == null) {
            throw new IllegalArgumentException("bus '" + busName + "' is not configured for the engine");
        }
        MessageChannelContext channelContext = (MessageChannelContext)this.channelIndexByChannelId.get(channelId);
        if (channelContext == null) {
            throw new IllegalArgumentException("channel id '" + channelId + "' is not configured in the '" + busName + "' bus for the engine");
        }
        return channelContext;
    }

    private final MessageChannelContext getMessageChannelContext(XString busName, int channelId) {
        XIntLinkedHashMap channelSubIndexByChannelId = (XIntLinkedHashMap)this.channelIndexByChannelIdAndBusNameAsXString.get((Object)busName);
        if (channelSubIndexByChannelId == null) {
            throw new IllegalArgumentException("bus '" + busName + "' is not configured for the engine");
        }
        MessageChannelContext channelContext = (MessageChannelContext)this.channelIndexByChannelId.get(channelId);
        if (channelContext == null) {
            throw new IllegalArgumentException("channel id '" + channelId + "' is not configured in the '" + busName + "' bus for the engine");
        }
        return channelContext;
    }

    public final void sendMessage(String channelName, IRogMessage message) {
        MessageChannelContext channelContext = this.getMessageChannelContext(channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext));
    }

    public final void sendMessage(String channelName, IRogMessage message, String key) {
        MessageChannelContext channelContext = this.getMessageChannelContext(channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext), key, (Properties)null);
    }

    public final void sendMessage(String channelName, IRogMessage message, XString key) {
        MessageChannelContext channelContext = this.getMessageChannelContext(channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext), key, (MessageChannel.RawKeyResolutionTable)null);
    }

    public final void sendMessage(String channelName, IRogMessage message, Properties keyResolutionTable) {
        MessageChannelContext channelContext = this.getMessageChannelContext(channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext), keyResolutionTable);
    }

    public final void sendMessage(String channelName, IRogMessage message, MessageChannel.RawKeyResolutionTable keyResolutionTable) {
        MessageChannelContext channelContext = this.getMessageChannelContext(channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext), keyResolutionTable);
    }

    public final void sendMessage(XString channelName, IRogMessage message) {
        MessageChannelContext channelContext = this.getMessageChannelContext(channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext));
    }

    public final void sendMessage(XString channelName, IRogMessage message, String key) {
        MessageChannelContext channelContext = this.getMessageChannelContext(channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext), key, (Properties)null);
    }

    public final void sendMessage(XString channelName, IRogMessage message, XString key) {
        MessageChannelContext channelContext = this.getMessageChannelContext(channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext), key, (MessageChannel.RawKeyResolutionTable)null);
    }

    public final void sendMessage(XString channelName, IRogMessage message, Properties keyResolutionTable) {
        MessageChannelContext channelContext = this.getMessageChannelContext(channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext), keyResolutionTable);
    }

    public final void sendMessage(XString channelName, IRogMessage message, MessageChannel.RawKeyResolutionTable keyResolutionTable) {
        MessageChannelContext channelContext = this.getMessageChannelContext(channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext), keyResolutionTable);
    }

    public final void sendMessage(String busName, String channelName, IRogMessage message) {
        MessageChannelContext channelContext = this.getMessageChannelContext(busName, channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext));
    }

    public final void sendMessage(String busName, String channelName, IRogMessage message, String key) {
        MessageChannelContext channelContext = this.getMessageChannelContext(busName, channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext), key, (Properties)null);
    }

    public final void sendMessage(String busName, String channelName, IRogMessage message, XString key) {
        MessageChannelContext channelContext = this.getMessageChannelContext(busName, channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext), key, (MessageChannel.RawKeyResolutionTable)null);
    }

    public final void sendMessage(String busName, String channelName, IRogMessage message, Properties keyResolutionTable) {
        MessageChannelContext channelContext = this.getMessageChannelContext(busName, channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext), keyResolutionTable);
    }

    public final void sendMessage(String busName, String channelName, IRogMessage message, MessageChannel.RawKeyResolutionTable keyResolutionTable) {
        MessageChannelContext channelContext = this.getMessageChannelContext(busName, channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext), keyResolutionTable);
    }

    public final void sendMessage(XString busName, XString channelName, IRogMessage message) {
        MessageChannelContext channelContext = this.getMessageChannelContext(busName, channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext));
    }

    public final void sendMessage(XString busName, XString channelName, IRogMessage message, String key) {
        MessageChannelContext channelContext = this.getMessageChannelContext(busName, channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext), key, (Properties)null);
    }

    public final void sendMessage(XString busName, XString channelName, IRogMessage message, XString key) {
        MessageChannelContext channelContext = this.getMessageChannelContext(busName, channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext), key, (MessageChannel.RawKeyResolutionTable)null);
    }

    public final void sendMessage(XString busName, XString channelName, IRogMessage message, Properties keyResolutionTable) {
        MessageChannelContext channelContext = this.getMessageChannelContext(busName, channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext), keyResolutionTable);
    }

    public final void sendMessage(XString busName, XString channelName, IRogMessage message, MessageChannel.RawKeyResolutionTable keyResolutionTable) {
        MessageChannelContext channelContext = this.getMessageChannelContext(busName, channelName);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext), keyResolutionTable);
    }

    public final void sendMessage(int channelId, IRogMessage message) {
        MessageChannelContext channelContext = this.getMessageChannelContext(channelId);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext));
    }

    public final void sendMessage(String busName, int channelId, IRogMessage message) {
        MessageChannelContext channelContext = this.getMessageChannelContext(busName, channelId);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext));
    }

    public final void sendMessage(XString busName, int channelId, IRogMessage message) {
        MessageChannelContext channelContext = this.getMessageChannelContext(busName, channelId);
        this.engine.sendMessage(channelContext.channel, this.prepareMessageForSend(message, channelContext));
    }

    private final class MessageChannelContext {
        final XString busName;
        final XString channelName;
        MessageChannel channel;

        MessageChannelContext(XString busName, int channelId, XString channelName) {
            this.busName = busName;
            this.channelName = channelName;
        }
    }
}

