/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.common.SolEnum;
import com.solacesystems.common.config.Version;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPStats;
import com.solacesystems.jcsmp.JCSMPVersion;
import com.solacesystems.jcsmp.statistics.RuntimeStatType;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;

public class JCSMPRuntime
extends JCSMPStats {
    private static JCSMPRuntime currentRuntime = new JCSMPRuntime();
    private Version m_version = new JCSMPVersion();
    protected AtomicLong[] runtimestatTable;
    private static int MAX_XPE = 50;
    private static final String MAX_XPE_PROPERTY_NAME = "MAX_XPE";

    private JCSMPRuntime() {
        super("JCSMPRuntime Stats");
        this.resetStats();
    }

    public static JCSMPRuntime onlyInstance() {
        return currentRuntime;
    }

    public Version getVersion() {
        return this.m_version;
    }

    public List<String> getSupportedProtocolStacks() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(JCSMPChannelProperties.supportedProtocolStacks);
        return list;
    }

    @Override
    public synchronized void resetStats() {
        super.resetStats();
        this.initRuntimeStatsFromEnumeration(RuntimeStatType.elements());
    }

    private void initRuntimeStatsFromEnumeration(Enumeration<RuntimeStatType> types) {
        Vector<SolEnum> v = new Vector<SolEnum>();
        while (types.hasMoreElements()) {
            v.add(types.nextElement());
        }
        if (this.runtimestatTable == null) {
            this.runtimestatTable = new AtomicLong[v.size()];
        }
        for (SolEnum t : v) {
            this.runtimestatTable[t.getId()] = new AtomicLong();
        }
    }

    protected static final long getStat(SolEnum key, AtomicLong[] table) {
        int idx = key.getId();
        AtomicLong s = table[idx];
        JCSMPRuntime.checkStatFound(s);
        return s.longValue();
    }

    protected static final void incStat(SolEnum key, AtomicLong[] table) {
        int idx = key.getId();
        AtomicLong s = table[idx];
        JCSMPRuntime.checkStatFound(s);
        s.incrementAndGet();
    }

    protected static final void incStat(SolEnum key, long v, AtomicLong[] table) {
        int idx = key.getId();
        AtomicLong s = table[idx];
        JCSMPRuntime.checkStatFound(s);
        s.addAndGet(v);
    }

    public long getStat(RuntimeStatType key) {
        return JCSMPRuntime.getStat(key, this.runtimestatTable);
    }

    public void incStat(RuntimeStatType key) {
        JCSMPRuntime.incStat(key, this.runtimestatTable);
    }

    public void incStat(RuntimeStatType key, long v) {
        JCSMPRuntime.incStat(key, this.runtimestatTable);
    }

    public int getSupportedMaxNumOfXpesInOneRequest() {
        return MAX_XPE;
    }

    static {
        try {
            MAX_XPE = Integer.parseInt(System.getProperty(MAX_XPE_PROPERTY_NAME));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

