/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto.test.unit;

import com.neeve.sto.StoField;
import com.neeve.sto.StoFixedLengthStringField;
import com.neeve.sto.StoStringField;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public final class StoFixedLengthStringFieldTest
extends UnitTest {
    private final void validate(StoFixedLengthStringField field, String name, ByteBuffer buffer, String val) {
        if (name == null) {
            Assert.assertNull((Object)field.getName());
        } else {
            Assert.assertEquals((Object)field.getName(), (Object)name);
        }
        if (buffer == null) {
            Assert.assertNull((Object)field.getBackingBuffer());
        } else {
            Assert.assertSame((Object)field.getBackingBuffer(), (Object)buffer);
        }
        Assert.assertEquals((Object)((Object)StoField.Type.FIXLEN_STRING), (Object)((Object)field.getType()));
        if (val == null) {
            Assert.assertNull((Object)field.getValue());
        } else {
            Assert.assertEquals((Object)field.getValue(), (Object)val);
        }
    }

    private final void cloneAndValidate(StoFixedLengthStringField field, String name, String val) {
        StoFixedLengthStringField clone = (StoFixedLengthStringField)field.clone();
        Assert.assertNotSame((Object)clone, (Object)field);
        this.validate(clone, name, null, val);
        Assert.assertTrue((boolean)field.contentsEquals(clone));
    }

    private final void validate(ByteBuffer buffer, int pos, int limit, int capacity) {
        Assert.assertEquals((long)buffer.position(), (long)pos);
        Assert.assertEquals((long)buffer.limit(), (long)limit);
        Assert.assertEquals((long)buffer.capacity(), (long)capacity);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateWithZeroLength() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create((String)null, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateWithNegativeLength() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create((String)null, -1);
    }

    @Test
    public void testCreateWithNullName() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create((String)null, 1);
        this.validate(field, null, null, null);
        this.cloneAndValidate(field, null, null);
    }

    @Test
    public void testCreateWithNonNullName() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create("name", 1);
        this.validate(field, "name", null, null);
        this.cloneAndValidate(field, "name", null);
    }

    @Test
    public void testIsVariableLength() throws Exception {
        Assert.assertFalse((boolean)StoFixedLengthStringField.create((String)null, 1).isVariableLength());
    }

    @Test
    public void testCreateWithNullNameSetValue() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create((String)null, 7);
        this.validate(field, null, null, null);
        field.setValue("string1");
        this.validate(field, null, null, "string1");
        this.cloneAndValidate(field, null, "string1");
    }

    @Test
    public void testCreateWithNonNullNameSetValue() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create("name", 7);
        this.validate(field, "name", null, null);
        field.setValue("string1");
        this.validate(field, "name", null, "string1");
        this.cloneAndValidate(field, "name", "string1");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetValueWithLessThanStringLength() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create("name", 7);
        field.setValue("string");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetValueWithGreaterThanStringLength() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create("name", 7);
        field.setValue("string12");
    }

    @Test
    public void testCreateWithNullNameBackByBuffer() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create((String)null, 10);
        this.validate(field, null, null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 5);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, null);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBuffer() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create("name", 7);
        this.validate(field, "name", null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 9);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, null);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByBuffer() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create((String)null, 7);
        this.validate(field, null, null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue("string1");
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByBuffer() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create("name", 7);
        this.validate(field, "name", null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue("string1");
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create((String)null, 7);
        this.validate(field, null, null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue("string1");
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create("name", 7);
        this.validate(field, "name", null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue("string1");
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValue() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create((String)null, 7);
        this.validate(field, null, null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue("string1");
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValue() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create("name", 7);
        this.validate(field, "name", null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue("string1");
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create((String)null, 7);
        this.validate(field, null, null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue("string1");
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create("name", 7);
        this.validate(field, "name", null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue("string1");
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueSync() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create((String)null, 7);
        this.validate(field, null, null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue("string1");
        field.sync(buffer, 45);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, "string1");
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((Object)StoStringField.get(buffer, field.shiftForHeader(45)), (Object)"string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueSync() throws Exception {
        StoFixedLengthStringField field = StoFixedLengthStringField.create("name", 7);
        this.validate(field, "name", null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue("string1");
        field.sync(buffer, 52);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, "string1");
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((Object)StoStringField.get(buffer, field.shiftForHeader(52)), (Object)"string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserialize() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create((String)null, 7);
        this.validate(field1, null, null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue("string1");
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoFixedLengthStringField field2 = (StoFixedLengthStringField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        this.validate(field2, null, buffer, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserialize() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create("name", 7);
        this.validate(field1, "name", null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue("string1");
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoFixedLengthStringField field2 = (StoFixedLengthStringField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        this.validate(field2, "name", buffer, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameDeserialize() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create((String)null, 7);
        this.validate(field1, null, null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoFixedLengthStringField field2 = (StoFixedLengthStringField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        this.validate(field2, null, buffer, null);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameDeserialize() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create("name", 7);
        this.validate(field1, "name", null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoFixedLengthStringField field2 = (StoFixedLengthStringField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        this.validate(field2, "name", buffer, null);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create((String)null, 7);
        this.validate(field1, null, null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue("string1");
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoFixedLengthStringField field2 = (StoFixedLengthStringField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field2, null, null, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create("name", 7);
        this.validate(field1, "name", null, null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue("string1");
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoFixedLengthStringField field2 = (StoFixedLengthStringField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field2, "name", null, "string1");
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", "string1");
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create((String)null, 7);
        this.validate(field1, null, null, null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue("string1");
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        StoFixedLengthStringField field2 = (StoFixedLengthStringField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoFixedLengthStringField field3 = (StoFixedLengthStringField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, null, buffer2, "string1");
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field3.contentsEquals(field2));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, null, "string1");
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create("name", 7);
        this.validate(field1, "name", null, null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue("string1");
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        StoFixedLengthStringField field2 = (StoFixedLengthStringField)StoField.create(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoFixedLengthStringField field3 = (StoFixedLengthStringField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, "name", buffer2, "string1");
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field2.contentsEquals(field3));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, "name", "string1");
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateSetNullValueDeserialize() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create((String)null, 7);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(null);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoFixedLengthStringField field2 = (StoFixedLengthStringField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateSetBackingBufferSync() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create((String)null, 7);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field1.sync(buffer2, 65);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateDeserializeSync() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create((String)null, 7);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        StoFixedLengthStringField field2 = (StoFixedLengthStringField)StoField.create(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.sync(buffer2, 25);
    }

    @Test
    public void testContentsEqualsWithDifferentNamesFirstNonNull() throws Exception {
        Assert.assertFalse((boolean)StoFixedLengthStringField.create("name", 1).contentsEquals(StoFixedLengthStringField.create((String)null, 1)));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesSecondNonNull() throws Exception {
        Assert.assertFalse((boolean)StoFixedLengthStringField.create((String)null, 1).contentsEquals(StoFixedLengthStringField.create("name", 1)));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesBothNonNull() throws Exception {
        Assert.assertFalse((boolean)StoFixedLengthStringField.create("name1", 1).contentsEquals(StoFixedLengthStringField.create("name2", 1)));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesFirstNonNull() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create((String)null, 6);
        StoFixedLengthStringField field2 = StoFixedLengthStringField.create((String)null, 6);
        field1.setValue("string");
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesSecondNonNull() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create((String)null, 6);
        StoFixedLengthStringField field2 = StoFixedLengthStringField.create((String)null, 6);
        field2.setValue("string");
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffContent() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create((String)null, 7);
        StoFixedLengthStringField field2 = StoFixedLengthStringField.create((String)null, 7);
        field1.setValue("string1");
        field2.setValue("string2");
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNamesSameLengthsNameNullValuesDefault() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create((String)null, 7);
        StoFixedLengthStringField field2 = StoFixedLengthStringField.create((String)null, 7);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNamesDiffLengthsNameNullValuesDefault() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create((String)null, 7);
        StoFixedLengthStringField field2 = StoFixedLengthStringField.create((String)null, 10);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNamesSameLengthsNameNonNullValuesDefault() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create("name", 7);
        StoFixedLengthStringField field2 = StoFixedLengthStringField.create("name", 7);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNamesDiffLengthsNameNonNullValuesDefault() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create("name", 7);
        StoFixedLengthStringField field2 = StoFixedLengthStringField.create("name", 10);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNamesSameLengthsNameNullValuesNonDefault() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create((String)null, 8);
        StoFixedLengthStringField field2 = StoFixedLengthStringField.create((String)null, 8);
        field1.setValue("string42");
        field2.setValue("string42");
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNamesDiffLengthsNameNullValuesNonDefault() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create((String)null, 8);
        StoFixedLengthStringField field2 = StoFixedLengthStringField.create((String)null, 10);
        field1.setValue("string42");
        field2.setValue("string4242");
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNamesSameLengthsNameNonNullValuesNonDefault() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create("name", 8);
        StoFixedLengthStringField field2 = StoFixedLengthStringField.create("name", 8);
        field1.setValue("string66");
        field2.setValue("string66");
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNamesDiffLengthsNameNonNullValuesNonDefault() throws Exception {
        StoFixedLengthStringField field1 = StoFixedLengthStringField.create("name", 8);
        StoFixedLengthStringField field2 = StoFixedLengthStringField.create("name", 10);
        field1.setValue("string66");
        field2.setValue("string6666");
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }
}

