/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import com.neeve.sto.StoShortField;
import com.neeve.sto.StoVariableLengthField;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class StoStringField
extends StoVariableLengthField<String> {
    private StoStringField(String name) {
        super(StoField.Type.STRING, name);
    }

    protected StoStringField(StoField.Type type, String name) {
        super(type, name);
    }

    protected StoStringField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    @Override
    protected final int serializedLength(ByteBuffer buffer, int offset) {
        return StoStringField.getSerializedLength(buffer, offset);
    }

    @Override
    protected final int serializedLength(String val) {
        return StoStringField.getSerializedLength(val);
    }

    @Override
    protected final void serialize(ByteBuffer buffer, int offset, String val) {
        StoStringField.put(buffer, offset, val);
    }

    @Override
    protected final String deserialize(ByteBuffer buffer, int offset) {
        return StoStringField.get(buffer, offset);
    }

    @Override
    protected final boolean compare(String val1, String val2) {
        return val1.equals(val2);
    }

    @Override
    protected final String clone(String val) {
        return val;
    }

    @Override
    protected final String toString(String val) {
        return val;
    }

    public static StoStringField create(String name) {
        return new StoStringField(name);
    }

    public static StoStringField create(ByteBuffer buffer, int bufferOffset) {
        return new StoStringField(buffer, bufferOffset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        return 2 + (len < 0 ? (short)0 : len) * 8 / 8;
    }

    public static int getSerializedLength(String val) {
        try {
            return 2 + (val != null ? val.getBytes("UTF-8").length : 0);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static int put(ByteBuffer buffer, int offset, String val) {
        try {
            byte[] valbytes;
            byte[] byArray = valbytes = val != null ? val.getBytes("UTF-8") : null;
            StoShortField.put(buffer, offset, (short)(valbytes == null ? 0 : (valbytes.length == 0 ? -1 : valbytes.length)));
            if (valbytes != null) {
                int pos = buffer.position();
                ((ByteBuffer)buffer.position(offset + 2)).put(valbytes).position(pos);
            }
            return 2 + (valbytes == null ? 0 : valbytes.length);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isNull(ByteBuffer buffer, int offset) {
        return StoStringField.getSerializedLength(buffer, offset) == 2;
    }

    public static String get(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        if (len > 0) {
            byte[] valbytes = new byte[len];
            int pos = buffer.position();
            ((ByteBuffer)buffer.position(offset + 2)).get(valbytes).position(pos);
            try {
                return new String(valbytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (len < 0) {
            return "";
        }
        return null;
    }
}

