/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import com.neeve.sto.StoShortField;
import com.neeve.sto.StoVariableLengthField;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class StoShortArrayField
extends StoVariableLengthField<short[]> {
    private StoShortArrayField(String name) {
        super(StoField.Type.SHORT_ARRAY, name);
    }

    private StoShortArrayField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    @Override
    protected final int serializedLength(ByteBuffer buffer, int offset) {
        return StoShortArrayField.getSerializedLength(buffer, offset);
    }

    @Override
    protected final int serializedLength(short[] val) {
        return StoShortArrayField.getSerializedLength(val);
    }

    @Override
    protected final void serialize(ByteBuffer buffer, int offset, short[] val) {
        StoShortArrayField.put(buffer, offset, val);
    }

    @Override
    protected final short[] deserialize(ByteBuffer buffer, int offset) {
        return StoShortArrayField.get(buffer, offset);
    }

    @Override
    protected final boolean compare(short[] val1, short[] val2) {
        return Arrays.equals(val1, val2);
    }

    @Override
    protected final short[] clone(short[] val) {
        return Arrays.copyOf(val, val.length);
    }

    @Override
    protected final String toString(short[] val) {
        return Arrays.toString(val);
    }

    public static StoShortArrayField create(String name) {
        return new StoShortArrayField(name);
    }

    public static StoShortArrayField create(ByteBuffer buffer, int bufferOffset) {
        return new StoShortArrayField(buffer, bufferOffset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        return 2 + (len < 0 ? (short)0 : len) * 16 / 8;
    }

    public static int getSerializedLength(short[] val) {
        return 2 + (val != null ? val.length * 16 / 8 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(ByteBuffer buffer, int offset, short[] val) {
        StoShortField.put(buffer, offset, (short)(val == null ? 0 : (val.length == 0 ? -1 : val.length)));
        if (val != null) {
            int pos = buffer.position();
            try {
                ((ByteBuffer)buffer.position(offset + 2)).asShortBuffer().put(val);
            }
            finally {
                buffer.position(pos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short[] get(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        if (len > 0) {
            short[] val = new short[len];
            int pos = buffer.position();
            try {
                ((ByteBuffer)buffer.position(offset + 2)).asShortBuffer().get(val);
                short[] sArray = val;
                return sArray;
            }
            finally {
                buffer.position(pos);
            }
        }
        if (len < 0) {
            return new short[0];
        }
        return null;
    }
}

