/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link;

import com.neeve.emx.IEmxDispatcher;
import com.neeve.link.ELnkException;
import com.neeve.link.ELnkInvalidStateException;
import com.neeve.link.ELnkNotOwnerException;
import com.neeve.link.ELnkOpCancelledException;
import com.neeve.link.ELnkOpFailedException;
import com.neeve.link.ELnkOpTimeoutException;
import com.neeve.link.ILnkEndpoint;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkServerEndpoint;
import com.neeve.link.LnkEvents;
import com.neeve.link.LnkFactory;
import com.neeve.link.LnkObject;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;

public class LnkContinuousAcceptor
extends LnkObject {
    private final UtlAddressDescriptor descriptor;
    private final ILnkEventHandler userHandler;
    private final ILnkEventHandler completionHandler;
    private ILnkServerEndpoint sep;
    private IEmxDispatcher dispatcher;
    private int sno;
    private State state;

    protected LnkContinuousAcceptor(RootConfig.ObjectConfig config, UtlAddressDescriptor descriptor, ILnkEventHandler userHandler) {
        super(config);
        this.descriptor = descriptor;
        this.userHandler = userHandler;
        this.completionHandler = new AcceptCompleteEventHandler();
        this.state = State.STOPPED;
    }

    public static LnkContinuousAcceptor create(RootConfig.ObjectConfig config, UtlAddressDescriptor descriptor, ILnkEventHandler userHandler) {
        return new LnkContinuousAcceptor(config, descriptor, userHandler);
    }

    public static LnkContinuousAcceptor create(RootConfig.ObjectConfig config, String descriptor, ILnkEventHandler userHandler) {
        return LnkContinuousAcceptor.create(config, UtlAddressDescriptor.parse((String)descriptor, null), userHandler);
    }

    private final void createServerEndpoint() throws ELnkOpFailedException {
        try {
            if (this.tracer.debug) {
                this.tracer.log("Creating server endpoint using [" + this.descriptor + "].", Tracer.Level.DEBUG);
            }
            this.sep = LnkFactory.getInstance().createServerEndpoint(this.descriptor);
        }
        catch (ELnkException e) {
            if (this.tracer.debug) {
                this.tracer.log("Failed to create server endpoint using [" + this.descriptor + "] [" + e.toString() + "].", Tracer.Level.DEBUG);
            }
            throw new ELnkOpFailedException((Throwable)((Object)e));
        }
    }

    private final void closeServerEndpoint() {
        try {
            if (this.tracer.debug) {
                this.tracer.log("Closing server endpoint [" + this.descriptor + "].", Tracer.Level.DEBUG);
            }
            this.sep.close();
        }
        catch (Exception e) {
            this.tracer.log("Failed to close server endpoint in acceptor [" + this.descriptor + "] [" + e.toString() + "]. Ignoring.", Tracer.Level.DIAGNOSE);
        }
        finally {
            this.sep = null;
        }
    }

    private final void dispatchCompletion(IEmxDispatcher dispatcher, LnkEvents.ConnectAcceptCompleteEventData eventData) {
        block7: {
            if (!eventData.status) {
                this.state = State.STOPPED;
                this.closeServerEndpoint();
            }
            try {
                LnkEvents.ConnectAcceptCompleteEventData connectAcceptCompleteEventData;
                if (eventData instanceof LnkEvents.ContinuousAcceptCompleteEventData) {
                    connectAcceptCompleteEventData = eventData;
                } else {
                    LnkEvents.ContinuousAcceptCompleteEventData continuousAcceptCompleteEventData = new LnkEvents.ContinuousAcceptCompleteEventData(eventData, ++this.sno);
                    connectAcceptCompleteEventData = continuousAcceptCompleteEventData;
                }
                this.userHandler.onEvent(dispatcher, null, 4, connectAcceptCompleteEventData);
            }
            catch (Exception e) {
                if (!eventData.status) break block7;
                try {
                    eventData.pep.close((short)-1);
                }
                catch (Exception e1) {
                    this.tracer.log("Failure to close an accepted link upon receiving an exception from the handler of the accept completion event [" + e1.toString() + "].", Tracer.Level.DIAGNOSE);
                }
            }
        }
    }

    private final void onAcceptSuccessOrTimeoutUnprotected(IEmxDispatcher dispatcher, LnkEvents.ConnectAcceptCompleteEventData eventData) {
        if (this.state == State.STOPPED) {
            throw new InternalError("State is STOPPED on successful connection acceptance!");
        }
        if (eventData.status) {
            if (this.tracer.verbose) {
                this.tracer.log("Accepted a new link through [" + this.descriptor + "] [" + eventData.pep.toString() + "].", Tracer.Level.VERBOSE);
            }
            this.dispatchCompletion(dispatcher, eventData);
        } else if (this.tracer.verbose) {
            this.tracer.log("Timed out in accepting a link through [" + this.descriptor + "].", Tracer.Level.VERBOSE);
        }
        if (this.state == State.STOPPING) {
            this.dispatchCompletion(dispatcher, new LnkEvents.ContinuousAcceptCompleteEventData(new ELnkOpCancelledException()));
        } else {
            try {
                this.accept(dispatcher);
            }
            catch (ELnkNotOwnerException e) {
                throw new InternalError("Received 'not owner' exception when posting accept from owner thread!");
            }
            catch (ELnkOpFailedException e) {
                this.tracer.log("Failed to post an accept after a successful acceptance[" + this.descriptor + "] [" + e.toString() + "].", Tracer.Level.DIAGNOSE);
                this.dispatchCompletion(dispatcher, new LnkEvents.ContinuousAcceptCompleteEventData(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onAcceptSuccessOrTimeout(IEmxDispatcher dispatcher, LnkEvents.ConnectAcceptCompleteEventData eventData) {
        if (this.threaded) {
            LnkContinuousAcceptor lnkContinuousAcceptor = this;
            synchronized (lnkContinuousAcceptor) {
                this.onAcceptSuccessOrTimeoutUnprotected(dispatcher, eventData);
            }
        } else {
            this.onAcceptSuccessOrTimeoutUnprotected(dispatcher, eventData);
        }
    }

    private final void onAcceptFailureUnprotected(IEmxDispatcher dispatcher, LnkEvents.ConnectAcceptCompleteEventData eventData) {
        if (this.state == State.STOPPED) {
            throw new InternalError("State is STOPPED on successful connection acceptance!");
        }
        this.tracer.log("Acceptance of link through [" + this.descriptor + "] failed. [" + eventData.e.toString() + "].", Tracer.Level.DIAGNOSE);
        this.dispatchCompletion(dispatcher, eventData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onAcceptFailure(IEmxDispatcher dispatcher, LnkEvents.ConnectAcceptCompleteEventData eventData) {
        if (this.threaded) {
            LnkContinuousAcceptor lnkContinuousAcceptor = this;
            synchronized (lnkContinuousAcceptor) {
                this.onAcceptFailureUnprotected(dispatcher, eventData);
            }
        } else {
            this.onAcceptFailureUnprotected(dispatcher, eventData);
        }
    }

    private final void accept(IEmxDispatcher dispatcher) throws ELnkNotOwnerException, ELnkOpFailedException {
        try {
            if (this.tracer.verbose) {
                this.tracer.log("Accepting links using [" + this.descriptor + "]", Tracer.Level.VERBOSE);
            }
            this.sep.acceptPost(dispatcher, this.completionHandler, 1000, 0);
        }
        catch (ELnkInvalidStateException e) {
            throw new InternalError("Received 'invalid state' exception from accept post when server endpoint was just created!");
        }
        catch (ELnkOpFailedException e) {
            if (this.tracer.verbose) {
                this.tracer.log("Failed to start link acceptance using [" + this.descriptor + "] [" + e.toString() + "].", Tracer.Level.VERBOSE);
            }
            throw e;
        }
    }

    private final void startUnprotected(IEmxDispatcher dispatcher) throws ELnkInvalidStateException, ELnkNotOwnerException, ELnkOpFailedException {
        if (this.state == State.STOPPED) {
            this.createServerEndpoint();
            try {
                this.accept(dispatcher);
                this.dispatcher = dispatcher;
                this.state = State.STARTED;
            }
            catch (ELnkNotOwnerException e) {
                this.closeServerEndpoint();
                throw e;
            }
            catch (ELnkOpFailedException e) {
                this.closeServerEndpoint();
                throw e;
            }
            catch (RuntimeException e) {
                this.closeServerEndpoint();
                throw e;
            }
        } else {
            throw new ELnkInvalidStateException("start", this.state.toString());
        }
    }

    private final void stopUnprotected() throws ELnkInvalidStateException {
        if (this.state == State.STARTED) {
            this.state = State.STOPPING;
            if (this.dispatcher.getOwner() == Thread.currentThread()) {
                this.sep.acceptCancel(0);
                this.dispatcher.flush();
            }
        } else {
            throw new ELnkInvalidStateException("stop", this.state.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(IEmxDispatcher dispatcher) throws ELnkInvalidStateException, ELnkNotOwnerException, ELnkOpFailedException {
        if (this.threaded) {
            LnkContinuousAcceptor lnkContinuousAcceptor = this;
            synchronized (lnkContinuousAcceptor) {
                this.startUnprotected(dispatcher);
            }
        } else {
            this.startUnprotected(dispatcher);
        }
    }

    public final State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws ELnkInvalidStateException, ELnkOpFailedException {
        if (this.threaded) {
            LnkContinuousAcceptor lnkContinuousAcceptor = this;
            synchronized (lnkContinuousAcceptor) {
                this.stopUnprotected();
            }
        } else {
            this.stopUnprotected();
        }
    }

    public static enum State {
        STOPPED,
        STARTED,
        STOPPING;

    }

    private final class AcceptCompleteEventHandler
    implements ILnkEventHandler {
        private AcceptCompleteEventHandler() {
        }

        @Override
        public final void onEvent(IEmxDispatcher dispatcher, ILnkEndpoint ep, int type, Object data) {
            try {
                LnkEvents.ConnectAcceptCompleteEventData eventData = (LnkEvents.ConnectAcceptCompleteEventData)data;
                if (eventData.status || eventData.e instanceof ELnkOpTimeoutException) {
                    LnkContinuousAcceptor.this.onAcceptSuccessOrTimeout(dispatcher, eventData);
                } else {
                    LnkContinuousAcceptor.this.onAcceptFailure(dispatcher, eventData);
                }
            }
            catch (Exception e) {
                throw new InternalError("Unhandled fault in continuous link acceptor [" + LnkContinuousAcceptor.this.descriptor + "] {" + e.toString() + "}. ");
            }
        }
    }
}

