/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.error;

import com.neeve.error.EErrorUnknownErrorException;
import com.neeve.error.ErrorObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class ErrorCodeRegistry
extends ErrorObject {
    private static final ErrorCodeRegistry instance = new ErrorCodeRegistry();
    private final HashMap<Integer, ErrorDescriptor> errorTable = new HashMap();
    public static final int CORE_BEGIN = 0;
    public static final int CORE_MAX_COUNT = 2048;
    public static final int PACKET_BEGIN = 2048;
    public static final int PACKET_MAX_COUNT = 2048;
    public static final int NOERROR = 0;

    private ErrorCodeRegistry() {
        HashSet<ErrorDescriptor> descriptors = new HashSet<ErrorDescriptor>();
        descriptors.add(new ErrorDescriptor(0, "no error"));
        this.registerErrorDescriptors(descriptors);
    }

    public static final ErrorCodeRegistry getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerErrorDescriptors(Set<ErrorDescriptor> errors) {
        HashMap<Integer, ErrorDescriptor> hashMap = this.errorTable;
        synchronized (hashMap) {
            for (ErrorDescriptor descriptor : errors) {
                this.errorTable.put(descriptor.errorCode, descriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ErrorDescriptor getErrorDescriptor(int errorCode) throws EErrorUnknownErrorException {
        HashMap<Integer, ErrorDescriptor> hashMap = this.errorTable;
        synchronized (hashMap) {
            ErrorDescriptor descriptor = this.errorTable.get(errorCode);
            if (descriptor == null) {
                throw new EErrorUnknownErrorException(errorCode);
            }
            return descriptor;
        }
    }

    public static final class ErrorDescriptor {
        public final int errorCode;
        public final String errorDescription;

        public ErrorDescriptor(int errorCode, String errorDescription) {
            this.errorCode = errorCode;
            this.errorDescription = errorDescription;
        }
    }
}

