/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf.test.unit;

import com.neeve.pkt.PktBuffer;
import com.neeve.test.UnitTest;
import com.neeve.xbuf.XbufCurrencyField;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.test.unit.XbufStringFieldTest;
import java.nio.ByteOrder;
import java.util.Currency;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class XbufCurrencyFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    static final Currency randomCurrency() {
        switch (random.nextInt(5)) {
            case 0: {
                return Currency.getInstance("USD");
            }
            case 1: {
                return Currency.getInstance("GBP");
            }
            case 2: {
                return Currency.getInstance("INR");
            }
            case 3: {
                return Currency.getInstance("AUD");
            }
            case 4: {
                return Currency.getInstance("BHD");
            }
        }
        return null;
    }

    private final XbufCurrencyField testSetClearSyncDesync(XbufCurrencyField field1) {
        Currency value = XbufCurrencyFieldTest.randomCurrency();
        field1.setValue(value);
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((Object)value, (Object)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + 3), (long)field1.length());
        value = null;
        field1.setValue(null);
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((Object)value, (Object)field1.getValue());
        Assert.assertEquals((long)field1.headerLength(), (long)field1.length());
        field1.setValue(XbufCurrencyFieldTest.randomCurrency());
        Assert.assertTrue((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.hasValue());
        value = null;
        Assert.assertEquals(null, (Object)field1.getValue());
        PktBuffer buffer1 = PktBuffer.create(null, (int)256, (boolean)false);
        buffer1.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        Assert.assertEquals((long)field1.headerLength(), (long)field1.sync(buffer1, 10));
        XbufCurrencyField field2 = XbufCurrencyField.create(field1.id(), field1.name(), field1.pinned());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)field1.headerLength(), (long)field2.desync(buffer1, 10));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((Object)value, (Object)field2.getValue());
        Assert.assertEquals((long)field2.headerLength(), (long)field2.length());
        value = XbufCurrencyFieldTest.randomCurrency();
        field1.setValue(value);
        Assert.assertEquals((long)(field1.headerLength() + 3), (long)field1.sync(buffer1, 23));
        field2 = XbufCurrencyField.create(field1.id(), field1.name(), field1.pinned());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + 3), (long)field2.desync(buffer1, 23));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((Object)value, (Object)field2.getValue());
        Assert.assertEquals((long)(field2.headerLength() + 3), (long)field2.length());
        return field2;
    }

    @Test
    public final void testInitialState() {
        short id = (short)random.nextInt(Short.MAX_VALUE);
        String name = XbufStringFieldTest.randomString();
        XbufCurrencyField field1 = XbufCurrencyField.create(id, name, false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.CURRENCY), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertEquals((Object)name, (Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertFalse((boolean)field1.variableLength());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertNull((Object)field1.getValue());
        Assert.assertEquals((long)field1.headerLength(), (long)field1.length());
        field1 = XbufCurrencyField.create(id, null, true);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.CURRENCY), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertNull((Object)field1.name());
        Assert.assertTrue((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertFalse((boolean)field1.variableLength());
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertNull((Object)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + 3), (long)field1.length());
    }

    @Test
    public final void testInitSetClearSyncDesync_Unpinned_Heap() {
        XbufCurrencyField field1 = XbufCurrencyField.create((short)random.nextInt(Short.MAX_VALUE), null, false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testInitSetClearSyncDesync_Unpinned_Native() {
        XbufCurrencyField field1 = XbufCurrencyField.create((short)random.nextInt(Short.MAX_VALUE), null, false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }
}

